/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.debug.eval.ast.engine.EvaluationEngineMessages;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.AndAssignmentOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.AndOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.ArrayAllocation;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.ArrayInitializerInstruction;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.AssignmentOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.Cast;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.CompoundInstruction;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.ConditionalJump;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.Constructor;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.DivideAssignmentOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.DivideOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.EqualEqualOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.GreaterEqualOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.GreaterOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstanceOfOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.Instruction;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionSequence;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.Jump;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.LeftShiftAssignmentOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.LeftShiftOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.LessEqualOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.LessOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.LocalVariableCreation;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.MinusAssignmentOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.MinusOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.MultiplyAssignmentOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.MultiplyOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.NoOp;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.NotOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.OrAssignmentOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.OrOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PlusAssignmentOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PlusOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.Pop;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PostfixMinusMinusOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PostfixPlusPlusOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PrefixMinusMinusOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PrefixPlusPlusOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PushArrayLength;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PushArrayType;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PushBoolean;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PushChar;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PushClassLiteralValue;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PushDouble;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PushFieldVariable;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PushFloat;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PushInt;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PushLocalVariable;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PushLong;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PushNull;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PushStaticFieldVariable;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PushString;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PushThis;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.PushType;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.RemainderAssignmentOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.RemainderOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.ReturnInstruction;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.RightShiftAssignmentOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.RightShiftOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.SendMessage;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.SendStaticMessage;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.TwiddleOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.UnaryMinusOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.UnaryPlusOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.UnsignedRightShiftAssignmentOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.UnsignedRightShiftOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.XorAssignmentOperator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.XorOperator;

public class ASTInstructionCompiler
extends ASTVisitor {
    private static boolean VERBOSE = false;
    private InstructionSequence fInstructions;
    private List fCompleteInstructions;
    private int fStartPosition;
    private boolean fActive;
    private boolean fHasErrors;
    private Stack fStack;
    private int fCounter;

    public ASTInstructionCompiler(int startPosition, String snippet) {
        this.fStartPosition = startPosition;
        this.fInstructions = new InstructionSequence(snippet);
        this.fStack = new Stack();
        this.fCompleteInstructions = new ArrayList();
    }

    public InstructionSequence getInstructions() {
        return this.fInstructions;
    }

    public boolean hasErrors() {
        return this.fHasErrors;
    }

    private void setHasError(boolean value) {
        this.fHasErrors = value;
    }

    private void addErrorMessage(String message) {
        this.fInstructions.addError(message);
    }

    private boolean isActive() {
        return this.fActive;
    }

    private void setActive(boolean active) {
        this.fActive = active;
    }

    private void push(Instruction i) {
        this.fStack.push(i);
    }

    private Instruction pop() {
        return (Instruction)this.fStack.pop();
    }

    private void storeInstruction() {
        Instruction instruction = this.pop();
        ++this.fCounter;
        if (instruction instanceof CompoundInstruction) {
            ((CompoundInstruction)instruction).setEnd(this.fCounter);
        }
        this.fInstructions.add(instruction);
        this.verbose("Add " + instruction.toString());
    }

    private void verbose(String message) {
        if (VERBOSE) {
            System.out.println(message);
        }
    }

    private String getTypeName(ITypeBinding typeBinding) {
        if (typeBinding.isArray()) {
            StringBuffer name = new StringBuffer(this.getTypeName(typeBinding.getElementType()));
            int dimensions = typeBinding.getDimensions();
            int i = 0;
            while (i < dimensions) {
                name.append("[]");
                ++i;
            }
            return name.toString();
        }
        StringBuffer name = new StringBuffer(typeBinding.getName());
        IPackageBinding packageBinding = typeBinding.getPackage();
        typeBinding = typeBinding.getDeclaringClass();
        while (typeBinding != null) {
            name.insert(0, '$').insert(0, typeBinding.getName());
            typeBinding = typeBinding.getDeclaringClass();
        }
        if (packageBinding != null && !packageBinding.isUnnamed()) {
            name.insert(0, '.').insert(0, packageBinding.getName());
        }
        return name.toString();
    }

    private String getTypeSignature(ITypeBinding typeBinding) {
        return Signature.createTypeSignature((String)this.getTypeName(typeBinding), (boolean)true).replace('.', '/');
    }

    private boolean isALocalType(ITypeBinding typeBinding) {
        while (typeBinding != null) {
            if (typeBinding.isLocal()) {
                return true;
            }
            typeBinding = typeBinding.getDeclaringClass();
        }
        return false;
    }

    private boolean containsALocalType(IMethodBinding methodBinding) {
        ITypeBinding[] typeBindings = methodBinding.getParameterTypes();
        int i = 0;
        int length = typeBindings.length;
        while (i < length) {
            if (this.isALocalType(typeBindings[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int getEnclosingLevel(ASTNode node, ITypeBinding referenceTypeBinding) {
        ASTNode parent = node;
        while (!((parent = parent.getParent()) instanceof TypeDeclaration) && !(parent instanceof AnonymousClassDeclaration)) {
        }
        if (parent == null) {
            return 9999;
        }
        ITypeBinding parentBinding = parent instanceof TypeDeclaration ? ((TypeDeclaration)parent).resolveBinding() : ((AnonymousClassDeclaration)parent).resolveBinding();
        if (this.isInstanceOf(parentBinding, referenceTypeBinding)) {
            return 0;
        }
        return this.getEnclosingLevel(parent, referenceTypeBinding) + 1;
    }

    private int getSuperLevel(ITypeBinding current, ITypeBinding reference) {
        if (current.equals((Object)reference)) {
            return 0;
        }
        return this.getSuperLevel(current.getSuperclass(), reference);
    }

    private boolean isInstanceOf(ITypeBinding current, ITypeBinding reference) {
        if (current.equals((Object)reference)) {
            return true;
        }
        ITypeBinding superClass = current.getSuperclass();
        if (superClass == null) {
            return false;
        }
        return this.isInstanceOf(current.getSuperclass(), reference);
    }

    private String getLabel(Statement statement) {
        ASTNode parent = statement.getParent();
        if (parent instanceof LabeledStatement) {
            return ((LabeledStatement)parent).getLabel().getIdentifier();
        }
        return null;
    }

    private void addPopInstructionIfNeeded(Expression expression) {
        boolean pop = true;
        if (expression instanceof MethodInvocation) {
            IMethodBinding methodBinding = (IMethodBinding)((MethodInvocation)expression).getName().resolveBinding();
            if ("void".equals(methodBinding.getReturnType().getName())) {
                pop = false;
            }
        } else if (expression instanceof SuperMethodInvocation) {
            IMethodBinding methodBinding = (IMethodBinding)((SuperMethodInvocation)expression).getName().resolveBinding();
            if ("void".equals(methodBinding.getReturnType().getName())) {
                pop = false;
            }
        } else if (expression instanceof VariableDeclarationExpression) {
            pop = false;
        }
        if (pop) {
            this.push(new Pop());
            this.storeInstruction();
        }
    }

    public void endVisit(AnonymousClassDeclaration node) {
    }

    public void endVisit(ArrayAccess node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(ArrayCreation node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(ArrayInitializer node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(ArrayType node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(AssertStatement node) {
    }

    public void endVisit(Assignment node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(Block node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(BooleanLiteral node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(BreakStatement node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(CastExpression node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(CatchClause node) {
    }

    public void endVisit(CharacterLiteral node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(ClassInstanceCreation node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(CompilationUnit node) {
    }

    public void endVisit(ConditionalExpression node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        int ifFalseAddress = this.fInstructions.getEnd();
        Instruction ifFalse = this.fInstructions.get(ifFalseAddress);
        int ifTrueAddress = ifFalseAddress - ifFalse.getSize();
        Instruction ifTrue = this.fInstructions.get(ifTrueAddress);
        int conditionalAddress = ifTrueAddress - ifTrue.getSize();
        ConditionalJump conditionalJump = new ConditionalJump(false);
        this.fInstructions.insert(conditionalJump, conditionalAddress + 1);
        int jumpAddress = ifTrueAddress + 2;
        Jump jump = new Jump();
        this.fInstructions.insert(jump, jumpAddress);
        conditionalJump.setOffset(ifTrue.getSize() + 1);
        jump.setOffset(ifFalse.getSize() + 1);
        this.fCounter += 2;
        this.storeInstruction();
    }

    public void endVisit(ConstructorInvocation node) {
    }

    public void endVisit(ContinueStatement node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(DoStatement node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        String label = this.getLabel((Statement)node);
        int conditionAddress = this.fInstructions.getEnd();
        Instruction condition = this.fInstructions.getInstruction(conditionAddress);
        int bodyAddress = conditionAddress - condition.getSize();
        Instruction body = this.fInstructions.getInstruction(bodyAddress);
        ConditionalJump conditionalJump = new ConditionalJump(true);
        this.fInstructions.add(conditionalJump);
        ++this.fCounter;
        conditionalJump.setOffset(-(condition.getSize() + body.getSize() + 1));
        Iterator iter = this.fCompleteInstructions.iterator();
        while (iter.hasNext()) {
            CompleteInstruction instruction = (CompleteInstruction)iter.next();
            if (instruction.fLabel != null && !instruction.fLabel.equals(label)) continue;
            iter.remove();
            Jump jumpInstruction = instruction.fInstruction;
            int instructionAddress = this.fInstructions.indexOf(jumpInstruction);
            if (instruction.fIsBreak) {
                jumpInstruction.setOffset(conditionAddress - instructionAddress + 1);
                continue;
            }
            jumpInstruction.setOffset(bodyAddress - instructionAddress);
        }
        this.storeInstruction();
    }

    public void endVisit(EmptyStatement node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(ExpressionStatement node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.addPopInstructionIfNeeded(node.getExpression());
    }

    public void endVisit(FieldAccess node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(FieldDeclaration node) {
    }

    public void endVisit(ForStatement node) {
        Instruction condition;
        int conditionAddress;
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        String label = this.getLabel((Statement)node);
        boolean hasCondition = node.getExpression() != null;
        int updatersAddress = this.fInstructions.getEnd();
        Instruction updaters = this.fInstructions.getInstruction(updatersAddress);
        int bodyAddress = updatersAddress - updaters.getSize();
        Instruction body = this.fInstructions.getInstruction(bodyAddress);
        if (hasCondition) {
            conditionAddress = bodyAddress - body.getSize();
            condition = this.fInstructions.getInstruction(conditionAddress);
        } else {
            conditionAddress = 0;
            condition = null;
        }
        Jump jump = new Jump();
        this.fInstructions.add(jump);
        ++this.fCounter;
        if (hasCondition) {
            ConditionalJump condJump = new ConditionalJump(false);
            this.fInstructions.insert(condJump, conditionAddress + 1);
            ++bodyAddress;
            ++updatersAddress;
            ++this.fCounter;
            condJump.setOffset(body.getSize() + updaters.getSize() + 1);
        }
        jump.setOffset(-((hasCondition ? condition.getSize() : 0) + body.getSize() + updaters.getSize() + 2));
        Iterator iter = this.fCompleteInstructions.iterator();
        while (iter.hasNext()) {
            CompleteInstruction instruction = (CompleteInstruction)iter.next();
            if (instruction.fLabel != null && !instruction.fLabel.equals(label)) continue;
            iter.remove();
            Jump jumpInstruction = instruction.fInstruction;
            int instructionAddress = this.fInstructions.indexOf(jumpInstruction);
            if (instruction.fIsBreak) {
                jumpInstruction.setOffset(updatersAddress - instructionAddress + 1);
                continue;
            }
            jumpInstruction.setOffset(bodyAddress - instructionAddress);
        }
        this.storeInstruction();
    }

    public void endVisit(IfStatement node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        boolean hasElseStatement = node.getElseStatement() != null;
        int ifFalseAddress = 0;
        Instruction ifFalse = null;
        int ifTrueAddress = 0;
        Instruction ifTrue = null;
        if (hasElseStatement) {
            ifFalseAddress = this.fInstructions.getEnd();
            ifFalse = this.fInstructions.get(ifFalseAddress);
            ifTrueAddress = ifFalseAddress - ifFalse.getSize();
            ifTrue = this.fInstructions.get(ifTrueAddress);
        } else {
            ifTrueAddress = this.fInstructions.getEnd();
            ifTrue = this.fInstructions.get(ifTrueAddress);
        }
        int conditionalAddress = ifTrueAddress - ifTrue.getSize();
        ConditionalJump conditionalJump = new ConditionalJump(false);
        this.fInstructions.insert(conditionalJump, conditionalAddress + 1);
        conditionalJump.setOffset(ifTrue.getSize() + (hasElseStatement ? 1 : 0));
        ++this.fCounter;
        if (hasElseStatement) {
            int jumpAddress = ifTrueAddress + 2;
            Jump jump = new Jump();
            this.fInstructions.insert(jump, jumpAddress);
            jump.setOffset(ifFalse.getSize() + 1);
            ++this.fCounter;
        }
        this.storeInstruction();
    }

    public void endVisit(ImportDeclaration node) {
    }

    public void endVisit(InfixExpression node) {
    }

    public void endVisit(Initializer node) {
    }

    public void endVisit(InstanceofExpression node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(Javadoc node) {
    }

    public void endVisit(LabeledStatement node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        String label = node.getLabel().getIdentifier();
        Iterator iter = this.fCompleteInstructions.iterator();
        while (iter.hasNext()) {
            CompleteInstruction instruction = (CompleteInstruction)iter.next();
            if (instruction.fLabel == null || !instruction.fLabel.equals(label)) continue;
            iter.remove();
            Jump jumpInstruction = instruction.fInstruction;
            int instructionAddress = this.fInstructions.indexOf(jumpInstruction);
            if (!instruction.fIsBreak) continue;
            jumpInstruction.setOffset(this.fInstructions.getEnd() - instructionAddress);
        }
    }

    public void endVisit(MethodDeclaration node) {
        this.setActive(false);
    }

    public void endVisit(MethodInvocation node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(NullLiteral node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(NumberLiteral node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(PackageDeclaration node) {
    }

    public void endVisit(ParenthesizedExpression node) {
    }

    public void endVisit(PostfixExpression node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(PrefixExpression node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(PrimitiveType node) {
    }

    public void endVisit(QualifiedName node) {
    }

    public void endVisit(ReturnStatement node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(SimpleName node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(SimpleType node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(SingleVariableDeclaration node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(StringLiteral node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(SuperConstructorInvocation node) {
    }

    public void endVisit(SuperFieldAccess node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(SuperMethodInvocation node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(SwitchCase node) {
    }

    public void endVisit(SwitchStatement node) {
    }

    public void endVisit(SynchronizedStatement node) {
    }

    public void endVisit(ThisExpression node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(ThrowStatement node) {
    }

    public void endVisit(TryStatement node) {
    }

    public void endVisit(TypeDeclaration node) {
    }

    public void endVisit(TypeDeclarationStatement node) {
    }

    public void endVisit(TypeLiteral node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(VariableDeclarationExpression node) {
    }

    public void endVisit(VariableDeclarationFragment node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        this.storeInstruction();
    }

    public void endVisit(VariableDeclarationStatement node) {
    }

    public void endVisit(WhileStatement node) {
        if (!this.isActive() || this.hasErrors()) {
            return;
        }
        String label = this.getLabel((Statement)node);
        int bodyAddress = this.fInstructions.getEnd();
        Instruction body = this.fInstructions.getInstruction(bodyAddress);
        int conditionAddress = bodyAddress - body.getSize();
        Instruction condition = this.fInstructions.getInstruction(conditionAddress);
        ConditionalJump conditionalJump = new ConditionalJump(false);
        this.fInstructions.insert(conditionalJump, conditionAddress + 1);
        Jump jump = new Jump();
        this.fInstructions.add(jump);
        conditionalJump.setOffset(body.getSize() + 1);
        jump.setOffset(-(condition.getSize() + body.getSize() + 2));
        Iterator iter = this.fCompleteInstructions.iterator();
        while (iter.hasNext()) {
            CompleteInstruction instruction = (CompleteInstruction)iter.next();
            if (instruction.fLabel != null && !instruction.fLabel.equals(label)) continue;
            iter.remove();
            Jump jumpInstruction = instruction.fInstruction;
            int instructionAddress = this.fInstructions.indexOf(jumpInstruction);
            if (instruction.fIsBreak) {
                jumpInstruction.setOffset(bodyAddress - instructionAddress + 2);
                continue;
            }
            jumpInstruction.setOffset(conditionAddress - condition.getSize() - instructionAddress);
        }
        this.fCounter += 2;
        this.storeInstruction();
    }

    public boolean visit(AnonymousClassDeclaration node) {
        if (!this.isActive()) {
            return true;
        }
        this.setHasError(true);
        this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Anonymous_type_declaration_cannot_be_used_in_an_evaluation_expression_2"));
        return false;
    }

    public boolean visit(ArrayAccess node) {
        if (!this.isActive()) {
            return false;
        }
        this.push(new org.eclipse.jdt.internal.debug.eval.ast.instructions.ArrayAccess(this.fCounter));
        return true;
    }

    public boolean visit(ArrayCreation node) {
        if (!this.isActive()) {
            return false;
        }
        ArrayType arrayType = node.getType();
        if (this.isALocalType(arrayType.resolveBinding().getElementType())) {
            this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Local_type_array_instance_creation_cannot_be_used_in_an_evaluation_expression_29"));
            this.setHasError(true);
            return true;
        }
        this.push(new ArrayAllocation(arrayType.getDimensions(), node.dimensions().size(), node.getInitializer() != null, this.fCounter));
        return true;
    }

    public boolean visit(ArrayInitializer node) {
        if (!this.isActive()) {
            return false;
        }
        ITypeBinding typeBinding = node.resolveTypeBinding();
        int dimension = typeBinding.getDimensions();
        String signature = this.getTypeSignature(typeBinding.getElementType());
        this.push(new ArrayInitializerInstruction(signature, node.expressions().size(), dimension, this.fCounter));
        return true;
    }

    public boolean visit(ArrayType node) {
        if (!this.isActive()) {
            return false;
        }
        ITypeBinding arrayTypeBinding = node.resolveBinding();
        int dimension = arrayTypeBinding.getDimensions();
        String signature = this.getTypeSignature(arrayTypeBinding.getElementType());
        this.push(new PushArrayType(signature, dimension, this.fCounter));
        return false;
    }

    public boolean visit(AssertStatement node) {
        if (!this.isActive()) {
            return false;
        }
        this.setHasError(true);
        this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Assert_statement_cannot_be_used_in_an_evaluation_expression_3"));
        return true;
    }

    public boolean visit(Assignment node) {
        if (!this.isActive()) {
            return false;
        }
        int variableTypeId = this.getTypeId(node.getLeftHandSide());
        int valueTypeId = this.getTypeId(node.getRightHandSide());
        String opToken = node.getOperator().toString();
        int opTokenLength = opToken.length();
        char char0 = opToken.charAt(0);
        char char2 = '\u0000';
        if (opTokenLength > 2) {
            char2 = opToken.charAt(2);
        }
        boolean unrecognized = false;
        block0 : switch (char0) {
            case '=': {
                this.push(new AssignmentOperator(variableTypeId, valueTypeId, this.fCounter));
                break;
            }
            case '+': {
                this.push(new PlusAssignmentOperator(variableTypeId, valueTypeId, this.fCounter));
                break;
            }
            case '-': {
                this.push(new MinusAssignmentOperator(variableTypeId, valueTypeId, this.fCounter));
                break;
            }
            case '*': {
                this.push(new MultiplyAssignmentOperator(variableTypeId, valueTypeId, this.fCounter));
                break;
            }
            case '/': {
                this.push(new DivideAssignmentOperator(variableTypeId, valueTypeId, this.fCounter));
                break;
            }
            case '%': {
                this.push(new RemainderAssignmentOperator(variableTypeId, valueTypeId, this.fCounter));
                break;
            }
            case '^': {
                this.push(new XorAssignmentOperator(variableTypeId, valueTypeId, this.fCounter));
                break;
            }
            case '|': {
                this.push(new OrAssignmentOperator(variableTypeId, valueTypeId, this.fCounter));
                break;
            }
            case '&': {
                this.push(new AndAssignmentOperator(variableTypeId, valueTypeId, this.fCounter));
                break;
            }
            case '<': {
                this.push(new LeftShiftAssignmentOperator(variableTypeId, valueTypeId, this.fCounter));
                break;
            }
            case '>': {
                switch (char2) {
                    case '=': {
                        this.push(new RightShiftAssignmentOperator(variableTypeId, valueTypeId, this.fCounter));
                        break block0;
                    }
                    case '>': {
                        this.push(new UnsignedRightShiftAssignmentOperator(variableTypeId, valueTypeId, this.fCounter));
                        break block0;
                    }
                }
                unrecognized = true;
                break;
            }
            default: {
                unrecognized = true;
            }
        }
        if (unrecognized) {
            this.setHasError(true);
            this.addErrorMessage(String.valueOf(EvaluationEngineMessages.getString("ASTInstructionCompiler.Unrecognized_assignment_operator____4")) + opToken);
        }
        return true;
    }

    public boolean visit(Block node) {
        int start = node.getStartPosition();
        if (start == this.fStartPosition || start == this.fStartPosition + 1) {
            this.setActive(true);
        }
        if (!this.isActive()) {
            return true;
        }
        this.push(new NoOp(this.fCounter));
        return true;
    }

    public boolean visit(BooleanLiteral node) {
        if (!this.isActive()) {
            return false;
        }
        this.push(new PushBoolean(node.booleanValue()));
        return true;
    }

    public boolean visit(BreakStatement node) {
        if (!this.isActive()) {
            return false;
        }
        Jump instruction = new Jump();
        SimpleName labelName = node.getLabel();
        String label = null;
        if (labelName != null) {
            label = labelName.getIdentifier();
        }
        this.push(instruction);
        this.fCompleteInstructions.add(new CompleteInstruction(instruction, label, true));
        return false;
    }

    public boolean visit(CastExpression node) {
        if (!this.isActive()) {
            return false;
        }
        Type type = node.getType();
        int typeId = this.getTypeId(type);
        ITypeBinding typeBinding = type.resolveBinding();
        int dimension = typeBinding.getDimensions();
        if (typeBinding.isArray()) {
            typeBinding = typeBinding.getElementType();
        }
        String baseTypeSignature = this.getTypeName(typeBinding);
        this.push(new Cast(typeId, baseTypeSignature, dimension, this.fCounter));
        node.getExpression().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(CatchClause node) {
        if (!this.isActive()) {
            return false;
        }
        this.setHasError(true);
        this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Catch_clause_cannot_be_used_in_an_evaluation_expression_6"));
        return true;
    }

    public boolean visit(CharacterLiteral node) {
        if (!this.isActive()) {
            return false;
        }
        this.push(new PushChar(node.charValue()));
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        boolean isInstanceMemberType;
        if (!this.isActive()) {
            return true;
        }
        if (node.getAnonymousClassDeclaration() != null) {
            this.setHasError(true);
            this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Anonymous_type_declaration_cannot_be_used_in_an_evaluation_expression_7"));
        }
        IMethodBinding methodBinding = node.resolveConstructorBinding();
        ITypeBinding typeBinding = methodBinding.getDeclaringClass();
        ITypeBinding enclosingTypeBinding = typeBinding.getDeclaringClass();
        boolean bl = isInstanceMemberType = typeBinding.isMember() && !Modifier.isStatic((int)typeBinding.getModifiers());
        if (this.isALocalType(typeBinding)) {
            this.setHasError(true);
            this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Constructor_of_a_local_type_cannot_be_used_in_an_evaluation_expression_8"));
        }
        if (this.containsALocalType(methodBinding)) {
            this.setHasError(true);
            this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Constructor_which_contains_a_local_type_as_parameter_cannot_be_used_in_an_evaluation_expression_30"));
        }
        if (this.hasErrors()) {
            return true;
        }
        int argCount = methodBinding.getParameterTypes().length;
        String enclosingTypeSignature = null;
        if (isInstanceMemberType) {
            enclosingTypeSignature = this.getTypeSignature(enclosingTypeBinding);
            ++argCount;
        }
        String signature = this.getMethodSignature(methodBinding, enclosingTypeSignature).replace('.', '/');
        this.push(new Constructor(signature, argCount, this.fCounter));
        this.push(new PushType(this.getTypeName(typeBinding)));
        this.storeInstruction();
        if (isInstanceMemberType) {
            Expression optionalExpression = node.getExpression();
            if (optionalExpression != null) {
                optionalExpression.accept((ASTVisitor)this);
            } else {
                ClassInstanceCreation parent = node;
                while (!((parent = parent.getParent()) instanceof MethodDeclaration)) {
                }
                if (Modifier.isStatic((int)((MethodDeclaration)parent).getModifiers())) {
                    this.setHasError(true);
                    this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Must_explicitly_qualify_the_allocation_with_an_instance_of_the_enclosing_type_33"));
                    return true;
                }
                this.push(new PushThis(this.getEnclosingLevel((ASTNode)node, enclosingTypeBinding)));
                this.storeInstruction();
            }
        }
        Iterator iterator = node.arguments().iterator();
        while (iterator.hasNext()) {
            ((Expression)iterator.next()).accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(CompilationUnit node) {
        return true;
    }

    public boolean visit(ConditionalExpression node) {
        if (!this.isActive()) {
            return true;
        }
        this.push(new NoOp(this.fCounter));
        return true;
    }

    public boolean visit(ConstructorInvocation node) {
        if (!this.isActive()) {
            return false;
        }
        this.setHasError(true);
        this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.this_constructor_invocation_cannot_be_used_in_an_evaluation_expression_9"));
        return false;
    }

    public boolean visit(ContinueStatement node) {
        if (!this.isActive()) {
            return false;
        }
        Jump instruction = new Jump();
        SimpleName labelName = node.getLabel();
        String label = null;
        if (labelName != null) {
            label = labelName.getIdentifier();
        }
        this.push(instruction);
        this.fCompleteInstructions.add(new CompleteInstruction(instruction, label, false));
        return false;
    }

    public boolean visit(DoStatement node) {
        if (!this.isActive()) {
            return false;
        }
        this.push(new NoOp(this.fCounter));
        return true;
    }

    public boolean visit(EmptyStatement node) {
        if (!this.isActive()) {
            return false;
        }
        this.push(new NoOp(this.fCounter));
        return true;
    }

    public boolean visit(ExpressionStatement node) {
        if (!this.isActive()) {
            return true;
        }
        return true;
    }

    public boolean visit(FieldAccess node) {
        if (!this.isActive()) {
            return false;
        }
        SimpleName fieldName = node.getName();
        IVariableBinding fieldBinding = (IVariableBinding)fieldName.resolveBinding();
        ITypeBinding declaringTypeBinding = fieldBinding.getDeclaringClass();
        Expression expression = node.getExpression();
        String fieldId = fieldName.getIdentifier();
        if (Modifier.isStatic((int)fieldBinding.getModifiers())) {
            this.push(new PushStaticFieldVariable(fieldId, this.getTypeName(declaringTypeBinding), this.fCounter));
            expression.accept((ASTVisitor)this);
            this.push(new Pop());
            this.storeInstruction();
        } else {
            if (declaringTypeBinding == null) {
                this.push(new PushArrayLength(this.fCounter));
            } else {
                if (this.isALocalType(declaringTypeBinding)) {
                    this.setHasError(true);
                    this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Qualified_local_type_field_access_cannot_be_used_in_an_evaluation_expression_31"));
                    return false;
                }
                this.push(new PushFieldVariable(fieldId, this.getTypeSignature(declaringTypeBinding), this.fCounter));
            }
            expression.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(FieldDeclaration node) {
        return true;
    }

    public boolean visit(ForStatement node) {
        if (!this.isActive()) {
            return false;
        }
        this.push(new NoOp(this.fCounter));
        this.push(new NoOp(this.fCounter));
        Iterator iter = node.initializers().iterator();
        while (iter.hasNext()) {
            Expression expr = (Expression)iter.next();
            expr.accept((ASTVisitor)this);
            this.addPopInstructionIfNeeded(expr);
        }
        this.storeInstruction();
        Expression condition = node.getExpression();
        if (condition != null) {
            condition.accept((ASTVisitor)this);
        }
        node.getBody().accept((ASTVisitor)this);
        this.push(new NoOp(this.fCounter));
        Iterator iter2 = node.updaters().iterator();
        while (iter2.hasNext()) {
            Expression expr = (Expression)iter2.next();
            expr.accept((ASTVisitor)this);
            this.addPopInstructionIfNeeded(expr);
        }
        this.storeInstruction();
        return false;
    }

    public boolean visit(IfStatement node) {
        if (!this.isActive()) {
            return false;
        }
        this.push(new NoOp(this.fCounter));
        return true;
    }

    public boolean visit(ImportDeclaration node) {
        return false;
    }

    public boolean visit(InfixExpression node) {
        int resultTypeId;
        if (!this.isActive()) {
            return false;
        }
        String opToken = node.getOperator().toString();
        int opTokenLength = opToken.length();
        char char0 = opToken.charAt(0);
        char char1 = '\u0000';
        char char2 = '\u0000';
        if (opTokenLength > 1) {
            char1 = opToken.charAt(1);
            if (opTokenLength > 2) {
                char2 = opToken.charAt(2);
            }
        }
        List extendedOperands = node.extendedOperands();
        int operatorNumber = extendedOperands.size() + 1;
        int[][] types = new int[operatorNumber][3];
        Iterator iterator = extendedOperands.iterator();
        int leftTypeId = this.getTypeId(node.getLeftOperand());
        int rightTypeId = this.getTypeId(node.getRightOperand());
        types[0][0] = resultTypeId = Instruction.getBinaryPromotionType(leftTypeId, rightTypeId);
        types[0][1] = leftTypeId;
        types[0][2] = rightTypeId;
        int i = 1;
        while (i < operatorNumber) {
            Expression operand = (Expression)iterator.next();
            leftTypeId = resultTypeId;
            rightTypeId = this.getTypeId(operand);
            types[i][0] = resultTypeId = Instruction.getBinaryPromotionType(leftTypeId, rightTypeId);
            types[i][1] = leftTypeId;
            types[i][2] = rightTypeId;
            ++i;
        }
        boolean unrecognized = false;
        block0 : switch (char0) {
            case '*': {
                int i2 = operatorNumber - 1;
                while (i2 >= 0) {
                    this.push(new MultiplyOperator(types[i2][0], types[i2][1], types[i2][2], this.fCounter));
                    --i2;
                }
                break;
            }
            case '/': {
                int i3 = operatorNumber - 1;
                while (i3 >= 0) {
                    this.push(new DivideOperator(types[i3][0], types[i3][1], types[i3][2], this.fCounter));
                    --i3;
                }
                break;
            }
            case '%': {
                int i4 = operatorNumber - 1;
                while (i4 >= 0) {
                    this.push(new RemainderOperator(types[i4][0], types[i4][1], types[i4][2], this.fCounter));
                    --i4;
                }
                break;
            }
            case '+': {
                int i5 = operatorNumber - 1;
                while (i5 >= 0) {
                    this.push(new PlusOperator(types[i5][0], types[i5][1], types[i5][2], this.fCounter));
                    --i5;
                }
                break;
            }
            case '-': {
                int i6 = operatorNumber - 1;
                while (i6 >= 0) {
                    this.push(new MinusOperator(types[i6][0], types[i6][1], types[i6][2], this.fCounter));
                    --i6;
                }
                break;
            }
            case '<': {
                switch (char1) {
                    case '\u0000': {
                        int i7 = operatorNumber - 1;
                        while (i7 >= 0) {
                            this.push(new LessOperator(types[i7][1], types[i7][2], this.fCounter));
                            --i7;
                        }
                        break block0;
                    }
                    case '<': {
                        int i8 = operatorNumber - 1;
                        while (i8 >= 0) {
                            this.push(new LeftShiftOperator(Instruction.getUnaryPromotionType(types[i8][1]), types[i8][1], types[i8][2], this.fCounter));
                            --i8;
                        }
                        break block0;
                    }
                    case '=': {
                        int i9 = operatorNumber - 1;
                        while (i9 >= 0) {
                            this.push(new LessEqualOperator(types[i9][1], types[i9][2], this.fCounter));
                            --i9;
                        }
                        break block0;
                    }
                    default: {
                        unrecognized = true;
                        break;
                    }
                }
                break;
            }
            case '>': {
                switch (char1) {
                    case '\u0000': {
                        int i10 = operatorNumber - 1;
                        while (i10 >= 0) {
                            this.push(new GreaterOperator(types[i10][1], types[i10][2], this.fCounter));
                            --i10;
                        }
                        break block0;
                    }
                    case '>': {
                        switch (char2) {
                            case '\u0000': {
                                int i11 = operatorNumber - 1;
                                while (i11 >= 0) {
                                    this.push(new RightShiftOperator(Instruction.getUnaryPromotionType(types[i11][1]), types[i11][1], types[i11][2], this.fCounter));
                                    --i11;
                                }
                                break block0;
                            }
                            case '>': {
                                int i12 = operatorNumber - 1;
                                while (i12 >= 0) {
                                    this.push(new UnsignedRightShiftOperator(Instruction.getUnaryPromotionType(types[i12][1]), types[i12][1], types[i12][2], this.fCounter));
                                    --i12;
                                }
                                break block24;
                            }
                        }
                        break block0;
                    }
                    case '=': {
                        int i13 = operatorNumber - 1;
                        while (i13 >= 0) {
                            this.push(new GreaterEqualOperator(types[i13][1], types[i13][2], this.fCounter));
                            --i13;
                        }
                        break block0;
                    }
                    default: {
                        unrecognized = true;
                        break;
                    }
                }
                break;
            }
            case '=': {
                int i14 = operatorNumber - 1;
                while (i14 >= 0) {
                    this.push(new EqualEqualOperator(types[i14][1], types[i14][2], true, this.fCounter));
                    --i14;
                }
                break;
            }
            case '!': {
                int i15 = operatorNumber - 1;
                while (i15 >= 0) {
                    this.push(new EqualEqualOperator(types[i15][1], types[i15][2], false, this.fCounter));
                    --i15;
                }
                break;
            }
            case '^': {
                int i16 = operatorNumber - 1;
                while (i16 >= 0) {
                    this.push(new XorOperator(types[i16][0], types[i16][1], types[i16][2], this.fCounter));
                    --i16;
                }
                break;
            }
            case '|': {
                switch (char1) {
                    case '\u0000': {
                        int i17 = operatorNumber - 1;
                        while (i17 >= 0) {
                            this.push(new OrOperator(types[i17][0], types[i17][1], types[i17][2], this.fCounter));
                            --i17;
                        }
                        break block0;
                    }
                    case '|': {
                        int i18 = operatorNumber - 1;
                        while (i18 >= 0) {
                            this.push(new NoOp(this.fCounter));
                            --i18;
                        }
                        break block0;
                    }
                    default: {
                        unrecognized = true;
                        break;
                    }
                }
                break;
            }
            case '&': {
                switch (char1) {
                    case '\u0000': {
                        int i19 = operatorNumber - 1;
                        while (i19 >= 0) {
                            this.push(new AndOperator(types[i19][0], types[i19][1], types[i19][2], this.fCounter));
                            --i19;
                        }
                        break block0;
                    }
                    case '&': {
                        int i20 = operatorNumber - 1;
                        while (i20 >= 0) {
                            this.push(new NoOp(this.fCounter));
                            --i20;
                        }
                        break block0;
                    }
                    default: {
                        unrecognized = true;
                        break;
                    }
                }
                break;
            }
            default: {
                unrecognized = true;
            }
        }
        if (unrecognized) {
            this.setHasError(true);
            this.addErrorMessage(String.valueOf(EvaluationEngineMessages.getString("ASTInstructionCompiler.Unrecognized_infix_operator____13")) + opToken);
        }
        if (this.hasErrors()) {
            return true;
        }
        iterator = extendedOperands.iterator();
        if (char0 == '&' && char1 == '&' || char0 == '|' && char1 == '|') {
            ConditionalJump conditionalJump;
            boolean isOrOr = char0 == '|';
            ConditionalJump[] conditionalJumps = new ConditionalJump[operatorNumber];
            int[] conditionalJumpAddresses = new int[operatorNumber];
            node.getLeftOperand().accept((ASTVisitor)this);
            conditionalJumps[0] = conditionalJump = new ConditionalJump(isOrOr);
            conditionalJumpAddresses[0] = this.fCounter;
            this.push(conditionalJump);
            this.storeInstruction();
            node.getRightOperand().accept((ASTVisitor)this);
            int i21 = 1;
            while (i21 < operatorNumber) {
                conditionalJumps[i21] = conditionalJump = new ConditionalJump(isOrOr);
                conditionalJumpAddresses[i21] = this.fCounter;
                this.push(conditionalJump);
                this.storeInstruction();
                ((Expression)iterator.next()).accept((ASTVisitor)this);
                ++i21;
            }
            Jump jump = new Jump();
            jump.setOffset(1);
            this.push(jump);
            this.storeInstruction();
            int i22 = 0;
            while (i22 < operatorNumber) {
                conditionalJumps[i22].setOffset(this.fCounter - conditionalJumpAddresses[i22] - 1);
                ++i22;
            }
            this.push(new PushBoolean(isOrOr));
            this.storeInstruction();
            this.storeInstruction();
        } else {
            node.getLeftOperand().accept((ASTVisitor)this);
            node.getRightOperand().accept((ASTVisitor)this);
            this.storeInstruction();
            int i23 = 1;
            while (i23 < operatorNumber) {
                ((Expression)iterator.next()).accept((ASTVisitor)this);
                this.storeInstruction();
                ++i23;
            }
        }
        return false;
    }

    public boolean visit(Initializer node) {
        return true;
    }

    public boolean visit(InstanceofExpression node) {
        if (!this.isActive()) {
            return false;
        }
        this.push(new InstanceOfOperator(this.fCounter));
        return true;
    }

    public boolean visit(Javadoc node) {
        return false;
    }

    public boolean visit(LabeledStatement node) {
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        int start = node.getStartPosition();
        int end = start + node.getLength();
        return start < this.fStartPosition && end > this.fStartPosition;
    }

    public boolean visit(MethodInvocation node) {
        if (!this.isActive()) {
            return false;
        }
        IMethodBinding methodBinding = (IMethodBinding)node.getName().resolveBinding();
        if (this.containsALocalType(methodBinding)) {
            this.setHasError(true);
            this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Method_which_contains_a_local_type_as_parameter_cannot_be_used_in_an_evaluation_expression_32"));
        }
        if (this.hasErrors()) {
            return true;
        }
        int argCount = methodBinding.getParameterTypes().length;
        String selector = methodBinding.getName();
        String signature = this.getMethodSignature(methodBinding, null).replace('.', '/');
        boolean isStatic = Flags.isStatic((int)methodBinding.getModifiers());
        Expression expression = node.getExpression();
        if (isStatic) {
            String typeName = this.getTypeName(methodBinding.getDeclaringClass());
            this.push(new SendStaticMessage(typeName, selector, signature, argCount, this.fCounter));
            if (expression != null) {
                node.getExpression().accept((ASTVisitor)this);
                this.push(new Pop());
                this.storeInstruction();
            }
        } else {
            this.push(new SendMessage(selector, signature, argCount, null, this.fCounter));
            if (expression == null) {
                this.push(new PushThis(this.getEnclosingLevel((ASTNode)node, methodBinding.getDeclaringClass())));
                this.storeInstruction();
            } else {
                node.getExpression().accept((ASTVisitor)this);
            }
        }
        Iterator iterator = node.arguments().iterator();
        while (iterator.hasNext()) {
            ((Expression)iterator.next()).accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(NullLiteral node) {
        if (!this.isActive()) {
            return false;
        }
        this.push(new PushNull());
        return true;
    }

    public boolean visit(NumberLiteral node) {
        if (!this.isActive()) {
            return false;
        }
        int literalType = this.getTypeId((Expression)node);
        String token = node.getToken();
        int tokenLastCharOffset = token.length() - 1;
        char lastChar = token.charAt(tokenLastCharOffset);
        String subToken = token.substring(0, tokenLastCharOffset);
        switch (literalType) {
            case 10: {
                this.push(new PushInt(this.parseIntValue(token)));
                break;
            }
            case 7: {
                this.push(new PushLong(this.parseLongValue(subToken)));
                break;
            }
            case 9: {
                this.push(new PushFloat(Float.parseFloat(subToken)));
                break;
            }
            case 8: {
                if (lastChar == 'D' || lastChar == 'd') {
                    this.push(new PushDouble(Double.parseDouble(subToken)));
                    break;
                }
                this.push(new PushDouble(Double.parseDouble(token)));
            }
        }
        return true;
    }

    private int parseIntValue(String token) {
        int tokenLength = token.length();
        if (tokenLength < 10) {
            return Integer.decode(token);
        }
        switch (this.getBase(token)) {
            case 8: {
                return Integer.decode(token.substring(0, tokenLength - 1)) << 3 | Integer.decode("0" + token.charAt(tokenLength - 1));
            }
            case 10: {
                return Integer.decode(token);
            }
            case 16: {
                return Integer.decode(token.substring(0, tokenLength - 1)) << 4 | Integer.decode("0x" + token.charAt(tokenLength - 1));
            }
        }
        return 0;
    }

    private long parseLongValue(String token) {
        int tokenLength = token.length();
        if (tokenLength < 18) {
            return Long.decode(token);
        }
        switch (this.getBase(token)) {
            case 8: {
                return Long.decode(token.substring(0, tokenLength - 1)) << 3 | Long.decode("0" + token.charAt(tokenLength - 1));
            }
            case 10: {
                return Long.decode(token);
            }
            case 16: {
                return Long.decode(token.substring(0, tokenLength - 1)) << 4 | Long.decode("0x" + token.charAt(tokenLength - 1));
            }
        }
        return 0L;
    }

    private int getBase(String token) {
        if (token.charAt(0) == '0') {
            if (token.charAt(1) == 'x') {
                return 16;
            }
            return 8;
        }
        return 10;
    }

    public boolean visit(PackageDeclaration node) {
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        return this.isActive();
    }

    public boolean visit(PostfixExpression node) {
        if (!this.isActive()) {
            return false;
        }
        int expressionTypeId = this.getTypeId(node.getOperand());
        String opToken = node.getOperator().toString();
        char char0 = opToken.charAt(0);
        switch (char0) {
            case '+': {
                this.push(new PostfixPlusPlusOperator(expressionTypeId, this.fCounter));
                break;
            }
            case '-': {
                this.push(new PostfixMinusMinusOperator(expressionTypeId, this.fCounter));
                break;
            }
            default: {
                this.setHasError(true);
                this.addErrorMessage(String.valueOf(EvaluationEngineMessages.getString("ASTInstructionCompiler.unrecognized_postfix_operator____15")) + opToken);
            }
        }
        return true;
    }

    public boolean visit(PrefixExpression node) {
        if (!this.isActive()) {
            return false;
        }
        int expressionTypeId = this.getTypeId(node.getOperand());
        String opToken = node.getOperator().toString();
        int opTokenLength = opToken.length();
        char char0 = opToken.charAt(0);
        char char1 = '\u0000';
        if (opTokenLength > 1) {
            char1 = opToken.charAt(1);
        }
        boolean unrecognized = false;
        block0 : switch (char0) {
            case '+': {
                switch (char1) {
                    case '\u0000': {
                        this.push(new UnaryPlusOperator(expressionTypeId, this.fCounter));
                        break block0;
                    }
                    case '+': {
                        this.push(new PrefixPlusPlusOperator(expressionTypeId, this.fCounter));
                        break block0;
                    }
                }
                unrecognized = true;
                break;
            }
            case '-': {
                switch (char1) {
                    case '\u0000': {
                        this.push(new UnaryMinusOperator(expressionTypeId, this.fCounter));
                        break block0;
                    }
                    case '-': {
                        this.push(new PrefixMinusMinusOperator(expressionTypeId, this.fCounter));
                        break block0;
                    }
                }
                unrecognized = true;
                break;
            }
            case '~': {
                this.push(new TwiddleOperator(expressionTypeId, this.fCounter));
                break;
            }
            case '!': {
                this.push(new NotOperator(expressionTypeId, this.fCounter));
                break;
            }
            default: {
                unrecognized = true;
            }
        }
        if (unrecognized) {
            this.setHasError(true);
            this.addErrorMessage(String.valueOf(EvaluationEngineMessages.getString("ASTInstructionCompiler.unrecognized_prefix_operator____16")) + opToken);
        }
        return true;
    }

    public boolean visit(PrimitiveType node) {
        return this.isActive();
    }

    public boolean visit(QualifiedName node) {
        if (!this.isActive()) {
            return false;
        }
        if (this.hasErrors()) {
            return true;
        }
        IBinding binding = node.resolveBinding();
        switch (binding.getKind()) {
            case 2: {
                node.getName().accept((ASTVisitor)this);
                break;
            }
            case 3: {
                SimpleName fieldName = node.getName();
                IVariableBinding fieldBinding = (IVariableBinding)fieldName.resolveBinding();
                ITypeBinding declaringTypeBinding = fieldBinding.getDeclaringClass();
                String fieldId = fieldName.getIdentifier();
                if (Modifier.isStatic((int)fieldBinding.getModifiers())) {
                    this.push(new PushStaticFieldVariable(fieldId, this.getTypeName(declaringTypeBinding), this.fCounter));
                } else {
                    if (declaringTypeBinding == null) {
                        this.push(new PushArrayLength(this.fCounter));
                    } else {
                        this.push(new PushFieldVariable(fieldId, this.getTypeSignature(declaringTypeBinding), this.fCounter));
                    }
                    node.getQualifier().accept((ASTVisitor)this);
                }
                this.storeInstruction();
            }
        }
        return false;
    }

    public boolean visit(ReturnStatement node) {
        if (!this.isActive()) {
            return false;
        }
        this.push(new ReturnInstruction(this.fCounter));
        return true;
    }

    public boolean visit(SimpleName node) {
        if (!this.isActive()) {
            return false;
        }
        if (this.hasErrors()) {
            return true;
        }
        IBinding binding = node.resolveBinding();
        String variableId = node.getIdentifier();
        if (binding == null) {
            this.setHasError(true);
            this.addErrorMessage(String.valueOf(EvaluationEngineMessages.getString("ASTInstructionCompiler.binding_null_for__17")) + variableId);
            return true;
        }
        switch (binding.getKind()) {
            case 2: {
                ITypeBinding typeBinding = (ITypeBinding)binding;
                this.push(new PushType(this.getTypeName(typeBinding)));
                break;
            }
            case 3: {
                IVariableBinding variableBinding = (IVariableBinding)binding;
                ITypeBinding declaringTypeBinding = variableBinding.getDeclaringClass();
                if (variableBinding.isField()) {
                    if (Modifier.isStatic((int)variableBinding.getModifiers())) {
                        this.push(new PushStaticFieldVariable(variableId, this.getTypeName(declaringTypeBinding), this.fCounter));
                        break;
                    }
                    this.push(new PushFieldVariable(variableId, this.getTypeSignature(declaringTypeBinding), this.fCounter));
                    this.push(new PushThis(this.getEnclosingLevel((ASTNode)node, declaringTypeBinding)));
                    this.storeInstruction();
                    break;
                }
                this.push(new PushLocalVariable(variableId));
            }
        }
        return true;
    }

    public boolean visit(SimpleType node) {
        if (!this.isActive()) {
            return false;
        }
        ITypeBinding typeBinding = node.resolveBinding();
        this.push(new PushType(this.getTypeName(typeBinding)));
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        if (!this.isActive()) {
            return false;
        }
        Expression initializer = node.getInitializer();
        boolean hasInitializer = initializer != null;
        ITypeBinding typeBinding = node.getType().resolveBinding();
        int typeDimension = typeBinding.getDimensions();
        if (typeDimension != 0) {
            typeBinding = typeBinding.getElementType();
        }
        this.push(new LocalVariableCreation(node.getName().getIdentifier(), this.getTypeSignature(typeBinding), typeDimension, typeBinding.isPrimitive(), hasInitializer, this.fCounter));
        if (hasInitializer) {
            initializer.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(StringLiteral node) {
        if (!this.isActive()) {
            return false;
        }
        this.push(new PushString(node.getLiteralValue()));
        return true;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (!this.isActive()) {
            return false;
        }
        this.setHasError(true);
        this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.super_constructor_invocation_cannot_be_used_in_an_evaluation_expression_19"));
        return false;
    }

    public boolean visit(SuperFieldAccess node) {
        if (!this.isActive()) {
            return false;
        }
        SimpleName fieldName = node.getName();
        IVariableBinding fieldBinding = (IVariableBinding)fieldName.resolveBinding();
        ITypeBinding declaringTypeBinding = fieldBinding.getDeclaringClass();
        String fieldId = fieldName.getIdentifier();
        if (Modifier.isStatic((int)fieldBinding.getModifiers())) {
            this.push(new PushStaticFieldVariable(fieldId, this.getTypeName(declaringTypeBinding), this.fCounter));
        } else {
            Name qualifier = node.getQualifier();
            int superLevel = 1;
            int enclosingLevel = 0;
            if (qualifier != null) {
                superLevel = this.getSuperLevel(qualifier.resolveTypeBinding(), declaringTypeBinding);
                enclosingLevel = this.getEnclosingLevel((ASTNode)node, (ITypeBinding)qualifier.resolveBinding());
            }
            this.push(new PushFieldVariable(fieldId, superLevel, this.fCounter));
            this.push(new PushThis(enclosingLevel));
            this.storeInstruction();
        }
        return false;
    }

    public boolean visit(SuperMethodInvocation node) {
        if (!this.isActive()) {
            return false;
        }
        IMethodBinding methodBinding = (IMethodBinding)node.getName().resolveBinding();
        if (this.containsALocalType(methodBinding)) {
            this.setHasError(true);
            this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Method_which_contains_a_local_type_as_parameter_cannot_be_used_in_an_evaluation_expression_32"));
        }
        if (this.hasErrors()) {
            return true;
        }
        ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
        int argCount = parameterTypes.length;
        String selector = methodBinding.getName();
        String signature = this.getMethodSignature(methodBinding, null);
        Name qualifier = node.getQualifier();
        if (Modifier.isStatic((int)methodBinding.getModifiers())) {
            this.push(new SendStaticMessage(this.getTypeName(methodBinding.getDeclaringClass()), selector, signature, argCount, this.fCounter));
        } else {
            this.push(new SendMessage(selector, signature, argCount, this.getTypeSignature(methodBinding.getDeclaringClass()), this.fCounter));
            int enclosingLevel = 0;
            if (qualifier != null) {
                enclosingLevel = this.getEnclosingLevel((ASTNode)node, (ITypeBinding)qualifier.resolveBinding());
            }
            this.push(new PushThis(enclosingLevel));
            this.storeInstruction();
        }
        Iterator iterator = node.arguments().iterator();
        while (iterator.hasNext()) {
            ((Expression)iterator.next()).accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(SwitchCase node) {
        if (!this.isActive()) {
            return false;
        }
        this.setHasError(true);
        this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Switch_case_cannot_be_used_in_an_evaluation_expression_20"));
        return true;
    }

    public boolean visit(SwitchStatement node) {
        if (!this.isActive()) {
            return false;
        }
        this.setHasError(true);
        this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Switch_statement_cannot_be_used_in_an_evaluation_expression_21"));
        return true;
    }

    public boolean visit(SynchronizedStatement node) {
        return this.isActive();
    }

    public boolean visit(ThisExpression node) {
        if (!this.isActive()) {
            return false;
        }
        Name qualifier = node.getQualifier();
        int enclosingLevel = 0;
        if (qualifier != null) {
            enclosingLevel = this.getEnclosingLevel((ASTNode)node, (ITypeBinding)qualifier.resolveBinding());
        }
        this.push(new PushThis(enclosingLevel));
        return false;
    }

    public boolean visit(ThrowStatement node) {
        if (!this.isActive()) {
            return false;
        }
        this.setHasError(true);
        this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Throw_statement_cannot_be_used_in_an_evaluation_expression_22"));
        return true;
    }

    public boolean visit(TryStatement node) {
        if (!this.isActive()) {
            return false;
        }
        this.setHasError(true);
        this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Try_statement_cannot_be_used_in_an_evaluation_expression_23"));
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        if (!this.isActive()) {
            return true;
        }
        this.setHasError(true);
        this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Type_declaration_cannot_be_used_in_an_evaluation_expression_24"));
        return true;
    }

    public boolean visit(TypeDeclarationStatement node) {
        if (!this.isActive()) {
            return true;
        }
        this.setHasError(true);
        this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Type_declaration_statement_cannot_be_used_in_an_evaluation_expression_25"));
        return false;
    }

    public boolean visit(TypeLiteral node) {
        if (!this.isActive()) {
            return false;
        }
        this.push(new PushClassLiteralValue(this.fCounter));
        return true;
    }

    public boolean visit(VariableDeclarationExpression node) {
        if (!this.isActive()) {
            return false;
        }
        Iterator iter = node.fragments().iterator();
        while (iter.hasNext()) {
            ((VariableDeclarationFragment)iter.next()).accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(VariableDeclarationFragment node) {
        Expression initializer;
        ITypeBinding typeBinding;
        if (!this.isActive()) {
            return false;
        }
        ASTNode parent = node.getParent();
        switch (parent.getNodeType()) {
            case 58: {
                typeBinding = ((VariableDeclarationExpression)parent).getType().resolveBinding();
                break;
            }
            case 60: {
                typeBinding = ((VariableDeclarationStatement)parent).getType().resolveBinding();
                break;
            }
            default: {
                this.setHasError(true);
                this.addErrorMessage(EvaluationEngineMessages.getString("ASTInstructionCompiler.Error_in_type_declaration_statement"));
                return false;
            }
        }
        int typeDimension = typeBinding.getDimensions();
        if (typeDimension != 0) {
            typeBinding = typeBinding.getElementType();
        }
        boolean hasInitializer = (initializer = node.getInitializer()) != null;
        this.push(new LocalVariableCreation(node.getName().getIdentifier(), this.getTypeSignature(typeBinding), typeDimension, typeBinding.isPrimitive(), hasInitializer, this.fCounter));
        if (hasInitializer) {
            initializer.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(VariableDeclarationStatement node) {
        if (!this.isActive()) {
            return false;
        }
        Iterator iter = node.fragments().iterator();
        while (iter.hasNext()) {
            ((VariableDeclarationFragment)iter.next()).accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(WhileStatement node) {
        if (!this.isActive()) {
            return false;
        }
        this.push(new NoOp(this.fCounter));
        return true;
    }

    private int getTypeId(Expression expression) {
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        String typeName = typeBinding.getName();
        if (typeBinding.isPrimitive()) {
            return this.getPrimitiveTypeId(typeName);
        }
        if ("String".equals(typeName) && "java.lang".equals(typeBinding.getPackage().getName())) {
            return 11;
        }
        return 1;
    }

    private int getTypeId(Type type) {
        if (type.isPrimitiveType()) {
            return this.getPrimitiveTypeId(((PrimitiveType)type).getPrimitiveTypeCode().toString());
        }
        if (type.isSimpleType()) {
            SimpleType simpleType = (SimpleType)type;
            if ("java.lang.String".equals(simpleType.getName())) {
                return 11;
            }
            return 1;
        }
        if (type.isArrayType()) {
            return 1;
        }
        return 0;
    }

    private String getMethodSignature(IMethodBinding methodBinding, String enclosingTypeSignature) {
        String[] parameterSignatures;
        int argCount;
        int i;
        ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
        if (enclosingTypeSignature == null) {
            i = 0;
            argCount = parameterTypes.length;
            parameterSignatures = new String[argCount];
        } else {
            i = 1;
            argCount = parameterTypes.length + 1;
            parameterSignatures = new String[argCount];
            parameterSignatures[0] = enclosingTypeSignature;
        }
        while (i < argCount) {
            parameterSignatures[i] = this.getTypeSignature(parameterTypes[i]);
            ++i;
        }
        String signature = Signature.createMethodSignature((String[])parameterSignatures, (String)this.getTypeSignature(methodBinding.getReturnType()));
        return signature;
    }

    private int getPrimitiveTypeId(String typeName) {
        switch (typeName.charAt(0)) {
            case 'b': {
                switch (typeName.charAt(1)) {
                    case 'o': {
                        return 5;
                    }
                    case 'y': {
                        return 3;
                    }
                }
                break;
            }
            case 'c': {
                return 2;
            }
            case 'd': {
                return 8;
            }
            case 'f': {
                return 9;
            }
            case 'i': {
                return 10;
            }
            case 'l': {
                return 7;
            }
            case 'n': {
                return 12;
            }
            case 's': {
                return 4;
            }
            case 'v': {
                return 6;
            }
        }
        return 0;
    }

    class CompleteInstruction {
        Jump fInstruction;
        String fLabel;
        boolean fIsBreak;

        public CompleteInstruction(Jump instruction, String label, boolean isBreak) {
            this.fInstruction = instruction;
            this.fLabel = label;
            this.fIsBreak = isBreak;
        }
    }
}

