/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.request.StepRequest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.jdi.hcr.EventRequestManager;
import org.eclipse.jdi.hcr.ReenterStepRequest;
import org.eclipse.jdi.hcr.ThreadReference;
import org.eclipse.jdt.debug.core.IEvaluationRunnable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.IJDIEventListener;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.StringMatcher;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugElement;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;

public class JDIThread
extends JDIDebugElement
implements IJavaThread {
    private static final String MAIN_THREAD_GROUP = "main";
    public static final int SUSPEND_TIMEOUT = 161;
    private com.sun.jdi.ThreadReference fThread;
    private String fPreviousName;
    private List fStackFrames;
    private ThreadGroupReference fThreadGroup;
    private String fThreadGroupName;
    private boolean fRefreshChildren = true;
    private StepHandler fStepHandler = null;
    private boolean fRunning;
    private boolean fTerminated;
    private boolean fSuspendedQuiet;
    private boolean fIsSystemThread;
    private List fCurrentBreakpoints = new ArrayList(2);
    private boolean fIsPerformingEvaluation = false;
    private IEvaluationRunnable fEvaluationRunnable;
    private boolean fEvaluationInterrupted = false;
    private boolean fIsInvokingMethod = false;
    private boolean fHonorBreakpoints = true;
    private int fOriginalStepKind;
    private Location fOriginalStepLocation;
    private int fOriginalStepStackDepth;
    private boolean fUseStepFilters = false;
    private boolean fIsSuspending = false;
    private AsyncThread fAsyncThread;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JDIThread(JDIDebugTarget target, com.sun.jdi.ThreadReference thread) throws ObjectCollectedException {
        super(target);
        this.setUnderlyingThread(thread);
        this.initialize();
    }

    protected void initialize() throws ObjectCollectedException {
        this.fStackFrames = Collections.EMPTY_LIST;
        try {
            this.determineIfSystemThread();
        }
        catch (DebugException e) {
            Throwable underlyingException = e.getStatus().getException();
            if (underlyingException instanceof VMDisconnectedException) {
                this.disconnected();
                return;
            }
            if (underlyingException instanceof ObjectCollectedException) {
                throw (ObjectCollectedException)underlyingException;
            }
            this.logError((Exception)((Object)e));
        }
        this.setTerminated(false);
        this.setRunning(false);
        try {
            this.setRunning(!this.getUnderlyingThread().isSuspended());
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.disconnected();
            return;
        }
        catch (ObjectCollectedException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.logError(e);
        }
    }

    protected void addCurrentBreakpoint(IBreakpoint bp) {
        this.fCurrentBreakpoints.add(bp);
    }

    protected void removeCurrentBreakpoint(IBreakpoint bp) {
        this.fCurrentBreakpoints.remove(bp);
    }

    public IBreakpoint[] getBreakpoints() {
        return this.fCurrentBreakpoints.toArray(new IBreakpoint[this.fCurrentBreakpoints.size()]);
    }

    public boolean canResume() {
        return this.isSuspended() && !this.isSuspendedQuiet() && (!this.isPerformingEvaluation() || this.isInvokingMethod()) && !this.getDebugTarget().isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended() || this.isSuspendedQuiet() || this.isPerformingEvaluation() && !this.isInvokingMethod();
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean canStepInto() {
        return this.canStep();
    }

    public boolean canStepOver() {
        return this.canStep();
    }

    public boolean canStepReturn() {
        return this.canStep();
    }

    protected boolean canStep() {
        try {
            return this.isSuspended() && !this.isSuspendedQuiet() && (!this.isPerformingEvaluation() || this.isInvokingMethod()) && !this.isStepping() && this.getTopStackFrame() != null && !this.getJavaDebugTarget().isPerformingHotCodeReplace();
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    protected void determineIfSystemThread() throws DebugException {
        this.fIsSystemThread = false;
        ThreadGroupReference tgr = this.getUnderlyingThreadGroup();
        this.fIsSystemThread = tgr != null;
        while (tgr != null) {
            String tgn = null;
            try {
                tgn = tgr.name();
                tgr = tgr.parent();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.fIsSystemThread = false;
                break;
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_determining_if_system_thread"), e.toString()), e);
                return;
            }
            if (tgn == null || !tgn.equals(MAIN_THREAD_GROUP)) continue;
            this.fIsSystemThread = false;
            break;
        }
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspendedQuiet()) {
            return new IStackFrame[0];
        }
        List list = this.computeStackFrames();
        return list.toArray(new IStackFrame[list.size()]);
    }

    protected synchronized List computeStackFrames(boolean refreshChildren) throws DebugException {
        if (this.isSuspended()) {
            if (this.isTerminated()) {
                this.fStackFrames = Collections.EMPTY_LIST;
            } else if (refreshChildren) {
                Method currMethod;
                if (this.fStackFrames.isEmpty()) {
                    this.fStackFrames = this.createAllStackFrames();
                    if (this.fStackFrames.isEmpty()) {
                        return this.fStackFrames;
                    }
                }
                List frames = this.getUnderlyingFrames();
                boolean topDown = false;
                Method lastMethod = ((JDIStackFrame)this.fStackFrames.get(0)).getLastMethod();
                if (frames.size() > 0 && (currMethod = ((StackFrame)frames.get(0)).location().method()).equals(lastMethod)) {
                    topDown = true;
                }
                int offset = 0;
                int length = frames.size();
                if (length > this.fStackFrames.size()) {
                    if (topDown) {
                        int num = length - this.fStackFrames.size();
                        int i = 0;
                        while (i < num) {
                            this.fStackFrames.add(new JDIStackFrame(this, null));
                            ++i;
                        }
                    } else {
                        offset = length - this.fStackFrames.size();
                        int i = offset - 1;
                        while (i >= 0) {
                            JDIStackFrame newStackFrame = new JDIStackFrame(this, (StackFrame)frames.get(i));
                            this.fStackFrames.add(0, newStackFrame);
                            --i;
                        }
                        length = this.fStackFrames.size() - offset;
                    }
                } else if (length < this.fStackFrames.size()) {
                    int removed = this.fStackFrames.size() - length;
                    if (topDown) {
                        int i = 0;
                        while (i < removed) {
                            this.fStackFrames.remove(this.fStackFrames.size() - 1);
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < removed) {
                            this.fStackFrames.remove(0);
                            ++i;
                        }
                    }
                } else if (length == 0) {
                    this.fStackFrames = Collections.EMPTY_LIST;
                }
                if (offset < this.fStackFrames.size()) {
                    this.updateStackFrames(frames, offset, length);
                }
            }
        } else {
            return Collections.EMPTY_LIST;
        }
        this.fRefreshChildren = false;
        return this.fStackFrames;
    }

    public List computeStackFrames() throws DebugException {
        return this.computeStackFrames(this.fRefreshChildren);
    }

    public List computeNewStackFrames() throws DebugException {
        return this.computeStackFrames(true);
    }

    protected List createAllStackFrames() throws DebugException {
        List frames = this.getUnderlyingFrames();
        ArrayList<JDIStackFrame> list = new ArrayList<JDIStackFrame>(frames.size());
        Iterator iter = frames.iterator();
        while (iter.hasNext()) {
            JDIStackFrame newStackFrame = new JDIStackFrame(this, (StackFrame)iter.next());
            list.add(newStackFrame);
        }
        return list;
    }

    protected List getUnderlyingFrames() throws DebugException {
        try {
            return this.getUnderlyingThread().frames();
        }
        catch (IncompatibleThreadStateException e) {
            this.requestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_retrieving_stack_frames"), e.toString()), e, 100);
            return null;
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_retrieving_stack_frames_2"), e.toString()), e);
            return null;
        }
        catch (InternalError e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_retrieving_stack_frames_2"), e.toString()), e);
            return null;
        }
    }

    protected Method getUnderlyingMethod(StackFrame frame) throws DebugException {
        try {
            return frame.location().method();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_retrieving_method"), e.toString()), e);
            return null;
        }
    }

    protected int getUnderlyingFrameCount() throws DebugException {
        try {
            return this.getUnderlyingThread().frameCount();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_retrieving_frame_count"), e.toString()), e);
        }
        catch (IncompatibleThreadStateException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_retrieving_frame_count"), e.toString()), e);
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public void runEvaluation(IEvaluationRunnable evaluation, IProgressMonitor monitor, int evaluationDetail, boolean hitBreakpoints) throws DebugException {
        block12: {
            block10: {
                block11: {
                    if (this.isPerformingEvaluation()) {
                        this.requestFailed(JDIDebugModelMessages.getString("JDIThread.Cannot_perform_nested_evaluations"), null, 101);
                    }
                    if (!this.canRunEvaluation()) {
                        this.requestFailed(JDIDebugModelMessages.getString("JDIThread.Evaluation_failed_-_thread_not_suspended"), null, 100);
                    }
                    this.fIsPerformingEvaluation = true;
                    this.fEvaluationRunnable = evaluation;
                    this.fHonorBreakpoints = hitBreakpoints;
                    this.fireResumeEvent(evaluationDetail);
                    breakpoints = this.getBreakpoints();
                    try {
                        evaluation.run(this, monitor);
                        break block10;
                    }
                    catch (Throwable var8_7) {
                        var7_8 = null;
                        this.fIsPerformingEvaluation = false;
                        this.fEvaluationRunnable = null;
                        this.fHonorBreakpoints = true;
                        if (this.getBreakpoints().length != 0 || breakpoints.length <= 0) break block11;
                        i = 0;
                        ** while (i < breakpoints.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.addCurrentBreakpoint(breakpoints[i]);
                        ++i;
                        continue;
                    }
                }
                this.fireSuspendEvent(evaluationDetail);
                if (this.fEvaluationInterrupted && (this.fAsyncThread == null || this.fAsyncThread.isEmpty())) {
                    this.fEvaluationInterrupted = false;
                    this.fireChangeEvent(512);
                }
                throw var8_7;
            }
            var7_9 = null;
            this.fIsPerformingEvaluation = false;
            this.fEvaluationRunnable = null;
            this.fHonorBreakpoints = true;
            if (this.getBreakpoints().length == 0 && breakpoints.length > 0) {
                i = 0;
                while (i < breakpoints.length) {
                    this.addCurrentBreakpoint(breakpoints[i]);
                    ++i;
                }
            }
            this.fireSuspendEvent(evaluationDetail);
            if (!this.fEvaluationInterrupted || this.fAsyncThread != null && !this.fAsyncThread.isEmpty()) break block12;
            this.fEvaluationInterrupted = false;
            this.fireChangeEvent(512);
        }
    }

    protected boolean canRunEvaluation() {
        try {
            return this.isSuspendedQuiet() || this.isSuspended() && !this.isPerformingEvaluation() && !this.isInvokingMethod() && !this.isStepping() && this.getTopStackFrame() != null && !this.getJavaDebugTarget().isPerformingHotCodeReplace();
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public void queueRunnable(Runnable evaluation) {
        if (this.fAsyncThread == null) {
            this.fAsyncThread = new AsyncThread();
        }
        this.fAsyncThread.addRunnable(evaluation);
    }

    public void terminateEvaluation() throws DebugException {
        if (this.canTerminateEvaluation()) {
            ((ITerminate)this.fEvaluationRunnable).terminate();
        }
    }

    public boolean canTerminateEvaluation() {
        return this.fEvaluationRunnable instanceof ITerminate;
    }

    protected Value invokeMethod(ClassType receiverClass, ObjectReference receiverObject, Method method, List args, boolean invokeNonvirtual) throws DebugException {
        if (receiverClass != null && receiverObject != null) {
            throw new IllegalArgumentException(JDIDebugModelMessages.getString("JDIThread.can_only_specify_one_receiver_for_a_method_invocation"));
        }
        Value result = null;
        int timeout = this.getRequestTimeout();
        try {
            JDIThread jDIThread = this;
            synchronized (jDIThread) {
                if (!this.isSuspended()) {
                    this.requestFailed(JDIDebugModelMessages.getString("JDIThread.Evaluation_failed_-_thread_not_suspended"), null, 100);
                }
                if (this.isInvokingMethod()) {
                    this.requestFailed(JDIDebugModelMessages.getString("JDIThread.Cannot_perform_nested_evaluations"), null, 101);
                }
                this.setRequestTimeout(Integer.MAX_VALUE);
                this.setRunning(true);
                this.setInvokingMethod(true);
            }
            this.preserveStackFrames();
            int flags = 1;
            if (invokeNonvirtual) {
                flags |= 2;
            }
            result = receiverClass == null ? receiverObject.invokeMethod(this.getUnderlyingThread(), method, args, flags) : receiverClass.invokeMethod(this.getUnderlyingThread(), method, args, flags);
        }
        catch (InvalidTypeException e) {
            this.invokeFailed(e, timeout);
        }
        catch (ClassNotLoadedException e) {
            this.invokeFailed(e, timeout);
        }
        catch (IncompatibleThreadStateException e) {
            this.invokeFailed(JDIDebugModelMessages.getString("JDIThread.Thread_must_be_suspended_by_step_or_breakpoint_to_perform_method_invocation_1"), 102, e, timeout);
        }
        catch (InvocationException e) {
            this.invokeFailed(e, timeout);
        }
        catch (RuntimeException e) {
            this.invokeFailed(e, timeout);
        }
        this.invokeComplete(timeout);
        return result;
    }

    protected ObjectReference newInstance(ClassType receiverClass, Method constructor, List args) throws DebugException {
        if (this.isInvokingMethod()) {
            this.requestFailed(JDIDebugModelMessages.getString("JDIThread.Cannot_perform_nested_evaluations_2"), null);
        }
        ObjectReference result = null;
        int timeout = this.getRequestTimeout();
        try {
            this.setRequestTimeout(Integer.MAX_VALUE);
            this.setRunning(true);
            this.setInvokingMethod(true);
            this.preserveStackFrames();
            result = receiverClass.newInstance(this.getUnderlyingThread(), constructor, args, 1);
        }
        catch (InvalidTypeException e) {
            this.invokeFailed(e, timeout);
        }
        catch (ClassNotLoadedException e) {
            this.invokeFailed(e, timeout);
        }
        catch (IncompatibleThreadStateException e) {
            this.invokeFailed(e, timeout);
        }
        catch (InvocationException e) {
            this.invokeFailed(e, timeout);
        }
        catch (RuntimeException e) {
            this.invokeFailed(e, timeout);
        }
        this.invokeComplete(timeout);
        return result;
    }

    protected void invokeFailed(Throwable e, int restoreTimeout) throws DebugException {
        this.invokeFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_invoking_method"), e.toString()), 5010, e, restoreTimeout);
    }

    protected void invokeFailed(String message, int code, Throwable e, int restoreTimeout) throws DebugException {
        this.invokeComplete(restoreTimeout);
        this.requestFailed(message, e, code);
    }

    protected void invokeComplete(int restoreTimeout) {
        this.abortStep();
        this.setInvokingMethod(false);
        this.setRunning(false);
        this.setRequestTimeout(restoreTimeout);
        try {
            this.computeStackFrames();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
    }

    public String getName() throws DebugException {
        try {
            this.fPreviousName = this.getUnderlyingThread().name();
            return this.fPreviousName;
        }
        catch (RuntimeException e) {
            if (e instanceof ObjectCollectedException) {
                if (this.fPreviousName == null) {
                    return JDIDebugModelMessages.getString("JDIThread.garbage_collected_1");
                }
                return this.fPreviousName;
            }
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_retrieving_thread_name"), e.toString()), e);
            return null;
        }
    }

    public int getPriority() throws DebugException {
        Field p = null;
        try {
            Value v;
            p = this.getUnderlyingThread().referenceType().fieldByName("priority");
            if (p == null) {
                this.requestFailed(JDIDebugModelMessages.getString("JDIThread.no_priority_field"), null);
            }
            if ((v = this.getUnderlyingThread().getValue(p)) instanceof IntegerValue) {
                return ((IntegerValue)v).value();
            }
            this.requestFailed(JDIDebugModelMessages.getString("JDIThread.priority_not_an_integer"), null);
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_retrieving_thread_priority"), e.toString()), e);
        }
        return -1;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        List c = this.computeStackFrames();
        if (c.isEmpty()) {
            return null;
        }
        return (IStackFrame)c.get(0);
    }

    public boolean handleSuspendForBreakpoint(JavaBreakpoint breakpoint, boolean queueEvent) {
        this.addCurrentBreakpoint(breakpoint);
        this.setSuspendedQuiet(false);
        try {
            if (breakpoint.getSuspendPolicy() == 1) {
                ((JDIDebugTarget)this.getDebugTarget()).prepareToSuspendByBreakpoint(breakpoint);
            } else {
                this.setRunning(false);
            }
            boolean suspend = JDIDebugPlugin.getDefault().fireBreakpointHit(this, breakpoint);
            if (suspend) {
                if (breakpoint.getSuspendPolicy() == 1) {
                    ((JDIDebugTarget)this.getDebugTarget()).suspendedByBreakpoint(breakpoint, queueEvent);
                }
                this.abortStep();
                if (queueEvent) {
                    this.queueSuspendEvent(16);
                } else {
                    this.fireSuspendEvent(16);
                }
            } else if (breakpoint.getSuspendPolicy() == 1) {
                ((JDIDebugTarget)this.getDebugTarget()).cancelSuspendByBreakpoint(breakpoint);
            } else {
                this.setRunning(true);
                this.preserveStackFrames();
            }
            return suspend;
        }
        catch (CoreException e) {
            this.logError((Exception)((Object)e));
            return true;
        }
    }

    public boolean handleSuspendForBreakpointQuiet(JavaBreakpoint breakpoint) {
        this.addCurrentBreakpoint(breakpoint);
        this.setSuspendedQuiet(true);
        this.setRunning(false);
        return true;
    }

    public boolean isStepping() {
        return this.getPendingStepHandler() != null;
    }

    public boolean isSuspended() {
        return !this.fRunning && !this.fTerminated;
    }

    public boolean isSuspendedQuiet() {
        return this.fSuspendedQuiet;
    }

    public boolean isSystemThread() {
        return this.fIsSystemThread;
    }

    public String getThreadGroupName() throws DebugException {
        if (this.fThreadGroupName == null) {
            ThreadGroupReference tgr = this.getUnderlyingThreadGroup();
            if (tgr == null) {
                return null;
            }
            try {
                this.fThreadGroupName = tgr.name();
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_retrieving_thread_group_name"), e.toString()), e);
                return null;
            }
        }
        return this.fThreadGroupName;
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public boolean isOutOfSynch() throws DebugException {
        if (this.isSuspended() && ((JDIDebugTarget)this.getDebugTarget()).hasHCRFailed()) {
            List frames = this.computeStackFrames();
            Iterator iter = frames.iterator();
            while (iter.hasNext()) {
                if (!((JDIStackFrame)iter.next()).isOutOfSynch()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean mayBeOutOfSynch() throws DebugException {
        if (!this.isSuspended()) {
            return ((JDIDebugTarget)this.getDebugTarget()).hasHCRFailed();
        }
        return false;
    }

    protected void setTerminated(boolean terminated) {
        this.fTerminated = terminated;
    }

    public void resume() throws DebugException {
        this.resumeThread(true);
    }

    public void resumeQuiet() throws DebugException {
        this.resumeThread(false);
    }

    private void resumeThread(boolean fireNotification) throws DebugException {
        if (!this.isSuspended() || this.isPerformingEvaluation() && !this.isInvokingMethod()) {
            return;
        }
        try {
            this.setRunning(true);
            this.setSuspendedQuiet(false);
            this.preserveStackFrames();
            if (fireNotification) {
                this.fireResumeEvent(32);
            }
            this.getUnderlyingThread().resume();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.disconnected();
        }
        catch (RuntimeException e) {
            this.setRunning(false);
            this.fireSuspendEvent(32);
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_resuming"), e.toString()), e);
        }
    }

    protected void setRunning(boolean running) {
        this.fRunning = running;
        if (running) {
            this.fCurrentBreakpoints.clear();
        }
    }

    protected void setSuspendedQuiet(boolean suspendedQuiet) {
        this.fSuspendedQuiet = suspendedQuiet;
    }

    protected synchronized void preserveStackFrames() {
        this.fRefreshChildren = true;
        Iterator frames = this.fStackFrames.iterator();
        while (frames.hasNext()) {
            ((JDIStackFrame)frames.next()).setUnderlyingStackFrame(null);
        }
    }

    protected synchronized void disposeStackFrames() {
        this.fStackFrames = Collections.EMPTY_LIST;
        this.fRefreshChildren = true;
    }

    public synchronized void stepInto() throws DebugException {
        if (!this.canStepInto()) {
            return;
        }
        StepIntoHandler handler = new StepIntoHandler();
        handler.step();
    }

    public synchronized void stepOver() throws DebugException {
        if (!this.canStepOver()) {
            return;
        }
        StepOverHandler handler = new StepOverHandler();
        handler.step();
    }

    public synchronized void stepReturn() throws DebugException {
        if (!this.canStepReturn()) {
            return;
        }
        StepReturnHandler handler = new StepReturnHandler();
        handler.step();
    }

    protected void setOriginalStepKind(int stepKind) {
        this.fOriginalStepKind = stepKind;
    }

    protected int getOriginalStepKind() {
        return this.fOriginalStepKind;
    }

    protected void setOriginalStepLocation(Location location) {
        this.fOriginalStepLocation = location;
    }

    protected Location getOriginalStepLocation() {
        return this.fOriginalStepLocation;
    }

    protected void setOriginalStepStackDepth(int depth) {
        this.fOriginalStepStackDepth = depth;
    }

    protected int getOriginalStepStackDepth() {
        return this.fOriginalStepStackDepth;
    }

    protected boolean shouldDoExtraStepInto(Location location) throws DebugException {
        Method currMethod;
        if (this.getOriginalStepKind() != 1) {
            return false;
        }
        if (this.getOriginalStepStackDepth() != this.getUnderlyingFrameCount()) {
            return false;
        }
        Location origLocation = this.getOriginalStepLocation();
        if (origLocation == null) {
            return false;
        }
        Method origMethod = origLocation.method();
        if (!origMethod.equals(currMethod = location.method())) {
            return false;
        }
        return origLocation.lineNumber() == location.lineNumber();
    }

    public void suspend() throws DebugException {
        try {
            this.abortStep();
            this.setSuspendedQuiet(false);
            this.fEvaluationInterrupted = this.isPerformingEvaluation();
            this.suspendUnderlyingThread();
        }
        catch (RuntimeException e) {
            this.setRunning(true);
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_suspending"), e.toString()), e);
        }
    }

    protected void suspendUnderlyingThread() {
        if (this.fIsSuspending) {
            return;
        }
        this.fIsSuspending = true;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    try {
                        JDIThread.this.getUnderlyingThread().suspend();
                        int timeout = JDIDebugModel.getPreferences().getInt(JDIDebugModel.PREF_REQUEST_TIMEOUT);
                        long stop = System.currentTimeMillis() + (long)timeout;
                        boolean suspended = JDIThread.this.isUnderlyingThreadSuspended();
                        while (System.currentTimeMillis() < stop && !suspended) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {}
                            suspended = JDIThread.this.isUnderlyingThreadSuspended();
                            if (suspended) break;
                        }
                        if (!suspended) {
                            Status status = new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 161, MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.suspend_timeout"), new Integer(timeout).toString()), null);
                            IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                            if (handler != null) {
                                try {
                                    handler.handleStatus((IStatus)status, (Object)JDIThread.this);
                                }
                                catch (CoreException coreException) {}
                            }
                        }
                        JDIThread.this.setRunning(false);
                        JDIThread.this.fireSuspendEvent(32);
                    }
                    catch (RuntimeException runtimeException) {}
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    JDIThread.this.fIsSuspending = false;
                    throw throwable;
                }
                Object var7_8 = null;
                JDIThread.this.fIsSuspending = false;
            }
        });
        thread.start();
    }

    public boolean isUnderlyingThreadSuspended() {
        return this.getUnderlyingThread().isSuspended();
    }

    protected void suspendedByVM() {
        this.setRunning(false);
        this.setSuspendedQuiet(false);
    }

    protected void resumedByVM() {
        this.setRunning(true);
        this.preserveStackFrames();
        com.sun.jdi.ThreadReference thread = this.getUnderlyingThread();
        while (thread.suspendCount() > 1) {
            thread.resume();
        }
    }

    public void terminate() throws DebugException {
        this.terminateEvaluation();
        this.getDebugTarget().terminate();
    }

    protected void updateStackFrames(List newFrames, int offset, int length) throws DebugException {
        int i = 0;
        while (i < length) {
            JDIStackFrame oldFrame = (JDIStackFrame)this.fStackFrames.get(offset);
            StackFrame newFrame = (StackFrame)newFrames.get(offset);
            if (oldFrame.getLastMethod() != null && oldFrame.getLastMethod().equals(newFrame.location().method())) {
                oldFrame.setUnderlyingStackFrame(newFrame);
            } else {
                this.fStackFrames.set(offset, new JDIStackFrame(this, newFrame));
            }
            ++offset;
            ++i;
        }
    }

    protected void dropToFrame(IStackFrame frame) throws DebugException {
        JDIDebugTarget target = (JDIDebugTarget)this.getDebugTarget();
        if (target.canPopFrames()) {
            try {
                this.popFrame(frame);
                this.stepInto();
            }
            catch (RuntimeException exception) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_dropping_to_frame"), exception.toString()), exception);
            }
        } else {
            JDIThread jDIThread = this;
            synchronized (jDIThread) {
                DropToFrameHandler handler = new DropToFrameHandler(frame);
                handler.step();
            }
        }
    }

    protected void popFrame(IStackFrame frame) throws DebugException {
        JDIDebugTarget target = (JDIDebugTarget)this.getDebugTarget();
        if (target.canPopFrames()) {
            try {
                StackFrame jdiFrame = null;
                int desiredSize = this.fStackFrames.size() - this.fStackFrames.indexOf(frame) - 1;
                int lastSize = this.fStackFrames.size() + 1;
                int size = this.fStackFrames.size();
                while (size < lastSize && size > desiredSize) {
                    jdiFrame = ((JDIStackFrame)frame).getUnderlyingStackFrame();
                    this.preserveStackFrames();
                    this.fThread.popFrames(jdiFrame);
                    lastSize = size;
                    size = this.computeStackFrames().size();
                }
            }
            catch (IncompatibleThreadStateException exception) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_popping"), exception.toString()), exception);
            }
            catch (InvalidStackFrameException exception) {
                this.fireChangeEvent(512);
                this.targetRequestFailed(exception.toString(), exception);
            }
            catch (RuntimeException exception) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_popping"), exception.toString()), exception);
            }
        }
    }

    protected synchronized void stepToFrame(IStackFrame frame) throws DebugException {
        if (!this.canStepReturn()) {
            return;
        }
        StepToFrameHandler handler = new StepToFrameHandler(frame);
        handler.step();
    }

    protected void abortStep() {
        StepHandler handler = this.getPendingStepHandler();
        if (handler != null) {
            handler.abort();
        }
    }

    public IJavaVariable findVariable(String varName) throws DebugException {
        block5: {
            if (this.isSuspended()) {
                try {
                    IStackFrame[] stackFrames = this.getStackFrames();
                    int i = 0;
                    while (i < stackFrames.length) {
                        IJavaStackFrame sf = (IJavaStackFrame)stackFrames[i];
                        IJavaVariable var = sf.findVariable(varName);
                        if (var != null) {
                            return var;
                        }
                        ++i;
                    }
                }
                catch (DebugException e) {
                    if (e.getStatus().getCode() == 100) break block5;
                    throw e;
                }
            }
        }
        return null;
    }

    protected void terminated() {
        this.setTerminated(true);
        this.setRunning(false);
        this.fireTerminateEvent();
    }

    public com.sun.jdi.ThreadReference getUnderlyingThread() {
        return this.fThread;
    }

    protected void setUnderlyingThread(com.sun.jdi.ThreadReference thread) {
        this.fThread = thread;
    }

    protected ThreadGroupReference getUnderlyingThreadGroup() throws DebugException {
        if (this.fThreadGroup == null) {
            try {
                this.fThreadGroup = this.getUnderlyingThread().threadGroup();
            }
            catch (UnsupportedOperationException e) {
                this.requestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_retrieving_thread_group"), e.toString()), e);
                return null;
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_retrieving_thread_group"), e.toString()), e);
                return null;
            }
        }
        return this.fThreadGroup;
    }

    public boolean isPerformingEvaluation() {
        return this.fIsPerformingEvaluation;
    }

    public boolean isInvokingMethod() {
        return this.fIsInvokingMethod;
    }

    public boolean isIgnoringBreakpoints() {
        return !this.fHonorBreakpoints;
    }

    protected void setInvokingMethod(boolean invoking) {
        this.fIsInvokingMethod = invoking;
    }

    protected void setPendingStepHandler(StepHandler handler) {
        this.fStepHandler = handler;
    }

    protected StepHandler getPendingStepHandler() {
        return this.fStepHandler;
    }

    public boolean hasStackFrames() throws DebugException {
        try {
            return this.computeStackFrames().size() > 0;
        }
        catch (DebugException e) {
            if (e.getStatus().getCode() != 100) {
                throw e;
            }
            return false;
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            try {
                return (IJavaStackFrame)this.getTopStackFrame();
            }
            catch (DebugException debugException) {}
        }
        return super.getAdapter(adapter);
    }

    public boolean hasOwnedMonitors() throws DebugException {
        return this.isSuspended() && this.getOwnedMonitors().length > 0;
    }

    public IJavaObject[] getOwnedMonitors() throws DebugException {
        try {
            JDIDebugTarget target = (JDIDebugTarget)this.getDebugTarget();
            List<ObjectReference> ownedMonitors = this.getUnderlyingThread().ownedMonitors();
            IJavaObject[] javaOwnedMonitors = new IJavaObject[ownedMonitors.size()];
            Iterator<ObjectReference> itr = ownedMonitors.iterator();
            int i = 0;
            while (itr.hasNext()) {
                ObjectReference element = itr.next();
                javaOwnedMonitors[i] = new JDIObjectValue(target, element);
                ++i;
            }
            return javaOwnedMonitors;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return null;
        }
    }

    public IJavaObject getContendedMonitor() throws DebugException {
        try {
            ObjectReference monitor = this.getUnderlyingThread().currentContendedMonitor();
            if (monitor != null) {
                return new JDIObjectValue((JDIDebugTarget)this.getDebugTarget(), monitor);
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {}
        return null;
    }

    public boolean canStepWithFilters() {
        if (this.canStepInto()) {
            String[] filters = this.getJavaDebugTarget().getStepFilters();
            return filters != null && filters.length > 0;
        }
        return false;
    }

    public void stepWithFilters() throws DebugException {
        if (!this.canStepWithFilters()) {
            return;
        }
        this.fUseStepFilters = true;
        this.stepInto();
    }

    abstract class StepHandler
    implements IJDIEventListener {
        private StepRequest fStepRequest;

        StepHandler() {
        }

        protected void step() throws DebugException {
            JDIStackFrame top = (JDIStackFrame)JDIThread.this.getTopStackFrame();
            if (top == null) {
                return;
            }
            JDIThread.this.setOriginalStepKind(this.getStepKind());
            Location location = top.getUnderlyingStackFrame().location();
            JDIThread.this.setOriginalStepLocation(location);
            JDIThread.this.setOriginalStepStackDepth(JDIThread.this.computeStackFrames().size());
            this.setStepRequest(this.createStepRequest());
            JDIThread.this.setPendingStepHandler(this);
            JDIThread.this.addJDIEventListener(this, this.getStepRequest());
            JDIThread.this.setRunning(true);
            JDIThread.this.preserveStackFrames();
            JDIThread.this.fireResumeEvent(this.getStepDetail());
            this.invokeThread();
        }

        protected void invokeThread() throws DebugException {
            try {
                JDIThread.this.getUnderlyingThread().resume();
            }
            catch (RuntimeException e) {
                this.stepEnd();
                JDIThread.this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_stepping"), e.toString()), e);
            }
        }

        protected StepRequest createStepRequest() throws DebugException {
            try {
                StepRequest request = JDIThread.this.getEventRequestManager().createStepRequest(JDIThread.this.getUnderlyingThread(), -2, this.getStepKind());
                request.setSuspendPolicy(1);
                request.addCountFilter(1);
                this.attachFiltersToStepRequest(request);
                request.enable();
                return request;
            }
            catch (RuntimeException e) {
                JDIThread.this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_creating_step_request"), e.toString()), e);
                return null;
            }
        }

        protected abstract int getStepKind();

        protected abstract int getStepDetail();

        protected void setStepRequest(StepRequest request) {
            this.fStepRequest = request;
        }

        protected StepRequest getStepRequest() {
            return this.fStepRequest;
        }

        protected void deleteStepRequest() {
            JDIThread.this.removeJDIEventListener(this, this.getStepRequest());
            try {
                JDIThread.this.getEventRequestManager().deleteEventRequest(this.getStepRequest());
                this.setStepRequest(null);
            }
            catch (RuntimeException e) {
                JDIThread.this.logError(e);
            }
        }

        protected void attachFiltersToStepRequest(StepRequest request) {
            if (this.applyStepFilters() && (JDIThread.this.getJavaDebugTarget().isStepFiltersEnabled() || JDIThread.this.fUseStepFilters)) {
                Location currentLocation = JDIThread.this.getOriginalStepLocation();
                if (currentLocation == null) {
                    return;
                }
                ReferenceType type = currentLocation.declaringType();
                String typeName = type.name();
                String[] activeFilters = JDIThread.this.getJavaDebugTarget().getStepFilters();
                int i = 0;
                while (i < activeFilters.length) {
                    StringMatcher matcher = new StringMatcher(activeFilters[i], false, false);
                    if (matcher.match(typeName)) {
                        return;
                    }
                    ++i;
                }
                i = 0;
                while (i < activeFilters.length) {
                    request.addClassExclusionFilter(activeFilters[i]);
                    ++i;
                }
            }
        }

        protected boolean applyStepFilters() {
            return false;
        }

        public boolean handleEvent(Event event, JDIDebugTarget target) {
            try {
                StepEvent stepEvent = (StepEvent)event;
                Location currentLocation = stepEvent.location();
                if (this.locationShouldBeFiltered(currentLocation) || JDIThread.this.shouldDoExtraStepInto(currentLocation)) {
                    JDIThread.this.setRunning(true);
                    this.deleteStepRequest();
                    this.createSecondaryStepRequest();
                    return true;
                }
                this.stepEnd();
                return false;
            }
            catch (DebugException e) {
                JDIThread.this.logError((Exception)((Object)e));
                this.stepEnd();
                return false;
            }
        }

        protected boolean locationShouldBeFiltered(Location location) throws DebugException {
            Location origLocation;
            if (this.applyStepFilters() && (origLocation = JDIThread.this.getOriginalStepLocation()) != null) {
                return !this.locationIsFiltered(origLocation.method()) && this.locationIsFiltered(location.method());
            }
            return false;
        }

        protected boolean locationIsFiltered(Method method) {
            if (JDIThread.this.getJavaDebugTarget().isStepFiltersEnabled() || JDIThread.this.fUseStepFilters) {
                boolean filterStatics = JDIThread.this.getJavaDebugTarget().isFilterStaticInitializers();
                boolean filterSynthetics = JDIThread.this.getJavaDebugTarget().isFilterSynthetics();
                boolean filterConstructors = JDIThread.this.getJavaDebugTarget().isFilterConstructors();
                if (!(filterStatics || filterSynthetics || filterConstructors)) {
                    return false;
                }
                if (filterStatics && method.isStaticInitializer() || filterSynthetics && method.isSynthetic() || filterConstructors && method.isConstructor()) {
                    return true;
                }
            }
            return false;
        }

        protected void stepEnd() {
            JDIThread.this.fUseStepFilters = false;
            JDIThread.this.setRunning(false);
            this.deleteStepRequest();
            JDIThread.this.setPendingStepHandler(null);
            JDIThread.this.queueSuspendEvent(8);
        }

        protected void createSecondaryStepRequest() throws DebugException {
            this.setStepRequest(this.createStepRequest());
            JDIThread.this.setPendingStepHandler(this);
            JDIThread.this.addJDIEventListener(this, this.getStepRequest());
        }

        protected void abort() {
            if (this.getStepRequest() != null) {
                this.deleteStepRequest();
                JDIThread.this.setPendingStepHandler(null);
            }
        }
    }

    class StepOverHandler
    extends StepHandler {
        StepOverHandler() {
        }

        protected int getStepKind() {
            return 2;
        }

        protected int getStepDetail() {
            return 2;
        }
    }

    class StepIntoHandler
    extends StepHandler {
        StepIntoHandler() {
        }

        protected int getStepKind() {
            return 1;
        }

        protected int getStepDetail() {
            return 1;
        }

        protected boolean applyStepFilters() {
            return true;
        }
    }

    class StepReturnHandler
    extends StepHandler {
        StepReturnHandler() {
        }

        protected int getStepKind() {
            return 3;
        }

        protected int getStepDetail() {
            return 4;
        }
    }

    class StepToFrameHandler
    extends StepReturnHandler {
        private int fRemainingFrames;

        protected StepToFrameHandler(IStackFrame frame) throws DebugException {
            List frames = JDIThread.this.computeStackFrames();
            this.setRemainingFrames(frames.size() - frames.indexOf(frame));
        }

        protected void setRemainingFrames(int num) {
            this.fRemainingFrames = num;
        }

        protected int getRemainingFrames() {
            return this.fRemainingFrames;
        }

        public boolean handleEvent(Event event, JDIDebugTarget target) {
            try {
                int numFrames = JDIThread.this.getUnderlyingFrameCount();
                if (numFrames <= this.getRemainingFrames()) {
                    this.stepEnd();
                    return false;
                }
                JDIThread.this.setRunning(true);
                this.deleteStepRequest();
                this.createSecondaryStepRequest();
                return true;
            }
            catch (DebugException e) {
                JDIThread.this.logError((Exception)((Object)e));
                this.stepEnd();
                return false;
            }
        }
    }

    class DropToFrameHandler
    extends StepReturnHandler {
        private int fFramesToDrop;

        protected DropToFrameHandler(IStackFrame frame) throws DebugException {
            List frames = JDIThread.this.computeStackFrames();
            this.setFramesToDrop(frames.indexOf(frame));
        }

        protected void setFramesToDrop(int num) {
            this.fFramesToDrop = num;
        }

        protected int getFramesToDrop() {
            return this.fFramesToDrop;
        }

        protected void invokeThread() throws DebugException {
            if (this.getFramesToDrop() < 0) {
                super.invokeThread();
            } else {
                try {
                    ThreadReference hcrThread = (ThreadReference)((Object)JDIThread.this.getUnderlyingThread());
                    hcrThread.doReturn(null, true);
                }
                catch (RuntimeException e) {
                    this.stepEnd();
                    JDIThread.this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString(JDIDebugModelMessages.getString("JDIThread.exception_while_popping_stack_frame")), e.toString()), e);
                }
            }
        }

        public boolean handleEvent(Event event, JDIDebugTarget target) {
            this.setFramesToDrop(this.getFramesToDrop() - 1);
            try {
                if (this.getFramesToDrop() >= -1) {
                    this.deleteStepRequest();
                    this.doSecondaryStep();
                } else {
                    this.stepEnd();
                }
            }
            catch (DebugException e) {
                this.stepEnd();
                JDIThread.this.logError((Exception)((Object)e));
            }
            return false;
        }

        protected void doSecondaryStep() throws DebugException {
            this.setStepRequest(this.createStepRequest());
            JDIThread.this.setPendingStepHandler(this);
            JDIThread.this.addJDIEventListener(this, this.getStepRequest());
            this.invokeThread();
        }

        protected StepRequest createStepRequest() throws DebugException {
            int num = this.getFramesToDrop();
            if (num > 0) {
                return super.createStepRequest();
            }
            if (num == 0) {
                try {
                    com.sun.jdi.request.EventRequestManager erm = JDIThread.this.getEventRequestManager();
                    ReenterStepRequest request = ((EventRequestManager)((Object)erm)).createReenterStepRequest(JDIThread.this.getUnderlyingThread());
                    request.setSuspendPolicy(1);
                    request.addCountFilter(1);
                    request.enable();
                    return request;
                }
                catch (RuntimeException e) {
                    JDIThread.this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_creating_step_request"), e.toString()), e);
                }
            } else if (num == -1) {
                try {
                    StepRequest request = JDIThread.this.getEventRequestManager().createStepRequest(JDIThread.this.getUnderlyingThread(), -2, 1);
                    request.setSuspendPolicy(1);
                    request.addCountFilter(1);
                    request.enable();
                    return request;
                }
                catch (RuntimeException e) {
                    JDIThread.this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThread.exception_creating_step_request"), e.toString()), e);
                }
            }
            return null;
        }
    }

    private class AsyncThread
    implements Runnable {
        private ArrayList fRunnables = new ArrayList();
        private Thread fThread;

        public void addRunnable(Runnable runnable) {
            AsyncThread asyncThread = this;
            synchronized (asyncThread) {
                this.fRunnables.add(runnable);
                if (this.fThread == null) {
                    try {
                        this.fThread = new Thread((Runnable)this, "JDI async thread - " + JDIThread.this.getName());
                    }
                    catch (DebugException e) {
                        JDIDebugPlugin.log(e);
                        return;
                    }
                    this.fThread.start();
                }
            }
        }

        public boolean isEmpty() {
            return this.fRunnables.isEmpty();
        }

        public void clearQueue() {
            AsyncThread asyncThread = this;
            synchronized (asyncThread) {
                this.fRunnables.clear();
            }
        }

        public void run() {
            while (true) {
                Runnable nextRunnable = null;
                AsyncThread asyncThread = this;
                synchronized (asyncThread) {
                    if (this.fRunnables.isEmpty()) {
                        this.fThread = null;
                        return;
                    }
                    nextRunnable = (Runnable)this.fRunnables.remove(0);
                }
                try {
                    nextRunnable.run();
                    continue;
                }
                catch (Throwable e) {
                    JDIDebugPlugin.log(e);
                    continue;
                }
                break;
            }
        }
    }
}

