/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.ReferenceType;
import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaClassObject;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIFieldVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIType;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;

public class JDIInterfaceType
extends JDIType
implements IJavaInterfaceType {
    public JDIInterfaceType(JDIDebugTarget target, InterfaceType type) {
        super(target, type);
    }

    public IJavaFieldVariable getField(String name) throws DebugException {
        try {
            Field field = ((InterfaceType)this.getUnderlyingType()).fieldByName(name);
            if (field != null) {
                return new JDIFieldVariable(this.getDebugTarget(), field, null);
            }
        }
        catch (RuntimeException e) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIClassType.exception_while_retrieving_field"), e.toString(), name), e);
        }
        return null;
    }

    public IJavaClassObject getClassObject() throws DebugException {
        try {
            ReferenceType type = (ReferenceType)this.getUnderlyingType();
            return (IJavaClassObject)((Object)JDIValue.createValue(this.getDebugTarget(), type.classObject()));
        }
        catch (RuntimeException e) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIClassType.exception_while_retrieving_class_object"), e.toString()), e);
            return null;
        }
    }
}

