/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaClassObject;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIFieldVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.core.model.JDIType;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;

public class JDIClassType
extends JDIType
implements IJavaClassType {
    public JDIClassType(JDIDebugTarget target, ClassType type) {
        super(target, type);
    }

    public IJavaObject newInstance(String signature, IJavaValue[] args, IJavaThread thread) throws DebugException {
        if (this.getUnderlyingType() instanceof ClassType) {
            ClassType clazz = (ClassType)this.getUnderlyingType();
            JDIThread javaThread = (JDIThread)thread;
            List arguments = this.convertArguments(args);
            Method method = null;
            try {
                List<Method> methods = clazz.methodsByName("<init>", signature);
                if (methods.isEmpty()) {
                    this.getDebugTarget().requestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIClassType.Type_does_not_implement_cosntructor"), signature), null);
                } else {
                    method = methods.get(0);
                }
            }
            catch (RuntimeException e) {
                this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIClassType.exception_while_performing_method_lookup_for_constructor"), e.toString(), signature), e);
            }
            ObjectReference result = javaThread.newInstance(clazz, method, arguments);
            return (IJavaObject)((Object)JDIValue.createValue(this.getDebugTarget(), result));
        }
        this.getDebugTarget().requestFailed(JDIDebugModelMessages.getString("JDIClassType.Type_is_not_a_class_type"), null);
        return null;
    }

    public IJavaValue sendMessage(String selector, String signature, IJavaValue[] args, IJavaThread thread) throws DebugException {
        if (this.getUnderlyingType() instanceof ClassType) {
            ClassType clazz = (ClassType)this.getUnderlyingType();
            JDIThread javaThread = (JDIThread)thread;
            List arguments = this.convertArguments(args);
            Method method = null;
            try {
                List<Method> methods = clazz.methodsByName(selector, signature);
                if (methods.isEmpty()) {
                    this.getDebugTarget().requestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIClassType.Type_does_not_implement_selector"), selector, signature), null);
                } else {
                    method = methods.get(0);
                }
            }
            catch (RuntimeException e) {
                this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIClassType.exception_while_performing_method_lookup_for_selector"), e.toString(), selector, signature), e);
            }
            Value result = javaThread.invokeMethod(clazz, null, method, arguments, false);
            return JDIValue.createValue(this.getDebugTarget(), result);
        }
        this.getDebugTarget().requestFailed(JDIDebugModelMessages.getString("JDIClassType.Type_is_not_a_class_type"), null);
        return null;
    }

    protected List convertArguments(IJavaValue[] args) {
        ArrayList<Value> arguments = null;
        if (args == null) {
            arguments = Collections.EMPTY_LIST;
        } else {
            arguments = new ArrayList<Value>(args.length);
            int i = 0;
            while (i < args.length) {
                arguments.add(((JDIValue)args[i]).getUnderlyingValue());
                ++i;
            }
        }
        return arguments;
    }

    public IJavaFieldVariable getField(String name) throws DebugException {
        try {
            Field field = ((ClassType)this.getUnderlyingType()).fieldByName(name);
            if (field != null) {
                return new JDIFieldVariable(this.getDebugTarget(), field, null);
            }
        }
        catch (RuntimeException e) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIClassType.exception_while_retrieving_field"), e.toString(), name), e);
        }
        return null;
    }

    public IJavaClassType getSuperclass() throws DebugException {
        try {
            ClassType superclazz = ((ClassType)this.getUnderlyingType()).superclass();
            if (superclazz != null) {
                return (IJavaClassType)((Object)JDIType.createType(this.getDebugTarget(), superclazz));
            }
        }
        catch (RuntimeException e) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIClassType.exception_while_retrieving_superclass"), e.toString()), e);
        }
        return null;
    }

    public IJavaClassObject getClassObject() throws DebugException {
        try {
            ReferenceType type = (ReferenceType)this.getUnderlyingType();
            return (IJavaClassObject)((Object)JDIValue.createValue(this.getDebugTarget(), type.classObject()));
        }
        catch (RuntimeException e) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIClassType.exception_while_retrieving_class_object"), e.toString()), e);
            return null;
        }
    }
}

