/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Type;
import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.debug.core.IJavaClassObject;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIType;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;

public class JDIArrayType
extends JDIType
implements IJavaArrayType {
    public JDIArrayType(JDIDebugTarget target, ArrayType type) {
        super(target, type);
    }

    public IJavaArray newInstance(int size) throws DebugException {
        try {
            ArrayReference ar = ((ArrayType)this.getUnderlyingType()).newInstance(size);
            return (IJavaArray)((Object)JDIValue.createValue(this.getDebugTarget(), ar));
        }
        catch (RuntimeException e) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIArrayType.exception_while_creating_new_instance_of_array"), e.toString()), e);
            return null;
        }
    }

    public IJavaType getComponentType() throws DebugException {
        try {
            Type type = ((ArrayType)this.getUnderlyingType()).componentType();
            return JDIType.createType(this.getDebugTarget(), type);
        }
        catch (ClassNotLoadedException e) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIArrayType.exception_while_retrieving_component_type_of_array"), e.toString()), e);
        }
        catch (RuntimeException e) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIArrayType.exception_while_retrieving_component_type_of_array"), e.toString()), e);
        }
        return null;
    }

    public IJavaClassObject getClassObject() throws DebugException {
        try {
            ArrayType type = (ArrayType)this.getUnderlyingType();
            return (IJavaClassObject)((Object)JDIValue.createValue(this.getDebugTarget(), type.classObject()));
        }
        catch (RuntimeException e) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIClassType.exception_while_retrieving_class_object"), e.toString()), e);
            return null;
        }
    }
}

