/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.ArrayReference;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.model.JDIArrayPartition;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugElement;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;

public class JDIArrayPartitionValue
extends JDIDebugElement
implements IJavaValue {
    private JDIArrayPartition fPartition;

    public JDIArrayPartitionValue(JDIArrayPartition partition) {
        super(null);
        this.fPartition = partition;
    }

    public String getReferenceTypeName() {
        return "";
    }

    public String getValueString(boolean qualified) {
        return "";
    }

    public String getValueString() {
        return "";
    }

    public String evaluateToString(IJavaThread thread) {
        return this.getValueString();
    }

    public IVariable[] getVariables() throws DebugException {
        List list = this.getVariables0();
        return list.toArray(new IVariable[list.size()]);
    }

    protected List getVariables0() {
        return JDIArrayPartition.splitArray((JDIDebugTarget)this.getPartition().getDebugTarget(), this.getPartition().getArrayReference(), this.getPartition().getStart(), this.getPartition().getEnd());
    }

    public ArrayReference getArrayReference() {
        return this.getPartition().getArrayReference();
    }

    public IDebugTarget getDebugTarget() {
        return this.getPartition().getDebugTarget();
    }

    public boolean isAllocated() throws DebugException {
        try {
            return !this.getArrayReference().isCollected();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIArrayPartitionValue.exception_is_garbage_collected"), e.toString()), e);
            return false;
        }
    }

    public int getArrayLength() {
        return -1;
    }

    public String getSignature() {
        return "";
    }

    protected JDIArrayPartition getPartition() {
        return this.fPartition;
    }

    public IJavaType getJavaType() throws DebugException {
        return null;
    }

    public IJavaValue sendMessage(String selector, String signature, IJavaValue[] args, IJavaThread thread, boolean superSend) throws DebugException {
        this.requestFailed(JDIDebugModelMessages.getString("JDIArrayPartitionValue.Cannot_send_a_message_to_an_array"), null);
        return null;
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables0().size() > 0;
    }
}

