/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.internal.debug.core.model.JDIArrayEntryVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIArrayPartitionValue;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIVariable;

public class JDIArrayPartition
extends JDIVariable {
    private int fStart;
    private int fEnd;
    private ArrayReference fArray;
    private JDIArrayPartitionValue fArrayPartitionValue;

    public JDIArrayPartition(JDIDebugTarget target, ArrayReference array, int start, int end) {
        super(target);
        this.fArray = array;
        this.fStart = start;
        this.fEnd = end;
    }

    public String getName() throws DebugException {
        StringBuffer name = new StringBuffer();
        name.append('[');
        name.append(this.getStart());
        name.append("..");
        name.append(this.getEnd());
        name.append(']');
        return name.toString();
    }

    protected Value retrieveValue() {
        return null;
    }

    public IValue getValue() {
        if (this.fArrayPartitionValue == null) {
            this.fArrayPartitionValue = new JDIArrayPartitionValue(this);
        }
        return this.fArrayPartitionValue;
    }

    public static List splitArray(JDIDebugTarget target, ArrayReference array, int start, int end) {
        ArrayList<JDIArrayEntryVariable> children = new ArrayList<JDIArrayEntryVariable>();
        int perSlot = 1;
        int l = end - start;
        while (perSlot * 100 < l) {
            perSlot *= 100;
        }
        while (start <= end) {
            if (start + perSlot > end) {
                perSlot = end - start + 1;
            }
            JDIVariable var = null;
            var = perSlot == 1 ? new JDIArrayEntryVariable(target, array, start) : new JDIArrayPartition(target, array, start, start + perSlot - 1);
            children.add((JDIArrayEntryVariable)var);
            start += perSlot;
        }
        return children;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getEnd() {
        return this.fEnd;
    }

    protected ArrayReference getArrayReference() {
        return this.fArray;
    }

    public String getReferenceTypeName() throws DebugException {
        try {
            return this.getArrayReference().referenceType().name();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIArrayPartition.exception_retrieving_reference_type"), e.toString()), e);
            return null;
        }
    }

    public String getSignature() throws DebugException {
        try {
            return this.getArrayReference().type().signature();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIArrayPartition.exception_retrieving_signature"), e.toString()), e);
            return null;
        }
    }

    protected Type getUnderlyingType() throws DebugException {
        try {
            return this.getArrayReference().type();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIArrayPartition.exception_while_retrieving_type_of_array"), e.toString()), e);
            return null;
        }
    }
}

