/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.hcr;

import java.util.Stack;
import org.eclipse.jdt.internal.compiler.SourceElementRequestorAdapter;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.debug.core.hcr.JavaNode;

class JavaParseTreeBuilder
extends SourceElementRequestorAdapter
implements ICompilationUnit {
    private static final boolean SHOW_COMPILATIONUNIT = true;
    private char[] fBuffer;
    private JavaNode fImportContainer = null;
    private Stack fStack = new Stack();

    JavaParseTreeBuilder(JavaNode root, char[] buffer) {
        this.fStack.clear();
        this.fStack.push(root);
        this.fBuffer = buffer;
    }

    public char[] getContents() {
        return this.fBuffer;
    }

    public char[] getFileName() {
        return new char[0];
    }

    public char[] getMainTypeName() {
        return new char[0];
    }

    public char[][] getPackageName() {
        return null;
    }

    public void enterCompilationUnit() {
        this.push(0, null, 0);
    }

    public void exitCompilationUnit(int declarationEnd) {
        this.pop(declarationEnd);
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] p3) {
        this.push(1, null, declarationStart);
        this.pop(declarationEnd);
    }

    public void acceptImport(int declarationStart, int declarationEnd, char[] name, boolean onDemand) {
        int length = declarationEnd - declarationStart + 1;
        if (this.fImportContainer == null) {
            this.fImportContainer = new JavaNode(this.getCurrentContainer(), 2, null, declarationStart, length);
        }
        String nm = new String(name);
        if (onDemand) {
            nm = String.valueOf(nm) + ".*";
        }
        new JavaNode(this.fImportContainer, 3, nm, declarationStart, length);
        this.fImportContainer.setLength(declarationEnd - this.fImportContainer.getStart() + 1);
    }

    public void enterClass(int declarationStart, int p2, char[] name, int p4, int p5, char[] p6, char[][] p7) {
        this.push(5, new String(name), declarationStart);
    }

    public void exitClass(int declarationEnd) {
        this.pop(declarationEnd);
    }

    public void enterInterface(int declarationStart, int p2, char[] name, int p4, int p5, char[][] p6) {
        this.push(4, new String(name), declarationStart);
    }

    public void exitInterface(int declarationEnd) {
        this.pop(declarationEnd);
    }

    public void enterInitializer(int declarationSourceStart, int modifiers) {
        this.push(7, this.getCurrentContainer().getInitializerCount(), declarationSourceStart);
    }

    public void enterConstructor(int declarationStart, int p2, char[] name, int p4, int p5, char[][] parameterTypes, char[][] p7, char[][] p8) {
        this.push(8, this.getSignature(name, parameterTypes), declarationStart);
    }

    public void exitConstructor(int declarationEnd) {
        this.pop(declarationEnd);
    }

    public void enterMethod(int declarationStart, int p2, char[] p3, char[] name, int p5, int p6, char[][] parameterTypes, char[][] p8, char[][] p9) {
        this.push(9, this.getSignature(name, parameterTypes), declarationStart);
    }

    public void exitMethod(int declarationEnd) {
        this.pop(declarationEnd);
    }

    public void enterField(int declarationStart, int p2, char[] p3, char[] name, int p5, int p6) {
        this.push(6, new String(name), declarationStart);
    }

    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        this.pop(declarationEnd);
    }

    private JavaNode getCurrentContainer() {
        return (JavaNode)this.fStack.peek();
    }

    private void push(int type, String name, int declarationStart) {
        while (declarationStart > 0) {
            char c = this.fBuffer[declarationStart - 1];
            if (c != ' ' && c != '\t') break;
            --declarationStart;
        }
        this.fStack.push(new JavaNode(this.getCurrentContainer(), type, name, declarationStart, 0));
    }

    private void pop(int declarationEnd) {
        JavaNode current = this.getCurrentContainer();
        current.setLength(declarationEnd - current.getStart() + 1);
        this.fStack.pop();
    }

    public String getSignature(char[] name, char[][] parameterTypes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(name);
        buffer.append('(');
        if (parameterTypes != null) {
            int p = 0;
            while (p < parameterTypes.length) {
                String parameterType = new String(parameterTypes[p]);
                int pos = parameterType.lastIndexOf(46);
                if (pos >= 0) {
                    parameterType = parameterType.substring(pos + 1);
                }
                buffer.append(parameterType);
                if (p < parameterTypes.length - 1) {
                    buffer.append(", ");
                }
                ++p;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    public void exitInitializer(int declarationEnd) {
        this.pop(declarationEnd);
    }
}

