/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.breakpoints;

import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.WatchpointRequest;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.breakpoints.JDIDebugBreakpointMessages;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;

public class JavaWatchpoint
extends JavaLineBreakpoint
implements IJavaWatchpoint {
    private static final String JAVA_WATCHPOINT = "org.eclipse.jdt.debug.javaWatchpointMarker";
    protected static final String ACCESS = "org.eclipse.jdt.debug.core.access";
    protected static final String MODIFICATION = "org.eclipse.jdt.debug.core.modification";
    protected static final String AUTO_DISABLED = "org.eclipse.jdt.debug.core.auto_disabled";
    protected static final String FIELD_NAME = "org.eclipse.jdt.debug.core.fieldName";
    protected static final Integer ACCESS_EVENT = new Integer(0);
    protected static final Integer MODIFICATION_EVENT = new Integer(1);
    private HashMap fLastEventTypes = new HashMap(10);

    public JavaWatchpoint() {
    }

    public JavaWatchpoint(final IResource resource, final String typeName, final String fieldName, final int lineNumber, final int charStart, final int charEnd, final int hitCount, final boolean add, final Map attributes) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JavaWatchpoint.this.setMarker(resource.createMarker(JavaWatchpoint.JAVA_WATCHPOINT));
                JavaWatchpoint.this.addLineBreakpointAttributes(attributes, JavaWatchpoint.this.getModelIdentifier(), true, lineNumber, charStart, charEnd);
                JavaWatchpoint.this.addTypeNameAndHitCount(attributes, typeName, hitCount);
                JavaWatchpoint.this.addFieldName(attributes, fieldName);
                JavaWatchpoint.this.addDefaultAccessAndModification(attributes);
                JavaWatchpoint.this.ensureMarker().setAttributes(attributes);
                JavaWatchpoint.this.register(add);
            }
        };
        this.run(wr);
    }

    protected boolean createRequest(JDIDebugTarget target, ReferenceType type) throws CoreException {
        Field field = null;
        field = type.fieldByName(this.getFieldName());
        if (field == null) {
            return false;
        }
        AccessWatchpointRequest accessRequest = null;
        ModificationWatchpointRequest modificationRequest = null;
        if (this.accessSupportedBy(target.getVM())) {
            accessRequest = this.createAccessWatchpoint(target, field);
            this.registerRequest(accessRequest, target);
        } else {
            this.notSupported(JDIDebugBreakpointMessages.getString("JavaWatchpoint.no_access_watchpoints"));
        }
        if (this.modificationSupportedBy(target.getVM())) {
            modificationRequest = this.createModificationWatchpoint(target, field);
            if (modificationRequest == null) {
                return false;
            }
            this.registerRequest(modificationRequest, target);
            return true;
        }
        this.notSupported(JDIDebugBreakpointMessages.getString("JavaWatchpoint.no_modification_watchpoints"));
        return false;
    }

    protected void setRequestThreadFilter(EventRequest request, ThreadReference thread) {
        ((WatchpointRequest)request).addThreadFilter(thread);
    }

    protected boolean modificationSupportedBy(VirtualMachine vm) {
        return vm.canWatchFieldModification();
    }

    protected boolean accessSupportedBy(VirtualMachine vm) {
        return vm.canWatchFieldAccess();
    }

    protected void notSupported(String message) throws DebugException {
        throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5011, message, null));
    }

    protected AccessWatchpointRequest createAccessWatchpoint(JDIDebugTarget target, Field field) throws CoreException {
        return (AccessWatchpointRequest)this.createWatchpoint(target, field, true);
    }

    protected ModificationWatchpointRequest createModificationWatchpoint(JDIDebugTarget target, Field field) throws CoreException {
        return (ModificationWatchpointRequest)this.createWatchpoint(target, field, false);
    }

    protected WatchpointRequest createWatchpoint(JDIDebugTarget target, Field field, boolean access) throws CoreException {
        WatchpointRequest request = null;
        try {
            request = access ? target.getEventRequestManager().createAccessWatchpointRequest(field) : target.getEventRequestManager().createModificationWatchpointRequest(field);
            this.configureRequest(request, target);
        }
        catch (VMDisconnectedException e) {
            if (!target.isAvailable()) {
                return null;
            }
            target.internalError(e);
            return null;
        }
        catch (RuntimeException e) {
            target.internalError(e);
            return null;
        }
        return request;
    }

    protected EventRequest recreateRequest(EventRequest request, JDIDebugTarget target) throws CoreException {
        try {
            Field field = ((WatchpointRequest)request).field();
            if (request instanceof AccessWatchpointRequest) {
                request = this.createAccessWatchpoint(target, field);
            } else if (request instanceof ModificationWatchpointRequest) {
                request = this.createModificationWatchpoint(target, field);
            }
        }
        catch (VMDisconnectedException e) {
            if (!target.isAvailable()) {
                return request;
            }
            target.internalError(e);
            return request;
        }
        catch (RuntimeException e) {
            JDIDebugPlugin.log(e);
        }
        return request;
    }

    public void setEnabled(boolean enabled) throws CoreException {
        if (this.isEnabled() && !this.isAccess() && !this.isModification()) {
            this.setDefaultAccessAndModification();
        }
        super.setEnabled(enabled);
    }

    public boolean isAccess() throws CoreException {
        return this.ensureMarker().getAttribute(ACCESS, false);
    }

    public void setAccess(boolean access) throws CoreException {
        if (access == this.isAccess()) {
            return;
        }
        this.setAttribute(ACCESS, access);
        if (access && !this.isEnabled()) {
            this.setEnabled(true);
        } else if (!access && !this.isModification()) {
            this.setEnabled(false);
        }
        this.recreate();
    }

    public boolean isModification() throws CoreException {
        return this.ensureMarker().getAttribute(MODIFICATION, false);
    }

    public void setModification(boolean modification) throws CoreException {
        if (modification == this.isModification()) {
            return;
        }
        this.setAttribute(MODIFICATION, modification);
        if (modification && !this.isEnabled()) {
            this.setEnabled(true);
        } else if (!modification && !this.isAccess()) {
            this.setEnabled(false);
        }
        this.recreate();
    }

    protected void setDefaultAccessAndModification() throws CoreException {
        Object[] values = new Object[]{Boolean.FALSE, Boolean.TRUE};
        String[] attributes = new String[]{ACCESS, MODIFICATION};
        this.setAttributes(attributes, values);
    }

    protected void addDefaultAccessAndModification(Map attributes) {
        attributes.put(ACCESS, Boolean.TRUE);
        attributes.put(MODIFICATION, Boolean.TRUE);
        attributes.put(AUTO_DISABLED, Boolean.FALSE);
    }

    protected void addFieldName(Map attributes, String fieldName) {
        attributes.put(FIELD_NAME, fieldName);
    }

    public String getFieldName() throws CoreException {
        return this.ensureMarker().getAttribute(FIELD_NAME, null);
    }

    public boolean handleEvent(Event event, JDIDebugTarget target) {
        if (event instanceof AccessWatchpointEvent) {
            this.fLastEventTypes.put(target, ACCESS_EVENT);
        } else if (event instanceof ModificationWatchpointEvent) {
            this.fLastEventTypes.put(target, MODIFICATION_EVENT);
        }
        return super.handleEvent(event, target);
    }

    protected void updateEnabledState(EventRequest request, JDIDebugTarget target) throws CoreException {
        boolean enabled = this.isEnabled();
        if (request instanceof AccessWatchpointRequest) {
            if (this.isAccess()) {
                if (enabled != request.isEnabled()) {
                    this.internalUpdateEnabledState(request, enabled, target);
                }
            } else if (request.isEnabled()) {
                this.internalUpdateEnabledState(request, false, target);
            }
        }
        if (request instanceof ModificationWatchpointRequest) {
            if (this.isModification()) {
                if (enabled != request.isEnabled()) {
                    this.internalUpdateEnabledState(request, enabled, target);
                }
            } else if (request.isEnabled()) {
                this.internalUpdateEnabledState(request, false, target);
            }
        }
    }

    public boolean isAccessSuspend(IDebugTarget target) {
        Integer lastEventType = (Integer)this.fLastEventTypes.get(target);
        if (lastEventType == null) {
            return false;
        }
        return lastEventType.equals(ACCESS_EVENT);
    }

    public boolean supportsCondition() {
        return false;
    }

    public void removeFromTarget(JDIDebugTarget target) throws CoreException {
        this.fLastEventTypes.remove(target);
        super.removeFromTarget(target);
    }

    protected void addInstanceFilter(EventRequest request, ObjectReference object) {
        if (request instanceof WatchpointRequest) {
            ((WatchpointRequest)request).addInstanceFilter(object);
        }
    }
}

