/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.connect;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import org.eclipse.jdi.internal.connect.ConnectMessages;
import org.eclipse.jdi.internal.connect.TransportImpl;

public class SocketTransportImpl
extends TransportImpl {
    public static final int MIN_PORTNR = 0;
    public static final int MAX_PORTNR = 65535;
    private static final byte[] handshakeBytes = "JDWP-Handshake".getBytes();
    private Socket fSocket = null;
    private ServerSocket fServerSocket = null;

    public SocketTransportImpl() {
        super("dt_socket");
    }

    public void attach(String hostname, int port) throws IOException {
        this.fSocket = new Socket(hostname, port);
        this.PerformHandshake();
    }

    public void listen(int port) throws IOException {
        this.closeListen();
        this.fServerSocket = new ServerSocket(port);
    }

    public int listeningPort() {
        if (this.fServerSocket != null) {
            return this.fServerSocket.getLocalPort();
        }
        return 0;
    }

    public void closeListen() throws IOException {
        if (this.fServerSocket == null) {
            return;
        }
        this.fServerSocket.close();
        this.fServerSocket = null;
    }

    public void accept() throws IOException {
        this.fSocket = this.fServerSocket.accept();
        this.PerformHandshake();
    }

    public void setAcceptTimeout(int timeout) throws SocketException {
        this.fServerSocket.setSoTimeout(timeout);
    }

    public boolean isOpen() {
        return this.fSocket != null;
    }

    public void close() {
        if (this.fSocket == null) {
            return;
        }
        try {
            try {
                this.fSocket.close();
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fSocket = null;
            throw throwable;
        }
        Object var1_3 = null;
        this.fSocket = null;
    }

    public InputStream getInputStream() throws IOException {
        return this.fSocket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.fSocket.getOutputStream();
    }

    private void PerformHandshake() throws IOException {
        DataOutputStream out = new DataOutputStream(this.fSocket.getOutputStream());
        out.write(handshakeBytes);
        try {
            DataInputStream in = new DataInputStream(this.fSocket.getInputStream());
            byte[] handshakeInput = new byte[handshakeBytes.length];
            in.readFully(handshakeInput);
            if (!Arrays.equals(handshakeInput, handshakeBytes)) {
                throw new IOException(String.valueOf(ConnectMessages.getString("SocketTransportImpl.Incorrect_handshake_reply_received___1")) + new String(handshakeInput));
            }
        }
        catch (EOFException eOFException) {
            throw new IOException(ConnectMessages.getString("SocketTransportImpl.EOF_encoutered_during_handshake_2"));
        }
    }
}

