/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.connect;

import java.io.IOException;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.connect.ConnectorImpl;

public abstract class PacketManager
implements Runnable {
    private ConnectorImpl fConnector;
    private Thread fPartnerThread;
    private IOException fDisconnectException;

    protected PacketManager(ConnectorImpl connector) {
        this.fConnector = connector;
    }

    public synchronized void disconnectVM(IOException disconnectException) {
        this.fDisconnectException = disconnectException;
        this.disconnectVM();
    }

    public synchronized void disconnectVM() {
        VirtualMachineImpl vm = this.fConnector.virtualMachine();
        vm.setDisconnected(true);
        this.fConnector.close();
        this.notifyAll();
        this.fPartnerThread.interrupt();
    }

    public boolean VMIsDisconnected() {
        return this.fConnector.virtualMachine().isDisconnected();
    }

    public IOException getDisconnectException() {
        return this.fDisconnectException;
    }

    public void setPartnerThread(Thread thread) {
        this.fPartnerThread = thread;
    }

    public abstract void run();
}

