/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.connect;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.Transport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.VirtualMachineManagerImpl;
import org.eclipse.jdi.internal.connect.ConnectMessages;
import org.eclipse.jdi.internal.connect.PacketReceiveManager;
import org.eclipse.jdi.internal.connect.PacketSendManager;
import org.eclipse.jdi.internal.connect.TransportImpl;

public abstract class ConnectorImpl
implements Connector {
    private PacketReceiveManager fPacketReceiveManager;
    private Thread fThreadReceiveMgr;
    private PacketSendManager fPacketSendManager;
    private Thread fThreadSendMgr;
    private VirtualMachineManagerImpl fVirtualMachineManager;
    protected TransportImpl fTransport;
    protected VirtualMachineImpl fVirtualMachine;

    public ConnectorImpl(VirtualMachineManagerImpl virtualMachineManager) {
        this.fVirtualMachineManager = virtualMachineManager;
    }

    public VirtualMachineManagerImpl virtualMachineManager() {
        return this.fVirtualMachineManager;
    }

    public VirtualMachineImpl virtualMachine() {
        return this.fVirtualMachine;
    }

    public abstract String description();

    public abstract String name();

    void setTransport(TransportImpl transport) {
        this.fTransport = transport;
    }

    public Transport transport() {
        return this.fTransport;
    }

    public PacketReceiveManager packetReceiveManager() {
        return this.fPacketReceiveManager;
    }

    public PacketSendManager packetSendManager() {
        return this.fPacketSendManager;
    }

    synchronized void close() {
        this.virtualMachineManager().removeConnectedVM(this.fVirtualMachine);
        this.fTransport.close();
    }

    protected InputStream getInputStream() throws IOException {
        return this.fTransport.getInputStream();
    }

    protected OutputStream getOutputStream() throws IOException {
        return this.fTransport.getOutputStream();
    }

    protected void startIOManagers() {
        this.fPacketReceiveManager = new PacketReceiveManager(this);
        this.fPacketSendManager = new PacketSendManager(this);
        this.fThreadReceiveMgr = new Thread((Runnable)this.fPacketReceiveManager, ConnectMessages.getString("ConnectorImpl.Packet_Receive_Manager_1"));
        this.fThreadSendMgr = new Thread((Runnable)this.fPacketSendManager, ConnectMessages.getString("ConnectorImpl.Packet_Send_Manager_2"));
        this.fPacketReceiveManager.setPartnerThread(this.fThreadSendMgr);
        this.fPacketSendManager.setPartnerThread(this.fThreadReceiveMgr);
        this.fThreadReceiveMgr.start();
        this.fThreadSendMgr.start();
    }

    protected VirtualMachine establishedConnection() {
        this.fVirtualMachine = new VirtualMachineImpl(this);
        this.startIOManagers();
        this.virtualMachineManager().addConnectedVM(this.fVirtualMachine);
        return this.fVirtualMachine;
    }

    public abstract Map defaultArguments();

    public abstract class ArgumentImpl
    implements Connector.Argument {
        private String fName;
        private String fDescription;
        private String fLabel;
        private boolean fMustSpecify;

        protected ArgumentImpl(String name, String description, String label, boolean mustSpecify) {
            this.fName = name;
            this.fLabel = label;
            this.fDescription = description;
            this.fMustSpecify = mustSpecify;
        }

        public String name() {
            return this.fName;
        }

        public String description() {
            return this.fDescription;
        }

        public String label() {
            return this.fLabel;
        }

        public boolean mustSpecify() {
            return this.fMustSpecify;
        }

        public abstract String value();

        public abstract void setValue(String var1);

        public abstract boolean isValid(String var1);

        public abstract String toString();
    }

    public class StringArgumentImpl
    extends ArgumentImpl
    implements Connector.StringArgument {
        private String fValue;

        protected StringArgumentImpl(String name, String description, String label, boolean mustSpecify) {
            super(name, description, label, mustSpecify);
        }

        public String value() {
            return this.fValue;
        }

        public void setValue(String value) {
            this.fValue = value;
        }

        public boolean isValid(String value) {
            return true;
        }

        public String toString() {
            return this.fValue;
        }
    }

    public class IntegerArgumentImpl
    extends ArgumentImpl
    implements Connector.IntegerArgument {
        private Integer fValue;
        private int fMin;
        private int fMax;

        protected IntegerArgumentImpl(String name, String description, String label, boolean mustSpecify, int min, int max) {
            super(name, description, label, mustSpecify);
            this.fMin = min;
            this.fMax = max;
        }

        public String value() {
            return this.fValue.toString();
        }

        public void setValue(String value) {
            this.fValue = new Integer(value);
        }

        public boolean isValid(String value) {
            Integer val;
            try {
                val = new Integer(value);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return this.isValid(val);
        }

        public String toString() {
            return this.value();
        }

        public int intValue() {
            return this.fValue;
        }

        public void setValue(int value) {
            this.fValue = new Integer(value);
        }

        public int min() {
            return this.fMin;
        }

        public int max() {
            return this.fMax;
        }

        public boolean isValid(int value) {
            return this.fMin <= value && value <= this.fMax;
        }

        public String stringValueOf(int value) {
            return new Integer(value).toString();
        }
    }

    public class BooleanArgumentImpl
    extends ArgumentImpl
    implements Connector.BooleanArgument {
        private Boolean fValue;

        protected BooleanArgumentImpl(String name, String description, String label, boolean mustSpecify) {
            super(name, description, label, mustSpecify);
        }

        public String value() {
            return this.fValue.toString();
        }

        public void setValue(String value) {
            this.fValue = new Boolean(value);
        }

        public boolean isValid(String value) {
            return true;
        }

        public String toString() {
            return this.value();
        }

        public boolean booleanValue() {
            return this.fValue;
        }

        public void setValue(boolean value) {
            this.fValue = new Boolean(value);
        }

        public String stringValueOf(boolean value) {
            return new Boolean(value).toString();
        }
    }

    public class SelectedArgumentImpl
    extends StringArgumentImpl
    implements Connector.SelectedArgument {
        private List fChoices;

        protected SelectedArgumentImpl(String name, String description, String label, boolean mustSpecify, List choices) {
            super(name, description, label, mustSpecify);
            this.fChoices = choices;
        }

        public List choices() {
            return this.fChoices;
        }

        public boolean isValid(String value) {
            return this.fChoices.contains(value);
        }
    }
}

