/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidLineNumberException;
import com.sun.jdi.Method;
import com.sun.jdi.Value;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdi.hcr.ReferenceType;
import org.eclipse.jdi.internal.AccessibleImpl;
import org.eclipse.jdi.internal.ArrayTypeImpl;
import org.eclipse.jdi.internal.ClassLoaderReferenceImpl;
import org.eclipse.jdi.internal.ClassObjectReferenceImpl;
import org.eclipse.jdi.internal.ClassTypeImpl;
import org.eclipse.jdi.internal.FieldImpl;
import org.eclipse.jdi.internal.InterfaceTypeImpl;
import org.eclipse.jdi.internal.JDIMessages;
import org.eclipse.jdi.internal.MethodImpl;
import org.eclipse.jdi.internal.MirrorImpl;
import org.eclipse.jdi.internal.TypeImpl;
import org.eclipse.jdi.internal.ValueImpl;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.jdwp.JdwpFieldID;
import org.eclipse.jdi.internal.jdwp.JdwpID;
import org.eclipse.jdi.internal.jdwp.JdwpMethodID;
import org.eclipse.jdi.internal.jdwp.JdwpReferenceTypeID;
import org.eclipse.jdi.internal.jdwp.JdwpReplyPacket;

public abstract class ReferenceTypeImpl
extends TypeImpl
implements com.sun.jdi.ReferenceType,
ReferenceType {
    public static final int JDWP_CLASS_STATUS_VERIFIED = 1;
    public static final int JDWP_CLASS_STATUS_PREPARED = 2;
    public static final int JDWP_CLASS_STATUS_INITIALIZED = 4;
    public static final int JDWP_CLASS_STATUS_ERROR = 8;
    private static String[] fgClassStatusStrings = null;
    private JdwpReferenceTypeID fReferenceTypeID;
    protected List fInterfaces = null;
    private List fMethods = null;
    private Hashtable fMethodTable = null;
    private List fFields = null;
    private List fAllMethods = null;
    private List fVisibleMethods = null;
    private List fAllFields = null;
    private List fVisibleFields = null;
    private List fAllInterfaces = null;
    private List fAllLineLocations = null;
    private String fSourcename = null;
    private int fModifierBits = -1;
    private ClassLoaderReferenceImpl fClassLoader = null;
    private ClassObjectReferenceImpl fClassObject = null;
    private boolean fGotClassFileVersion = false;
    private int fClassFileVersion;
    private boolean fIsHCREligible;
    private boolean fIsVersionKnown;
    static /* synthetic */ Class class$0;

    protected ReferenceTypeImpl(String description, VirtualMachineImpl vmImpl, JdwpReferenceTypeID referenceTypeID) {
        super(description, vmImpl);
        this.fReferenceTypeID = referenceTypeID;
    }

    protected ReferenceTypeImpl(String description, VirtualMachineImpl vmImpl, JdwpReferenceTypeID referenceTypeID, String signature) {
        super(description, vmImpl);
        this.fReferenceTypeID = referenceTypeID;
        this.setSignature(signature);
    }

    public abstract byte typeTag();

    public void flushStoredJdwpResults() {
        Iterator iter;
        if (this.fMethods != null) {
            iter = this.fMethods.iterator();
            while (iter.hasNext()) {
                MethodImpl method = (MethodImpl)iter.next();
                method.flushStoredJdwpResults();
            }
            this.fMethods = null;
            this.fMethodTable = null;
        }
        if (this.fFields != null) {
            iter = this.fFields.iterator();
            while (iter.hasNext()) {
                FieldImpl field = (FieldImpl)iter.next();
                field.flushStoredJdwpResults();
            }
            this.fFields = null;
        }
        this.fInterfaces = null;
        this.fAllMethods = null;
        this.fVisibleMethods = null;
        this.fAllFields = null;
        this.fVisibleFields = null;
        this.fAllInterfaces = null;
        this.fAllLineLocations = null;
        this.fSourcename = null;
        this.fModifierBits = -1;
        this.fClassLoader = null;
        this.fClassObject = null;
        this.fGotClassFileVersion = false;
        this.fSignature = null;
        this.fSourcename = null;
    }

    public List allInterfaces() {
        ClassType superclass;
        if (this.fAllInterfaces != null) {
            return this.fAllInterfaces;
        }
        HashSet<InterfaceType> allInterfacesSet = new HashSet<InterfaceType>(this.interfaces());
        Iterator interfaces = this.interfaces().iterator();
        while (interfaces.hasNext()) {
            InterfaceTypeImpl inter = (InterfaceTypeImpl)interfaces.next();
            allInterfacesSet.addAll(inter.allInterfaces());
        }
        if (this instanceof ClassType && (superclass = ((ClassType)((Object)this)).superclass()) != null) {
            allInterfacesSet.addAll(superclass.allInterfaces());
        }
        this.fAllInterfaces = new ArrayList(allInterfacesSet);
        return this.fAllInterfaces;
    }

    public JdwpReferenceTypeID getRefTypeID() {
        return this.fReferenceTypeID;
    }

    public int modifiers() {
        if (this.fModifierBits != -1) {
            return this.fModifierBits;
        }
        this.initJdwpRequest();
        try {
            try {
                JdwpReplyPacket replyPacket = this.requestVM(515, this);
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                int n = this.fModifierBits = this.readInt("modifiers", AccessibleImpl.getModifierStrings(), replyData);
                Object var3_5 = null;
                this.handledJdwpRequest();
                return n;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                Object var3_6 = null;
                this.handledJdwpRequest();
                return 0;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
    }

    private void addVisibleMethods(List inheritedMethods, Set nameAndSignatures, List resultMethods) {
        Iterator iter = inheritedMethods.iterator();
        while (iter.hasNext()) {
            MethodImpl inheritedMethod = (MethodImpl)iter.next();
            if (nameAndSignatures.contains(String.valueOf(inheritedMethod.name()) + inheritedMethod.signature())) continue;
            resultMethods.add(inheritedMethod);
        }
    }

    public List visibleMethods() {
        ClassType superclass;
        if (this.fVisibleMethods != null) {
            return this.fVisibleMethods;
        }
        HashSet<String> namesAndSignatures = new HashSet<String>();
        ArrayList<MethodImpl> visibleMethods = new ArrayList<MethodImpl>();
        Iterator iter = this.methods().iterator();
        while (iter.hasNext()) {
            MethodImpl method = (MethodImpl)iter.next();
            namesAndSignatures.add(String.valueOf(method.name()) + method.signature());
            visibleMethods.add(method);
        }
        Iterator interfaces = this.interfaces().iterator();
        while (interfaces.hasNext()) {
            InterfaceTypeImpl inter = (InterfaceTypeImpl)interfaces.next();
            this.addVisibleMethods(inter.visibleMethods(), namesAndSignatures, visibleMethods);
        }
        if (this instanceof ClassType && (superclass = ((ClassType)((Object)this)).superclass()) != null) {
            this.addVisibleMethods(superclass.visibleMethods(), namesAndSignatures, visibleMethods);
        }
        this.fVisibleMethods = visibleMethods;
        return this.fVisibleMethods;
    }

    public List allMethods() {
        ClassType superclass;
        if (this.fAllMethods != null) {
            return this.fAllMethods;
        }
        HashSet<Method> resultSet = new HashSet<Method>();
        resultSet.addAll(this.methods());
        Iterator interfaces = this.interfaces().iterator();
        while (interfaces.hasNext()) {
            InterfaceTypeImpl inter = (InterfaceTypeImpl)interfaces.next();
            resultSet.addAll(inter.allMethods());
        }
        if (this instanceof ClassType && (superclass = ((ClassType)((Object)this)).superclass()) != null) {
            resultSet.addAll(superclass.allMethods());
        }
        this.fAllMethods = new ArrayList(resultSet);
        return this.fAllMethods;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List interfaces() {
        ArrayList<InterfaceTypeImpl> arrayList;
        if (this.fInterfaces != null) {
            return this.fInterfaces;
        }
        this.initJdwpRequest();
        try {
            try {
                JdwpReplyPacket replyPacket = this.requestVM(522, this);
                switch (replyPacket.errorCode()) {
                    case 41: {
                        List list = Collections.EMPTY_LIST;
                        Object var7_5 = null;
                        this.handledJdwpRequest();
                        return list;
                    }
                }
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                ArrayList<InterfaceTypeImpl> elements = new ArrayList<InterfaceTypeImpl>();
                int nrOfElements = this.readInt("elements", replyData);
                int i = 0;
                while (true) {
                    if (i >= nrOfElements) {
                        this.fInterfaces = elements;
                        arrayList = elements;
                        break;
                    }
                    InterfaceTypeImpl ref = InterfaceTypeImpl.read(this, replyData);
                    if (ref != null) {
                        elements.add(ref);
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                Object var7_7 = null;
                this.handledJdwpRequest();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
        Object var7_6 = null;
        this.handledJdwpRequest();
        return arrayList;
    }

    private void addVisibleFields(List newFields, Set names, List resultFields) {
        Iterator iter = newFields.iterator();
        while (iter.hasNext()) {
            FieldImpl field = (FieldImpl)iter.next();
            String name = field.name();
            if (names.contains(name)) continue;
            resultFields.add(field);
            names.add(name);
        }
    }

    public List visibleFields() {
        ClassType superclass;
        if (this.fVisibleFields != null) {
            return this.fVisibleFields;
        }
        HashSet fieldNames = new HashSet();
        ArrayList visibleFields = new ArrayList();
        this.addVisibleFields(this.fields(), fieldNames, visibleFields);
        Iterator interfaces = this.interfaces().iterator();
        while (interfaces.hasNext()) {
            InterfaceTypeImpl inter = (InterfaceTypeImpl)interfaces.next();
            this.addVisibleFields(inter.visibleFields(), fieldNames, visibleFields);
        }
        if (this instanceof ClassType && (superclass = ((ClassType)((Object)this)).superclass()) != null) {
            this.addVisibleFields(superclass.visibleFields(), fieldNames, visibleFields);
        }
        this.fVisibleFields = visibleFields;
        return this.fVisibleFields;
    }

    public List allFields() {
        ClassType superclass;
        if (this.fAllFields != null) {
            return this.fAllFields;
        }
        HashSet<com.sun.jdi.Field> resultSet = new HashSet<com.sun.jdi.Field>();
        resultSet.addAll(this.fields());
        Iterator interfaces = this.interfaces().iterator();
        while (interfaces.hasNext()) {
            InterfaceTypeImpl inter = (InterfaceTypeImpl)interfaces.next();
            resultSet.addAll(inter.allFields());
        }
        if (this instanceof ClassType && (superclass = ((ClassType)((Object)this)).superclass()) != null) {
            resultSet.addAll(superclass.allFields());
        }
        this.fAllFields = new ArrayList(resultSet);
        return this.fAllFields;
    }

    public ClassLoaderReference classLoader() {
        if (this.fClassLoader != null) {
            return this.fClassLoader;
        }
        this.initJdwpRequest();
        try {
            try {
                JdwpReplyPacket replyPacket = this.requestVM(514, this);
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                ClassLoaderReferenceImpl classLoaderReferenceImpl = this.fClassLoader = ClassLoaderReferenceImpl.read(this, replyData);
                Object var3_5 = null;
                this.handledJdwpRequest();
                return classLoaderReferenceImpl;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                Object var3_6 = null;
                this.handledJdwpRequest();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
    }

    public ClassObjectReference classObject() {
        if (this.fClassObject != null) {
            return this.fClassObject;
        }
        this.initJdwpRequest();
        try {
            try {
                JdwpReplyPacket replyPacket = this.requestVM(523, this);
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                ClassObjectReferenceImpl classObjectReferenceImpl = this.fClassObject = ClassObjectReferenceImpl.read(this, replyData);
                Object var3_5 = null;
                this.handledJdwpRequest();
                return classObjectReferenceImpl;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                Object var3_6 = null;
                this.handledJdwpRequest();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
    }

    protected int status() {
        this.initJdwpRequest();
        try {
            try {
                int status;
                JdwpReplyPacket replyPacket = this.requestVM(521, this);
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                int n = status = this.readInt("status", ReferenceTypeImpl.classStatusStrings(), replyData);
                Object var4_6 = null;
                this.handledJdwpRequest();
                return n;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                Object var4_7 = null;
                this.handledJdwpRequest();
                return 0;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
    }

    public boolean failedToInitialize() {
        return (this.status() & 8) != 0;
    }

    public boolean isInitialized() {
        return (this.status() & 4) != 0;
    }

    public boolean isPrepared() {
        return (this.status() & 2) != 0;
    }

    public boolean isVerified() {
        return (this.status() & 1) != 0;
    }

    public com.sun.jdi.Field fieldByName(String name) {
        Iterator iter = this.visibleFields().iterator();
        while (iter.hasNext()) {
            FieldImpl field = (FieldImpl)iter.next();
            if (!field.name().equals(name)) continue;
            return field;
        }
        return null;
    }

    public List fields() {
        if (this.fFields != null) {
            return this.fFields;
        }
        this.initJdwpRequest();
        try {
            try {
                JdwpReplyPacket replyPacket = this.requestVM(516, this);
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                ArrayList<FieldImpl> elements = new ArrayList<FieldImpl>();
                int nrOfElements = this.readInt("elements", replyData);
                int i = 0;
                while (i < nrOfElements) {
                    FieldImpl elt = FieldImpl.readWithNameSignatureModifiers(this, this, replyData);
                    if (elt != null) {
                        elements.add(elt);
                    }
                    ++i;
                }
                this.fFields = elements;
                ArrayList<FieldImpl> arrayList = elements;
                Object var7_9 = null;
                this.handledJdwpRequest();
                return arrayList;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                Object var7_10 = null;
                this.handledJdwpRequest();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
    }

    public FieldImpl findField(JdwpFieldID fieldID) {
        Iterator iter = this.fields().iterator();
        while (iter.hasNext()) {
            FieldImpl field = (FieldImpl)iter.next();
            if (!field.getFieldID().equals(fieldID)) continue;
            return field;
        }
        return null;
    }

    public MethodImpl findMethod(JdwpMethodID methodID) {
        if (methodID.value() == 0L) {
            return new MethodImpl(this.virtualMachineImpl(), this, methodID, JDIMessages.getString("ReferenceTypeImpl.Obsolete_method_1"), "", -1);
        }
        if (this.fMethodTable == null) {
            this.fMethodTable = new Hashtable();
            Iterator iter = this.methods().iterator();
            while (iter.hasNext()) {
                MethodImpl method = (MethodImpl)iter.next();
                this.fMethodTable.put(method.getMethodID(), method);
            }
        }
        return (MethodImpl)this.fMethodTable.get(methodID);
    }

    public Value getValue(com.sun.jdi.Field field) {
        ArrayList<com.sun.jdi.Field> list = new ArrayList<com.sun.jdi.Field>(1);
        list.add(field);
        return (ValueImpl)this.getValues(list).get(field);
    }

    public Map getValues(List fields) {
        if (fields.isEmpty()) {
            return new HashMap();
        }
        this.initJdwpRequest();
        try {
            try {
                ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
                DataOutputStream outData = new DataOutputStream(outBytes);
                int fieldsSize = fields.size();
                this.write(this, outData);
                this.writeInt(fieldsSize, "size", outData);
                int i = 0;
                while (i < fieldsSize) {
                    FieldImpl field = (FieldImpl)fields.get(i);
                    this.checkVM(field);
                    field.getFieldID().write(outData);
                    ++i;
                }
                JdwpReplyPacket replyPacket = this.requestVM(518, outBytes);
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                HashMap map = new HashMap();
                int nrOfElements = this.readInt("elements", replyData);
                if (nrOfElements != fieldsSize) {
                    throw new InternalError(JDIMessages.getString("ReferenceTypeImpl.Retrieved_a_different_number_of_values_from_the_VM_than_requested_3"));
                }
                int i2 = 0;
                while (i2 < nrOfElements) {
                    map.put(fields.get(i2), ValueImpl.readWithTag(this, replyData));
                    ++i2;
                }
                HashMap hashMap = map;
                Object var10_13 = null;
                this.handledJdwpRequest();
                return hashMap;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                Object var10_14 = null;
                this.handledJdwpRequest();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
    }

    public int hashCode() {
        return this.fReferenceTypeID.hashCode();
    }

    public boolean equals(Object object) {
        return object != null && object.getClass().equals(this.getClass()) && this.fReferenceTypeID.equals(((ReferenceTypeImpl)object).fReferenceTypeID) && this.virtualMachine().equals(((MirrorImpl)object).virtualMachine());
    }

    public int compareTo(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            throw new ClassCastException(JDIMessages.getString("ReferenceTypeImpl.Can__t_compare_reference_type_to_given_object_4"));
        }
        return this.name().compareTo(((com.sun.jdi.ReferenceType)object).name());
    }

    public boolean isAbstract() {
        return (this.modifiers() & 0x400) != 0;
    }

    public boolean isFinal() {
        return (this.modifiers() & 0x10) != 0;
    }

    public boolean isStatic() {
        return (this.modifiers() & 8) != 0;
    }

    public List locationsOfLine(int line) throws AbsentInformationException {
        Iterator allMethods = this.methods().iterator();
        AbsentInformationException absentInformationException = null;
        while (allMethods.hasNext()) {
            MethodImpl method = (MethodImpl)allMethods.next();
            if (method.isAbstract() || method.isNative()) continue;
            try {
                return method.locationsOfLine(line);
            }
            catch (InvalidLineNumberException invalidLineNumberException) {
            }
            catch (AbsentInformationException e) {
                absentInformationException = e;
            }
        }
        if (absentInformationException != null) {
            throw absentInformationException;
        }
        throw new InvalidLineNumberException(String.valueOf(JDIMessages.getString("ReferenceTypeImpl.No_executable_code_at_line__5")) + line + JDIMessages.getString("ReferenceTypeImpl._6"));
    }

    public List methods() {
        if (this.fMethods != null) {
            return this.fMethods;
        }
        this.initJdwpRequest();
        try {
            try {
                JdwpReplyPacket replyPacket = this.requestVM(517, this);
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                ArrayList<MethodImpl> elements = new ArrayList<MethodImpl>();
                int nrOfElements = this.readInt("elements", replyData);
                int i = 0;
                while (i < nrOfElements) {
                    MethodImpl elt = MethodImpl.readWithNameSignatureModifiers(this, this, replyData);
                    if (elt != null) {
                        elements.add(elt);
                    }
                    ++i;
                }
                this.fMethods = elements;
                ArrayList<MethodImpl> arrayList = elements;
                Object var7_9 = null;
                this.handledJdwpRequest();
                return arrayList;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                Object var7_10 = null;
                this.handledJdwpRequest();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
    }

    public List methodsByName(String name) {
        ArrayList<MethodImpl> elements = new ArrayList<MethodImpl>();
        Iterator iter = this.visibleMethods().iterator();
        while (iter.hasNext()) {
            MethodImpl method = (MethodImpl)iter.next();
            if (!method.name().equals(name)) continue;
            elements.add(method);
        }
        return elements;
    }

    public List methodsByName(String name, String signature) {
        ArrayList<MethodImpl> elements = new ArrayList<MethodImpl>();
        Iterator iter = this.visibleMethods().iterator();
        while (iter.hasNext()) {
            MethodImpl method = (MethodImpl)iter.next();
            if (!method.name().equals(name) || !method.signature().equals(signature)) continue;
            elements.add(method);
        }
        return elements;
    }

    public String name() {
        if (this.fName == null) {
            this.setName(TypeImpl.signatureToName(this.signature()));
        }
        return this.fName;
    }

    public String signature() {
        if (this.fSignature != null) {
            return this.fSignature;
        }
        this.initJdwpRequest();
        try {
            try {
                JdwpReplyPacket replyPacket = this.requestVM(513, this);
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                this.setSignature(this.readString("signature", replyData));
                String string = this.fSignature;
                Object var3_5 = null;
                this.handledJdwpRequest();
                return string;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                Object var3_6 = null;
                this.handledJdwpRequest();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
    }

    public List nestedTypes() {
        ArrayList<ReferenceTypeImpl> result = new ArrayList<ReferenceTypeImpl>();
        Iterator itr = this.virtualMachineImpl().allRefTypes();
        while (itr.hasNext()) {
            try {
                ReferenceTypeImpl refType = (ReferenceTypeImpl)itr.next();
                String refName = refType.name();
                if (refName.length() <= this.name().length() || !refName.startsWith(this.name()) || refName.charAt(this.name().length()) != '$') continue;
                result.add(refType);
            }
            catch (ClassNotPreparedException classNotPreparedException) {}
        }
        return result;
    }

    public String sourceName() throws AbsentInformationException {
        if (this.fSourcename != null) {
            return this.fSourcename;
        }
        this.initJdwpRequest();
        try {
            try {
                JdwpReplyPacket replyPacket = this.requestVM(519, this);
                if (replyPacket.errorCode() == 101) {
                    throw new AbsentInformationException(JDIMessages.getString("ReferenceTypeImpl.Source_name_is_not_known_7"));
                }
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                String string = this.fSourcename = this.readString("source name", replyData);
                Object var3_5 = null;
                this.handledJdwpRequest();
                return string;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                Object var3_6 = null;
                this.handledJdwpRequest();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
    }

    public int getClassFileVersion() {
        this.virtualMachineImpl().checkHCRSupported();
        if (this.fGotClassFileVersion) {
            return this.fClassFileVersion;
        }
        this.initJdwpRequest();
        try {
            try {
                JdwpReplyPacket replyPacket = this.requestVM(32770, this);
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                this.fIsHCREligible = this.readBoolean("HCR eligible", replyData);
                this.fIsVersionKnown = this.readBoolean("version known", replyData);
                this.fClassFileVersion = this.readInt("class file version", replyData);
                this.fGotClassFileVersion = true;
                int n = this.fClassFileVersion;
                Object var3_5 = null;
                this.handledJdwpRequest();
                return n;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                Object var3_6 = null;
                this.handledJdwpRequest();
                return 0;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
    }

    public boolean isVersionKnown() {
        this.getClassFileVersion();
        return this.fIsVersionKnown;
    }

    public boolean isHCREligible() {
        this.getClassFileVersion();
        return this.fIsHCREligible;
    }

    public void write(MirrorImpl target, DataOutputStream out) throws IOException {
        this.fReferenceTypeID.write(out);
        if (target.fVerboseWriter != null) {
            target.fVerboseWriter.println("referenceType", this.fReferenceTypeID.value());
        }
    }

    public static void writeNull(MirrorImpl target, DataOutputStream out) throws IOException {
        JdwpReferenceTypeID ID = new JdwpReferenceTypeID(target.virtualMachineImpl());
        ID.write(out);
        if (target.fVerboseWriter != null) {
            target.fVerboseWriter.println("referenceType", ID.value());
        }
    }

    public void writeWithTag(MirrorImpl target, DataOutputStream out) throws IOException {
        target.writeByte(this.typeTag(), "type tag", JdwpID.typeTagMap(), out);
        this.write(target, out);
    }

    public static ReferenceTypeImpl readWithTypeTag(MirrorImpl target, DataInputStream in) throws IOException {
        byte typeTag = target.readByte("type tag", JdwpID.typeTagMap(), in);
        switch (typeTag) {
            case 0: {
                return null;
            }
            case 3: {
                return ArrayTypeImpl.read(target, in);
            }
            case 1: {
                return ClassTypeImpl.read(target, in);
            }
            case 2: {
                return InterfaceTypeImpl.read(target, in);
            }
        }
        throw new InternalException(String.valueOf(JDIMessages.getString("ReferenceTypeImpl.Invalid_ReferenceTypeID_tag_encountered___8")) + typeTag);
    }

    public List allLineLocations() throws AbsentInformationException {
        if (this.fAllLineLocations != null) {
            return this.fAllLineLocations;
        }
        Iterator allMethods = this.methods().iterator();
        ArrayList locations = new ArrayList();
        while (allMethods.hasNext()) {
            MethodImpl method = (MethodImpl)allMethods.next();
            if (method.isAbstract() || method.isNative()) continue;
            locations.addAll(method.allLineLocations());
        }
        this.fAllLineLocations = locations;
        return this.fAllLineLocations;
    }

    public static ReferenceTypeImpl readWithTypeTagAndSignature(MirrorImpl target, DataInputStream in) throws IOException {
        byte typeTag = target.readByte("type tag", JdwpID.typeTagMap(), in);
        switch (typeTag) {
            case 0: {
                return null;
            }
            case 3: {
                return ArrayTypeImpl.readWithSignature(target, in);
            }
            case 1: {
                return ClassTypeImpl.readWithSignature(target, in);
            }
            case 2: {
                return InterfaceTypeImpl.readWithSignature(target, in);
            }
        }
        throw new InternalException(String.valueOf(JDIMessages.getString("ReferenceTypeImpl.Invalid_ReferenceTypeID_tag_encountered___8")) + typeTag);
    }

    public static TypeImpl create(VirtualMachineImpl vmImpl, String signature, ClassLoaderReference classLoader) throws ClassNotLoadedException {
        ReferenceTypeImpl type;
        ReferenceTypeImpl refTypeBootstrap = null;
        List classes = vmImpl.classesBySignature(signature);
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            type = (ReferenceTypeImpl)iter.next();
            if (type.classLoader() == null) {
                if (classLoader == null) {
                    return type;
                }
                refTypeBootstrap = type;
            }
            if (classLoader == null || !classLoader.equals(type.classLoader())) continue;
            return type;
        }
        if (refTypeBootstrap != null) {
            return refTypeBootstrap;
        }
        iter = classes.iterator();
        while (iter.hasNext()) {
            type = (ReferenceTypeImpl)iter.next();
            List<com.sun.jdi.ReferenceType> visibleTypes = classLoader.visibleClasses();
            Iterator<com.sun.jdi.ReferenceType> visibleIter = visibleTypes.iterator();
            while (visibleIter.hasNext()) {
                if (!type.equals(visibleIter.next())) continue;
                return type;
            }
        }
        throw new ClassNotLoadedException(TypeImpl.classSignatureToName(signature), JDIMessages.getString("ReferenceTypeImpl.Type_has_not_been_loaded_10"));
    }

    public static void getConstantMaps() {
        if (fgClassStatusStrings != null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdi.internal.ReferenceTypeImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Field[] fields = clazz.getDeclaredFields();
        fgClassStatusStrings = new String[32];
        int i = 0;
        while (i < fields.length) {
            String name;
            Field field = fields[i];
            if ((field.getModifiers() & 1) != 0 && (field.getModifiers() & 8) != 0 && (field.getModifiers() & 0x10) != 0 && (name = field.getName()).startsWith("JDWP_CLASS_STATUS_")) {
                name = name.substring(18);
                try {
                    int value = field.getInt(null);
                    int j = 0;
                    while (j < fgClassStatusStrings.length) {
                        if ((1 << j & value) != 0) {
                            ReferenceTypeImpl.fgClassStatusStrings[j] = name;
                            break;
                        }
                        ++j;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            ++i;
        }
    }

    public static String[] classStatusStrings() {
        ReferenceTypeImpl.getConstantMaps();
        return fgClassStatusStrings;
    }

    public Value createNullValue() {
        return null;
    }

    public List sourceNames(String arg0) throws AbsentInformationException {
        return null;
    }

    public List sourcePaths(String arg0) throws AbsentInformationException {
        return null;
    }

    public String sourceDebugExtension() throws AbsentInformationException {
        return null;
    }

    public List allLineLocations(String arg0, String arg1) throws AbsentInformationException {
        return null;
    }

    public List locationsOfLine(String arg0, String arg1, int arg2) throws AbsentInformationException {
        return null;
    }

    public List availableStrata() {
        return null;
    }

    public String defaultStratum() {
        return null;
    }
}

