/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.uddi;

import com.sap.engine.interfaces.security.userstore.UserStore;
import com.sap.engine.interfaces.security.userstore.context.GroupContext;
import com.sap.engine.interfaces.security.userstore.context.GroupInfo;
import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import com.sap.engine.interfaces.webservices.uddi.UDDIServer;
import com.sap.engine.interfaces.webservices.uddi.UDDIServerAdmin;
import com.sap.engine.interfaces.webservices.uddi.UserDoesNotExistException;
import com.sap.engine.interfaces.webservices.uddi.UserExistsException;
import java.util.Iterator;
import java.util.Vector;

public class UDDIServerAdminImpl
implements UDDIServerAdmin {
    private UDDIServer uddiServer = null;
    private UserStore userStore;
    private GroupInfo levelTier1;
    private GroupInfo levelTierN;
    private GroupInfo levelAdmin;

    public void setUserStore(UserStore store) {
        this.userStore = store;
        GroupContext groupCtx = this.userStore.getGroupContext();
        this.levelTier1 = this.getGroup("LEVEL_PUB_TIER1", groupCtx);
        this.levelTierN = this.getGroup("LEVEL_PUB_TIERN", groupCtx);
        this.levelAdmin = this.getGroup("LEVEL_ADMIN", groupCtx);
    }

    private GroupInfo getGroup(String groupName, GroupContext ctx) {
        Iterator it = ctx.listGroups();
        while (it.hasNext()) {
            String group = it.next().toString();
            if (!groupName.equals(group)) continue;
            return ctx.getGroupInfo(groupName);
        }
        return ctx.createGroup(groupName);
    }

    public void registerUDDIServer(UDDIServer server) {
        this.uddiServer = server;
    }

    public void unregisterUDDIServer() {
        this.uddiServer = null;
    }

    public UDDIServer getUDDIServer() {
        return this.uddiServer;
    }

    private boolean groupContainsUser(GroupInfo group, String username) {
        Iterator it = group.getUsersInGroup();
        while (it.hasNext()) {
            String user = it.next().toString();
            if (!username.equals(user)) continue;
            return true;
        }
        return false;
    }

    public int getUserLevel(String username) {
        if (this.groupContainsUser(this.levelAdmin, username)) {
            return 3;
        }
        if (this.groupContainsUser(this.levelTierN, username)) {
            return 2;
        }
        if (this.groupContainsUser(this.levelTier1, username)) {
            return 1;
        }
        return -1;
    }

    private UserInfo getUserInfoPerGroup(String username, GroupInfo group) {
        Iterator it = group.getUsersInGroup();
        while (it.hasNext()) {
            String user = it.next().toString();
            if (!username.equals(user)) continue;
            return this.userStore.getUserContext().getUserInfo(username);
        }
        return null;
    }

    private UserInfo getUserInfo(String username) {
        UserInfo user = this.getUserInfoPerGroup(username, this.levelAdmin);
        if (user == null && (user = this.getUserInfoPerGroup(username, this.levelTierN)) == null) {
            user = this.getUserInfoPerGroup(username, this.levelTier1);
        }
        return user;
    }

    public boolean isValidUser(String username, char[] password) {
        UserInfo user = this.getUserInfo(username);
        if (user == null) {
            return false;
        }
        return user.checkPassword(password);
    }

    public void createNewUser(String username, char[] password, int level) throws UserExistsException {
        UserInfo user = this.getUserInfo(username);
        if (user != null) {
            throw new UserExistsException("Such a user already exists: " + username);
        }
        user = this.userStore.getUserContext().createUser(username);
        user.setPassword(password);
        GroupContext groupCtx = this.userStore.getGroupContext();
        switch (level) {
            case 3: {
                groupCtx.addUserToGroup(username, this.levelAdmin.getName());
                break;
            }
            case 2: {
                groupCtx.addUserToGroup(username, this.levelTierN.getName());
                break;
            }
            case 1: {
                groupCtx.addUserToGroup(username, this.levelTier1.getName());
                break;
            }
            default: {
                this.userStore.getUserContext().deleteUser(username);
                throw new IllegalArgumentException("Unknown level passed: " + level);
            }
        }
    }

    public void changeUserLevel(String username, int level) throws UserDoesNotExistException {
        int oldLevel = this.getUserLevel(username);
        if (oldLevel == -1) {
            throw new UserDoesNotExistException("Such a user does not exist: " + username);
        }
        if (oldLevel != level) {
            GroupContext groupCtx = this.userStore.getGroupContext();
            switch (oldLevel) {
                case 3: {
                    groupCtx.removeUserFromGroup(username, this.levelAdmin.getName());
                    break;
                }
                case 2: {
                    groupCtx.removeUserFromGroup(username, this.levelTierN.getName());
                    break;
                }
                case 1: {
                    groupCtx.removeUserFromGroup(username, this.levelTier1.getName());
                }
            }
            switch (level) {
                case 3: {
                    groupCtx.addUserToGroup(username, this.levelAdmin.getName());
                    break;
                }
                case 2: {
                    groupCtx.addUserToGroup(username, this.levelTierN.getName());
                    break;
                }
                case 1: {
                    groupCtx.addUserToGroup(username, this.levelTier1.getName());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown level passed: " + level);
                }
            }
        }
    }

    public void deleteUser(String username) throws UserDoesNotExistException {
        if (this.getUserInfo(username) == null) {
            throw new UserDoesNotExistException("Such a user does not exist: " + username);
        }
        this.userStore.getUserContext().deleteUser(username);
    }

    public String[] getUsersOfLevel(int level) {
        GroupInfo group = null;
        switch (level) {
            case 3: {
                group = this.levelAdmin;
                break;
            }
            case 2: {
                group = this.levelTierN;
                break;
            }
            case 1: {
                group = this.levelTier1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown level passed: " + level);
            }
        }
        Iterator it = group.getUsersInGroup();
        Vector<String> usernames = new Vector<String>();
        while (it.hasNext()) {
            String user = it.next().toString();
            usernames.addElement(user);
        }
        Object[] names = new String[usernames.size()];
        usernames.copyInto(names);
        return names;
    }
}

