/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.lcr;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ObjectWrapper {
    public static Class objClass = null;
    public Object objInstance = null;

    public ObjectWrapper(Object objInstance) {
        this.objInstance = objInstance;
    }

    public static void initClass(Class objClass) {
        if (ObjectWrapper.objClass == null) {
            ObjectWrapper.objClass = objClass;
        }
    }

    public static void initClass(ClassLoader loader, String className) throws ClassNotFoundException {
        objClass = loader.loadClass(className);
    }

    public static Object invokeStaticMethod(String methodName, Class[] argClasses, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = objClass.getMethod(methodName, argClasses);
        return method.invoke(null, args);
    }

    public static Object getStaticField(String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = objClass.getField(fieldName);
        return field.get(null);
    }

    public Object getObjInstance() {
        return this.objInstance;
    }

    public void setObjInstance(Object objInstance) {
        this.objInstance = objInstance;
    }

    public Class getObjClass() {
        return this.objInstance.getClass();
    }

    public Object invokeMethod(String methodName, Class[] argClasses, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = this.objInstance.getClass().getMethod(methodName, argClasses);
        return method.invoke(this.objInstance, args);
    }

    public Object getField(String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = this.objInstance.getClass().getField(fieldName);
        return field.get(this.objInstance);
    }

    public static boolean isInstanceOf(Object obj, String className) {
        return ObjectWrapper.isDerivableClass(obj.getClass(), className);
    }

    private static boolean isDerivableClass(Class classInst, String parentClassName) {
        if (classInst == null) {
            return false;
        }
        Class<?>[] interfaces = classInst.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].getName().equals(parentClassName)) {
                return true;
            }
            ++i;
        }
        if (classInst.getName().equals(parentClassName)) {
            return true;
        }
        return ObjectWrapper.isDerivableClass(classInst.getSuperclass(), parentClassName);
    }
}

