/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.dynamic;

import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DynamicWSDLResolver
implements EntityResolver {
    private Class wsInterface;

    public DynamicWSDLResolver(Class wsInterface) {
        this.wsInterface = wsInterface;
    }

    public InputSource getFromClassLoader(String resourcePath) throws IOException {
        InputStream in = this.wsInterface.getResourceAsStream(resourcePath);
        if (in == null && (in = this.wsInterface.getClassLoader().getResourceAsStream(resourcePath)) == null) {
            throw new IOException("Cannot load from classloader: " + resourcePath);
        }
        InputSource source = new InputSource(in);
        source.setSystemId(resourcePath);
        return source;
    }

    public InputSource resolveEntity(String publicID, String systemID) throws IOException {
        if (systemID.lastIndexOf(":") != -1) {
            systemID = systemID.substring(systemID.lastIndexOf(":") + 1);
        }
        if (systemID.lastIndexOf("\\") != -1) {
            systemID = systemID.substring(systemID.lastIndexOf("\\") + 1);
        }
        if (systemID.lastIndexOf("/") != -1) {
            systemID = systemID.substring(systemID.lastIndexOf("/") + 1);
        }
        String resourcePath = "/META-INF/ws-clients-descriptors/" + systemID;
        return this.getFromClassLoader(resourcePath);
    }
}

