/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.dynamic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;

public class DynamicStubsLoader
extends ClassLoader {
    private Hashtable generatedStubs = new Hashtable();

    public DynamicStubsLoader(ClassLoader parent, File generatedDir) throws IOException {
        super(parent);
        this.addClassFiles(null, generatedDir);
    }

    private void addClassFiles(String packageName, File dir) throws IOException {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                String newPackage = packageName == null ? file.getName() : packageName + "." + file.getName();
                this.addClassFiles(newPackage, file);
            } else {
                String extension;
                String className = packageName == null ? file.getName() : packageName + "." + file.getName();
                int index = className.lastIndexOf(".");
                if (index != -1 && "class".equals(extension = className.substring(index + 1))) {
                    className = className.substring(0, index);
                    FileInputStream in = new FileInputStream(file);
                    int len = in.available();
                    byte[] result = new byte[len];
                    int n = 0;
                    while (n < len) {
                        int count = in.read(result, n, len - n);
                        if (count < 0) break;
                        n += count;
                    }
                    in.close();
                    this.defineClass(className, result, 0, n);
                }
            }
            ++i;
        }
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        try {
            return super.loadClass(name);
        }
        catch (Throwable thr) {
            return this.getParent().loadClass(name);
        }
    }
}

