/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.dynamic;

import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.interfaces.webservices.client.ClientFeatureProvider;
import com.sap.engine.interfaces.webservices.dynamic.DynamicServiceFactory;
import com.sap.engine.interfaces.webservices.runtime.component.ClientComponentFactory;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientTransportBinding;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGenerator;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGeneratorConfig;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.RuntimeInformation;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ServiceBaseServer;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortFactory;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPorts;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.WSManagementInterfaceImpl;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.ComponentScopedRefsDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.ServiceRefDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.WSClientDeploymentDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.WSClientsParser;
import com.sap.engine.services.webservices.server.dynamic.DynamicStubsLoader;
import com.sap.engine.services.webservices.server.dynamic.DynamicWSDLResolver;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DynamicServiceFactoryImpl
implements DynamicServiceFactory {
    private Vector getJarsVector(ClassLoader refLoader) {
        Vector<String> loaderJars = new Vector<String>();
        while (refLoader instanceof ReferencedLoader) {
            ReferencedLoader loader = (ReferencedLoader)refLoader;
            String[] resources = loader.getResourceNames();
            int i = 0;
            while (i < resources.length) {
                String jar = resources[i];
                if (!loaderJars.contains(jar)) {
                    loaderJars.addElement(jar);
                }
                ++i;
            }
            refLoader = loader.getParent();
        }
        return loaderJars;
    }

    public Object getWebService(Class wsInterface, String wsclientsDescriptorName) throws Exception {
        return this.getWebService(wsInterface, wsclientsDescriptorName, wsInterface.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getWebService(Class wsInterface, String wsclientsDescriptorName, String componentName) throws Exception {
        ServiceBaseServer serviceBaseServer;
        File tempDirectory = null;
        try {
            try {
                DynamicStubsLoader stubsLoader;
                StringTokenizer wsdlTokenizer;
                String jndiName;
                String wsdlMappingFile;
                ClassLoader extLoader = wsInterface.getClassLoader();
                Vector loaderJars = new Vector();
                loaderJars.addAll(this.getJarsVector(this.getClass().getClassLoader()));
                loaderJars.addAll(this.getJarsVector(extLoader));
                String packageName = wsInterface.getPackage().getName();
                tempDirectory = this.getTempProxyDir();
                DynamicWSDLResolver wsdlResolver = new DynamicWSDLResolver(wsInterface);
                InputSource wsclientsDescriptor = wsdlResolver.getFromClassLoader("/META-INF/ws-clients-descriptors/" + wsclientsDescriptorName);
                InputStream input = wsclientsDescriptor.getByteStream();
                WSClientDeploymentDescriptor wsClientsDesc = WSClientsParser.loadWSClientsDeploymentDescriptor(input);
                input.close();
                ComponentScopedRefsDescriptor[] components = wsClientsDesc.getComponentScopedRefs();
                if (components.length == 0) {
                    throw new Exception("Cannot find component descriptors in the ws-clients-deployment-descriptor!");
                }
                ServiceRefDescriptor[] serviceRefs = components[0].getServiceRef();
                if (serviceRefs.length == 0) {
                    throw new Exception("Cannot find service reference in the ws-clients-deployment-descriptor!");
                }
                ServiceRefDescriptor serviceRef = serviceRefs[0];
                String lpFileName = serviceRef.getLogicalPortsFile();
                InputSource source = wsdlResolver.getFromClassLoader("/META-INF/ws-clients-descriptors/" + lpFileName);
                LogicalPortFactory factory = new LogicalPortFactory();
                InputStream in = source.getByteStream();
                LogicalPorts originalPorts = factory.loadLogicalPorts(in);
                in.close();
                StringBuffer classpath = new StringBuffer();
                classpath.append(WSContainer.getWSDeployer().getJarsPath());
                classpath.append(File.pathSeparator + tempDirectory.getAbsolutePath());
                int i = 0;
                while (true) {
                    if (i >= loaderJars.size()) {
                        Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                        wsLocation.debugT("Classpath for stubs is: " + classpath.toString());
                        String rootWSDL = serviceRef.getWsdlFile();
                        wsdlMappingFile = serviceRef.getUriMappingFile();
                        jndiName = serviceRef.getServiceRefName();
                        wsdlTokenizer = new StringTokenizer(rootWSDL, ";");
                        if (wsdlTokenizer.hasMoreTokens()) break;
                        throw new Exception("Incorrect WSDL file in the deployment descriptor!");
                    }
                    classpath.append(File.pathSeparator + loaderJars.elementAt(i));
                    ++i;
                }
                StringTokenizer mappingTokenizer = new StringTokenizer(wsdlMappingFile, ";");
                Vector<LogicalPortType> lpVector = new Vector<LogicalPortType>();
                String serviceName = null;
                block5: while (true) {
                    if (!wsdlTokenizer.hasMoreTokens()) {
                        stubsLoader = new DynamicStubsLoader(extLoader, tempDirectory);
                        serviceName = serviceName == null || serviceName.trim().length() == 0 ? "DefaultServiceImpl" : serviceName + "Impl";
                    }
                    String wsdlFile = wsdlTokenizer.nextToken();
                    if (!mappingTokenizer.hasMoreTokens()) throw new Exception("The number of mapping files is not equal to the number of the WSDL files!");
                    String mappingFile = mappingTokenizer.nextToken();
                    Properties wsdlMapping = null;
                    if (wsdlMappingFile != null) {
                        InputSource mappingSource = wsdlResolver.getFromClassLoader("/META-INF/ws-clients-descriptors/" + mappingFile);
                        wsdlMapping = new Properties();
                        InputStream mappingStream = mappingSource.getByteStream();
                        wsdlMapping.load(mappingStream);
                        mappingStream.close();
                    }
                    ProxyGeneratorConfig config = new ProxyGeneratorConfig(wsdlFile, tempDirectory.getAbsolutePath(), packageName);
                    ClientFeatureProvider[] clientInterfaces = WSContainer.getComponentFactory().listClientransportBindingInterfaces();
                    ClientTransportBinding[] bindings = new ClientTransportBinding[clientInterfaces.length];
                    int i2 = 0;
                    while (true) {
                        if (i2 >= clientInterfaces.length) {
                            config.setBindings(bindings);
                            config.setLogicalPorts(originalPorts);
                            config.setStubsOnly(true);
                            config.setResolver((EntityResolver)wsdlResolver);
                            if (wsdlMapping != null) {
                                config.setLocationMap((Hashtable)wsdlMapping);
                            }
                            break;
                        }
                        bindings[i2] = (ClientTransportBinding)clientInterfaces[i2];
                        ++i2;
                    }
                    config.setAdditionalClassPath(classpath.toString());
                    config.setCompile(true);
                    ProxyGenerator gen = new ProxyGenerator();
                    gen.generateProxy(config);
                    LogicalPorts logicalPorts = config.getLogicalPorts();
                    serviceName = logicalPorts.getName();
                    LogicalPortType[] portTypes = logicalPorts.getLogicalPort();
                    int i3 = 0;
                    while (true) {
                        if (i3 >= portTypes.length) continue block5;
                        lpVector.addElement(portTypes[i3]);
                        ++i3;
                    }
                    break;
                }
                serviceName = packageName + "." + serviceName;
                Class serviceClass = stubsLoader.loadClass(serviceName);
                ServiceBaseServer service = (ServiceBaseServer)serviceClass.newInstance();
                LogicalPorts logicalPorts = new LogicalPorts();
                Object[] portTypes = new LogicalPortType[lpVector.size()];
                lpVector.copyInto(portTypes);
                logicalPorts.setLogicalPort((LogicalPortType[])portTypes);
                service.init(logicalPorts, (ClientComponentFactory)WSContainer.getComponentFactory(), (ClassLoader)stubsLoader);
                RuntimeInformation runtimeInformation = new RuntimeInformation();
                runtimeInformation.setJndiName(jndiName);
                runtimeInformation.setApplicationName(componentName);
                runtimeInformation.setArchiveName("");
                service.setRuntimeInformation(runtimeInformation);
                service.setHTTPProxyResolver(WSContainer.getHTTPProxyResolver());
                serviceBaseServer = service;
                Object var42_44 = null;
                if (tempDirectory == null) return serviceBaseServer;
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsLocation.catching((Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var42_45 = null;
            if (tempDirectory == null) throw throwable;
            WSManagementInterfaceImpl.removeDirectory(tempDirectory);
            throw throwable;
        }
        WSManagementInterfaceImpl.removeDirectory(tempDirectory);
        return serviceBaseServer;
    }

    private synchronized File getTempProxyDir() {
        File tempDir;
        String tempDirectory;
        String string = tempDirectory = WSContainer.getServiceContext().getServiceState().getWorkingDirectoryName() + File.separatorChar + "dynamic";
        synchronized (string) {
            while ((tempDir = new File(tempDirectory, "proxy" + System.currentTimeMillis())).exists()) {
            }
            tempDir.mkdirs();
        }
        return tempDir;
    }
}

