/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.wsclient.update;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.services.webservices.exceptions.WSConfigurationException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientRuntimeInfo;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.WSConfigurationHandler;
import com.sap.engine.services.webservices.server.deploy.common.AppDeployInfo;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDirsHandler;
import com.sap.engine.services.webservices.server.deploy.common.ModuleFileStorageHandler;
import com.sap.engine.services.webservices.server.deploy.common.update.ModuleUpdateProcessor;
import com.sap.engine.services.webservices.server.deploy.common.update.ModuleUpdateResult;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.ws.WSDirsHandler;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientDeploymentInfo;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientDirsHandler;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsDeployGenerator;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsDeployResult;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsFactory;
import com.sap.engine.services.webservices.server.deploy.wsclient.update.WSClientArchiveLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.wsclient.update.WSClientFileLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.wsclient.update.WSClientLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.wsclient.update.WSClientsAppUpdateResult;
import com.sap.engine.services.webservices.server.deploy.wsclient.update.WSClientsUpdateInfo;
import com.sap.engine.services.webservices.server.deploy.wsclient.update.WSClientsUpdateResult;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class WSClientsUpdateProcessor {
    private WSClientsFactory wsClientsFactory = new WSClientsFactory();
    private WSClientsDeployGenerator wsClientsDeployGenerator = null;
    private ModuleUpdateProcessor moduleUpdateProcessor = null;
    private ModuleFileStorageHandler moduleFileStorageHandler = null;

    public WSClientsUpdateProcessor(WSClientsDeployGenerator wsClientsDeployGenerator, ModuleUpdateProcessor moduleUpdateProcessor, ModuleFileStorageHandler moduleFileStorageHandler) {
        this.wsClientsDeployGenerator = wsClientsDeployGenerator;
        this.moduleUpdateProcessor = moduleUpdateProcessor;
        this.moduleFileStorageHandler = moduleFileStorageHandler;
    }

    public WSClientsAppUpdateResult updateWSClients(String applicationName, String wsClientsDir, String wsClientsWorkingDir, AppDeployInfo appDeployInfo, File[] wsClientsModuleArchives) throws WSDeploymentException {
        String excMsg = "Error occured, trying to update ws clients for application " + appDeployInfo.getApplicationName() + ". ";
        Configuration appConfiguration = appDeployInfo.getAppConfiguration();
        Hashtable notChangedModules = null;
        WSClientArchiveLocationWrapper[] wsClientArchiveLocationWrappers = null;
        WSClientFileLocationWrapper[] wsClientFileLocationWrappers = null;
        Object[] notChangedWSClients = null;
        try {
            this.preprocess(applicationName, wsClientsDir, appConfiguration);
            notChangedModules = this.moduleUpdateProcessor.collectNotChangedModules(wsClientsModuleArchives, WSConfigurationHandler.loadWSClientsModuleCrcTable(appConfiguration));
            notChangedWSClients = this.moduleUpdateProcessor.collectNotChangedWSComponentsPerModules(notChangedModules.keySet(), wsClientsDir);
            File[] changedWSClientsModules = IOUtil.filterFiles(wsClientsModuleArchives, notChangedModules.keySet());
            wsClientArchiveLocationWrappers = this.wsClientsFactory.loadWSClientArchiveLocationWrappers(applicationName, changedWSClientsModules);
            wsClientFileLocationWrappers = this.loadWSClientFileLocationWrappers(applicationName, new File(wsClientsDir).listFiles());
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        WSClientsUpdateResult wsClientsUpdateResult = this.updateWSClients(wsClientsDir, wsClientsWorkingDir, appDeployInfo, wsClientArchiveLocationWrappers, wsClientFileLocationWrappers, WSUtil.collectSet(notChangedWSClients));
        if (wsClientsUpdateResult.getDeployedComponentNames() == null || wsClientsUpdateResult.getDeployedComponentNames().length == 0) {
            this.removeWSClients(applicationName, appConfiguration);
            WSClientsAppUpdateResult wsClientsAppUpdateResult = new WSClientsAppUpdateResult();
            wsClientsAppUpdateResult.setWsClientsUpdateResult(wsClientsUpdateResult);
            wsClientsAppUpdateResult.setModuleUpdateResult(new ModuleUpdateResult());
            return wsClientsAppUpdateResult;
        }
        ModuleUpdateResult moduleUpdateResult = this.moduleUpdateProcessor.updateModuleFiles(applicationName, wsClientsDir, wsClientsModuleArchives, notChangedModules, appConfiguration, WSClientDirsHandler.getWSClientsConfigName("webservices_container"));
        WSClientsAppUpdateResult wsClientsAppUpdateResult = new WSClientsAppUpdateResult();
        wsClientsAppUpdateResult.setWsClientsUpdateResult(wsClientsUpdateResult);
        wsClientsAppUpdateResult.setModuleUpdateResult(moduleUpdateResult);
        return wsClientsAppUpdateResult;
    }

    private WSClientsUpdateResult updateWSClients(String wsClientsDir, String wsClientsWorkingDir, AppDeployInfo appDeployInfo, WSClientArchiveLocationWrapper[] wsClientArchiveLocationWrappers, WSClientFileLocationWrapper[] wsClientFileLocationWrappersAll, Set notChangedWSClients) throws WSDeploymentException {
        WSClientFileLocationWrapper[] wsClientFileLocationWrappersOld = this.filterWSClientFileLocationWrappers(wsClientFileLocationWrappersAll, notChangedWSClients, false);
        WSClientFileLocationWrapper[] notChangedWSClientFileLocationWrappers = this.filterWSClientFileLocationWrappers(wsClientFileLocationWrappersAll, notChangedWSClients, true);
        int maxIndex = WSUtil.getMaxPositiveInt(this.collectIndexSet(wsClientFileLocationWrappersAll));
        int[] freeIndexes = WSUtil.getIntArray(WSUtil.getMissedInts(this.collectIndexSet(wsClientFileLocationWrappersAll), 0, maxIndex));
        return this.updateWSClients(wsClientsDir, wsClientsWorkingDir, appDeployInfo, wsClientArchiveLocationWrappers, wsClientFileLocationWrappersOld, notChangedWSClientFileLocationWrappers, maxIndex, freeIndexes);
    }

    private WSClientsUpdateResult updateWSClients(String wsClientsDir, String wsClientsWorkingDir, AppDeployInfo appDeployInfo, WSClientArchiveLocationWrapper[] wsClientArchiveLocationWrappersNew, WSClientFileLocationWrapper[] wsClientFileLocationWrappersOld, WSClientFileLocationWrapper[] wsClientFileLocationWrappersNotChanged, int maxIndex, int[] freeIndexes) throws WSDeploymentException {
        String excMsg = "Error occured, trying to update ws clients for application " + appDeployInfo.getApplicationName() + ". ";
        Configuration appConfiguration = appDeployInfo.getAppConfiguration();
        WSClientsUpdateResult wsClientsUpdateResultNotChanged = this.defineWSClientsUpdateResult(wsClientFileLocationWrappersNotChanged);
        if (!(wsClientArchiveLocationWrappersNew != null && wsClientArchiveLocationWrappersNew.length != 0 || wsClientFileLocationWrappersOld != null && wsClientFileLocationWrappersOld.length != 0)) {
            return wsClientsUpdateResultNotChanged;
        }
        String[] wsClientNamesNotChanged = this.collectWSClientNames(wsClientFileLocationWrappersNotChanged);
        WSClientsUpdateInfo wsClientsUpdateInfo = this.collectWSClientsUpdateInfo(wsClientArchiveLocationWrappersNew, wsClientFileLocationWrappersOld);
        WSClientsUpdateResult wsClientsUpdateResultChanged = this.updateWSClients(wsClientsDir, wsClientsWorkingDir, appDeployInfo, wsClientsUpdateInfo, appConfiguration, wsClientNamesNotChanged, maxIndex, freeIndexes);
        WSClientsUpdateResult wsClientsUpdateResultFinal = new WSClientsUpdateResult();
        wsClientsUpdateResultFinal.addWSClientsUpdateResult(wsClientsUpdateResultNotChanged);
        wsClientsUpdateResultFinal.addWSClientsUpdateResult(wsClientsUpdateResultChanged);
        String deployedComponentsPerModuleParentdir = ModuleDirsHandler.getDeployedComponentsPerModuleParentDir(wsClientsDir);
        String deployedComponentsPerModuleFileName = ModuleDirsHandler.getDeployedComponestPerModuleFileName();
        try {
            this.moduleFileStorageHandler.saveDeployedComponentsPerModule(wsClientsDir, wsClientsUpdateResultFinal.getDeployedWSPerModule());
            WSConfigurationHandler.uploadFile(deployedComponentsPerModuleParentdir, deployedComponentsPerModuleFileName, appConfiguration, WSClientDirsHandler.getWSClientsConfigName("webservices_container") + "/" + ModuleDirsHandler.getAppJarsRelDir());
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to save and/or upload " + ModuleDirsHandler.getDeployedComponestPerModuleFileName() + ". ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsClientsUpdateResultFinal;
    }

    private WSClientsUpdateResult updateWSClients(String wsClientsDir, String wsClientsWorkingDir, AppDeployInfo appDeployInfo, WSClientsUpdateInfo wsClientsUpdateInfo, Configuration appConfiguration, String[] wsClientNamesNotChanged, int maxIndex, int[] freeIndexes) throws WSDeploymentException {
        String excMsg = "Error occured, trying to update ws clients for application " + appDeployInfo.getApplicationName() + ". ";
        WSClientsDeployResult wsClientsDeployResult = null;
        WSClientsUpdateResult wsClientsUpdateResult = null;
        try {
            WSClientFileLocationWrapper[] wsClientForDeleteFileLocationWrappers = wsClientsUpdateInfo.getWsClientForDeleteFileLocationWrappers();
            this.deleteWSClients(wsClientForDeleteFileLocationWrappers, appConfiguration);
            wsClientsUpdateResult = this.updateWSClients(wsClientsDir, wsClientsWorkingDir, appDeployInfo, wsClientsUpdateInfo.getWsClientForUpdateArchiveLocationWrappers(), wsClientsUpdateInfo.getWsClientForUpdateFileLocationWrappers());
            int[] deletedIndexes = WSUtil.getIntArray(this.collectIndexSet(wsClientForDeleteFileLocationWrappers));
            int[] allFreeIndexes = WSUtil.unifyInts(new int[][]{freeIndexes, deletedIndexes});
            String[] wsClientNamesUpdated = this.collectWSClientNames(this.collectWsClientFileLocationWrappers(wsClientsUpdateInfo.getWsClientForUpdateFileLocationWrappers()));
            String[] additionalWSClientNames = WSUtil.unifyStrings(new String[][]{wsClientNamesNotChanged, wsClientNamesUpdated});
            wsClientsDeployResult = this.deployWSClients(wsClientsDir, wsClientsWorkingDir, appDeployInfo, wsClientsUpdateInfo.getWsClientForDeployArchiveLocationWrappers(), appConfiguration, additionalWSClientNames, maxIndex, allFreeIndexes);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        WSClientsUpdateResult wsClientsUpdateResultFinal = new WSClientsUpdateResult();
        wsClientsUpdateResultFinal.addWSClientsUpdateResult(wsClientsDeployResult);
        wsClientsUpdateResultFinal.addWSClientsUpdateResult(wsClientsUpdateResult);
        return wsClientsUpdateResultFinal;
    }

    private void deleteWSClients(WSClientFileLocationWrapper[] wsClientFileLocationWrappers, Configuration appConfiguration) throws WSDeploymentException {
        if (wsClientFileLocationWrappers == null) {
            return;
        }
        int i = 0;
        while (i < wsClientFileLocationWrappers.length) {
            this.deleteWSClient(wsClientFileLocationWrappers[i], appConfiguration);
            ++i;
        }
    }

    private void deleteWSClient(WSClientFileLocationWrapper wsClientFileLocationWrapper, Configuration appConfiguration) throws WSDeploymentException {
        WSClientDirsHandler wsClientDirsHandler = wsClientFileLocationWrapper.getWsClientDirsHandler();
        String wsClientDir = wsClientDirsHandler.getWsClientDirectory();
        String wsClientConfigName = wsClientDirsHandler.getWsClientConfigName();
        this.deleteWSClient(wsClientFileLocationWrapper.getApplicationName(), wsClientFileLocationWrapper.getWsClientName(), wsClientDir, wsClientConfigName, appConfiguration);
    }

    public void deleteWSClient(String applicationName, String wsClientName, String wsClientDir, String wsClientConfigName, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occured, trying to delete ws client " + wsClientName + ", application " + applicationName + ". ";
        boolean isWSClientDirDeleted = false;
        try {
            isWSClientDirDeleted = IOUtil.deleteDir(wsClientDir);
            WSConfigurationHandler.deleteWSClientConfiguration(appConfiguration, wsClientConfigName);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        if (!isWSClientDirDeleted) {
            String msg = excMsg + "Unable to clear ws client directory " + wsClientDir + " - this may cause problmes on ws client start or update phase. ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args);
        }
    }

    private WSClientsDeployResult deployWSClients(String wsClientsDir, String wsClientsWorkingDir, AppDeployInfo appDeployInfo, WSClientArchiveLocationWrapper[] wsClientArchiveLocationWrappers, Configuration appConfiguration, String[] additionalWSClientNames, int maxIndex, int[] freeIndexes) throws WSDeploymentException {
        String excMsg = "Error occured, trying to deploy ws clients for application " + appDeployInfo.getApplicationName() + ". ";
        boolean areDirsDeleted = false;
        try {
            areDirsDeleted = IOUtil.deleteDirs(new String[]{wsClientsWorkingDir});
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to clear web services directories. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
        if (!areDirsDeleted) {
            String msg = excMsg + "Unable to clear web services directories ( " + wsClientsWorkingDir + ") - this may cause problems on ws client start or update phase. ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args);
        }
        WSClientsDeployResult wsClientsDeployResult = null;
        try {
            wsClientsDeployResult = this.generateDeployFiles(wsClientsDir, wsClientsWorkingDir, appDeployInfo, wsClientArchiveLocationWrappers, additionalWSClientNames, freeIndexes, maxIndex);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to make web services configurations. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
        try {
            WSConfigurationHandler.makeWSClientConfigurations(this.collectWSClientDirs(wsClientsDeployResult.getWsClientRuntimeInfoes()), appConfiguration);
        }
        catch (WSConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)((Object)e));
            String msg = excMsg + "Unable to make web services configurations. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)((Object)e));
        }
        return wsClientsDeployResult;
    }

    private WSClientsDeployResult generateDeployFiles(String wsClientsDir, String wsClientsWorkingDir, AppDeployInfo appDeployInfo, WSClientArchiveLocationWrapper[] wsForDeployArchiveLocationWrappers, String[] webServiceNamesUpdated, int[] freeIndexes, int maxIndex) throws WSDeploymentException {
        WSClientDeploymentInfo[] wsClientDeploymentInfoes = this.wsClientsFactory.loadWSClientDeploymentInfoes(appDeployInfo.getApplicationName(), wsClientsDir, wsClientsWorkingDir, wsForDeployArchiveLocationWrappers);
        return this.wsClientsDeployGenerator.generateWSClientsDeployFiles(wsClientsDir, wsClientsWorkingDir, appDeployInfo, wsClientDeploymentInfoes, webServiceNamesUpdated, maxIndex, freeIndexes);
    }

    private void preprocess(String applicationName, String wsClientsDir, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occured, trying to collect web services location information for application " + applicationName + ". ";
        try {
            if (!WSConfigurationHandler.existsWSClientsConfiguration(appConfiguration)) {
                return;
            }
            WSConfigurationHandler.downloadWSClientsBaseConfiguration(wsClientsDir, appConfiguration);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    public WSClientFileLocationWrapper[] loadWSClientFileLocationWrappers(String applicationName, File[] wsClientDirs) throws WSDeploymentException {
        if (wsClientDirs == null) {
            return new WSClientFileLocationWrapper[0];
        }
        Vector<WSClientFileLocationWrapper> wsClientFileLocationWrappers = new Vector<WSClientFileLocationWrapper>();
        int i = 0;
        while (i < wsClientDirs.length) {
            File wsClientDir = wsClientDirs[i];
            if (!wsClientDir.getName().equals("app_jars")) {
                wsClientFileLocationWrappers.add(this.wsClientsFactory.loadWSClientFileLocationWrapper(applicationName, wsClientDir.getAbsolutePath()));
            }
            ++i;
        }
        Object[] wsClientFileLocationWrappersArr = new WSClientFileLocationWrapper[wsClientFileLocationWrappers.size()];
        wsClientFileLocationWrappers.copyInto(wsClientFileLocationWrappersArr);
        return wsClientFileLocationWrappersArr;
    }

    private WSClientsUpdateResult updateWSClients(String wsClientsDir, String wsClientsWorkingDir, AppDeployInfo appDeployInfo, Hashtable wsClientForUpdateArchiveLocationWrappers, Hashtable wsClientForUpdateFileLocationWrappers) throws WSDeploymentException {
        String excMsg = "Error occured, trying to update ws clients for application " + appDeployInfo.getApplicationName() + ". ";
        WSClientsDeployResult wsClientsDeployResult = null;
        try {
            wsClientsDeployResult = this.updateSingleWSClient(wsClientsDir, wsClientsWorkingDir, appDeployInfo, wsClientForUpdateArchiveLocationWrappers, wsClientForUpdateFileLocationWrappers);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        WSClientsUpdateResult wsClientsUpdateResult = new WSClientsUpdateResult();
        wsClientsUpdateResult.addWSClientsUpdateResult(wsClientsDeployResult);
        return wsClientsUpdateResult;
    }

    private WSClientsDeployResult updateSingleWSClient(String wsClientsDir, String wsClientsWorkingDir, AppDeployInfo appDeployInfo, Hashtable wsClientArchiveLocationWrappers, Hashtable wsClientFileLocationWrappers) throws WSDeploymentException {
        if (wsClientArchiveLocationWrappers == null || wsClientFileLocationWrappers == null) {
            return new WSClientsDeployResult();
        }
        WSClientDeploymentInfo[] wsClientDeploymentInfoes = new WSClientDeploymentInfo[wsClientArchiveLocationWrappers.size()];
        Enumeration enumeration = wsClientArchiveLocationWrappers.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            String wsClientName = (String)enumeration.nextElement();
            WSClientArchiveLocationWrapper wsClientArchiveLocationWrapper = (WSClientArchiveLocationWrapper)wsClientArchiveLocationWrappers.get(wsClientName);
            WSClientFileLocationWrapper wsClientFileLocationWrapper = (WSClientFileLocationWrapper)wsClientFileLocationWrappers.get(wsClientName);
            wsClientDeploymentInfoes[i++] = this.updateSingleWSClient(wsClientsDir, wsClientsWorkingDir, appDeployInfo, wsClientArchiveLocationWrapper, wsClientFileLocationWrapper);
        }
        return this.wsClientsDeployGenerator.defineWsClientsDeployResult(wsClientDeploymentInfoes);
    }

    private WSClientDeploymentInfo updateSingleWSClient(String wsClientsDir, String wsClientsWorkingDir, AppDeployInfo appDeployInfo, WSClientArchiveLocationWrapper wsClientArchiveLocationWrapper, WSClientFileLocationWrapper wsClientFileLocationWrapper) throws WSDeploymentException {
        String applicationName = wsClientFileLocationWrapper.getApplicationName();
        String excMsg = "Error occured trying to update ws client " + wsClientFileLocationWrapper.getWsClientName() + ", application " + applicationName + ". ";
        Configuration appConfiguration = appDeployInfo.getAppConfiguration();
        WSClientDeploymentInfo wsClientDeploymentInfo = null;
        try {
            this.deleteWSClient(wsClientFileLocationWrapper, appConfiguration);
            wsClientDeploymentInfo = this.wsClientsFactory.loadWSClientDeploymentInfoes(applicationName, wsClientsDir, wsClientsWorkingDir, wsClientArchiveLocationWrapper)[0];
            int index = wsClientFileLocationWrapper.getWsClientDirsHandler().getIndex();
            if (index != -1) {
                this.wsClientsDeployGenerator.generateWSClientsDeployFiles(wsClientsDir, wsClientsWorkingDir, appDeployInfo, new WSClientDeploymentInfo[]{wsClientDeploymentInfo}, new String[0], -1, new int[]{index});
            } else {
                this.wsClientsDeployGenerator.generateWSClientsDeployFiles630(wsClientsDir, wsClientsWorkingDir, appDeployInfo, new WSClientDeploymentInfo[]{wsClientDeploymentInfo}, new String[0]);
            }
            WSConfigurationHandler.makeWSClientConfigurations(new String[]{wsClientFileLocationWrapper.getWsClientDirsHandler().getWsClientDirectory()}, appConfiguration);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsClientDeploymentInfo;
    }

    public WSClientsUpdateInfo collectWSClientsUpdateInfo(WSClientArchiveLocationWrapper[] wsClientArchiveLocationWrappersNew, WSClientFileLocationWrapper[] wsClientFileLocationWrappersOld) {
        return this.collectWSClientsUpdateInfo(this.collectWSClientLocationWrappersTable(wsClientArchiveLocationWrappersNew), this.collectWSClientLocationWrappersTable(wsClientFileLocationWrappersOld));
    }

    public WSClientsUpdateInfo collectWSClientsUpdateInfo(Hashtable wsClientArchiveLocationWrappersNew, Hashtable wsClientFileLocationWrappersOld) {
        Hashtable wsClientForDeployArchiveLocationWrappers = WSUtil.makeSubtraction(wsClientArchiveLocationWrappersNew, wsClientFileLocationWrappersOld);
        Hashtable wsClientForDeleteFileLocationWrappers = WSUtil.makeSubtraction(wsClientFileLocationWrappersOld, wsClientArchiveLocationWrappersNew);
        Hashtable wsClientForUpdateArchiveLocationWrappers = WSUtil.makeIntersection(wsClientArchiveLocationWrappersNew, wsClientFileLocationWrappersOld);
        Hashtable wsClientForUpdateFileLocationWrappers = WSUtil.makeIntersection(wsClientFileLocationWrappersOld, wsClientArchiveLocationWrappersNew);
        WSClientsUpdateInfo wsClientsUpdateInfo = new WSClientsUpdateInfo();
        wsClientsUpdateInfo.setWsClientForDeployArchiveLocationWrappers(this.collectWsClientArchiveLocationWrappers(wsClientForDeployArchiveLocationWrappers));
        wsClientsUpdateInfo.setWsClientForDeleteFileLocationWrappers(this.collectWsClientFileLocationWrappers(wsClientForDeleteFileLocationWrappers));
        wsClientsUpdateInfo.setWsClientForUpdateArchiveLocationWrappers(wsClientForUpdateArchiveLocationWrappers);
        wsClientsUpdateInfo.setWsClientForUpdateFileLocationWrappers(wsClientForUpdateFileLocationWrappers);
        return wsClientsUpdateInfo;
    }

    private Hashtable collectWSClientLocationWrappersTable(WSClientLocationWrapper[] wsClientLocationWrappers) {
        if (wsClientLocationWrappers == null) {
            return new Hashtable();
        }
        Hashtable<String, WSClientLocationWrapper> wsClientLocationWrappersTable = new Hashtable<String, WSClientLocationWrapper>();
        int i = 0;
        while (i < wsClientLocationWrappers.length) {
            WSClientLocationWrapper wsClientLocationWrapper = wsClientLocationWrappers[i];
            wsClientLocationWrappersTable.put(wsClientLocationWrapper.getWsClientName(), wsClientLocationWrapper);
            ++i;
        }
        return wsClientLocationWrappersTable;
    }

    private WSClientArchiveLocationWrapper[] collectWsClientArchiveLocationWrappers(Hashtable wsClientArchiveLocationWrappersTable) {
        if (wsClientArchiveLocationWrappersTable == null) {
            return new WSClientArchiveLocationWrapper[0];
        }
        WSClientArchiveLocationWrapper[] wsClientArchiveLocationWrappers = new WSClientArchiveLocationWrapper[wsClientArchiveLocationWrappersTable.size()];
        Enumeration enumeration = wsClientArchiveLocationWrappersTable.elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            wsClientArchiveLocationWrappers[i++] = (WSClientArchiveLocationWrapper)enumeration.nextElement();
        }
        return wsClientArchiveLocationWrappers;
    }

    private WSClientFileLocationWrapper[] collectWsClientFileLocationWrappers(Hashtable wsClientFileLocationWrappersTable) {
        if (wsClientFileLocationWrappersTable == null) {
            return new WSClientFileLocationWrapper[0];
        }
        WSClientFileLocationWrapper[] wsClientFileLocationWrappers = new WSClientFileLocationWrapper[wsClientFileLocationWrappersTable.size()];
        Enumeration enumeration = wsClientFileLocationWrappersTable.elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            wsClientFileLocationWrappers[i++] = (WSClientFileLocationWrapper)enumeration.nextElement();
        }
        return wsClientFileLocationWrappers;
    }

    private Set collectIndexSet(WSClientFileLocationWrapper[] wsClientFileLocationWrappers) {
        if (wsClientFileLocationWrappers == null) {
            return new HashSet();
        }
        HashSet<Integer> indexSet = new HashSet<Integer>();
        int i = 0;
        while (i < wsClientFileLocationWrappers.length) {
            int index = wsClientFileLocationWrappers[i].getWsClientDirsHandler().getIndex();
            if (index != -1) {
                indexSet.add(new Integer(index));
            }
            ++i;
        }
        return indexSet;
    }

    private String[] collectWSClientDirs(WSClientRuntimeInfo[] wsClientRuntimeInfoes) {
        if (wsClientRuntimeInfoes == null) {
            return new String[0];
        }
        String[] wsClientDirs = new String[wsClientRuntimeInfoes.length];
        int i = 0;
        while (i < wsClientRuntimeInfoes.length) {
            wsClientDirs[i] = wsClientRuntimeInfoes[i].getWsClientDirsHandler().getWsClientDirectory();
            ++i;
        }
        return wsClientDirs;
    }

    private String[] collectWSClientNames(WSClientFileLocationWrapper[] wsClientFileLocationWrappers) {
        if (wsClientFileLocationWrappers == null) {
            return new String[0];
        }
        String[] wsClientNames = new String[wsClientFileLocationWrappers.length];
        int i = 0;
        while (i < wsClientFileLocationWrappers.length) {
            wsClientNames[i] = wsClientFileLocationWrappers[i].getWsClientName();
            ++i;
        }
        return wsClientNames;
    }

    private WSClientsUpdateResult defineWSClientsUpdateResult(WSClientFileLocationWrapper[] wsClientFileLocationWrappers) {
        if (wsClientFileLocationWrappers == null) {
            return new WSClientsUpdateResult();
        }
        WSClientsUpdateResult wsClientsUpdateResult = new WSClientsUpdateResult();
        wsClientsUpdateResult.setDeployedComponentNames(this.wsClientsDeployGenerator.constructDeployedWSClientNames(this.collectWSClientNames(wsClientFileLocationWrappers)));
        wsClientsUpdateResult.setFilesForClassLoader(this.getWSClientFilesForClassLoader(wsClientFileLocationWrappers));
        wsClientsUpdateResult.setWsClientFileLocationWrappers(wsClientFileLocationWrappers);
        wsClientsUpdateResult.setDeployedWSPerModule(this.collectDeployedWSClientNamesPerModule(this.collectWSClientFileLocationWrappersPerModule(wsClientFileLocationWrappers)));
        return wsClientsUpdateResult;
    }

    public String[] getWSClientFilesForClassLoader(WSClientFileLocationWrapper[] wsClientFileLocationWrappers) {
        if (wsClientFileLocationWrappers == null) {
            return new String[0];
        }
        String[] wsClientFilesForClassLoader = new String[wsClientFileLocationWrappers.length];
        int i = 0;
        while (i < wsClientFileLocationWrappers.length) {
            wsClientFilesForClassLoader[i] = wsClientFileLocationWrappers[i].getWsClientDirsHandler().getJarPath();
            ++i;
        }
        return wsClientFilesForClassLoader;
    }

    private Hashtable collectWSClientFileLocationWrappersPerModule(WSClientFileLocationWrapper[] wsClientFileLocationWrappers) {
        String moduleName;
        if (wsClientFileLocationWrappers == null) {
            return new Hashtable();
        }
        Hashtable<String, Object> wsClientsPerModuleTable = new Hashtable<String, Object>();
        int i = 0;
        while (i < wsClientFileLocationWrappers.length) {
            Vector deployedComponentsPerSingleModule;
            WSClientFileLocationWrapper wsClientFileLocationWrapper = wsClientFileLocationWrappers[i];
            moduleName = wsClientFileLocationWrapper.getModuleName();
            if (wsClientsPerModuleTable.containsKey(moduleName)) {
                deployedComponentsPerSingleModule = (Vector)wsClientsPerModuleTable.get(moduleName);
                deployedComponentsPerSingleModule.add(wsClientFileLocationWrapper);
            } else {
                deployedComponentsPerSingleModule = new Vector();
                deployedComponentsPerSingleModule.add(wsClientFileLocationWrapper);
                wsClientsPerModuleTable.put(moduleName, deployedComponentsPerSingleModule);
            }
            ++i;
        }
        Enumeration enumeration = wsClientsPerModuleTable.keys();
        while (enumeration.hasMoreElements()) {
            moduleName = (String)enumeration.nextElement();
            Vector wsPerModule = (Vector)wsClientsPerModuleTable.get(moduleName);
            Object[] wsPerModuleArr = new WSClientFileLocationWrapper[wsPerModule.size()];
            wsPerModule.copyInto(wsPerModuleArr);
            wsClientsPerModuleTable.put(moduleName, wsPerModuleArr);
        }
        return wsClientsPerModuleTable;
    }

    public Properties collectDeployedWSClientNamesPerModule(Hashtable wsClientFileLocationWrappersPerModule) {
        String delimiter = ";";
        if (wsClientFileLocationWrappersPerModule == null) {
            return new Properties();
        }
        Enumeration enumeration = wsClientFileLocationWrappersPerModule.keys();
        Properties deployedWSNamesPerModule = new Properties();
        while (enumeration.hasMoreElements()) {
            String moduleName = (String)enumeration.nextElement();
            WSClientFileLocationWrapper[] wsClientFileLocationWrappersPerSingeModule = (WSClientFileLocationWrapper[])wsClientFileLocationWrappersPerModule.get(moduleName);
            deployedWSNamesPerModule.setProperty(moduleName, WSUtil.concatStrings(this.collectWSClientNames(wsClientFileLocationWrappersPerSingeModule), delimiter));
        }
        return deployedWSNamesPerModule;
    }

    private WSClientFileLocationWrapper[] filterWSClientFileLocationWrappers(WSClientFileLocationWrapper[] wsClientFileLocationWrappers, Set wsClientNamesFilterList, boolean includeFlag) {
        if (wsClientFileLocationWrappers == null) {
            return new WSClientFileLocationWrapper[0];
        }
        Vector<WSClientFileLocationWrapper> wsClientFileLocationWrappersFiltered = new Vector<WSClientFileLocationWrapper>();
        int i = 0;
        while (i < wsClientFileLocationWrappers.length) {
            WSClientFileLocationWrapper wsClientFileLocationWrapper = wsClientFileLocationWrappers[i];
            if (includeFlag) {
                if (wsClientNamesFilterList.contains(wsClientFileLocationWrapper.getWsClientName())) {
                    wsClientFileLocationWrappersFiltered.add(wsClientFileLocationWrapper);
                }
            } else if (!wsClientNamesFilterList.contains(wsClientFileLocationWrapper.getWsClientName())) {
                wsClientFileLocationWrappersFiltered.add(wsClientFileLocationWrapper);
            }
            ++i;
        }
        Object[] wsClientFileLocationWrappersFilteredArr = new WSClientFileLocationWrapper[wsClientFileLocationWrappersFiltered.size()];
        wsClientFileLocationWrappersFiltered.copyInto(wsClientFileLocationWrappersFilteredArr);
        return wsClientFileLocationWrappersFilteredArr;
    }

    private void removeWSClients(String applicationName, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occured, trying to remove ws clients for application " + applicationName + ". ";
        try {
            if (WSConfigurationHandler.existsSubConfiguration(appConfiguration, WSClientDirsHandler.getWSClientsConfigName("webservices_container"))) {
                WSConfigurationHandler.deleteConfiguration(appConfiguration, WSClientDirsHandler.getWSClientsConfigName("webservices_container"), "/");
            }
            String wsContainerDir = WSContainer.getWSDeployer().getWSContainerDir(applicationName, 0);
            IOUtil.deleteDir(WSClientDirsHandler.getWSClientsDir(wsContainerDir));
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + " Unable to delete " + WSDirsHandler.getWebServicesConfigName("webservices_container") + " configuration. ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }
}

