/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.wsclient.update;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.webservices.exceptions.WSConfigurationException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientRuntimeInfo;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.WSConfigurationHandler;
import com.sap.engine.services.webservices.server.deploy.common.AppDeployInfo;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDeployGenerator;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDirsHandler;
import com.sap.engine.services.webservices.server.deploy.common.ModuleFileStorageHandler;
import com.sap.engine.services.webservices.server.deploy.common.update.ModuleUpdateProcessor;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientDirsHandler;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientProtocolNotificator;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsDeployGenerator;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsDeployManager;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsFactory;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsRuntimeActivator;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsUtil;
import com.sap.engine.services.webservices.server.deploy.wsclient.update.WSClientFileLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.wsclient.update.WSClientsAppUpdateResult;
import com.sap.engine.services.webservices.server.deploy.wsclient.update.WSClientsUpdateProcessor;
import com.sap.engine.services.webservices.server.deploy.wsclient.update.WSClientsUpdateResult;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;

public class WSClientsUpdateManager {
    private WSClientsDeployManager wsClientsDeployManager = null;
    private WSClientsUpdateProcessor wsClientsUpdateProcessor = null;

    public WSClientsUpdateManager(WSClientsDeployManager wsClientsDeployManager, WSClientsDeployGenerator wsClientsDeployGenerator, ModuleDeployGenerator moduleDeployGenerator, ModuleFileStorageHandler moduleFileStorageHandler) {
        this.wsClientsDeployManager = wsClientsDeployManager;
        this.wsClientsUpdateProcessor = new WSClientsUpdateProcessor(wsClientsDeployGenerator, new ModuleUpdateProcessor(moduleDeployGenerator, moduleFileStorageHandler), moduleFileStorageHandler);
    }

    public WSClientsAppUpdateResult makeUpdate(String wsClientsDir, String wsClientsWorkingDir, File[] moduleArchives, AppDeployInfo appDeployInfo) throws DeploymentException {
        String applicationName = appDeployInfo.getApplicationName();
        WSClientsAppUpdateResult wsClientsAppUpdateResult = this.wsClientsUpdateProcessor.updateWSClients(applicationName, wsClientsDir, wsClientsWorkingDir, appDeployInfo, this.wsClientsDeployManager.collectWSClientsModuleArchives(moduleArchives));
        WSClientsUpdateResult wsClientsUpdateResult = wsClientsAppUpdateResult.getWsClientsUpdateResult();
        try {
            if (wsClientsUpdateResult.getDeployedComponentNames() != null && wsClientsUpdateResult.getDeployedComponentNames().length != 0) {
                this.notifyProtocolsOnUpdate(applicationName, wsClientsUpdateResult.getWsClientFileLocationWrappers(), wsClientsUpdateResult.getWsClientRuntimeInfoes(), appDeployInfo.getAppConfiguration());
            }
        }
        catch (WSWarningException e) {
            wsClientsAppUpdateResult.addWarnings(e.getWarningsVector());
        }
        return wsClientsAppUpdateResult;
    }

    public void notifyUpdatedComponents(String applicationName) throws WarningException {
        this.wsClientsDeployManager.removeWSClientsDir(applicationName);
    }

    public void prepareUpdate(String applicationName) throws DeploymentException, WarningException {
        ClassLoader appLoader = WSContainer.getServiceContext().getCoreContext().getLoadContext().getClassLoader(applicationName);
        this.notifyProtocolsOnPostUpdate(applicationName, appLoader);
    }

    public ApplicationDeployInfo commitUpdate(String applicationName) throws WarningException {
        this.notifyProtocolsOnCommitUpdate(applicationName);
        return null;
    }

    public void rollbackUpdate(String applicationName, Configuration appConfiguration, Properties props) throws WarningException {
        ClassLoader appLoader = WSContainer.getServiceContext().getCoreContext().getLoadContext().getClassLoader(applicationName);
        Vector warnings = new Vector();
        try {
            this.wsClientsDeployManager.removeWSClientsDir(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.notifyProtocolsOnRollbackUpdate(applicationName, appConfiguration, appLoader);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void notifyProtocolsOnUpdate(String applicationName, WSClientFileLocationWrapper[] wsClientFileLocationWrappers, WSClientRuntimeInfo[] wsClientRuntimeInfoes, Configuration appConfiguration) throws WSWarningException {
        String excMsg = "Error occured, trying to notify protocols on " + WSClientProtocolNotificator.getModeName(10) + " phase, application " + applicationName + ". ";
        WSClientRuntimeInfo[] notChangedWSClientRuntimeInfoes = null;
        try {
            notChangedWSClientRuntimeInfoes = this.loadWSClients(wsClientFileLocationWrappers, appConfiguration);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            WSWarningException wExc = new WSWarningException();
            String msg = excMsg + e.getLocalizedMessage() + ". ";
            wExc.addWarning(msg);
            throw wExc;
        }
        WSClientRuntimeInfo[] allWSClientRuntimeInfoes = WSClientsUtil.unifyWSClientRuntimeInfoes(new WSClientRuntimeInfo[][]{notChangedWSClientRuntimeInfoes, wsClientRuntimeInfoes});
        this.notifyProtocolsOnUpdate(applicationName, allWSClientRuntimeInfoes, appConfiguration);
    }

    private WSClientRuntimeInfo[] loadWSClients(WSClientFileLocationWrapper[] wsClientFileLocationWrappers, Configuration appConfiguration) throws WSDeploymentException {
        if (wsClientFileLocationWrappers == null) {
            return new WSClientRuntimeInfo[0];
        }
        WSClientRuntimeInfo[] wsClientRuntimeInfoes = new WSClientRuntimeInfo[wsClientFileLocationWrappers.length];
        int i = 0;
        while (i < wsClientFileLocationWrappers.length) {
            wsClientRuntimeInfoes[i] = this.loadWSClient(wsClientFileLocationWrappers[i], appConfiguration);
            ++i;
        }
        return wsClientRuntimeInfoes;
    }

    private WSClientRuntimeInfo loadWSClient(WSClientFileLocationWrapper wsClientFileLocationWrapper, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occured, trying to load ws client " + wsClientFileLocationWrapper.getWsClientName() + ", application " + wsClientFileLocationWrapper.getApplicationName() + ". ";
        String wsClientDir = wsClientFileLocationWrapper.getWsClientDirsHandler().getWsClientDirectory();
        try {
            WSClientDirsHandler wsClientDirsHandler = wsClientFileLocationWrapper.getWsClientDirsHandler();
            WSConfigurationHandler.downloadConfiguration(wsClientDirsHandler.getDescriptorsDir(), wsClientDirsHandler.getWsClientConfigPath("webservices_container") + '/' + wsClientDirsHandler.getDescriptorsRelDir(), appConfiguration, new HashSet());
        }
        catch (WSConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)((Object)e));
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)((Object)e));
        }
        return new WSClientsFactory().loadWSClientRuntimeInfo(wsClientDir);
    }

    private void notifyProtocolsOnUpdate(String applicationName, WSClientRuntimeInfo[] wsClientRuntimeInfoes, Configuration appConfiguration) throws WSWarningException {
        String excMsg = "Error occured, trying to notify protocols on " + WSClientProtocolNotificator.getModeName(10) + " phase, application " + applicationName + ". ";
        Vector warnings = new Vector();
        try {
            this.wsClientsDeployManager.notifyProtocolsOnRemove(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
        }
        try {
            this.wsClientsDeployManager.notifyProtocolsOnDeploy(applicationName, wsClientRuntimeInfoes, appConfiguration);
        }
        catch (WSWarningException e) {
            warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void notifyProtocolsOnPostUpdate(String applicationName, ClassLoader appLoader) throws WSWarningException {
        String excMsg = "Error occured, trying to notify protocols on " + WSClientProtocolNotificator.getModeName(11) + " phase, applicationName " + applicationName + ". ";
        Vector warnings = new Vector();
        try {
            this.wsClientsDeployManager.notifyProtocolsOnPostDeploy(applicationName, appLoader);
        }
        catch (WSWarningException e) {
            warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void notifyProtocolsOnCommitUpdate(String applicationName) throws WSWarningException {
        String excMsg = "Error occured, trying to notify protocols on " + WSClientProtocolNotificator.getModeName(12) + " phase, applicationName " + applicationName + ". ";
        Vector warnings = new Vector();
        try {
            this.wsClientsDeployManager.notifyProtocolsOnCommitDeploy(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void notifyProtocolsOnRollbackUpdate(String applicationName, Configuration appConfiguration, ClassLoader appLoader) throws WSWarningException {
        String excMsg = "Error occured, trying to notify protocols on rollback update for application " + applicationName + ". ";
        Vector warnings = new Vector();
        try {
            this.wsClientsDeployManager.notifyProtocolsOnRollback(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
        }
        String wsClientsDir = null;
        try {
            String wsContainerDir = WSContainer.getWSDeployer().getWSContainerDir(applicationName, 0);
            wsClientsDir = WSClientDirsHandler.getWSClientsDir(wsContainerDir);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            String msg = excMsg + "Unable to get " + "wsClients" + " directory. ";
            WSWarningException wExc = new WSWarningException();
            wExc.addWarnings(warnings);
            wExc.addWarning(msg);
            throw wExc;
        }
        try {
            new WSClientsRuntimeActivator().downloadWSClientsFiles(applicationName, appConfiguration);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            String msg = excMsg + e.getLocalizedMessage();
            WSWarningException wExc = new WSWarningException();
            wExc.addWarnings(warnings);
            wExc.addWarning(msg);
            throw wExc;
        }
        WSClientRuntimeInfo[] wsClientRuntimeInfoes = null;
        try {
            wsClientRuntimeInfoes = this.loadWSClients(applicationName, wsClientsDir);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            String msg = excMsg + e.getLocalizedMessage();
            WSWarningException wExc = new WSWarningException();
            wExc.addWarnings(warnings);
            wExc.addWarning(msg);
            throw wExc;
        }
        try {
            this.wsClientsDeployManager.notifyProtocolsOnDeploy(applicationName, wsClientRuntimeInfoes, appConfiguration);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.wsClientsDeployManager.notifyProtocolsOnPostDeploy(applicationName, appLoader);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.wsClientsDeployManager.notifyProtocolsOnCommitDeploy(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private WSClientRuntimeInfo[] loadWSClients(String applicationName, String wsClientsDir) throws WSDeploymentException {
        String excMsg;
        String warningMsg = excMsg = "Error occured trying to load ws clients for application " + applicationName + ". ";
        if (!new File(wsClientsDir).exists()) {
            return new WSClientRuntimeInfo[0];
        }
        File[] wsClientOwnDirs = new File(wsClientsDir).listFiles();
        Vector<WSClientRuntimeInfo> wsClientRuntimeInfoes = new Vector<WSClientRuntimeInfo>();
        int i = 0;
        while (i < wsClientOwnDirs.length) {
            String wsClientOwnDir = null;
            try {
                wsClientOwnDir = wsClientOwnDirs[i].getAbsolutePath();
                if (!wsClientOwnDir.endsWith(ModuleDirsHandler.getAppJarsRelDir())) {
                    WSClientRuntimeInfo wsClientRuntimeInfo = new WSClientsFactory().loadWSClientRuntimeInfo(wsClientOwnDir);
                    wsClientRuntimeInfoes.add(wsClientRuntimeInfo);
                }
            }
            catch (WSDeploymentException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                String msg = warningMsg + "Unable to load ws client with own directory " + wsClientOwnDir + ". ";
                Object[] args = new String[]{msg, "none"};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            ++i;
        }
        Object[] wsClientRuntimeInfoesArray = new WSClientRuntimeInfo[wsClientRuntimeInfoes.size()];
        wsClientRuntimeInfoes.copyInto(wsClientRuntimeInfoesArray);
        return wsClientRuntimeInfoesArray;
    }
}

