/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.wsclient;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.services.webservices.exceptions.WSConfigurationException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ServiceBaseServer;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientIdentifier;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientRuntimeInfo;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.WSConfigurationHandler;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDirsHandler;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.wsclient.ServiceFactory;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientDirsHandler;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientProtocolNotificator;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientRuntimetHelper;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsConstants;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsDeployContext;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsFactory;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.xml.rpc.Service;

public class WSClientsRuntimeActivator
implements WSClientsConstants {
    private Hashtable lcmContext = new Hashtable();
    private WSClientProtocolNotificator wsClientProtocolNotificator = new WSClientProtocolNotificator();

    public void downloadApplicationFiles(String applicationName, Configuration appConfiguration) throws WSDeploymentException, WSWarningException {
        Hashtable configsToDirsMapping = this.downloadWSClientsFiles(applicationName, appConfiguration);
        this.notifyProtocolsOnDownloadFiles(applicationName, this.getStrings(configsToDirsMapping.elements(), configsToDirsMapping.size()), this.getStrings(configsToDirsMapping.keys(), configsToDirsMapping.size()), appConfiguration);
    }

    public Hashtable downloadWSClientsFiles(String applicationName, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occurred, downloading ws client files for application: " + applicationName + ". ";
        try {
            if (!WSConfigurationHandler.existsSubConfiguration(appConfiguration, WSClientDirsHandler.getWSClientsConfigName("webservices_container"))) {
                return new Hashtable();
            }
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Error occurred, trying to get " + "webservices_container" + " DB configuration. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        String wsClientsDir = null;
        try {
            String wsContainerDir = WSContainer.getWSDeployer().getWSContainerDir(applicationName);
            wsClientsDir = WSClientDirsHandler.getWSClientsDir(wsContainerDir);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to get " + "webservices_container" + " directory. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        Hashtable configsToDirsMapping = null;
        try {
            configsToDirsMapping = WSConfigurationHandler.downloadWSClientsConfiguration(wsClientsDir, appConfiguration);
        }
        catch (WSConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)((Object)e));
            String msg = excMsg + "Error occurred, trying to download web services files. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)((Object)e));
        }
        return configsToDirsMapping;
    }

    public void startWSClients(String applicationName, String wsClientsDir, Configuration appConfiguration) throws WSDeploymentException, WSWarningException {
        File[] wsClientOwnDirs = new File(wsClientsDir).listFiles();
        Vector warnings = new Vector();
        try {
            this.startWSClients(applicationName, wsClientsDir, wsClientOwnDirs);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.notifyProtocolsOnStart(applicationName, appConfiguration);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings != null && warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void startWSClients(String applicationName, String wsClientsDir, File[] wsClientOwnDirs) throws WSWarningException {
        if (wsClientOwnDirs == null) {
            return;
        }
        Vector warnings = new Vector();
        int i = 0;
        while (i < wsClientOwnDirs.length) {
            String wsClientOwnDir = wsClientOwnDirs[i].getAbsolutePath();
            if (!wsClientOwnDir.endsWith(ModuleDirsHandler.getAppJarsRelDir())) {
                try {
                    this.startSingleWSClient(applicationName, wsClientsDir, wsClientOwnDir);
                }
                catch (WSWarningException e) {
                    warnings.addAll(e.getWarningsVector());
                }
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void commitStart(String applicatioName) throws WSWarningException {
        this.notifyProtocolsOnCommitStart(applicatioName);
    }

    public void rollbackStart(String applicationName) throws WSWarningException {
        Vector warnings = new Vector();
        try {
            this.notifyProtocolsOnRollbackStart(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.unregisterWSClients(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void startSingleWSClient(String applicationName, String wsClientsDir, String wsClientOwnDir) throws WSWarningException {
        String excMsg = "Error occured, trying to start ws client with own directory " + wsClientOwnDir + ", application  " + applicationName + ". ";
        WSClientRuntimeInfo wsClientRuntimeInfo = null;
        try {
            wsClientRuntimeInfo = new WSClientsFactory().loadWSClientRuntimeInfo(wsClientOwnDir);
            this.startSingleWSClient(wsClientsDir, wsClientRuntimeInfo);
        }
        catch (WSWarningException e) {
            throw e;
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            String msg = excMsg;
            if (wsClientRuntimeInfo != null) {
                msg = msg + "WS client " + wsClientRuntimeInfo.getWsClientId().getServiceRefName() + ". ";
            }
            try {
                if (wsClientRuntimeInfo != null) {
                    this.unregisterSingleWSClient(wsClientRuntimeInfo.getWsClientId());
                }
            }
            catch (Exception iExc) {
                wsDeployLocation.catching("Warning!, ", (Throwable)iExc);
                msg = msg + "The ws client has been unregistered with warnings: " + iExc.getLocalizedMessage();
            }
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
    }

    public void startSingleWSClient(String wsClientsDir, WSClientRuntimeInfo wsClientRuntimeInfo) throws WSDeploymentException, WSWarningException {
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String excMsg = "Error occurred, staring ws client " + wsClientId.getApplicationName() + ", application name " + wsClientId.getApplicationName() + ". ";
        Vector<String> warnings = new Vector<String>();
        try {
            WSContainer.getWsClientRegistry().registerWSClient(wsClientId, wsClientRuntimeInfo);
            Service service = new ServiceFactory().getServiceInstance(wsClientRuntimeInfo);
            WSClientRuntimetHelper wsClientRuntimetHelper = new WSClientRuntimetHelper();
            wsClientRuntimetHelper.bindServiceInstance(wsClientId, service);
            wsClientRuntimetHelper.bindServiceInstanceLinkReference(wsClientRuntimeInfo);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(excMsg, (Throwable)e);
            Object[] args = new String[]{excMsg, wsClientId.getApplicationName(), wsClientId.getJarName(), wsClientId.getServiceRefName()};
            throw new WSDeploymentException("webservices_5042", args, (Throwable)e);
        }
        try {
            WSLogging.applyAndStoreWSClientConfiguration(wsClientId.getApplicationName(), wsClientId.getServiceRefName());
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            String msg = excMsg + "Unable to register log configuration. ";
            warnings.add(msg);
        }
        if (warnings != null && warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void stop(String applicationName) throws WSWarningException {
        Vector warnings = new Vector();
        try {
            this.notifyProtocolsOnStop(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.unregisterWSClients(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings != null && warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void notifyProtocolsOnDownloadFiles(String applicationName, String[] wsClientRelDirs, String[] wsClientConfigNames, Configuration appConfiguration) throws WSWarningException {
        String excMsg = "Unable to initialize web service protocols on " + WSClientProtocolNotificator.getModeName(5) + " mode. Application name " + applicationName + ". ";
        if (wsClientRelDirs == null || wsClientRelDirs.length == 0) {
            return;
        }
        String wsClientsDir = null;
        try {
            String wsContainerDir = WSContainer.getWSDeployer().getWSContainerDir(applicationName);
            wsClientsDir = WSClientDirsHandler.getWSClientsDir(wsContainerDir);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to get " + "webservices_container" + " directory. ";
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
        String[] wsClientDirs = IOUtil.getFilePaths(wsClientsDir, wsClientRelDirs);
        String[] wsClientNames = null;
        try {
            wsClientNames = this.getWSClientNames(wsClientDirs);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Error occurred, trying to extract web services names. ";
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
        this.wsClientProtocolNotificator.downloadFiles(applicationName, wsClientNames, wsClientDirs, wsClientConfigNames, appConfiguration);
    }

    private void notifyProtocolsOnStart(String applicationName, Configuration appConfiguration) throws WSWarningException {
        String excMsg = "Error occurred, trying to notify protocols on " + WSClientProtocolNotificator.getModeName(6) + " phase for application " + applicationName + ". ";
        WSClientRuntimeInfo[] wsClientRuntimeInfoes = WSContainer.getWsClientRegistry().getWSClientsByApplicationName(applicationName);
        Vector warnings = new Vector();
        Hashtable wsClientsToServicesMapping = this.lookUpServiceInstances(wsClientRuntimeInfoes, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        WSClientRuntimeInfo[] wsClientRuntimeInfoesForProcessing = this.getWSClients(wsClientsToServicesMapping);
        Service[] services = this.getServiceInstances(wsClientsToServicesMapping);
        WSClientsDeployContext context = new WSClientsDeployContext(applicationName, wsClientRuntimeInfoesForProcessing, services, appConfiguration);
        this.lcmContext.put(applicationName, context);
        try {
            this.wsClientProtocolNotificator.onStart(wsClientRuntimeInfoesForProcessing, (ServiceBaseServer[])services, appConfiguration);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void notifyProtocolsOnCommitStart(String applicationName) throws WSWarningException {
        this.notifyProtocolsOnShortPhases(applicationName, 7);
    }

    private void notifyProtocolsOnRollbackStart(String applicationName) throws WSWarningException {
        this.notifyProtocolsOnShortPhases(applicationName, 8);
    }

    private void notifyProtocolsOnStop(String applicationName) throws WSWarningException {
        String excMsg = "Error occurred, trying to notify protocols on " + WSClientProtocolNotificator.getModeName(9) + " phase for application " + applicationName + ". ";
        WSClientRuntimeInfo[] wsClientRuntimeInfoes = WSContainer.getWsClientRegistry().getWSClientsByApplicationName(applicationName);
        Hashtable wsClientsToServicesMapping = null;
        Vector warnings = new Vector();
        wsClientsToServicesMapping = this.lookUpServiceInstances(wsClientRuntimeInfoes, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        WSClientRuntimeInfo[] wsClientRuntimeInfoesForProcessing = this.getWSClients(wsClientsToServicesMapping);
        Service[] services = this.getServiceInstances(wsClientsToServicesMapping);
        try {
            this.wsClientProtocolNotificator.onStop(wsClientRuntimeInfoesForProcessing, (ServiceBaseServer[])services);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void notifyProtocolsOnShortPhases(String applicationName, int mode) throws WSWarningException {
        WSClientsDeployContext wsClientsDeployContext = (WSClientsDeployContext)this.lcmContext.remove(applicationName);
        if (wsClientsDeployContext == null) {
            return;
        }
        switch (mode) {
            case 7: {
                this.wsClientProtocolNotificator.onCommitStart(wsClientsDeployContext.getWsClientRuntimeInfos(), (ServiceBaseServer[])wsClientsDeployContext.getServices());
                break;
            }
            case 8: {
                String[] wsClientNames = this.getWSClientNames(wsClientsDeployContext.getWsClientRuntimeInfos());
                String[][] protocolIds = new String[][]{};
                ServiceBaseServer[] services = (ServiceBaseServer[])wsClientsDeployContext.getServices();
                protocolIds = services == null || services.length == 0 ? this.multiply(WSContainer.getComponentFactory().listClientProtocolIds(), wsClientNames.length) : this.getServiceProtocols((ServiceBaseServer[])wsClientsDeployContext.getServices());
                this.wsClientProtocolNotificator.onRollbackStart(applicationName, this.getWSClientNames(wsClientsDeployContext.getWsClientRuntimeInfos()), protocolIds);
                break;
            }
        }
    }

    private Hashtable lookUpServiceInstances(WSClientRuntimeInfo[] wsClientRuntimeInfoes, Vector warnings) {
        String excMsg = "Error occurred, trying to look up service instances for ws clients. ";
        if (wsClientRuntimeInfoes == null) {
            return new Hashtable();
        }
        Hashtable<WSClientRuntimeInfo, ServiceBaseServer> services = new Hashtable<WSClientRuntimeInfo, ServiceBaseServer>();
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching("Warning! ", (Throwable)e);
            String msg = excMsg + " Unable to get initial context. ";
            warnings.add(msg);
        }
        if (ctx != null) {
            int i = 0;
            while (i < wsClientRuntimeInfoes.length) {
                WSClientRuntimeInfo wsClientRuntimeInfo = wsClientRuntimeInfoes[i];
                WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
                String jndiName = WSClientRuntimetHelper.getServiceJndiNameInRootCtx(wsClientId);
                try {
                    ServiceBaseServer service = (ServiceBaseServer)ctx.lookup(jndiName);
                    services.put(wsClientRuntimeInfo, service);
                }
                catch (Exception e) {
                    Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsLocation.catching("Warning! ", (Throwable)e);
                    String msg = excMsg + " Unable to look up ws client: application " + wsClientId.getApplicationName() + ", ws client " + wsClientId.getServiceRefName() + ". ";
                    warnings.add(msg);
                }
                ++i;
            }
        }
        return services;
    }

    private String[] getWSClientNames(WSClientRuntimeInfo[] wsClientRuntimeInfoes) {
        if (wsClientRuntimeInfoes == null) {
            return new String[0];
        }
        String[] wsClientNames = new String[wsClientRuntimeInfoes.length];
        int i = 0;
        while (i < wsClientRuntimeInfoes.length) {
            wsClientNames[i] = wsClientRuntimeInfoes[i].getWsClientId().getServiceRefName();
            ++i;
        }
        return wsClientNames;
    }

    private void unregisterWSClients(String applicationName) throws WSWarningException {
        this.unregisterWSClients(WSContainer.getWsClientRegistry().listWSClientsByApplicationName(applicationName));
    }

    private void unregisterWSClients(WSClientIdentifier[] wsClientIds) throws WSWarningException {
        if (wsClientIds == null) {
            return;
        }
        Vector warnings = new Vector();
        int i = 0;
        while (i < wsClientIds.length) {
            try {
                this.unregisterSingleWSClient(wsClientIds[i]);
            }
            catch (WSWarningException e) {
                warnings.addAll(e.getWarningsVector());
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void unregisterSingleWSClient(WSClientIdentifier wsClientId) throws WSWarningException {
        String msg;
        Location wsDeployLocation;
        String excMsg = "Error occurred, trying to unregister ws client from WS Client Runtime, application " + wsClientId.getApplicationName() + ", web service " + wsClientId.getServiceRefName() + ". ";
        Vector<String> warnings = new Vector<String>();
        try {
            WSContainer.getWsClientRegistry().unregisterWSClient(wsClientId);
        }
        catch (Exception e) {
            wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            msg = excMsg + "Unexpected error occurred: " + e.getLocalizedMessage() + ". ";
            warnings.add(msg);
        }
        try {
            new WSClientRuntimetHelper().unbindServiceInstance(wsClientId);
        }
        catch (Exception e) {
            wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            msg = excMsg + "Unexpected error occurred: " + e.getLocalizedMessage() + ". ";
            warnings.add(msg);
        }
        try {
            WSLogging.removeAndStoreWSClientConfiguration(wsClientId.getApplicationName(), wsClientId.getServiceRefName());
        }
        catch (Exception e) {
            wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            msg = excMsg + "Unexpected error occurred: " + e.getLocalizedMessage() + ". ";
            warnings.add(msg);
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private String[] getWSClientDirs(String wsClientsDir) {
        Vector<String> wsClientDirsVector = new Vector<String>();
        File[] wsClientDirs = new File(wsClientsDir).listFiles();
        int i = 0;
        while (i < wsClientDirs.length) {
            File wsClientDir = wsClientDirs[i];
            if (!wsClientDir.getName().equals("app_jars")) {
                wsClientDirsVector.add(wsClientDirs[i].getAbsolutePath());
            }
            ++i;
        }
        String[] wsClientDirsArray = new String[wsClientDirsVector.size()];
        wsClientDirsVector.toArray(wsClientDirsArray);
        return wsClientDirsArray;
    }

    private String[] getWSClientNames(String[] wsClientDirs) throws WSDeploymentException {
        Vector<String> wsClientNames = new Vector<String>();
        int i = 0;
        while (i < wsClientDirs.length) {
            String wsClientDir = wsClientDirs[i];
            if (!new File(wsClientDir).getName().equals("app_jars")) {
                String wsClientName = new WSClientsFactory().extractWSClientNames(wsClientDir)[0];
                wsClientNames.add(wsClientName);
            }
            ++i;
        }
        String[] webServicesNamesArray = new String[wsClientNames.size()];
        wsClientNames.toArray(webServicesNamesArray);
        return webServicesNamesArray;
    }

    private String[][] getServiceProtocols(ServiceBaseServer[] services) {
        if (services == null) {
            return new String[0][0];
        }
        String[][] protocols = new String[services.length][];
        int i = 0;
        while (i < protocols.length) {
            protocols[i] = this.wsClientProtocolNotificator.getProtocols(services[i].getUsedProtocols());
            ++i;
        }
        return protocols;
    }

    private String[][] multiply(String[] str, int size) {
        if (size <= 0) {
            return new String[0][0];
        }
        String[][] strs = new String[size][];
        int i = 0;
        while (i < size) {
            strs[i] = str;
            ++i;
        }
        return strs;
    }

    private WSClientRuntimeInfo[] getWSClients(Hashtable wsClientsToServicesMapping) {
        if (wsClientsToServicesMapping == null) {
            return new WSClientRuntimeInfo[0];
        }
        WSClientRuntimeInfo[] wsClientRuntimeInfoes = new WSClientRuntimeInfo[wsClientsToServicesMapping.size()];
        Enumeration wsClientIdsEnum = wsClientsToServicesMapping.keys();
        int i = 0;
        while (wsClientIdsEnum.hasMoreElements()) {
            wsClientRuntimeInfoes[i++] = (WSClientRuntimeInfo)wsClientIdsEnum.nextElement();
        }
        return wsClientRuntimeInfoes;
    }

    private Service[] getServiceInstances(Hashtable wsClientsToServicesMapping) {
        if (wsClientsToServicesMapping == null) {
            return new ServiceBaseServer[0];
        }
        ServiceBaseServer[] services = new ServiceBaseServer[wsClientsToServicesMapping.size()];
        Enumeration servicesEnum = wsClientsToServicesMapping.elements();
        int i = 0;
        while (servicesEnum.hasMoreElements()) {
            services[i++] = (ServiceBaseServer)servicesEnum.nextElement();
        }
        return services;
    }

    private String[] getStrings(Enumeration strEnum, int size) {
        if (strEnum == null) {
            return new String[0];
        }
        String[] strs = new String[size];
        int i = 0;
        while (strEnum.hasMoreElements()) {
            String str = (String)strEnum.nextElement();
            strs[i++] = str;
        }
        return strs;
    }
}

