/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.wsclient;

import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.wsclient.ComponentDescriptor;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientIdentifier;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientRuntimeInfo;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDirsHandler;
import com.sap.engine.services.webservices.server.deploy.common.WSBaseConstants;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.ComponentScopedRefsDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.ServiceRefDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.WSClientDeploymentDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.WSClientsParser;
import com.sap.engine.services.webservices.server.deploy.descriptors.wsclientsruntime.ComponentDescriptorType;
import com.sap.engine.services.webservices.server.deploy.descriptors.wsclientsruntime.WSClientRuntimeDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.wsclientsruntime.WSClientsRuntimeDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.wsclientsruntime.WSClientsRuntimeParser;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.util.jar.JarUtil;
import com.sap.engine.services.webservices.server.deploy.ws.WSDirsHandler;
import com.sap.engine.services.webservices.server.deploy.ws.WSRuntimeActivator;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientArchiveFilesLocationHandler;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientArchiveLocationHandlerMultipleMode;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientDeploymentInfo;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientDirsHandler;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsConstants;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsFileNameFilter;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsUtil;
import com.sap.engine.services.webservices.server.deploy.wsclient.update.WSClientArchiveLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.wsclient.update.WSClientFileLocationWrapper;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarFile;

public class WSClientsFactory
implements WSClientsConstants {
    public WSClientArchiveLocationWrapper[] loadWSClientArchiveLocationWrappers(String applicatioName, File[] wsClientModuleArchives) throws WSDeploymentException {
        if (wsClientModuleArchives == null) {
            return new WSClientArchiveLocationWrapper[0];
        }
        WSClientArchiveLocationWrapper[] wsClientArchiveLocationWrappers = new WSClientArchiveLocationWrapper[]{};
        int i = 0;
        while (i < wsClientModuleArchives.length) {
            WSClientArchiveLocationWrapper[] currentWSClientArchiveLocationWrappers = this.loadWSClientArchiveLocationWrappers(applicatioName, wsClientModuleArchives[i]);
            wsClientArchiveLocationWrappers = this.unifyWSClientArchiveLocationWrappers(new WSClientArchiveLocationWrapper[][]{wsClientArchiveLocationWrappers, currentWSClientArchiveLocationWrappers});
            ++i;
        }
        return wsClientArchiveLocationWrappers;
    }

    public WSClientArchiveLocationWrapper[] loadWSClientArchiveLocationWrappers(String applicationName, File wsClientModuleArchive) throws WSDeploymentException {
        String excMsg = "Error occured, trying to load ws client archive location wrappers for module " + wsClientModuleArchive.getAbsolutePath() + ". ";
        WSClientArchiveLocationWrapper[] wsClientArchiveLocationWrappers = new WSClientArchiveLocationWrapper[]{};
        try {
            WSClientArchiveLocationWrapper[] currentWSClientArchiveLocationWrappers;
            if (WSClientsFactory.containsWSClientsSingleMode(wsClientModuleArchive) != null) {
                currentWSClientArchiveLocationWrappers = this.loadWSClientArchiveLocationWrappers(applicationName, new WSClientArchiveFilesLocationHandler(wsClientModuleArchive));
                wsClientArchiveLocationWrappers = this.unifyWSClientArchiveLocationWrappers(new WSClientArchiveLocationWrapper[][]{wsClientArchiveLocationWrappers, currentWSClientArchiveLocationWrappers});
            }
            if (WSClientsFactory.containsWSClientsMultipleMode(wsClientModuleArchive) != null) {
                currentWSClientArchiveLocationWrappers = this.loadWSClientArchiveLocationWrappers(applicationName, new WSClientArchiveLocationHandlerMultipleMode(wsClientModuleArchive));
                wsClientArchiveLocationWrappers = this.unifyWSClientArchiveLocationWrappers(new WSClientArchiveLocationWrapper[][]{wsClientArchiveLocationWrappers, currentWSClientArchiveLocationWrappers});
            }
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsClientArchiveLocationWrappers;
    }

    private WSClientArchiveLocationWrapper[] loadWSClientArchiveLocationWrappers(String applicationName, WSClientArchiveFilesLocationHandler wsClientArchiveFilesLocationHandler) throws WSDeploymentException {
        String excMsg = "Error occured, trying to collect ws clients descriptors (single mode). ";
        WSClientDeploymentDescriptor wsClientsDDescriptor = null;
        WSClientArchiveLocationWrapper[] wsClientArchiveLocationWrappers = new WSClientArchiveLocationWrapper[]{};
        try {
            if (wsClientArchiveFilesLocationHandler.existsWSClientsDeploymentDescriptor()) {
                InputStream wsClientsDDescriptorInputStream = wsClientArchiveFilesLocationHandler.getWSClientsDeploymentDescriptorInputStream();
                wsClientsDDescriptor = WSClientsParser.loadWSClientsDeploymentDescriptor(wsClientsDDescriptorInputStream);
                wsClientArchiveLocationWrappers = this.loadWSClientArchiveLocationWrappers(applicationName, wsClientsDDescriptor, wsClientArchiveFilesLocationHandler);
            }
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to load: " + wsClientArchiveFilesLocationHandler.getWSClientsDeploymentDescriptorLocationMsg() + ".";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsClientArchiveLocationWrappers;
    }

    private WSClientArchiveLocationWrapper[] loadWSClientArchiveLocationWrappers(String applicationName, WSClientArchiveLocationHandlerMultipleMode wsClientArchiveFilesLocationHandler) throws WSDeploymentException {
        String excMsg = "Error occured, trying to collect ws clients descriptors (multiple mode). ";
        String[] wsClientsDDescriptorPaths = null;
        try {
            wsClientsDDescriptorPaths = wsClientArchiveFilesLocationHandler.getWSClientsDeploymentDescriptorPathsMultipleMode();
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to collect " + WSClientDirsHandler.getWSClientsDeploymentDescriptorFileName() + " paths, source location " + wsClientArchiveFilesLocationHandler.getWSClientsDescriptorsDir() + ". ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        WSClientArchiveLocationWrapper[] wsClientArchiveLocationWrappers = new WSClientArchiveLocationWrapper[]{};
        int i = 0;
        while (i < wsClientsDDescriptorPaths.length) {
            String wsClientsDDescriptorPath = wsClientsDDescriptorPaths[i];
            try {
                WSClientDeploymentDescriptor wsClientDeploymentDescriptor = WSClientsParser.loadWSClientsDeploymentDescriptor(wsClientArchiveFilesLocationHandler.getInputStream(wsClientsDDescriptorPath));
                WSClientArchiveLocationWrapper[] currentWSClientArchiveLocationWrappers = this.loadWSClientArchiveLocationWrappers(applicationName, wsClientDeploymentDescriptor, wsClientArchiveFilesLocationHandler);
                wsClientArchiveLocationWrappers = this.unifyWSClientArchiveLocationWrappers(new WSClientArchiveLocationWrapper[][]{wsClientArchiveLocationWrappers, currentWSClientArchiveLocationWrappers});
            }
            catch (Exception e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                String msg = excMsg + "Unable to load  " + wsClientsDDescriptorPath + ". ";
                Object[] args = new String[]{msg, "none"};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            ++i;
        }
        return wsClientArchiveLocationWrappers;
    }

    private WSClientArchiveLocationWrapper[] loadWSClientArchiveLocationWrappers(String applicationName, WSClientDeploymentDescriptor wsClientDDescriptor, WSClientArchiveFilesLocationHandler wsClientArchiveFilesLocationHandler) {
        WSClientDeploymentDescriptor[] wsClientDeploymentDescriptors = this.collectSingleWSClientDeploymentDescriptors(wsClientDDescriptor);
        return this.loadWSClientArchiveLocationWrappers(applicationName, wsClientDDescriptor.getVersion().trim(), wsClientDeploymentDescriptors, wsClientArchiveFilesLocationHandler);
    }

    private WSClientDeploymentDescriptor[] collectSingleWSClientDeploymentDescriptors(WSClientDeploymentDescriptor wsClientDeploymentDescriptor) {
        String version = wsClientDeploymentDescriptor.getVersion().trim();
        WSClientDeploymentDescriptor[] wsClientDeploymentDescriptors1 = this.collectSingleWSClientDeploymentDescriptors(version, wsClientDeploymentDescriptor.getServiceRef());
        WSClientDeploymentDescriptor[] wsClientDeploymentDescriptors2 = this.collectSingleWSClientDeploymentDescriptors(version, wsClientDeploymentDescriptor.getComponentScopedRefs());
        WSClientDeploymentDescriptor[] wsClientDeploymentDescriptors = new WSClientDeploymentDescriptor[wsClientDeploymentDescriptors1.length + wsClientDeploymentDescriptors2.length];
        System.arraycopy(wsClientDeploymentDescriptors1, 0, wsClientDeploymentDescriptors, 0, wsClientDeploymentDescriptors1.length);
        System.arraycopy(wsClientDeploymentDescriptors2, 0, wsClientDeploymentDescriptors, wsClientDeploymentDescriptors1.length, wsClientDeploymentDescriptors2.length);
        return wsClientDeploymentDescriptors;
    }

    private WSClientDeploymentDescriptor[] collectSingleWSClientDeploymentDescriptors(String version, ServiceRefDescriptor[] serviceRefDescriptors) {
        if (serviceRefDescriptors == null) {
            return new WSClientDeploymentDescriptor[0];
        }
        WSClientDeploymentDescriptor[] wsClientDeploymentDescriptors = new WSClientDeploymentDescriptor[serviceRefDescriptors.length];
        int i = 0;
        while (i < serviceRefDescriptors.length) {
            WSClientDeploymentDescriptor currentWSClientDeploymentDescriptor = new WSClientDeploymentDescriptor();
            currentWSClientDeploymentDescriptor.setVersion(version);
            currentWSClientDeploymentDescriptor.setServiceRef(new ServiceRefDescriptor[]{serviceRefDescriptors[i]});
            wsClientDeploymentDescriptors[i] = currentWSClientDeploymentDescriptor;
            ++i;
        }
        return wsClientDeploymentDescriptors;
    }

    private WSClientDeploymentDescriptor[] collectSingleWSClientDeploymentDescriptors(String version, ComponentScopedRefsDescriptor[] componentScopedRefsDescriptors) {
        if (componentScopedRefsDescriptors == null) {
            return new WSClientDeploymentDescriptor[0];
        }
        WSClientDeploymentDescriptor[] wsClientDeploymentDescriptors = new WSClientDeploymentDescriptor[]{};
        int i = 0;
        while (i < componentScopedRefsDescriptors.length) {
            WSClientDeploymentDescriptor[] currentWSClientDeploymentDescriptors = this.collectSingleWSClientDeploymentDescriptors(version, componentScopedRefsDescriptors[i]);
            WSClientDeploymentDescriptor[] newWSClientDeploymentDescriptors = new WSClientDeploymentDescriptor[wsClientDeploymentDescriptors.length + currentWSClientDeploymentDescriptors.length];
            System.arraycopy(wsClientDeploymentDescriptors, 0, newWSClientDeploymentDescriptors, 0, wsClientDeploymentDescriptors.length);
            System.arraycopy(currentWSClientDeploymentDescriptors, 0, newWSClientDeploymentDescriptors, wsClientDeploymentDescriptors.length, currentWSClientDeploymentDescriptors.length);
            wsClientDeploymentDescriptors = newWSClientDeploymentDescriptors;
            ++i;
        }
        return wsClientDeploymentDescriptors;
    }

    private WSClientDeploymentDescriptor[] collectSingleWSClientDeploymentDescriptors(String version, ComponentScopedRefsDescriptor componentScopedRefsDescriptor) {
        String componentName = null;
        if (componentScopedRefsDescriptor.hasComponentName()) {
            componentName = componentScopedRefsDescriptor.getComponentName().trim();
        }
        ServiceRefDescriptor[] serviceRefDescriptors = componentScopedRefsDescriptor.getServiceRef();
        WSClientDeploymentDescriptor[] wsClientDeploymentDescriptors = new WSClientDeploymentDescriptor[serviceRefDescriptors.length];
        int i = 0;
        while (i < serviceRefDescriptors.length) {
            ComponentScopedRefsDescriptor currentComponentScopedRefsDescriptor = new ComponentScopedRefsDescriptor();
            if (componentName != null) {
                componentScopedRefsDescriptor.setComponentName(componentName);
            }
            currentComponentScopedRefsDescriptor.setServiceRef(new ServiceRefDescriptor[]{serviceRefDescriptors[i]});
            WSClientDeploymentDescriptor currentWSClientDeploymentDescriptor = new WSClientDeploymentDescriptor();
            currentWSClientDeploymentDescriptor.setVersion(version);
            currentWSClientDeploymentDescriptor.setComponentScopedRefs(new ComponentScopedRefsDescriptor[]{currentComponentScopedRefsDescriptor});
            wsClientDeploymentDescriptors[i] = currentWSClientDeploymentDescriptor;
            ++i;
        }
        return wsClientDeploymentDescriptors;
    }

    private WSClientArchiveLocationWrapper[] loadWSClientArchiveLocationWrappers(String applicationName, String version, WSClientDeploymentDescriptor[] wsClientDeploymentDescriptors, WSClientArchiveFilesLocationHandler wsClientArchiveFilesLocationHandler) {
        WSClientArchiveLocationWrapper[] wsClientArchiveLocationWrappers = new WSClientArchiveLocationWrapper[wsClientDeploymentDescriptors.length];
        int i = 0;
        while (i < wsClientDeploymentDescriptors.length) {
            wsClientArchiveLocationWrappers[i] = this.loadWSClientArchiveLocationWrapper(applicationName, version, wsClientDeploymentDescriptors[i], wsClientArchiveFilesLocationHandler);
            ++i;
        }
        return wsClientArchiveLocationWrappers;
    }

    private WSClientArchiveLocationWrapper loadWSClientArchiveLocationWrapper(String applicationName, String version, WSClientDeploymentDescriptor wsClientDeploymentDescriptor, WSClientArchiveFilesLocationHandler wsClientArchiveFilesLocationHandler) {
        String serviceRefName = this.getServiceRefNames(wsClientDeploymentDescriptor)[0];
        serviceRefName = this.getActualServiceRefName(version, wsClientArchiveFilesLocationHandler.getModuleArchive().getName(), serviceRefName);
        WSClientArchiveLocationWrapper wsClientArchiveLocationWrapper = new WSClientArchiveLocationWrapper();
        wsClientArchiveLocationWrapper.setApplicationName(applicationName);
        wsClientArchiveLocationWrapper.setWsClientName(serviceRefName);
        wsClientArchiveLocationWrapper.setWsClientArchiveFilesLocationHandler(wsClientArchiveFilesLocationHandler);
        wsClientArchiveLocationWrapper.setVersion(version);
        wsClientArchiveLocationWrapper.setWsClientDeploymentDescriptor(wsClientDeploymentDescriptor);
        return wsClientArchiveLocationWrapper;
    }

    public WSClientDeploymentInfo[] loadWSClientDeploymentInfoes(String applicationName, String wsClientsDir, String wsClientsWorkingDir, WSClientArchiveLocationWrapper[] wsClientArchiveLocationWrappers) {
        if (wsClientArchiveLocationWrappers == null) {
            return new WSClientDeploymentInfo[0];
        }
        WSClientDeploymentInfo[] wsClientDeploymentInfoes = new WSClientDeploymentInfo[]{};
        int i = 0;
        while (i < wsClientArchiveLocationWrappers.length) {
            WSClientDeploymentInfo[] currentWSWsClientDeploymentInfoes = this.loadWSClientDeploymentInfoes(applicationName, wsClientsDir, wsClientsWorkingDir, wsClientArchiveLocationWrappers[i]);
            wsClientDeploymentInfoes = WSClientsUtil.unifyWSClientDeploymentInfoes(new WSClientDeploymentInfo[][]{wsClientDeploymentInfoes, currentWSWsClientDeploymentInfoes});
            ++i;
        }
        return wsClientDeploymentInfoes;
    }

    public WSClientFileLocationWrapper loadWSClientFileLocationWrapper(String applicationName, String wsClientDir) throws WSDeploymentException {
        String excMsg = "Error occured, trying to collect web service location information, ws client directory " + wsClientDir + ".";
        WSClientFileLocationWrapper wsClientLocationWrapper = null;
        try {
            Properties mappings = null;
            boolean isBaseMappings = false;
            if (WSClientsFactory.hasMappings(wsClientDir)) {
                mappings = WSRuntimeActivator.loadMappingsFile(WSDirsHandler.getMappingsPath(wsClientDir));
            } else {
                mappings = WSClientDirsHandler.generateBaseDefaultMappings();
                isBaseMappings = true;
            }
            WSClientDirsHandler wsClientDirsHandler = new WSClientDirsHandler(wsClientDir, mappings);
            wsClientLocationWrapper = this.loadWSClientFileLocationWrapper(applicationName, wsClientDirsHandler);
            if (isBaseMappings) {
                wsClientLocationWrapper.getWsClientDirsHandler().updateDefaultMappings(wsClientLocationWrapper.getWsClientName());
            }
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsClientLocationWrapper;
    }

    private WSClientFileLocationWrapper loadWSClientFileLocationWrapper(String applicationName, WSClientDirsHandler wsClientDirsHandler) throws WSDeploymentException {
        String excMsg = "Error occured, loading ws client file location wrapper from " + wsClientDirsHandler.getWSClientsDeploymentDescriptorPath() + " and " + wsClientDirsHandler.getWSClientsRuntimeDescriptorPath() + ". ";
        String wsClientsDDescriptorPath = wsClientDirsHandler.getWSClientsDeploymentDescriptorPath();
        WSClientDeploymentDescriptor wsClientsDDescriptor = null;
        try {
            wsClientsDDescriptor = WSClientsParser.loadWSClientsDeploymentDescriptor(wsClientsDDescriptorPath);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        String wsClientRuntimeDescriptorPath = wsClientDirsHandler.getWSClientsRuntimeDescriptorPath();
        WSClientsRuntimeDescriptor wsClientsRuntimeDescriptor = null;
        try {
            wsClientsRuntimeDescriptor = WSClientsRuntimeParser.loadWSClientsRuntimeDescriptor(wsClientRuntimeDescriptorPath);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        String wsClientServiceRefName = this.getServiceRefNames(wsClientsDDescriptor)[0];
        String moduleName = this.getModuleNames(wsClientsRuntimeDescriptor.getWsclientRuntimeDescriptor())[0];
        wsClientServiceRefName = this.getActualServiceRefName(wsClientsDDescriptor.getVersion().trim(), moduleName, wsClientServiceRefName);
        WSClientFileLocationWrapper wsClientFileLocationWrapper = new WSClientFileLocationWrapper();
        wsClientFileLocationWrapper.setApplicationName(applicationName);
        wsClientFileLocationWrapper.setWsClientName(wsClientServiceRefName);
        wsClientFileLocationWrapper.setModuleName(moduleName);
        wsClientFileLocationWrapper.setWsClientDirsHandler(wsClientDirsHandler);
        return wsClientFileLocationWrapper;
    }

    public static boolean hasMappings(String wsClientOwnDir) {
        return new File(WSClientDirsHandler.getMappingsPath(wsClientOwnDir)).exists();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties loadMappings(String wsClientOwnDir) throws WSDeploymentException {
        String excMsg = "Error occured, loading mappings for ws client from directory " + wsClientOwnDir + ". ";
        String mappingsPath = WSClientDirsHandler.getMappingsPath(wsClientOwnDir);
        Properties mappings = new Properties();
        if (!new File(mappingsPath).exists()) return mappings;
        FileInputStream in = null;
        in = new FileInputStream(mappingsPath);
        mappings.load(in);
        Object var10_5 = null;
        if (in == null) return mappings;
        try {
            in.close();
            return mappings;
        }
        catch (IOException iExc) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = "Warning! " + excMsg + "Unable to close stream for file " + mappingsPath + ".";
            wsDeployLocation.catching(msg, (Throwable)iExc);
        }
        return mappings;
        {
            catch (IOException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                String msg = excMsg + "Unable to load mappings from file " + mappingsPath + ". ";
                Object[] args = new String[]{msg};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var10_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException iExc) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                String msg = "Warning! " + excMsg + "Unable to close stream for file " + mappingsPath + ".";
                wsDeployLocation.catching(msg, (Throwable)iExc);
            }
            throw throwable;
        }
    }

    public static void setMappings(String wsClientsDir, String wsClientsWorkingDir, WSClientDeploymentInfo[] wsClientDeploymentInfoes, int maxIndex, int[] freeIndexes) {
        if (wsClientDeploymentInfoes == null) {
            return;
        }
        int freeIndexesLength = freeIndexes.length;
        int i = 0;
        while (i < wsClientDeploymentInfoes.length) {
            if (i < freeIndexesLength) {
                WSClientsFactory.setMappings(wsClientsDir, wsClientsWorkingDir, wsClientDeploymentInfoes[i], freeIndexes[i]);
            } else {
                WSClientsFactory.setMappings(wsClientsDir, wsClientsWorkingDir, wsClientDeploymentInfoes[i], maxIndex + 1 + i - freeIndexesLength);
            }
            ++i;
        }
    }

    public static void setDefaultMappings(String wsClientsDir, String wsClientsWorkingDir, WSClientDeploymentInfo[] wsClientDeploymentInfoes) {
        if (wsClientDeploymentInfoes == null) {
            return;
        }
        int i = 0;
        while (i < wsClientDeploymentInfoes.length) {
            WSClientsFactory.setDefaultMappings(wsClientsDir, wsClientsWorkingDir, wsClientDeploymentInfoes[i]);
            ++i;
        }
    }

    public static void setDefaultMappings(String wsClientsDir, String wsClientsWorkingDir, WSClientDeploymentInfo wsClientDeploymentInfo) {
        WSClientIdentifier wsClientId = wsClientDeploymentInfo.getWsClientId();
        String serviceRefName = wsClientId.getServiceRefName();
        String wsClientDir = WSClientDirsHandler.getDefaultWSClientDir(wsClientsDir, serviceRefName);
        String wsClientWorkingDir = WSClientDirsHandler.getDefaultWSClientWorkingDir(wsClientsWorkingDir, serviceRefName);
        Properties mappings = WSClientDirsHandler.generateDefaultMappings(serviceRefName);
        WSClientDirsHandler wsClientDirsHandler = new WSClientDirsHandler(wsClientDir, mappings);
        wsClientDeploymentInfo.setWsClientDirsHandler(wsClientDirsHandler);
        wsClientDeploymentInfo.setWsClientWorkingDir(wsClientWorkingDir);
    }

    public static void setMappings(String wsClientsDir, String wsClientsWorkingDir, WSClientDeploymentInfo wsClientDeploymentInfo, int index) {
        WSClientIdentifier wsClientId = wsClientDeploymentInfo.getWsClientId();
        String wsClientDir = WSClientDirsHandler.getWSClientDir(wsClientsDir, index);
        String wsClientWorkingDir = WSClientDirsHandler.getWSClientWorkingDir(wsClientsWorkingDir, index);
        Properties mappings = WSClientDirsHandler.generateMappings(wsClientId.getServiceRefName(), index);
        WSClientDirsHandler wsClientDirsHandler = new WSClientDirsHandler(wsClientDir, mappings);
        wsClientDeploymentInfo.setWsClientDirsHandler(wsClientDirsHandler);
        wsClientDeploymentInfo.setWsClientWorkingDir(wsClientWorkingDir);
    }

    public static void setMappings(String wsClientsDir, WSClientRuntimeInfo wsClientRuntimeInfo) {
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String wsClientDir = WSClientDirsHandler.getDefaultWSClientDir(wsClientsDir, wsClientId.getServiceRefName());
        Properties mappings = WSClientDirsHandler.generateDefaultMappings(wsClientId.getServiceRefName());
        WSClientDirsHandler wsClientDirsHandler = new WSClientDirsHandler(wsClientDir, mappings);
        wsClientRuntimeInfo.setWsClientDirsHandler(wsClientDirsHandler);
    }

    public static void setMappings(String wsClientOwnDir, WSClientRuntimeInfo wsClientRuntimeInfo, Properties mappings) {
        WSClientDirsHandler wsClientDirsHandler = new WSClientDirsHandler(wsClientOwnDir, mappings);
        wsClientRuntimeInfo.setWsClientDirsHandler(wsClientDirsHandler);
    }

    public WSClientDeploymentInfo[] loadWSClientDeploymentInfoes(String applicationName, String wsClientsDir, String wsClientsWorkingDir, WSClientArchiveLocationWrapper wsClientArchiveLocationWrapper) {
        WSClientArchiveFilesLocationHandler wsClientArchiveFilesLocationHandler = wsClientArchiveLocationWrapper.getWsClientArchiveFilesLocationHandler();
        return this.parseWSClientDeploymentDescriptorDeploymentMode(applicationName, wsClientArchiveFilesLocationHandler.getModuleArchive(), wsClientArchiveLocationWrapper.getWsClientDeploymentDescriptor(), wsClientArchiveFilesLocationHandler.getMetaInfDir());
    }

    public WSClientDeploymentInfo[] loadWSClientDeploymentInfos(String wsClientsWorkingDir, String wsClientsDeployDir, String applicationName, File moduleArchive, Vector warnings) {
        WSClientDeploymentInfo[] wsClientDeploymentInfosSingleMode = this.loadWSClientDeploymentInfosSingleMode(wsClientsWorkingDir, wsClientsDeployDir, applicationName, moduleArchive, warnings);
        WSClientDeploymentInfo[] wsClientDeploymentInfosMultipleMode = this.loadWSClientDeploymentInfosMultipleMode(wsClientsWorkingDir, wsClientsDeployDir, applicationName, moduleArchive, warnings);
        WSClientDeploymentInfo[] wsClientDeploymentInfos = WSClientsUtil.unifyWSClientDeploymentInfoes(new WSClientDeploymentInfo[][]{wsClientDeploymentInfosSingleMode, wsClientDeploymentInfosMultipleMode});
        return wsClientDeploymentInfos;
    }

    /*
     * Loose catch block
     */
    public WSClientDeploymentInfo[] loadWSClientDeploymentInfosSingleMode(String wsClientsWorkingDir, String wsClientsDeployDir, String applicationName, File moduleArchive, Vector warnings) {
        WSClientDeploymentInfo[] wsClientDeploymentInfos;
        block14: {
            JarFile moduleJarFile;
            String warningMsg;
            String excMsg;
            block13: {
                excMsg = "Error occured trying to read ws-clients-deployment-descriptor.xml(in single mode) for module: " + moduleArchive.getName() + ". ";
                warningMsg = "Not deployed ws clients for module " + moduleArchive.getName() + ". " + excMsg;
                String metaInfValue = null;
                try {
                    metaInfValue = WSClientsFactory.containsWSClientsSingleMode(moduleArchive);
                }
                catch (Exception e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    String msg = warningMsg + "Unable to check the module archive if it contains ws clients. ";
                    wsDeployLocation.catching(msg, (Throwable)e);
                    warnings.add(msg);
                }
                moduleJarFile = null;
                wsClientDeploymentInfos = new WSClientDeploymentInfo[]{};
                if (metaInfValue == null) break block13;
                moduleJarFile = new JarFile(moduleArchive);
                String wsClientsDDescriptorEntry = metaInfValue + '/' + "ws-clients-deployment-descriptor.xml";
                String moduleWorkingDir = ModuleDirsHandler.getModuleWorkingDir(wsClientsWorkingDir, moduleArchive.getName());
                new File(moduleWorkingDir).mkdirs();
                new JarUtil().extractFile(moduleJarFile, wsClientsDDescriptorEntry, moduleWorkingDir);
                String wsClientsDDescriptorFileName = moduleWorkingDir + '/' + wsClientsDDescriptorEntry;
                WSClientDeploymentDescriptor wsClientDeploymentDescriptor = WSClientsParser.loadWSClientsDeploymentDescriptor(wsClientsDDescriptorFileName);
                wsClientDeploymentInfos = this.parseWSClientDeploymentDescriptorDeploymentMode(applicationName, moduleArchive, wsClientDeploymentDescriptor, metaInfValue);
            }
            Object var16_19 = null;
            try {
                if (moduleJarFile != null) {
                    moduleJarFile.close();
                }
                break block14;
            }
            catch (IOException e2) {
                Location wsDeployLocation2 = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                String msg2 = "Warning! " + excMsg + "Unable to close jarFile for file: " + moduleArchive + ". ";
                wsDeployLocation2.catching(msg2, (Throwable)e2);
            }
            break block14;
            {
                catch (Exception e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    String msg = warningMsg + "Unable to extract, load or parse " + "ws-clients-deployment-descriptor.xml" + ". ";
                    wsDeployLocation.catching(msg, (Throwable)e);
                    warnings.add(msg);
                    Object var16_20 = null;
                    try {
                        if (moduleJarFile != null) {
                            moduleJarFile.close();
                        }
                        break block14;
                    }
                    catch (IOException e2) {
                        Location wsDeployLocation2 = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                        String msg2 = "Warning! " + excMsg + "Unable to close jarFile for file: " + moduleArchive + ". ";
                        wsDeployLocation2.catching(msg2, (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                try {
                    if (moduleJarFile != null) {
                        moduleJarFile.close();
                    }
                }
                catch (IOException e2) {
                    Location wsDeployLocation2 = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    String msg2 = "Warning! " + excMsg + "Unable to close jarFile for file: " + moduleArchive + ". ";
                    wsDeployLocation2.catching(msg2, (Throwable)e2);
                }
                throw throwable;
            }
        }
        return wsClientDeploymentInfos;
    }

    /*
     * Loose catch block
     */
    public WSClientDeploymentInfo[] loadWSClientDeploymentInfosMultipleMode(String wsClientsWorkingDir, String wsClientsDeployDir, String applicationName, File moduleArchive, Vector warnings) {
        WSClientDeploymentInfo[] wsClientDeploymentInfos;
        block16: {
            String wsClientDDescriptorFileName;
            JarFile moduleJarFile;
            String warningMsg;
            String excMsg;
            block15: {
                excMsg = "Error occured trying to read ws-clients-deployment-descriptor.xml(in multipleMode mode) for module: " + moduleArchive.getName() + ". ";
                warningMsg = "Not deployed ws clients for module " + moduleArchive.getName() + ". " + excMsg;
                String metaInfValue = null;
                try {
                    metaInfValue = WSClientsFactory.containsWSClientsMultipleMode(moduleArchive);
                }
                catch (Exception e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    String msg = warningMsg + "Unable to check the module archive if it contains ws clients. ";
                    wsDeployLocation.catching(msg, (Throwable)e);
                    warnings.add(msg);
                }
                moduleJarFile = null;
                wsClientDeploymentInfos = new WSClientDeploymentInfo[]{};
                wsClientDDescriptorFileName = null;
                if (metaInfValue == null) break block15;
                moduleJarFile = new JarFile(moduleArchive);
                String wsClientsDDescriptorEntry = metaInfValue + '/' + "ws-clients-descriptors";
                String moduleWorkingDir = ModuleDirsHandler.getModuleWorkingDir(wsClientsWorkingDir, moduleArchive.getName());
                new File(moduleWorkingDir).mkdirs();
                new JarUtil().extractDir(moduleJarFile, wsClientsDDescriptorEntry, moduleWorkingDir);
                String wsClientsDDescriptorDirName = moduleWorkingDir + '/' + wsClientsDDescriptorEntry;
                File[] wsClientsDDescriptorFiles = new File(wsClientsDDescriptorDirName).listFiles(new WSClientsFileNameFilter());
                if (wsClientsDDescriptorFiles == null) break block15;
                int i = 0;
                while (i < wsClientsDDescriptorFiles.length) {
                    String wsClientsDDescriptorFileName = wsClientsDDescriptorFiles[i].getAbsolutePath();
                    WSClientDeploymentDescriptor wsClientDeploymentDescriptor = WSClientsParser.loadWSClientsDeploymentDescriptor(wsClientsDDescriptorFileName);
                    WSClientDeploymentInfo[] currentWSClientDeploymentInfos = this.parseWSClientDeploymentDescriptorDeploymentMode(applicationName, moduleArchive, wsClientDeploymentDescriptor, metaInfValue + '/' + "ws-clients-descriptors");
                    wsClientDeploymentInfos = WSClientsUtil.unifyWSClientDeploymentInfoes(new WSClientDeploymentInfo[][]{wsClientDeploymentInfos, currentWSClientDeploymentInfos});
                    ++i;
                }
            }
            Object var21_24 = null;
            try {
                if (moduleJarFile != null) {
                    moduleJarFile.close();
                }
                break block16;
            }
            catch (IOException e2) {
                Location wsDeployLocation2 = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                String msg2 = excMsg + "Unable to close jarFile for file: " + moduleArchive + ". ";
                wsDeployLocation2.catching(msg2, (Throwable)e2);
            }
            break block16;
            {
                catch (Exception e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    String msg = warningMsg;
                    if (wsClientDDescriptorFileName != null) {
                        msg = msg + "Unable to extract, load or parse " + WSUtil.cutString(wsClientDDescriptorFileName, "ws-clients-descriptors") + ". ";
                    }
                    wsDeployLocation.catching(msg, (Throwable)e);
                    warnings.add(msg);
                    Object var21_25 = null;
                    try {
                        if (moduleJarFile != null) {
                            moduleJarFile.close();
                        }
                        break block16;
                    }
                    catch (IOException e2) {
                        Location wsDeployLocation2 = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                        String msg2 = excMsg + "Unable to close jarFile for file: " + moduleArchive + ". ";
                        wsDeployLocation2.catching(msg2, (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var21_26 = null;
                try {
                    if (moduleJarFile != null) {
                        moduleJarFile.close();
                    }
                }
                catch (IOException e2) {
                    Location wsDeployLocation2 = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    String msg2 = excMsg + "Unable to close jarFile for file: " + moduleArchive + ". ";
                    wsDeployLocation2.catching(msg2, (Throwable)e2);
                }
                throw throwable;
            }
        }
        return wsClientDeploymentInfos;
    }

    public WSClientRuntimeInfo loadWSClientRuntimeInfo(String wsClientOwnDir) throws WSDeploymentException {
        String excMsg = "Error occured, loading ws client from directory " + wsClientOwnDir + ". ";
        Properties mappings = null;
        boolean setDefaultMappings = false;
        if (WSClientsFactory.hasMappings(wsClientOwnDir)) {
            mappings = WSClientsFactory.loadMappings(wsClientOwnDir);
        } else {
            setDefaultMappings = true;
            mappings = WSClientDirsHandler.generateBaseDefaultMappings();
        }
        String wsClientDeploymentDescriptor = WSClientDirsHandler.getWSClientsDeploymentDescriptorPath(wsClientOwnDir, mappings);
        String wsClientRuntimeDescriptor = WSClientDirsHandler.getWSClientsRuntimeDescriptorPath(wsClientOwnDir, mappings);
        WSClientRuntimeInfo wsClientRuntimeInfo = null;
        try {
            wsClientRuntimeInfo = this.loadWSClientRuntimeInfos(wsClientDeploymentDescriptor, wsClientRuntimeDescriptor)[0];
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Error occured, trying to load ws client from " + "ws-clients-deployment-descriptor.xml" + " and " + "ws-clients-runtime-descriptor.xml" + ". ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        if (setDefaultMappings) {
            WSClientDirsHandler.updateDefaultMappings(wsClientRuntimeInfo.getWsClientId().getServiceRefName(), mappings);
        }
        WSClientsFactory.setMappings(wsClientOwnDir, wsClientRuntimeInfo, mappings);
        return wsClientRuntimeInfo;
    }

    public WSClientRuntimeInfo[] loadWSClientRuntimeInfos(String wsClientDDescriptorFileName, String wsClientsRuntimeDescriptorFileName) throws WSDeploymentException {
        String excMsg = "Error occured trying to load ws clients from ws-clients-deployment-descriptor.xml and ws-clients-runtime-descriptor.xml. ";
        WSClientDeploymentDescriptor wsClientDeploymentDescriptor = null;
        try {
            wsClientDeploymentDescriptor = WSClientsParser.loadWSClientsDeploymentDescriptor(wsClientDDescriptorFileName);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = excMsg + "Unable to load " + "ws-clients-deployment-descriptor.xml" + ". ";
            wsDeployLocation.catching(msg, (Throwable)e);
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        WSClientsRuntimeDescriptor wsClientsRuntimeDescriptor = null;
        try {
            wsClientsRuntimeDescriptor = WSClientsRuntimeParser.loadWSClientsRuntimeDescriptor(wsClientsRuntimeDescriptorFileName);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = excMsg + "Unable to load " + "ws-clients-runtime-descriptor.xml" + ". ";
            wsDeployLocation.catching(msg, (Throwable)e);
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        WSClientRuntimeInfo[] wsClientRuntimeInfos = new WSClientRuntimeInfo[]{};
        try {
            wsClientRuntimeInfos = this.parseWSClientDeploymentAndRuntimeDescriptors(wsClientDeploymentDescriptor, wsClientsRuntimeDescriptor);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(excMsg, (Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsClientRuntimeInfos;
    }

    public WSClientRuntimeInfo[] parseWSClientDeploymentAndRuntimeDescriptors(WSClientDeploymentDescriptor wsClientDeploymentDescriptor, WSClientsRuntimeDescriptor wsClientsRuntimeDescriptor) throws WSDeploymentException {
        String excMsg = "Error occured trying to parse '" + WSClientsParser.WS_ClIENTS_DEPLOYMENT_DESCRIPTOR_TAG + "' or '" + WSClientsRuntimeParser.WS_ClIENTS_RUNTIME_DESCRIPTOR_TAG + "' element. ";
        WSClientRuntimeInfo[] wsClientRuntimeInfos = this.parseWSClientDeploymentDescriptor(wsClientDeploymentDescriptor);
        WSClientRuntimeDescriptor[] wsClientRuntimeDescriptors = wsClientsRuntimeDescriptor.getWsclientRuntimeDescriptor();
        if (wsClientRuntimeInfos == null) {
            return new WSClientRuntimeInfo[0];
        }
        if (wsClientRuntimeDescriptors == null || wsClientRuntimeDescriptors.length == 0) {
            return wsClientRuntimeInfos;
        }
        if (wsClientRuntimeInfos.length != wsClientRuntimeDescriptors.length) {
            String msg = excMsg + "WS clients count in the two descriptors is not the same. ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args);
        }
        this.parseWSClientRuntimeDescriptors(wsClientRuntimeInfos, wsClientRuntimeDescriptors);
        return wsClientRuntimeInfos;
    }

    public WSClientsRuntimeDescriptor loadWSClientsRuntimeDescriptor(WSClientRuntimeInfo wsClientRuntimeInfo) {
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        WSClientsRuntimeDescriptor wsClientsRuntimeDescriptor = new WSClientsRuntimeDescriptor();
        WSClientRuntimeDescriptor wsClientRuntimeDescriptor = new WSClientRuntimeDescriptor();
        wsClientsRuntimeDescriptor.setWsclientRuntimeDescriptor(new WSClientRuntimeDescriptor[]{wsClientRuntimeDescriptor});
        wsClientRuntimeDescriptor.setApplicationName(wsClientId.getApplicationName());
        wsClientRuntimeDescriptor.setModuleName(wsClientId.getJarName());
        ComponentDescriptor[] componentDescriptors = wsClientRuntimeInfo.getComponentDescriptors();
        ComponentDescriptorType[] componentDescriptorTypes = null;
        if (componentDescriptors == null) {
            componentDescriptorTypes = new ComponentDescriptorType[]{};
        } else {
            componentDescriptorTypes = new ComponentDescriptorType[componentDescriptors.length];
            int i = 0;
            while (i < componentDescriptors.length) {
                ComponentDescriptor componentDescriptor = componentDescriptors[i];
                ComponentDescriptorType componentDescriptorType = new ComponentDescriptorType();
                if (componentDescriptor.hasName()) {
                    componentDescriptorType.setName(componentDescriptor.getName());
                }
                if (componentDescriptor.hasJndiName()) {
                    componentDescriptorType.setJndiName(componentDescriptor.getJndiName());
                }
                componentDescriptorTypes[i] = componentDescriptorType;
                ++i;
            }
        }
        wsClientRuntimeDescriptor.setComponentDescriptor(componentDescriptorTypes);
        return wsClientsRuntimeDescriptor;
    }

    public String[] extractWSClientNames(String wsClientDir) throws WSDeploymentException {
        String excMsg = "Error occured, trying to extract ws client names, working directory " + wsClientDir + ". ";
        Properties mappings = new Properties();
        mappings = WSClientsFactory.hasMappings(wsClientDir) ? WSClientsFactory.loadMappings(wsClientDir) : WSClientDirsHandler.generateBaseDefaultMappings();
        String wsClientDeploymentDescriptor = WSClientDirsHandler.getWSClientsDeploymentDescriptorPath(wsClientDir, mappings);
        String wsClientRuntimeDescriptor = WSClientDirsHandler.getWSClientsRuntimeDescriptorPath(wsClientDir, mappings);
        String[] wsClientNames = new String[]{};
        try {
            wsClientNames = this.extractWSClientNames(wsClientDeploymentDescriptor, wsClientRuntimeDescriptor);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Error occured, extracting ws client names from " + "ws-clients-deployment-descriptor.xml" + " and " + "ws-clients-runtime-descriptor.xml" + ". ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsClientNames;
    }

    public String[] extractWSClientNames(String wsClientsDeploymentDescriptorPath, String wsClientsRuntimeDescriptorPath) throws WSDeploymentException {
        String excMsg = "Error occured trying to extract ws client names. ";
        WSClientDeploymentDescriptor wsClientDeploymentDescriptor = null;
        try {
            wsClientDeploymentDescriptor = WSClientsParser.loadWSClientsDeploymentDescriptor(wsClientsDeploymentDescriptorPath);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = excMsg + "Unable to load " + wsClientsDeploymentDescriptorPath + ". ";
            wsDeployLocation.catching(msg, (Throwable)e);
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        WSClientsRuntimeDescriptor wsClientsRuntimeDescriptor = null;
        try {
            wsClientsRuntimeDescriptor = WSClientsRuntimeParser.loadWSClientsRuntimeDescriptor(wsClientsRuntimeDescriptorPath);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = excMsg + "Unable to load " + "ws-clients-runtime-descriptor.xml" + ". ";
            wsDeployLocation.catching(msg, (Throwable)e);
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        String version = wsClientDeploymentDescriptor.getVersion().trim();
        String[] serviceRefNames = this.getServiceRefNames(wsClientDeploymentDescriptor);
        if (version.equals("6.30")) {
            String[] moduleNames = this.getModuleNames(wsClientsRuntimeDescriptor.getWsclientRuntimeDescriptor());
            serviceRefNames = this.getActualServiceRefNames(moduleNames, serviceRefNames);
        }
        return serviceRefNames;
    }

    public static boolean containsWSClients(File moduleArchive) throws IOException {
        if (WSClientsFactory.containsWSClientsSingleMode(moduleArchive) != null) {
            return true;
        }
        return WSClientsFactory.containsWSClientsMultipleMode(moduleArchive) != null;
    }

    public static String containsWSClientsSingleMode(File moduleArchive) throws IOException {
        String metaInfValue = null;
        int i = 0;
        while (i < WSBaseConstants.META_INF.length) {
            metaInfValue = WSBaseConstants.META_INF[i];
            String wsClientsDescriptorEntry = metaInfValue + '/' + "ws-clients-deployment-descriptor.xml";
            if (JarUtil.hasEntry(moduleArchive, wsClientsDescriptorEntry)) {
                return metaInfValue;
            }
            ++i;
        }
        return null;
    }

    public static String containsWSClientsMultipleMode(File moduleArchive) throws IOException {
        String metaInfValue = null;
        int i = 0;
        while (i < WSBaseConstants.META_INF.length) {
            metaInfValue = WSBaseConstants.META_INF[i];
            String wsClientsDescriptorEntry = metaInfValue + '/' + "ws-clients-descriptors";
            if (JarUtil.hasEntry(moduleArchive, wsClientsDescriptorEntry)) {
                return metaInfValue;
            }
            ++i;
        }
        return null;
    }

    private WSClientDeploymentInfo[] parseWSClientDeploymentDescriptorDeploymentMode(String applicationName, File moduleArchive, WSClientDeploymentDescriptor wsClientDeploymentDescriptor, String baseRelativeDirEntry) {
        WSClientDeploymentInfo[] wsClientDeploymentInfos = this.parseWSClientDeploymentDescriptorDeploymentMode(wsClientDeploymentDescriptor);
        this.setAdditionalWSClientSettings1(applicationName, moduleArchive.getName(), wsClientDeploymentInfos);
        this.setBaseRelativeDirEntry(baseRelativeDirEntry, wsClientDeploymentInfos);
        this.setModuleArchive(moduleArchive, wsClientDeploymentInfos);
        return wsClientDeploymentInfos;
    }

    private void setAdditionalWSClientSettings1(String applicationName, String moduleName, WSClientDeploymentInfo[] wsClientDeploymentInfos) {
        if (wsClientDeploymentInfos == null) {
            return;
        }
        int i = 0;
        while (i < wsClientDeploymentInfos.length) {
            this.setAdditionalWSClientSettings1(applicationName, moduleName, wsClientDeploymentInfos[i]);
            ++i;
        }
    }

    private void setAdditionalWSClientSettings1(String applicationName, String moduleName, WSClientRuntimeInfo wsClientRuntimeInfo) {
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        wsClientId.setApplicationName(applicationName);
        wsClientId.setJarName(moduleName);
        this.resetServiceRefName(wsClientRuntimeInfo);
    }

    private WSClientDeploymentInfo[] parseWSClientDeploymentDescriptorDeploymentMode(WSClientDeploymentDescriptor wsClientDeploymentDescriptor) {
        ComponentScopedRefsDescriptor[] componentDescriptors = wsClientDeploymentDescriptor.getComponentScopedRefs();
        ServiceRefDescriptor[] serviceRefDescriptors = wsClientDeploymentDescriptor.getServiceRef();
        if (componentDescriptors == null) {
            return new WSClientDeploymentInfo[0];
        }
        WSClientDeploymentInfo[] componentWSClientDeploymentInfos = new WSClientDeploymentInfo[]{};
        int i = 0;
        while (i < componentDescriptors.length) {
            ComponentScopedRefsDescriptor componentDescriptor = componentDescriptors[i];
            WSClientDeploymentInfo[] currentDeploymentInfos = this.parseComponentScopedDescriptorDeploymentMode(componentDescriptor);
            componentWSClientDeploymentInfos = WSClientsUtil.unifyWSClientDeploymentInfoes(new WSClientDeploymentInfo[][]{componentWSClientDeploymentInfos, currentDeploymentInfos});
            ++i;
        }
        WSClientDeploymentInfo[] aloneWSClientDeploymentInfos = this.getArrayOfWSClientDeploymentInfo(serviceRefDescriptors.length);
        this.parseServiceDescriptorsDeploymentMode(serviceRefDescriptors, aloneWSClientDeploymentInfos, true);
        WSClientRuntimeInfo[] wsClientDeploymentInfos = WSClientsUtil.unifyWSClientDeploymentInfoes(new WSClientDeploymentInfo[][]{componentWSClientDeploymentInfos, aloneWSClientDeploymentInfos});
        String version = wsClientDeploymentDescriptor.getVersion().trim();
        this.setVersion(version, wsClientDeploymentInfos);
        return wsClientDeploymentInfos;
    }

    private void setVersion(String version, WSClientRuntimeInfo[] wsClientRuntimeInfos) {
        if (wsClientRuntimeInfos == null) {
            return;
        }
        int i = 0;
        while (i < wsClientRuntimeInfos.length) {
            WSClientRuntimeInfo wsClientRuntimeInfo = wsClientRuntimeInfos[i];
            wsClientRuntimeInfo.setVersion(version);
            ++i;
        }
    }

    private WSClientDeploymentInfo[] parseComponentScopedDescriptorDeploymentMode(ComponentScopedRefsDescriptor componentScopedDescriptor) {
        ServiceRefDescriptor[] serviceDescriptors;
        ComponentDescriptor[] componentDescriptors = new ComponentDescriptor[]{};
        String componentName = null;
        if (componentScopedDescriptor.hasComponentName()) {
            componentName = componentScopedDescriptor.getComponentName();
            componentDescriptors = WSClientsFactory.getComponentDescriptors(new String[]{componentName});
        }
        if ((serviceDescriptors = componentScopedDescriptor.getServiceRef()) == null) {
            return new WSClientDeploymentInfo[0];
        }
        WSClientRuntimeInfo[] wsClientDeploymentInfos = this.getArrayOfWSClientDeploymentInfo(serviceDescriptors.length);
        this.parseServiceDescriptorsDeploymentMode(serviceDescriptors, (WSClientDeploymentInfo[])wsClientDeploymentInfos, false);
        this.setComponentDescriptors(componentDescriptors, wsClientDeploymentInfos);
        this.setComponentName(componentName, (WSClientDeploymentInfo[])wsClientDeploymentInfos);
        return wsClientDeploymentInfos;
    }

    private void parseServiceDescriptorsDeploymentMode(ServiceRefDescriptor[] serviceDescriptors, WSClientDeploymentInfo[] wsClientDeploymentInfos, boolean isServiceAloneMode) {
        int i = 0;
        while (i < serviceDescriptors.length) {
            this.parseServiceDescriptorDeploymentMode(serviceDescriptors[i], wsClientDeploymentInfos[i], isServiceAloneMode);
            ++i;
        }
    }

    private void parseServiceDescriptorDeploymentMode(ServiceRefDescriptor serviceDescriptor, WSClientDeploymentInfo wsClientDeploymentInfo, boolean isServiceAloneMode) {
        this.parseServiceDescriptor(serviceDescriptor, wsClientDeploymentInfo);
        WSClientDeploymentDescriptor wsClientDeploymentDescriptor = new WSClientDeploymentDescriptor();
        if (isServiceAloneMode) {
            wsClientDeploymentDescriptor.setServiceRef(new ServiceRefDescriptor[]{serviceDescriptor});
        } else {
            ComponentScopedRefsDescriptor componentScopedRefsDescriptor = new ComponentScopedRefsDescriptor();
            componentScopedRefsDescriptor.setServiceRef(new ServiceRefDescriptor[]{serviceDescriptor});
            wsClientDeploymentDescriptor.setComponentScopedRefs(new ComponentScopedRefsDescriptor[]{componentScopedRefsDescriptor});
        }
        wsClientDeploymentInfo.setWsClientSingleDescriptor(wsClientDeploymentDescriptor);
    }

    private void parseWSClientRuntimeDescriptors(WSClientRuntimeInfo[] wsClientRuntimeInfos, WSClientRuntimeDescriptor[] wsClientsRuntimeDescriptors) throws IllegalArgumentException {
        if (wsClientRuntimeInfos == null) {
            return;
        }
        if (wsClientRuntimeInfos.length != wsClientRuntimeInfos.length) {
            throw new IllegalArgumentException("The input parameter arrays are not equal by length.");
        }
        int i = 0;
        while (i < wsClientRuntimeInfos.length) {
            this.parseWSClientRuntimeDescriptor(wsClientRuntimeInfos[i], wsClientsRuntimeDescriptors[i]);
            ++i;
        }
    }

    private void parseWSClientRuntimeDescriptor(WSClientRuntimeInfo wsClientRuntimeInfo, WSClientRuntimeDescriptor wsClientRuntimeDescriptor) {
        String applicationName = wsClientRuntimeDescriptor.getApplicationName().trim();
        String moduleName = wsClientRuntimeDescriptor.getModuleName().trim();
        this.setAdditionalWSClientSettings1(applicationName, moduleName, wsClientRuntimeInfo);
        ComponentDescriptor[] componentDescriptors = this.getComponentDescriptors(wsClientRuntimeDescriptor.getComponentDescriptor());
        wsClientRuntimeInfo.setComponentDescriptors(componentDescriptors);
    }

    private WSClientRuntimeInfo[] parseWSClientDeploymentDescriptor(WSClientDeploymentDescriptor wsClientDeploymentDescriptor) {
        ComponentScopedRefsDescriptor[] componentDescriptors = wsClientDeploymentDescriptor.getComponentScopedRefs();
        ServiceRefDescriptor[] serviceRefDescriptors = wsClientDeploymentDescriptor.getServiceRef();
        if (componentDescriptors == null || serviceRefDescriptors == null) {
            return new WSClientRuntimeInfo[0];
        }
        WSClientRuntimeInfo[] componentWSClientRuntimeInfos = new WSClientRuntimeInfo[]{};
        int i = 0;
        while (i < componentDescriptors.length) {
            ComponentScopedRefsDescriptor componentDescriptor = componentDescriptors[i];
            WSClientRuntimeInfo[] currentRuntimeInfos = this.parseComponentScopedDescriptor(componentDescriptor);
            componentWSClientRuntimeInfos = WSClientsUtil.unifyWSClientRuntimeInfoes(new WSClientRuntimeInfo[][]{componentWSClientRuntimeInfos, currentRuntimeInfos});
            ++i;
        }
        WSClientRuntimeInfo[] aloneWSClientRuntimeInfos = this.getArrayOfWSClientRuntimeInfo(serviceRefDescriptors.length);
        this.parseServiceDescriptors(serviceRefDescriptors, aloneWSClientRuntimeInfos);
        WSClientRuntimeInfo[] wsClientRuntimeInfos = WSClientsUtil.unifyWSClientRuntimeInfoes(new WSClientRuntimeInfo[][]{componentWSClientRuntimeInfos, aloneWSClientRuntimeInfos});
        String version = wsClientDeploymentDescriptor.getVersion().trim();
        this.setVersion(version, wsClientRuntimeInfos);
        return wsClientRuntimeInfos;
    }

    private WSClientRuntimeInfo[] parseComponentScopedDescriptor(ComponentScopedRefsDescriptor componentScopedDescriptor) {
        ServiceRefDescriptor[] serviceDescriptors;
        ComponentDescriptor[] componentDescriptors = new ComponentDescriptor[]{};
        String componentName = null;
        if (componentScopedDescriptor.hasComponentName()) {
            componentName = componentScopedDescriptor.getComponentName();
            componentDescriptors = WSClientsFactory.getComponentDescriptors(new String[]{componentName});
        }
        if ((serviceDescriptors = componentScopedDescriptor.getServiceRef()) == null) {
            return new WSClientRuntimeInfo[0];
        }
        WSClientRuntimeInfo[] wsClientRuntimeInfos = this.getArrayOfWSClientRuntimeInfo(serviceDescriptors.length);
        this.parseServiceDescriptors(serviceDescriptors, wsClientRuntimeInfos);
        this.setComponentDescriptors(componentDescriptors, wsClientRuntimeInfos);
        return wsClientRuntimeInfos;
    }

    private void setComponentDescriptors(ComponentDescriptor[] componentDescriptors, WSClientRuntimeInfo[] wsClientRuntimeInfos) {
        if (wsClientRuntimeInfos == null) {
            return;
        }
        if (componentDescriptors == null || componentDescriptors.length == 0) {
            return;
        }
        int i = 0;
        while (i < wsClientRuntimeInfos.length) {
            WSClientRuntimeInfo wsClientRuntimeInfo = wsClientRuntimeInfos[i];
            wsClientRuntimeInfo.setComponentDescriptors(componentDescriptors);
            ++i;
        }
    }

    private void setComponentName(String componentName, WSClientDeploymentInfo[] wsClientDeploymentInfos) {
        if (wsClientDeploymentInfos == null) {
            return;
        }
        if (componentName == null) {
            return;
        }
        int i = 0;
        while (i < wsClientDeploymentInfos.length) {
            WSClientDeploymentInfo wsClientDeploymentInfo = wsClientDeploymentInfos[i];
            WSClientDeploymentDescriptor wsClientDeploymentDescriptor = wsClientDeploymentInfo.getWsClientSingleDescriptor();
            ComponentScopedRefsDescriptor[] componentScopedRefsDescriptors = wsClientDeploymentDescriptor.getComponentScopedRefs();
            int j = 0;
            while (j < componentScopedRefsDescriptors.length) {
                componentScopedRefsDescriptors[j].setComponentName(componentName);
                ++j;
            }
            ++i;
        }
    }

    private void parseServiceDescriptors(ServiceRefDescriptor[] serviceDescriptors, WSClientRuntimeInfo[] wsClientRuntimeInfos) {
        int i = 0;
        while (i < serviceDescriptors.length) {
            this.parseServiceDescriptor(serviceDescriptors[i], wsClientRuntimeInfos[i]);
            ++i;
        }
    }

    private void parseServiceDescriptor(ServiceRefDescriptor serviceDescriptor, WSClientRuntimeInfo wsClientRuntimeInfo) {
        WSClientIdentifier wsClientId = new WSClientIdentifier();
        wsClientId.setServiceRefName(serviceDescriptor.getServiceRefName().trim());
        wsClientRuntimeInfo.setWsClientId(wsClientId);
        wsClientRuntimeInfo.setServiceInterfaceName(serviceDescriptor.getServiceInterface().trim());
        wsClientRuntimeInfo.setPackageName(serviceDescriptor.getPackageName().trim());
        wsClientRuntimeInfo.setWsdlFileNames(WSUtil.getSeparateStrings(serviceDescriptor.getWsdlFile().trim(), ";"));
        if (serviceDescriptor.hasLogicalPortsFile()) {
            wsClientRuntimeInfo.setLogicalPortsFileName(serviceDescriptor.getLogicalPortsFile());
        }
        if (serviceDescriptor.hasUriMappingFile()) {
            wsClientRuntimeInfo.setUriMappingFiles(WSUtil.getSeparateStrings(serviceDescriptor.getUriMappingFile().trim(), ";"));
        }
        if (serviceDescriptor.hasPackageMappingFile()) {
            wsClientRuntimeInfo.setPackageMappingFile(serviceDescriptor.getPackageMappingFile().trim());
        }
    }

    private void setModuleArchive(File moduleArchive, WSClientDeploymentInfo[] wsClientDeploymentInfos) {
        if (wsClientDeploymentInfos == null) {
            return;
        }
        int i = 0;
        while (i < wsClientDeploymentInfos.length) {
            WSClientDeploymentInfo wsClientDeploymentInfo = wsClientDeploymentInfos[i];
            wsClientDeploymentInfo.setModuleArchive(moduleArchive);
            ++i;
        }
    }

    private void setBaseRelativeDirEntry(String baseRelativeDirEntry, WSClientDeploymentInfo[] wsClientDeploymentInfos) {
        if (wsClientDeploymentInfos == null) {
            return;
        }
        int i = 0;
        while (i < wsClientDeploymentInfos.length) {
            WSClientDeploymentInfo wsClientDeploymentInfo = wsClientDeploymentInfos[i];
            wsClientDeploymentInfo.setBaseRelativeDirEntry(baseRelativeDirEntry);
            ++i;
        }
    }

    public static ComponentDescriptor[] getComponentDescriptors(String[] names) {
        ComponentDescriptor[] componentDescriptors = new ComponentDescriptor[]{};
        if (names == null) {
            return componentDescriptors;
        }
        componentDescriptors = new ComponentDescriptor[names.length];
        int i = 0;
        while (i < componentDescriptors.length) {
            ComponentDescriptor componentDescriptor = new ComponentDescriptor();
            String name = names[i];
            componentDescriptor.setName(name);
            componentDescriptors[i] = componentDescriptor;
            ++i;
        }
        return componentDescriptors;
    }

    private ComponentDescriptor[] getComponentDescriptors(ComponentDescriptorType[] componentDescriptorTypes) {
        if (componentDescriptorTypes == null) {
            return new ComponentDescriptor[0];
        }
        ComponentDescriptor[] componentDescriptors = new ComponentDescriptor[componentDescriptorTypes.length];
        int i = 0;
        while (i < componentDescriptorTypes.length) {
            ComponentDescriptor componentDescriptor = new ComponentDescriptor();
            ComponentDescriptorType componentDescriptorType = componentDescriptorTypes[i];
            if (componentDescriptorType.hasName()) {
                componentDescriptor.setName(componentDescriptorType.getName().trim());
            }
            if (componentDescriptorType.hasJndiName()) {
                componentDescriptor.setJndiName(componentDescriptorType.getJndiName().trim());
            }
            componentDescriptors[i] = componentDescriptor;
            ++i;
        }
        return componentDescriptors;
    }

    private WSClientRuntimeInfo[] getArrayOfWSClientRuntimeInfo(int lenght) {
        if (lenght < 0) {
            return new WSClientRuntimeInfo[0];
        }
        WSClientRuntimeInfo[] wsClientRuntimeInfos = new WSClientRuntimeInfo[lenght];
        int i = 0;
        while (i < lenght) {
            wsClientRuntimeInfos[i] = new WSClientRuntimeInfo();
            ++i;
        }
        return wsClientRuntimeInfos;
    }

    private WSClientDeploymentInfo[] getArrayOfWSClientDeploymentInfo(int lenght) {
        if (lenght < 0) {
            return new WSClientDeploymentInfo[0];
        }
        WSClientDeploymentInfo[] wsClientDeploymentInfos = new WSClientDeploymentInfo[lenght];
        int i = 0;
        while (i < lenght) {
            wsClientDeploymentInfos[i] = new WSClientDeploymentInfo();
            ++i;
        }
        return wsClientDeploymentInfos;
    }

    private void resetServiceRefName(WSClientRuntimeInfo wsClientRuntimeInfo) {
        String version = wsClientRuntimeInfo.getVersion();
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        if (version.equals("6.30")) {
            String actualServiceRefName = this.getActualServiceRefName(wsClientId.getJarName(), wsClientId.getServiceRefName());
            String linkServiceRefName = wsClientId.getServiceRefName();
            wsClientId.setServiceRefName(actualServiceRefName);
            wsClientRuntimeInfo.setLinkServiceRefName(linkServiceRefName);
        }
    }

    private String getActualServiceRefName(String version, String moduleName, String serviceRefName) {
        String actualServiceRefName = serviceRefName;
        if (version.equals("6.30")) {
            actualServiceRefName = this.getActualServiceRefName(moduleName, serviceRefName);
        }
        return actualServiceRefName;
    }

    private String getActualServiceRefName(String moduleName, String serviceRefName) {
        return WSUtil.getModuleNameByType(moduleName) + "_" + serviceRefName;
    }

    private String[] getActualServiceRefNames(String[] moduleNames, String[] serviceRefNames) {
        if (serviceRefNames == null) {
            return new String[0];
        }
        String[] actualServiceRefNames = new String[serviceRefNames.length];
        int i = 0;
        while (i < serviceRefNames.length) {
            actualServiceRefNames[i] = this.getActualServiceRefName(moduleNames[i], serviceRefNames[i]);
            ++i;
        }
        return actualServiceRefNames;
    }

    private String[] getModuleNames(WSClientRuntimeDescriptor[] wsClientRuntimeDescriptors) {
        if (wsClientRuntimeDescriptors == null) {
            return new String[0];
        }
        String[] moduleNames = new String[wsClientRuntimeDescriptors.length];
        int i = 0;
        while (i < wsClientRuntimeDescriptors.length) {
            moduleNames[i] = wsClientRuntimeDescriptors[i].getModuleName().trim();
            ++i;
        }
        return moduleNames;
    }

    private String[] getServiceRefNames(WSClientDeploymentDescriptor wsClientDeploymentDescriptor) {
        ComponentScopedRefsDescriptor[] componentScopedRefsDescriptors = wsClientDeploymentDescriptor.getComponentScopedRefs();
        ServiceRefDescriptor[] serviceRefDescriptors = wsClientDeploymentDescriptor.getServiceRef();
        String[] serviceRefNames0 = this.getServiceRefNames(componentScopedRefsDescriptors);
        String[] serviceRefNames1 = this.getServiceRefNames(serviceRefDescriptors);
        return WSUtil.unifyStrings(new String[][]{serviceRefNames0, serviceRefNames1});
    }

    private String[] getServiceRefNames(ServiceRefDescriptor[] serviceRefDescriptors) {
        if (serviceRefDescriptors == null) {
            return new String[0];
        }
        String[] serviceRefNames = new String[serviceRefDescriptors.length];
        int i = 0;
        while (i < serviceRefDescriptors.length) {
            serviceRefNames[i] = serviceRefDescriptors[i].getServiceRefName().trim();
            ++i;
        }
        return serviceRefNames;
    }

    private String[] getServiceRefNames(ComponentScopedRefsDescriptor[] componentScopedRefsDescriptors) {
        if (componentScopedRefsDescriptors == null) {
            return new String[0];
        }
        String[] serviceRefNames = new String[]{};
        int i = 0;
        while (i < componentScopedRefsDescriptors.length) {
            String[] currentServiceRefNames = this.getServiceRefNames(componentScopedRefsDescriptors[i].getServiceRef());
            serviceRefNames = WSUtil.unifyStrings(new String[][]{serviceRefNames, currentServiceRefNames});
            ++i;
        }
        return serviceRefNames;
    }

    private WSClientArchiveLocationWrapper[] unifyWSClientArchiveLocationWrappers(WSClientArchiveLocationWrapper[][] wsClientArchiveLocationWrappers) {
        if (wsClientArchiveLocationWrappers == null) {
            return new WSClientArchiveLocationWrapper[0];
        }
        WSClientArchiveLocationWrapper[] allWSClientArchiveLocationWrappers = new WSClientArchiveLocationWrapper[]{};
        int i = 0;
        while (i < wsClientArchiveLocationWrappers.length) {
            WSClientArchiveLocationWrapper[] currentWSClientArchiveLocationWrappers = wsClientArchiveLocationWrappers[i];
            WSClientArchiveLocationWrapper[] newWSClientArchiveLocationWrappers = new WSClientArchiveLocationWrapper[allWSClientArchiveLocationWrappers.length + currentWSClientArchiveLocationWrappers.length];
            System.arraycopy(allWSClientArchiveLocationWrappers, 0, newWSClientArchiveLocationWrappers, 0, allWSClientArchiveLocationWrappers.length);
            System.arraycopy(currentWSClientArchiveLocationWrappers, 0, newWSClientArchiveLocationWrappers, allWSClientArchiveLocationWrappers.length, currentWSClientArchiveLocationWrappers.length);
            allWSClientArchiveLocationWrappers = newWSClientArchiveLocationWrappers;
            ++i;
        }
        return allWSClientArchiveLocationWrappers;
    }
}

