/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.wsclient;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.webservices.exceptions.WSConfigurationException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ServiceBaseServer;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientIdentifier;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientRuntimeInfo;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.WSConfigurationHandler;
import com.sap.engine.services.webservices.server.deploy.common.AppDeployInfo;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.wsclient.ServiceFactory;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientDirsHandler;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientProtocolNotificator;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsDeployContext;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsDeployGenerator;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsFactory;
import com.sap.engine.services.webservices.server.deploy.wsclient.deploy.WSClientsAppDeployResult;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.rpc.Service;

public class WSClientsDeployManager {
    private HashMapObjectObject deployContext = new HashMapObjectObject();
    private WSClientProtocolNotificator wsClientProtocolNotificator = new WSClientProtocolNotificator();
    private WSClientsDeployGenerator wsClientsDeployGenerator = null;

    public WSClientsDeployManager(WSClientsDeployGenerator wsClientsDeployGenerator) {
        this.wsClientsDeployGenerator = wsClientsDeployGenerator;
    }

    public WSClientsAppDeployResult deploy(String wsContainerDir, String wsContainerWorkingDir, AppDeployInfo appDeployInfo, File[] moduleArchives) throws WSDeploymentException {
        String wsClientsWorkingDir;
        String excMsg = "Error occured, trying to deploy ws clients for application " + appDeployInfo.getApplicationName() + ". ";
        String wsClientsDir = WSClientDirsHandler.getWSClientsDir(wsContainerDir);
        WSClientsAppDeployResult wsClientsAppDeployResult = this.wsClientsDeployGenerator.generateDeployFiles(wsClientsDir, wsClientsWorkingDir = WSClientDirsHandler.getWSClientsWorkingDir(wsContainerWorkingDir), appDeployInfo, this.collectWSClientsModuleArchives(moduleArchives));
        if (wsClientsAppDeployResult.getWsClientsDeployResult().getDeployedComponentNames() == null || wsClientsAppDeployResult.getWsClientsDeployResult().getDeployedComponentNames().length == 0) {
            return wsClientsAppDeployResult;
        }
        try {
            if (wsClientsAppDeployResult.getWsClientsDeployResult().getDeployedComponentNames() != null && wsClientsAppDeployResult.getWsClientsDeployResult().getDeployedComponentNames().length != 0) {
                WSConfigurationHandler.makeWSClientsConfiguration(wsClientsDir, wsClientsAppDeployResult.getModuleDeployResult().getModuleCrcTable(), appDeployInfo.getAppConfiguration());
            }
        }
        catch (WSConfigurationException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)((Object)e));
            Object[] args = new Object[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)((Object)e));
        }
        try {
            this.notifyProtocolsOnDeploy(appDeployInfo.getApplicationName(), wsClientsAppDeployResult.getWsClientsDeployResult().getWsClientRuntimeInfoes(), appDeployInfo.getAppConfiguration());
        }
        catch (WSWarningException e) {
            wsClientsAppDeployResult.addWarnings(e.getWarningsVector());
        }
        return wsClientsAppDeployResult;
    }

    public void postDeploy(String applicationName) throws WSDeploymentException, WSWarningException {
        ClassLoader appLoader = WSContainer.getServiceContext().getCoreContext().getLoadContext().getClassLoader(applicationName);
        this.notifyProtocolsOnPostDeploy(applicationName, appLoader);
    }

    public void commitDeploy(String applicationName) throws WSWarningException {
        this.notifyProtocolsOnCommitDeploy(applicationName);
    }

    public void rollbackDeploy(String applicationName) throws WSWarningException {
        Vector warnings = new Vector();
        try {
            this.notifyProtocolsOnRollback(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.removeWSClientsDir(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void remove(String applicationName) throws WSWarningException {
        Vector warnings = new Vector();
        try {
            this.notifyProtocolsOnRemove(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.removeWSClientsDir(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void notifyProtocolsOnDeploy(String applicationName, WSClientRuntimeInfo[] wsClientRuntimeInfoes, Configuration appConfiguration) throws WSWarningException {
        WSClientsDeployContext wsClientsDeployContext = new WSClientsDeployContext(applicationName, wsClientRuntimeInfoes, (Service[])new ServiceBaseServer[0], appConfiguration);
        this.deployContext.put((Object)applicationName, (Object)wsClientsDeployContext);
        this.wsClientProtocolNotificator.onDeploy(wsClientRuntimeInfoes, appConfiguration);
    }

    public void notifyProtocolsOnPostDeploy(String applicationName, ClassLoader appLoader) throws WSWarningException {
        String excMsg = "Error occurred, trying to notify protocols on " + WSClientProtocolNotificator.getModeName(1) + " phase for application " + applicationName + ". ";
        WSClientsDeployContext wsClientsDeployContext = (WSClientsDeployContext)this.deployContext.get((Object)applicationName);
        if (wsClientsDeployContext == null) {
            return;
        }
        WSClientRuntimeInfo[] wsClientRuntimeInfoes = wsClientsDeployContext.getWsClientRuntimeInfos();
        Vector warnings = new Vector();
        Hashtable wsClientsToServicesMapping = this.getServiceInstances(wsClientRuntimeInfoes, appLoader, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        WSClientRuntimeInfo[] wsClientRuntimeInfoForProcessing = this.getWSClients(wsClientsToServicesMapping);
        Service[] services = this.getServiceInstances(wsClientsToServicesMapping);
        wsClientsDeployContext.setWsClientRuntimeInfos(wsClientRuntimeInfoForProcessing);
        wsClientsDeployContext.setServices(services);
        try {
            this.wsClientProtocolNotificator.onPostDeploy(wsClientsDeployContext.getWsClientRuntimeInfos(), (ServiceBaseServer[])services, wsClientsDeployContext.getAppConfiguration());
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void notifyProtocolsOnCommitDeploy(String applicationName) throws WSWarningException {
        this.notifyProtocolsOnShortPhases(applicationName, 2);
    }

    public void notifyProtocolsOnRollback(String applicationName) throws WSWarningException {
        Vector warnings = new Vector();
        try {
            this.notifyProtocolsOnShortPhases(applicationName, 3);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.removeWSClientsDir(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void notifyProtocolsOnRemove(String applicationName) throws WSWarningException {
        this.wsClientProtocolNotificator.onRemove(applicationName);
    }

    private void notifyProtocolsOnShortPhases(String applicationName, int mode) throws WSWarningException {
        WSClientsDeployContext wsClientsDeployContext = (WSClientsDeployContext)this.deployContext.remove((Object)applicationName);
        if (wsClientsDeployContext == null) {
            return;
        }
        switch (mode) {
            case 2: {
                this.wsClientProtocolNotificator.onCommitDeploy(wsClientsDeployContext.getWsClientRuntimeInfos(), (ServiceBaseServer[])wsClientsDeployContext.getServices());
                break;
            }
            case 3: {
                String[] wsClientNames = this.wsClientsDeployGenerator.getWSClientNames(wsClientsDeployContext.getWsClientRuntimeInfos());
                String[][] protocolIds = new String[][]{};
                ServiceBaseServer[] services = (ServiceBaseServer[])wsClientsDeployContext.getServices();
                protocolIds = services == null || services.length == 0 ? this.multiply(WSContainer.getComponentFactory().listClientProtocolIds(), wsClientNames.length) : this.getServiceProtocols((ServiceBaseServer[])wsClientsDeployContext.getServices());
                this.wsClientProtocolNotificator.onRollbackDeploy(applicationName, wsClientNames, protocolIds);
                break;
            }
        }
    }

    private Hashtable getServiceInstances(WSClientRuntimeInfo[] wsClientRuntimeInfoes, ClassLoader appLoader, Vector warnings) {
        String excMsg = "Error occured, instantiating ws clients service instances. ";
        if (wsClientRuntimeInfoes == null) {
            return new Hashtable();
        }
        ServiceFactory serviceFactory = new ServiceFactory();
        Hashtable<WSClientRuntimeInfo, Service> wsClientsToServicesMapping = new Hashtable<WSClientRuntimeInfo, Service>();
        int i = 0;
        while (i < wsClientRuntimeInfoes.length) {
            WSClientRuntimeInfo wsClientRuntimeInfo = wsClientRuntimeInfoes[i];
            WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
            Service service = null;
            try {
                service = serviceFactory.getServiceInstance(wsClientRuntimeInfo, appLoader);
                wsClientsToServicesMapping.put(wsClientRuntimeInfo, service);
            }
            catch (WSDeploymentException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                String msg = excMsg + "Unable to instantiat service instance for ws client: application name:  " + wsClientId.getApplicationName() + ", ws client " + wsClientId.getServiceRefName() + ". ";
                warnings.add(msg);
            }
            ++i;
        }
        return wsClientsToServicesMapping;
    }

    private Service[] getServiceInstances(Hashtable wsClientsToServicesMapping) {
        if (wsClientsToServicesMapping == null) {
            return new ServiceBaseServer[0];
        }
        ServiceBaseServer[] services = new ServiceBaseServer[wsClientsToServicesMapping.size()];
        Enumeration servicesEnum = wsClientsToServicesMapping.elements();
        int i = 0;
        while (servicesEnum.hasMoreElements()) {
            services[i++] = (ServiceBaseServer)servicesEnum.nextElement();
        }
        return services;
    }

    private WSClientRuntimeInfo[] getWSClients(Hashtable wsClientsToServicesMapping) {
        if (wsClientsToServicesMapping == null) {
            return new WSClientRuntimeInfo[0];
        }
        WSClientRuntimeInfo[] wsClientRuntimeInfoes = new WSClientRuntimeInfo[wsClientsToServicesMapping.size()];
        Enumeration wsClientIdsEnum = wsClientsToServicesMapping.keys();
        int i = 0;
        while (wsClientIdsEnum.hasMoreElements()) {
            wsClientRuntimeInfoes[i++] = (WSClientRuntimeInfo)wsClientIdsEnum.nextElement();
        }
        return wsClientRuntimeInfoes;
    }

    private String[][] getServiceProtocols(ServiceBaseServer[] services) {
        if (services == null) {
            return new String[0][0];
        }
        String[][] protocols = new String[services.length][];
        int i = 0;
        while (i < protocols.length) {
            protocols[i] = this.wsClientProtocolNotificator.getProtocols(services[i].getUsedProtocols());
            ++i;
        }
        return protocols;
    }

    public void removeWSClientsDir(String applicationName) throws WSWarningException {
        String excMsg = "Error occured, deleting wsClients directory. ";
        String wsClientsDir = null;
        boolean isWSClientsDirDeleted = false;
        try {
            String wsContainerDir = WSContainer.getWSDeployer().getWSContainerDir(applicationName, 0);
            wsClientsDir = WSClientDirsHandler.getWSClientsDir(wsContainerDir);
            isWSClientsDirDeleted = IOUtil.deleteDir(wsClientsDir);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            String msg = null;
            msg = wsClientsDir != null ? excMsg + "Unable to get " + wsClientsDir + " directory. " : excMsg + "Unable to get " + "wsClients" + " directory. ";
            msg = msg + "Reason is: " + e.getLocalizedMessage();
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
        if (!isWSClientsDirDeleted) {
            String msg = null;
            msg = wsClientsDir != null ? excMsg + "Unable to get " + wsClientsDir + " directory. " : excMsg + "Unable to get " + "wsClients" + " directory. ";
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
    }

    private String[][] multiply(String[] str, int size) {
        if (size <= 0) {
            return new String[0][0];
        }
        String[][] strs = new String[size][];
        int i = 0;
        while (i < size) {
            strs[i] = str;
            ++i;
        }
        return strs;
    }

    public File[] collectWSClientsModuleArchives(File[] moduleArchives) throws WSDeploymentException {
        String excMsg = "Error occured, trying to collect module archives with ws clients. ";
        if (moduleArchives == null) {
            return new File[0];
        }
        Vector<File> wsClientsModuleArchives = new Vector<File>();
        int i = 0;
        while (i < moduleArchives.length) {
            File moduleArchive = moduleArchives[i];
            try {
                if (WSClientsFactory.containsWSClients(moduleArchive)) {
                    wsClientsModuleArchives.add(moduleArchive);
                }
            }
            catch (IOException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                Object[] args = new String[]{excMsg, "none"};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            ++i;
        }
        Object[] wsClientsModuleArchivesArr = new File[wsClientsModuleArchives.size()];
        wsClientsModuleArchives.copyInto(wsClientsModuleArchivesArr);
        return wsClientsModuleArchivesArr;
    }
}

