/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.wsclient;

import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientIdentifier;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientRuntimeInfo;
import com.sap.engine.services.webservices.server.deploy.common.AppDeployInfo;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDeployGenerator;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDeployResult;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDirsHandler;
import com.sap.engine.services.webservices.server.deploy.common.ModuleFileStorageHandler;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientChecker;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientDeploymentInfo;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientFileStorageHandler;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientOutsideSettingsProcessor;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientProxyGenerator;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsDeployResult;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsFactory;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsUtil;
import com.sap.engine.services.webservices.server.deploy.wsclient.deploy.WSClientsAppDeployResult;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class WSClientsDeployGenerator {
    private WSClientFileStorageHandler wsClientFileStorageHandler = new WSClientFileStorageHandler();
    private ModuleDeployGenerator moduleDeployGenerator = null;
    private ModuleFileStorageHandler moduleFileStorageHandler = null;

    public WSClientsDeployGenerator(ModuleDeployGenerator moduleDeployGenerator, ModuleFileStorageHandler moduleFileStorageHandler) {
        this.moduleDeployGenerator = moduleDeployGenerator;
        this.moduleFileStorageHandler = moduleFileStorageHandler;
    }

    public WSClientsAppDeployResult generateDeployFiles(String wsClientsDir, String wsClientsWorkingDir, AppDeployInfo appDeployInfo, File[] wsClientsModuleArchives) throws WSDeploymentException {
        if (wsClientsModuleArchives == null) {
            return new WSClientsAppDeployResult();
        }
        Vector wsWarnings = new Vector();
        WSClientsDeployResult wsClientsDeployResult = this.generateWSClientsDeployFiles(wsClientsDir, wsClientsWorkingDir, appDeployInfo, wsClientsModuleArchives, wsWarnings);
        if (wsClientsDeployResult.getDeployedComponentNames() == null || wsClientsDeployResult.getDeployedComponentNames().length == 0) {
            WSClientsAppDeployResult wsClientsAppDeployResult = new WSClientsAppDeployResult();
            wsClientsAppDeployResult.setWsClientsDeployResult(wsClientsDeployResult);
            return wsClientsAppDeployResult;
        }
        ModuleDeployResult moduleDeployResult = this.moduleDeployGenerator.generateAndSaveModuleDeployFiles(appDeployInfo.getApplicationName(), wsClientsDir, wsClientsModuleArchives);
        WSClientsAppDeployResult wsClientsAppDeployResult = new WSClientsAppDeployResult();
        wsClientsAppDeployResult.setModuleDeployResult(moduleDeployResult);
        wsClientsAppDeployResult.setWsClientsDeployResult(wsClientsDeployResult);
        wsClientsAppDeployResult.addWarnings(wsWarnings);
        return wsClientsAppDeployResult;
    }

    private WSClientDeploymentInfo[] loadWSClients(String wsClientsWorkingDir, String wsClientsDeployDir, AppDeployInfo appDeployInfo, File[] moduleArchives, Vector warnings) {
        WSClientDeploymentInfo[] wsClientDeploymentInfos = new WSClientDeploymentInfo[]{};
        int i = 0;
        while (i < moduleArchives.length) {
            File moduleArchive = moduleArchives[i];
            WSClientDeploymentInfo[] currentWSClientDeploymentInfos = this.loadWSClients(wsClientsWorkingDir, wsClientsDeployDir, appDeployInfo, moduleArchive, warnings);
            wsClientDeploymentInfos = this.unifyWSClientRuntimeInfos(new WSClientDeploymentInfo[][]{wsClientDeploymentInfos, currentWSClientDeploymentInfos});
            ++i;
        }
        return wsClientDeploymentInfos;
    }

    private WSClientDeploymentInfo[] loadWSClients(String wsClientsWorkingDir, String wsClientsDeployDir, AppDeployInfo appDeployInfo, File moduleArchive, Vector warnings) {
        String applicationName = appDeployInfo.getApplicationName();
        String excMsg = "Error occurred, trying to load ws clients for application: " + applicationName + ", module: " + moduleArchive.getName() + ". ";
        WSClientDeploymentInfo[] wsClientDeploymentInfos = new WSClientDeploymentInfo[]{};
        wsClientDeploymentInfos = new WSClientsFactory().loadWSClientDeploymentInfos(wsClientsWorkingDir, wsClientsDeployDir, appDeployInfo.getApplicationName(), moduleArchive, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        return wsClientDeploymentInfos;
    }

    private WSClientsDeployResult generateWSClientsDeployFiles(String wsClientsDir, String wsClientsWorkingDir, AppDeployInfo appDeployInfo, File[] wsClientsModuleArchives, Vector warnings) throws WSDeploymentException {
        String excMsg = "Error occured, trying to generate ws clients deploy files for applicaiton " + appDeployInfo.getApplicationName() + ". ";
        WSClientsDeployResult wsClientsDeployResult = this.generateWSClientsDeployFiles0(wsClientsDir, wsClientsWorkingDir, appDeployInfo, wsClientsModuleArchives, warnings);
        try {
            if (wsClientsDeployResult.getDeployedComponentNames() != null && wsClientsDeployResult.getDeployedComponentNames().length != 0) {
                this.moduleFileStorageHandler.saveDeployedComponentsPerModule(wsClientsDir, wsClientsDeployResult.getDeployedWSPerModule());
            }
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsClientsDeployResult;
    }

    public WSClientsDeployResult generateWSClientsDeployFiles0(String wsClientsDir, String wsClientsWorkingDir, AppDeployInfo appDeployInfo, File[] wsClientsModuleArchives, Vector warnings) throws WSDeploymentException {
        String excMsg = "Error occured, trying to generate ws clients deploy files for applicaiton " + appDeployInfo.getApplicationName() + ". ";
        try {
            this.prepareWSClientsDirsForDeploy(new String[]{wsClientsDir, wsClientsWorkingDir});
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        Vector newWarnings = new Vector();
        WSClientDeploymentInfo[] wsClientDeploymentInfos = this.loadWSClients(wsClientsWorkingDir, wsClientsDir, appDeployInfo, wsClientsModuleArchives, newWarnings);
        warnings.addAll(WSUtil.addPrefixToStrings(excMsg, newWarnings));
        if (wsClientDeploymentInfos == null || wsClientDeploymentInfos.length == 0) {
            return new WSClientsDeployResult();
        }
        return this.generateWSClientsDeployFiles(wsClientsDir, wsClientsWorkingDir, appDeployInfo, wsClientDeploymentInfos, new String[0], -1, new int[0]);
    }

    public WSClientsDeployResult generateWSClientsDeployFiles630(String wsClientsDir, String wsClientsWorkingDir, AppDeployInfo appDeployInfo, WSClientDeploymentInfo[] wsClientDeploymentInfoes, String[] additionalWSClientNames) throws WSDeploymentException {
        WSClientsFactory.setDefaultMappings(wsClientsDir, wsClientsWorkingDir, wsClientDeploymentInfoes);
        return this.generateWSClientsDeployFiles0(wsClientsDir, wsClientsWorkingDir, appDeployInfo, wsClientDeploymentInfoes, additionalWSClientNames);
    }

    public WSClientsDeployResult generateWSClientsDeployFiles(String wsClientsDir, String wsClientsWorkingDir, AppDeployInfo appDeployInfo, WSClientDeploymentInfo[] wsClientDeploymentInfos, String[] additionalWSClientNames, int maxIndex, int[] freeIndexes) throws WSDeploymentException {
        WSClientsFactory.setMappings(wsClientsDir, wsClientsWorkingDir, wsClientDeploymentInfos, maxIndex, freeIndexes);
        return this.generateWSClientsDeployFiles0(wsClientsDir, wsClientsWorkingDir, appDeployInfo, wsClientDeploymentInfos, additionalWSClientNames);
    }

    public WSClientsDeployResult generateWSClientsDeployFiles0(String wsClientsDir, String wsClientsWorkingDir, AppDeployInfo appDeployInfo, WSClientDeploymentInfo[] wsClientDeploymentInfos, String[] additionalWSClientNames) throws WSDeploymentException {
        String excMsg = "Error occured, trying to generate ws clients deploy files for applicaiton " + appDeployInfo.getApplicationName() + ". ";
        try {
            new WSClientChecker().checkWSClients(wsClientDeploymentInfos, additionalWSClientNames);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        this.generateSingleWSClientDeployFiles(appDeployInfo, wsClientsDir, wsClientDeploymentInfos, wsClientsWorkingDir);
        return this.defineWsClientsDeployResult(wsClientDeploymentInfos);
    }

    private void generateSingleWSClientDeployFiles(AppDeployInfo appDeployInfo, String wsClientsDir, WSClientDeploymentInfo[] wsClientDeploymentInfos, String wsClientsWorkingDir) throws WSDeploymentException {
        if (wsClientDeploymentInfos == null) {
            return;
        }
        int i = 0;
        while (i < wsClientDeploymentInfos.length) {
            WSClientDeploymentInfo wsClientDeploymentInfo = wsClientDeploymentInfos[i];
            this.generateSingleWSClientDeployFiles(wsClientsDir, wsClientsWorkingDir, wsClientDeploymentInfo, appDeployInfo);
            ++i;
        }
    }

    private void generateSingleWSClientDeployFiles(String wsClientsDir, String wsClientsWorkingDir, WSClientDeploymentInfo wsClientDeploymentInfo, AppDeployInfo appDeployInfo) throws WSDeploymentException {
        WSClientIdentifier wsClientIdentifier = wsClientDeploymentInfo.getWsClientId();
        String excMsg = "Error occured, trying to generate deployment files for ws client " + wsClientIdentifier.getServiceRefName() + ", application " + wsClientIdentifier.getApplicationName() + ". ";
        try {
            this.clearDirs(new String[]{wsClientDeploymentInfo.getWsClientDirsHandler().getWsClientDirectory(), wsClientDeploymentInfo.getWsClientWorkingDir()});
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        try {
            new WSClientOutsideSettingsProcessor().setComponentJndiNames(appDeployInfo.getWebMappings(), wsClientDeploymentInfo);
            this.wsClientFileStorageHandler.saveWSClientsDeployFiles(wsClientDeploymentInfo);
            new WSClientProxyGenerator().generateAndPackageProxyFiles(wsClientsDir, wsClientDeploymentInfo, wsClientsWorkingDir, wsClientDeploymentInfo.getModuleArchive(), appDeployInfo.getLoader());
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    private void prepareWSClientsDirsForDeploy(String[] dirs) throws WSDeploymentException {
        if (dirs == null) {
            return;
        }
        int i = 0;
        while (i < dirs.length) {
            String dir = dirs[i];
            this.prepareWSClientsDirForDeploy(dir);
            ++i;
        }
    }

    private void prepareWSClientsDirForDeploy(String wsClientsDir) throws WSDeploymentException {
        String excMsg = "Unable to deploy ws clients. Directory " + wsClientsDir + " is not empty and its subtree could not be deleted. ";
        try {
            IOUtil.deleteDirSubTree(wsClientsDir);
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(excMsg, (Throwable)e);
            Object[] args = new String[]{excMsg, "not available"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        boolean isEmptyDir = false;
        try {
            isEmptyDir = IOUtil.isEmptyDir(wsClientsDir);
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(excMsg, (Throwable)e);
            Object[] args = new String[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        if (!isEmptyDir) {
            Object[] args = new String[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args);
        }
    }

    public String[] constructDeployedWSClientNames(String[] wsClientNames) {
        return WSUtil.addPrefixToStrings("WS CLIENT: ", wsClientNames);
    }

    private String getModuleFileForClassLoader(String wsClientsDir, String moduleName) {
        String moduleExtension = IOUtil.getFileExtension(moduleName);
        if (moduleExtension.equals(".wsar")) {
            return ModuleDirsHandler.getModuleJarPath(wsClientsDir, moduleName);
        }
        return null;
    }

    private String[] getModuleFilesForClassLoader(String wsClientsDir, String[] moduleNames) {
        if (moduleNames == null) {
            return new String[0];
        }
        String[] allFilesForClassLoader = new String[]{};
        int i = 0;
        while (i < moduleNames.length) {
            String moduleFileForClassLoader = this.getModuleFileForClassLoader(wsClientsDir, moduleNames[i]);
            if (moduleFileForClassLoader != null) {
                allFilesForClassLoader = WSUtil.unifyStrings(new String[][]{allFilesForClassLoader, {moduleFileForClassLoader}});
            }
            ++i;
        }
        return allFilesForClassLoader;
    }

    private String[] getFilesForClassLoader(WSClientRuntimeInfo[] wsClientRuntimeInfos) {
        if (wsClientRuntimeInfos == null) {
            return new String[0];
        }
        String[] filesForClassLoader = new String[wsClientRuntimeInfos.length];
        int i = 0;
        while (i < wsClientRuntimeInfos.length) {
            WSClientRuntimeInfo wsClientRuntimeInfo = wsClientRuntimeInfos[i];
            filesForClassLoader[i] = wsClientRuntimeInfo.getWsClientDirsHandler().getJarPath();
            ++i;
        }
        return filesForClassLoader;
    }

    private WSClientDeploymentInfo[] unifyWSClientRuntimeInfos(WSClientDeploymentInfo[][] wsClientDeploymentInfos) {
        if (wsClientDeploymentInfos == null) {
            return new WSClientDeploymentInfo[0];
        }
        WSClientDeploymentInfo[] resultWSClientDeploymentInfos = new WSClientDeploymentInfo[]{};
        int i = 0;
        while (i < wsClientDeploymentInfos.length) {
            WSClientDeploymentInfo[] currentWSClientDeploymentInfos = wsClientDeploymentInfos[i];
            WSClientDeploymentInfo[] tempWsClientDeploymentInfos = new WSClientDeploymentInfo[resultWSClientDeploymentInfos.length + currentWSClientDeploymentInfos.length];
            System.arraycopy(resultWSClientDeploymentInfos, 0, tempWsClientDeploymentInfos, 0, resultWSClientDeploymentInfos.length);
            System.arraycopy(currentWSClientDeploymentInfos, 0, tempWsClientDeploymentInfos, resultWSClientDeploymentInfos.length, currentWSClientDeploymentInfos.length);
            resultWSClientDeploymentInfos = tempWsClientDeploymentInfos;
            ++i;
        }
        return resultWSClientDeploymentInfos;
    }

    private Hashtable collectWSClientDeploymentInfoesPerModule(WSClientRuntimeInfo[] wsClientRuntimeInfoes) {
        Vector wsClientRuntimeInfoesPerSingleModule;
        String moduleName;
        if (wsClientRuntimeInfoes == null) {
            return new Hashtable();
        }
        Hashtable<String, Object> wsClientRuntimeInfoesPerModule = new Hashtable<String, Object>();
        int i = 0;
        while (i < wsClientRuntimeInfoes.length) {
            WSClientRuntimeInfo wsClientRuntimeInfo = wsClientRuntimeInfoes[i];
            moduleName = wsClientRuntimeInfo.getWsClientId().getJarName();
            if (wsClientRuntimeInfoesPerModule.containsKey(moduleName)) {
                wsClientRuntimeInfoesPerSingleModule = (Vector)wsClientRuntimeInfoesPerModule.get(moduleName);
                wsClientRuntimeInfoesPerSingleModule.add(wsClientRuntimeInfo);
            } else {
                wsClientRuntimeInfoesPerSingleModule = new Vector();
                wsClientRuntimeInfoesPerSingleModule.add(wsClientRuntimeInfo);
                wsClientRuntimeInfoesPerModule.put(moduleName, wsClientRuntimeInfoesPerSingleModule);
            }
            ++i;
        }
        Enumeration enumeration = wsClientRuntimeInfoesPerModule.keys();
        while (enumeration.hasMoreElements()) {
            moduleName = (String)enumeration.nextElement();
            wsClientRuntimeInfoesPerSingleModule = (Vector)wsClientRuntimeInfoesPerModule.get(moduleName);
            Object[] wsClientRuntimeInfoesPerSingleModuleArr = new WSClientRuntimeInfo[wsClientRuntimeInfoesPerSingleModule.size()];
            wsClientRuntimeInfoesPerSingleModule.copyInto(wsClientRuntimeInfoesPerSingleModuleArr);
            wsClientRuntimeInfoesPerModule.put(moduleName, wsClientRuntimeInfoesPerSingleModuleArr);
        }
        return wsClientRuntimeInfoesPerModule;
    }

    private Properties collectDeployedWSClientNamesPerModule(Hashtable deployedWSClientRuntimeInfoesPerModule) {
        if (deployedWSClientRuntimeInfoesPerModule == null) {
            new Properties();
        }
        Properties deployedWSClientNamesPerModule = new Properties();
        Enumeration enumeration = deployedWSClientRuntimeInfoesPerModule.keys();
        while (enumeration.hasMoreElements()) {
            String moduleName = (String)enumeration.nextElement();
            WSClientRuntimeInfo[] wsClientRuntimeInfoes = (WSClientRuntimeInfo[])deployedWSClientRuntimeInfoesPerModule.get(moduleName);
            String[] wsClientNames = this.getWSClientNames(wsClientRuntimeInfoes);
            deployedWSClientNamesPerModule.setProperty(moduleName, WSUtil.concatStrings(wsClientNames, ";"));
        }
        return deployedWSClientNamesPerModule;
    }

    public String[] getWSClientNames(WSClientRuntimeInfo[] wsClientRuntimeInfoes) {
        if (wsClientRuntimeInfoes == null) {
            return new String[0];
        }
        String[] wsClientNames = new String[wsClientRuntimeInfoes.length];
        int i = 0;
        while (i < wsClientRuntimeInfoes.length) {
            wsClientNames[i] = wsClientRuntimeInfoes[i].getWsClientId().getServiceRefName();
            ++i;
        }
        return wsClientNames;
    }

    public WSClientsDeployResult defineWsClientsDeployResult(WSClientDeploymentInfo[] wsClientDeploymentInfos) {
        WSClientsDeployResult wsClientsDeployResult = new WSClientsDeployResult();
        wsClientsDeployResult.setDeployedWSPerModule(this.collectDeployedWSClientNamesPerModule(this.collectWSClientDeploymentInfoesPerModule(wsClientDeploymentInfos)));
        wsClientsDeployResult.setFilesForClassLoader(this.getFilesForClassLoader(wsClientDeploymentInfos));
        wsClientsDeployResult.setDeployedComponentNames(this.constructDeployedWSClientNames(WSClientsUtil.collectWSClientNames(wsClientDeploymentInfos)));
        wsClientsDeployResult.setWsClientRuntimeInfoes(wsClientDeploymentInfos);
        return wsClientsDeployResult;
    }

    public void clearDirs(String[] dirs) throws WSDeploymentException {
        String excMsg = "Unable to clear directories ( " + WSUtil.concatStrings(dirs, ";") + "). ";
        boolean areDirsDeleted = false;
        try {
            areDirsDeleted = IOUtil.deleteDirs(dirs);
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg;
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
        if (!areDirsDeleted) {
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args);
        }
    }
}

