/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.wsclient;

import com.sap.engine.interfaces.ejb.monitor.EJBManager;
import com.sap.engine.interfaces.ejb.monitor.EJBManagerException;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.wsclient.ComponentDescriptor;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientIdentifier;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientRuntimeInfo;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.tc.logging.Location;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.xml.rpc.Service;

public class WSClientRuntimetHelper {
    public static String getServiceJndiName(WSClientIdentifier wsClientId) {
        return wsClientId.getApplicationName() + "/" + wsClientId.getServiceRefName();
    }

    public static String getServiceJndiNameInRootCtx(WSClientIdentifier wsClientId) {
        return "wsclients/proxies/" + WSClientRuntimetHelper.getServiceJndiName(wsClientId);
    }

    public void bindServiceInstance(WSClientIdentifier wsClientId, Service service) throws WSDeploymentException {
        String serviceJndiName = WSClientRuntimetHelper.getServiceJndiName(wsClientId);
        String excMsg = "Unable to bind service instance in jndi with name " + serviceJndiName + ". ";
        try {
            Context proxiesCtx = (Context)new InitialContext().lookup("wsclients/proxies");
            WSUtil.rebind(proxiesCtx, serviceJndiName, service);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(excMsg, (Throwable)e);
            Object[] args = new String[]{excMsg, wsClientId.getApplicationName(), wsClientId.getJarName(), wsClientId.getServiceRefName()};
            throw new WSDeploymentException(excMsg, args, (Throwable)e);
        }
    }

    public void unbindServiceInstance(WSClientIdentifier wsClientId) throws WSDeploymentException {
        String serviceJndiName = WSClientRuntimetHelper.getServiceJndiName(wsClientId);
        String excMsg = "Unable to unbind service instance from jndi with name " + serviceJndiName + ". ";
        try {
            Context proxiesCtx = (Context)new InitialContext().lookup("wsclients/proxies");
            WSUtil.unbind(proxiesCtx, serviceJndiName);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(excMsg, (Throwable)e);
            Object[] args = new String[]{excMsg, wsClientId.getApplicationName(), wsClientId.getJarName(), wsClientId.getServiceRefName()};
            throw new WSDeploymentException(excMsg, args, (Throwable)e);
        }
    }

    public void bindServiceInstanceLinkReference(WSClientRuntimeInfo wsClientRuntimeInfo) throws WSDeploymentException {
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String version = wsClientRuntimeInfo.getVersion();
        String moduleExtension = IOUtil.getFileExtension(wsClientId.getJarName());
        if (version.equals("6.30") && moduleExtension.equals(".jar")) {
            this.registerServiceInstanceEJBLinkReference(wsClientRuntimeInfo);
        }
    }

    public void registerServiceInstanceEJBLinkReference(WSClientRuntimeInfo wsClientRuntimeInfo) throws WSDeploymentException {
        String excMsg = "Error occured trying to set ejb link reference to ws client service instance. ";
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        EJBManager ejbManager = WSContainer.getInterfaceContext().getEjbManager();
        if (ejbManager == null) {
            String msg = excMsg + "Unable to get EJBManager. ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args);
        }
        try {
            ComponentDescriptor[] componentDescriptors = wsClientRuntimeInfo.getComponentDescriptors();
            if (componentDescriptors == null) {
                return;
            }
            String serviceJndiName = WSClientRuntimetHelper.getServiceJndiNameInRootCtx(wsClientId);
            int i = 0;
            while (i < componentDescriptors.length) {
                ComponentDescriptor componentDescriptor = componentDescriptors[i];
                String beanJndiName = componentDescriptor.getJndiName();
                Reference serviceLinkReference = WSUtil.getLinkReference(serviceJndiName);
                ejbManager.addReferencedObject(wsClientId.getApplicationName(), beanJndiName, wsClientRuntimeInfo.getLinkServiceRefName(), (Object)serviceLinkReference);
                ++i;
            }
        }
        catch (EJBManagerException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(excMsg, (Throwable)e);
            Object[] args = new String[]{excMsg, wsClientId.getApplicationName(), wsClientId.getJarName(), wsClientId.getServiceRefName()};
            throw new WSDeploymentException("webservices_5042", args, (Throwable)e);
        }
    }
}

