/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.wsclient;

import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.interfaces.webservices.client.ClientFeatureProvider;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.jaxrpc.util.PackageBuilder;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientTransportBinding;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGenerator;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGeneratorConfig;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPorts;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientIdentifier;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientRuntimeInfo;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDirsHandler;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.jar.JarUtil;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientDeploymentInfo;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientDirsHandler;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientFileStorageHandler;
import com.sap.engine.services.webservices.wsdl.WSDLDOMLoader;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class WSClientProxyGenerator {
    public void generateAndPackageProxyFiles(String wsClientsDir, WSClientDeploymentInfo wsClientDeploymentInfo, String wsClientsWorkingDir, File moduleArchive, ClassLoader earLoader) throws WSDeploymentException {
        String excMsg = "Error occured generating ws client proxy files. ";
        String generatedDir = WSClientDirsHandler.getWSClientGeneratedDir(wsClientDeploymentInfo.getWsClientWorkingDir());
        new File(generatedDir).mkdirs();
        try {
            this.generateProxy(wsClientsDir, generatedDir, wsClientDeploymentInfo);
            this.compileAndPackageWSClientProxyFiles(wsClientDeploymentInfo, wsClientsWorkingDir, generatedDir, moduleArchive, earLoader);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = excMsg + "Package error. ";
            wsDeployLocation.catching(msg, (Throwable)e);
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    public void generateProxy(String wsClientsDir, String generatedDir, WSClientRuntimeInfo wsClientRuntimeInfo) throws WSDeploymentException {
        String excMessage = "Error occured generating proxy files for ws client. ";
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String packageName = wsClientRuntimeInfo.getPackageName();
        String[] wsdlFileNames = wsClientRuntimeInfo.getWsdlFullFileNames();
        boolean hasLogPortsFile = wsClientRuntimeInfo.hasLogicalPortsFile();
        String logPortsFileName = null;
        if (hasLogPortsFile) {
            logPortsFileName = wsClientRuntimeInfo.getLogicalPortsFullFileName();
        }
        boolean hasUriMappings = wsClientRuntimeInfo.hasUriMappingFiles();
        Properties[] uriMappingProps = new Properties[]{};
        Properties packageMappingProps = new Properties();
        try {
            if (hasUriMappings) {
                uriMappingProps = this.loadUriMappingProps(wsClientRuntimeInfo.getUriMappingFullFileNames());
            }
            packageMappingProps = this.loadPackageMappingProps(wsClientRuntimeInfo.getPackageMappingFullFileName());
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(excMessage, (Throwable)e);
            Object[] args = new String[]{excMessage, wsClientId.getApplicationName(), wsClientId.getJarName(), wsClientId.getServiceRefName()};
            throw new WSDeploymentException("webservices_5042", args, (Throwable)e);
        }
        ClientTransportBinding[] clientTransportBindings = this.getClientTransportBindings();
        ProxyGenerator proxyGenerator = new ProxyGenerator();
        LogicalPorts logicalPorts = null;
        if (hasLogPortsFile) {
            try {
                WSDLDefinitions def = null;
                WSDLDOMLoader loader = new WSDLDOMLoader();
                int i = 0;
                while (i < wsdlFileNames.length) {
                    String wsdlFileName = wsdlFileNames[i];
                    Properties uriMappingProperties = new Properties();
                    if (hasUriMappings) {
                        uriMappingProperties = uriMappingProps[i];
                    }
                    WSDLDefinitions newDef = loader.loadMirrorWSDLDocument(wsdlFileName, (Hashtable)uriMappingProperties);
                    if (def == null) {
                        def = newDef;
                    } else {
                        loader.joinWSDL(def, newDef);
                    }
                    ++i;
                }
                ProxyGeneratorConfig proxyGeneratorConfig = new ProxyGeneratorConfig(null, generatedDir, packageName);
                proxyGeneratorConfig.setServerHosted(true);
                proxyGeneratorConfig.setStubsOnly(true);
                proxyGeneratorConfig.setCompile(false);
                proxyGeneratorConfig.setLogicalPortName(new File(logPortsFileName).getName());
                proxyGeneratorConfig.setLogicalPortPath(new File(logPortsFileName).getParent());
                proxyGeneratorConfig.setDefinitions(def);
                proxyGeneratorConfig.setUriToPackageMapping(packageMappingProps);
                proxyGeneratorConfig.setBindings(clientTransportBindings);
                proxyGenerator.generateProxy(proxyGeneratorConfig);
                logicalPorts = proxyGeneratorConfig.getLogicalPorts();
            }
            catch (Exception e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching(excMessage, (Throwable)e);
                Object[] args = new String[]{excMessage, wsClientId.getApplicationName(), wsClientId.getJarName(), wsClientId.getServiceRefName()};
                throw new WSDeploymentException("webservices_5042", args, (Throwable)e);
            }
            try {
                new WSClientFileStorageHandler().saveLogicalPortsFile(wsClientRuntimeInfo, logicalPorts);
            }
            catch (Exception e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching(excMessage, (Throwable)e);
                Object[] args = new String[]{excMessage, wsClientId.getApplicationName(), wsClientId.getJarName(), wsClientId.getServiceRefName()};
                throw new WSDeploymentException("webservices_5042", args, (Throwable)e);
            }
        }
    }

    private Properties[] loadUriMappingProps(String[] uriMappingFileNames) throws WSDeploymentException {
        String excMessage = "Error occured loading uri mapping properties from uri mapping files. ";
        if (uriMappingFileNames == null) {
            return new Properties[0];
        }
        Properties[] uriMappingProps = new Properties[uriMappingFileNames.length];
        try {
            int i = 0;
            while (i < uriMappingFileNames.length) {
                Location wsDeployLocation;
                Object var9_11;
                String uriMappingFileName = uriMappingFileNames[i];
                Properties uriMappingProperties = new Properties();
                FileInputStream uriMappingInput = null;
                try {
                    uriMappingInput = new FileInputStream(uriMappingFileName);
                    uriMappingProperties = new Properties();
                    uriMappingProperties.load(uriMappingInput);
                    var9_11 = null;
                }
                catch (Throwable throwable) {
                    var9_11 = null;
                    wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    IOUtil.closeInputStreams(new InputStream[]{uriMappingInput}, new String[]{excMessage}, wsDeployLocation);
                    throw throwable;
                }
                wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                IOUtil.closeInputStreams(new InputStream[]{uriMappingInput}, new String[]{excMessage}, wsDeployLocation);
                uriMappingProps[i] = uriMappingProperties;
                ++i;
            }
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(excMessage, (Throwable)e);
            Object[] args = new String[]{excMessage};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return uriMappingProps;
    }

    private Properties loadPackageMappingProps(String packageMappingFileName) throws WSDeploymentException {
        String excMessage = "Error occured loading uri mapping properties from uri mapping files. ";
        if (packageMappingFileName == null) {
            return new Properties();
        }
        Properties packageMappingProps = new Properties();
        FileInputStream packageMappingInput = null;
        try {
            try {
                packageMappingInput = new FileInputStream(packageMappingFileName);
                packageMappingProps.load(packageMappingInput);
            }
            catch (IOException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching(excMessage, (Throwable)e);
                Object[] args = new String[]{excMessage};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            IOUtil.closeInputStreams(new InputStream[]{packageMappingInput}, new String[]{excMessage}, wsDeployLocation);
            throw throwable;
        }
        Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
        IOUtil.closeInputStreams(new InputStream[]{packageMappingInput}, new String[]{excMessage}, wsDeployLocation);
        return packageMappingProps;
    }

    private ClientTransportBinding[] getClientTransportBindings() {
        ClientFeatureProvider[] clientTrBindingsInterfaces = WSContainer.getComponentFactory().listClientransportBindingInterfaces();
        ClientTransportBinding[] clientTransportBindings = new ClientTransportBinding[clientTrBindingsInterfaces.length];
        int i = 0;
        while (i < clientTrBindingsInterfaces.length) {
            clientTransportBindings[i] = (ClientTransportBinding)clientTrBindingsInterfaces[i];
            ++i;
        }
        return clientTransportBindings;
    }

    private void compileAndPackageWSClientProxyFiles(WSClientDeploymentInfo wsClientDeploymentInfo, String wsClientsWorkingDir, String sourceDir, File moduleArchive, ClassLoader earLoader) throws WSDeploymentException {
        WSClientIdentifier wsClientId = wsClientDeploymentInfo.getWsClientId();
        this.compileWSClientProxyFile(wsClientId, wsClientsWorkingDir, sourceDir, moduleArchive, earLoader);
        this.packageWSClientProxyFiles(wsClientDeploymentInfo, sourceDir);
    }

    private void compileWSClientProxyFile(WSClientIdentifier wsClientId, String wsClientsWorkingDir, String sourceDir, File moduleArchive, ClassLoader earLoader) throws WSDeploymentException {
        String excMsg = "Error occured trying to compile ws client proxy files. ";
        String moduleWorkingDir = ModuleDirsHandler.getModuleWorkingDir(wsClientsWorkingDir, wsClientId.getJarName());
        try {
            this.extractModuleFilesForClassPath(moduleWorkingDir, moduleArchive);
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = excMsg + "Unable to extract additional files from module, used as additional classpath in compilation. ";
            wsDeployLocation.catching(msg, (Throwable)e);
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        String additionalModuleClassPath = this.getClassPathForModuleFiles(moduleWorkingDir, moduleArchive);
        String wsBaseClassPath = WSContainer.getWSDeployer().getJarsPath();
        String referencedPath = this.getReferencedPath(earLoader);
        String classPath = wsBaseClassPath + File.pathSeparatorChar + sourceDir + File.pathSeparatorChar + additionalModuleClassPath + File.pathSeparatorChar + referencedPath;
        try {
            new PackageBuilder().compile(classPath, new File(sourceDir));
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = excMsg + "Compilation error. ";
            wsDeployLocation.catching(msg, (Throwable)e);
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    private String getReferencedPath(ClassLoader earLoader) {
        if (earLoader instanceof ReferencedLoader) {
            StringBuffer refPath = new StringBuffer();
            ReferencedLoader refLoader = (ReferencedLoader)earLoader;
            String[] resources = refLoader.getResourceNames();
            if (resources != null) {
                int i = 0;
                while (i < resources.length) {
                    refPath.append(resources[i]);
                    refPath.append(File.pathSeparatorChar);
                    ++i;
                }
            }
            String[] refs = refLoader.getReferencesTo();
            LoadContext loadContext = WSContainer.getServiceContext().getCoreContext().getLoadContext();
            if (refs != null) {
                int i = 0;
                while (i < refs.length) {
                    String[] jarRefs;
                    ReferencedLoader rl = (ReferencedLoader)loadContext.getClassLoader(refs[i]);
                    if (rl != null && (jarRefs = rl.getResourceNames()) != null) {
                        int j = 0;
                        while (j < jarRefs.length) {
                            refPath.append(jarRefs[j]);
                            refPath.append(File.pathSeparatorChar);
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            return refPath.toString();
        }
        return "";
    }

    private void packageWSClientProxyFiles(WSClientRuntimeInfo wsClientRuntimeInfo, String sourceDir) throws WSDeploymentException {
        String excMsg = "Error occured trying to package ws client proxy files. ";
        String wsClientJarFileName = wsClientRuntimeInfo.getWsClientDirsHandler().getJarPath();
        IOUtil.createParentDir(new String[]{wsClientJarFileName});
        try {
            Vector<String> filters = new Vector<String>();
            filters.add("class");
            new JarUtils().makeJarFromDir(wsClientJarFileName, new String[]{sourceDir}, filters);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = excMsg + "Package error. ";
            wsDeployLocation.catching(msg, (Throwable)e);
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    private void extractModuleFilesForClassPath(String moduleWorkingDir, File moduleArchive) throws IOException {
        String moduleExtension = IOUtil.getFileExtension(moduleArchive);
        String extractJarName = ModuleDirsHandler.getModuleExtractPath(moduleWorkingDir, moduleArchive.getName());
        IOUtil.createParentDir(new String[]{extractJarName});
        if (moduleExtension.equals(".war")) {
            new JarUtil().makeJarFile(moduleArchive, new String[]{"WEB-INF/classes"}, new String[0], new String[0], new String[0], extractJarName);
        }
    }

    private String getClassPathForModuleFiles(String moduleWorkingDir, File moduleArchive) {
        String moduleExtension = IOUtil.getFileExtension(moduleArchive);
        String classPathDir = "";
        if (moduleExtension.equals(".jar")) {
            classPathDir = moduleArchive.getAbsolutePath();
        }
        if (moduleExtension.equals(".wsar")) {
            classPathDir = moduleArchive.getAbsolutePath();
        }
        if (moduleExtension.equals(".war")) {
            classPathDir = ModuleDirsHandler.getModuleExtractPath(moduleWorkingDir, moduleArchive.getName());
        }
        return classPathDir;
    }
}

