/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.wsclient;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.interfaces.webservices.client.ClientFeatureProvider;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.interfaces.webservices.server.deploy.wsclient.WSClientBaseContext;
import com.sap.engine.interfaces.webservices.server.deploy.wsclient.WSClientContext;
import com.sap.engine.interfaces.webservices.server.deploy.wsclient.WSClientDeploymentInterface;
import com.sap.engine.interfaces.webservices.server.deploy.wsclient.WSClientLCMInterface;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientProtocolAppStateEvents;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientProtocolDeployAppEvents;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientProtocolStartAppEvent;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.RuntimeInformation;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ServiceBaseServer;
import com.sap.engine.services.webservices.runtime.component.ComponentFactoryImpl;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientIdentifier;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientRuntimeInfo;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientBaseContextImpl;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientContextImpl;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class WSClientProtocolNotificator {
    public static final String[] SKIPPED_PROTOCOLS_LIST = new String[]{""};
    public static final int DEPLOY = 0;
    public static final int POST_DEPLOY = 1;
    public static final int COMMIT_DEPLOY = 2;
    public static final int ROLLBACK_DEPLOY = 3;
    public static final int REMOVE = 4;
    public static final int DOWNLOAD = 5;
    public static final int START = 6;
    public static final int COMMIT_START = 7;
    public static final int ROLLBACK_START = 8;
    public static final int STOP = 9;
    public static final int UPDATE = 10;
    public static final int POST_UPDATE = 11;
    public static final int COMMIT_UPDATE = 12;
    public static final int ROLLBACK_UPDATE = 13;

    public static String getModeName(int mode) {
        String modeName = "";
        switch (mode) {
            case 0: {
                modeName = "deploy";
                break;
            }
            case 1: {
                modeName = "post-deploy";
                break;
            }
            case 2: {
                modeName = "commit-deploy";
                break;
            }
            case 3: {
                modeName = "rollback-deploy";
                break;
            }
            case 4: {
                modeName = "download";
                break;
            }
            case 5: {
                modeName = "start";
                break;
            }
            case 6: {
                modeName = "commit-start";
                break;
            }
            case 7: {
                modeName = "rollback-start";
                break;
            }
            case 8: {
                modeName = "stop";
                break;
            }
            case 9: {
                modeName = "remove";
                break;
            }
            case 10: {
                modeName = "update";
                break;
            }
            case 11: {
                modeName = "post-update";
                break;
            }
            case 12: {
                modeName = "commit-update";
                break;
            }
            case 13: {
                modeName = "rollback-update";
            }
        }
        return modeName;
    }

    public void onDeploy(WSClientRuntimeInfo[] wsClientRuntimeInfoes, Configuration appConfiguration) throws WSWarningException {
        this.onLongNotificationPhases(wsClientRuntimeInfoes, new ServiceBaseServer[wsClientRuntimeInfoes.length], appConfiguration, 0);
    }

    public void onPostDeploy(WSClientRuntimeInfo[] wsClientRuntimeInfoes, ServiceBaseServer[] services, Configuration appConfiguration) throws WSWarningException {
        this.onLongNotificationPhases(wsClientRuntimeInfoes, services, appConfiguration, 1);
    }

    public void onCommitDeploy(WSClientRuntimeInfo[] wsClientRuntimeInfoes, ServiceBaseServer[] services) throws WSWarningException {
        this.onShortNotificationPhases(wsClientRuntimeInfoes, services, 2);
    }

    public void onRollbackDeploy(String applicationName, String[] wsClientNames, String[][] protocolIds) throws WSWarningException {
        this.onShortNotificationPhases(applicationName, wsClientNames, protocolIds, 3);
    }

    public void downloadFiles(String applicationName, String[] wsClientNames, String[] wsClientDirs, String[] wsClientConfigNames, Configuration appConfiguration) throws WSWarningException {
        String excMsg = "Error occurred, trying to initialize protocols on " + WSClientProtocolNotificator.getModeName(5) + "phase. ";
        Configuration[] wsClientConfigurations = null;
        try {
            wsClientConfigurations = this.getWSClientConfigurations(wsClientConfigNames, appConfiguration);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(excMsg);
            throw wExc;
        }
        this.downloadFiles(applicationName, wsClientNames, wsClientDirs, wsClientConfigurations);
    }

    public void downloadFiles(String applicationName, String[] wsClientNames, String[] wsClientDirs, Configuration[] wsClientConfigurations) throws WSWarningException {
        if (wsClientNames == null) {
            return;
        }
        Vector warnings = new Vector();
        int i = 0;
        while (i < wsClientNames.length) {
            try {
                this.downloadFiles(applicationName, wsClientNames[i], wsClientDirs[i], wsClientConfigurations[i]);
            }
            catch (WSWarningException e) {
                warnings.addAll(e.getWarningsVector());
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onStart(WSClientRuntimeInfo[] wsClientRuntimeInfoes, ServiceBaseServer[] services, Configuration appConfiguration) throws WSWarningException {
        this.onLongNotificationPhases(wsClientRuntimeInfoes, services, appConfiguration, 6);
    }

    public void onCommitStart(WSClientRuntimeInfo[] wsClientRuntimeInfoes, ServiceBaseServer[] services) throws WSWarningException {
        this.onShortNotificationPhases(wsClientRuntimeInfoes, services, 7);
    }

    public void onRollbackStart(String applicationName, String[] wsClientNames, String[][] protocolIds) throws WSWarningException {
        this.onShortNotificationPhases(applicationName, wsClientNames, protocolIds, 8);
    }

    public void onStop(WSClientRuntimeInfo[] wsClientRuntimeInfoes, ServiceBaseServer[] services) throws WSWarningException {
        this.onShortNotificationPhases(wsClientRuntimeInfoes, services, 9);
    }

    public void onRemove(String applicationName) throws WSWarningException {
        Hashtable filteredProtocols;
        String excMsg = "Unable to initialize ws client protocols on " + WSClientProtocolNotificator.getModeName(7) + " phase. Application " + applicationName + ". ";
        Vector warnings = new Vector();
        String[] protocolIds = WSContainer.getComponentFactory().listClientProtocolIds();
        Hashtable protocols = this.getProtocols(protocolIds, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        try {
            filteredProtocols = this.filterProtocols(protocols, 4);
            this.onRemove70(applicationName, filteredProtocols);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            filteredProtocols = this.filterProtocols630(protocols, 4);
            this.onRemove630(applicationName, filteredProtocols);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onDeploy(WSClientRuntimeInfo wsClientRuntimeInfo, Configuration wsClientConfiguration) throws WSWarningException {
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String excMsg = "Unable to initialize ws client protocols on " + WSClientProtocolNotificator.getModeName(0) + " phase. Application " + wsClientId.getApplicationName() + ", ws client " + wsClientId.getServiceRefName() + ". ";
        String[] protocolIds = WSContainer.getComponentFactory().listClientProtocolIds();
        if (protocolIds == null) {
            protocolIds = new String[]{};
        }
        Vector warnings = new Vector();
        Hashtable protocols = this.getProtocolsForNotification(protocolIds, 0, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        if (protocols.size() > 0) {
            WSClientBaseContextImpl wsClientBaseContext = new WSClientBaseContextImpl(wsClientRuntimeInfo);
            try {
                this.onLongNofiticationPhases(wsClientId.getApplicationName(), wsClientId.getServiceRefName(), wsClientRuntimeInfo.getWsClientDirsHandler().getWsClientDirectory(), protocols, wsClientBaseContext, wsClientConfiguration, 0);
            }
            catch (WSWarningException e) {
                warnings.addAll(e.getWarningsVector());
            }
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onPostDeploy(WSClientRuntimeInfo wsClientRuntimeInfo, ServiceBaseServer service, Configuration wsClientConfiguration) throws WSWarningException {
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String excMsg = "Unable to initialize ws client protocols on " + WSClientProtocolNotificator.getModeName(1) + " phase. Application " + wsClientId.getApplicationName() + ", ws client " + wsClientId.getServiceRefName() + ". ";
        Vector warnings = new Vector();
        String[] protocolIds = this.getProtocols(service.getUsedProtocols());
        Hashtable protocols = this.getProtocolsForNotification(protocolIds, 1, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        Hashtable wsClientContexts = this.getWSClientContexts(protocols.keys(), wsClientRuntimeInfo, service);
        try {
            this.onLongNotificationPhases(wsClientId.getApplicationName(), wsClientId.getServiceRefName(), wsClientRuntimeInfo.getWsClientDirsHandler().getWsClientDirectory(), protocols, wsClientContexts, wsClientConfiguration, 1);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onCommitDeploy(WSClientRuntimeInfo wsClientRuntimeInfo, ServiceBaseServer service) throws WSWarningException {
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String excMsg = "Unable to initialize ws client protocols on " + WSClientProtocolNotificator.getModeName(2) + " phase. Application " + wsClientId.getApplicationName() + ", ws client " + wsClientId.getServiceRefName() + ". ";
        Vector warnings = new Vector();
        String[] protocolIds = this.getProtocols(service.getUsedProtocols());
        Hashtable protocols = this.getProtocols(protocolIds, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        try {
            Hashtable filteredProtocols = this.filterProtocols(protocols, 2);
            this.onCommitDeploy(wsClientId.getApplicationName(), wsClientId.getServiceRefName(), filteredProtocols, service);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.onCommitDeploy630(wsClientRuntimeInfo, service);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onCommitDeploy(String applicationName, String wsClientName, Hashtable protocols, ServiceBaseServer service) throws WSWarningException {
        this.onShortNotificationPhases(applicationName, wsClientName, protocols, 2);
    }

    public void onCommitDeploy630(WSClientRuntimeInfo wsClientRuntimeInfo, ServiceBaseServer service) throws WSWarningException {
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String excMsg = "Unable to initialize ws client protocols on " + WSClientProtocolNotificator.getModeName(2) + " phase. Application " + wsClientId.getApplicationName() + ", ws client " + wsClientId.getServiceRefName() + ". ";
        try {
            RuntimeInformation runtimeInformation = this.getServiceRuntimeInformation(wsClientRuntimeInfo);
            service.onDeployApplication(runtimeInformation);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            String msg = excMsg + "Unexpected exception occurred: " + e.getLocalizedMessage();
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
    }

    public void onRollbackDeploy(String applicationName, String wsClientName, String[] protocolIds) throws WSWarningException {
        this.onShortNotificationPhases(applicationName, wsClientName, protocolIds, 3);
    }

    public void downloadFiles(String applicationName, String wsClientName, String wsClientDir, Configuration wsClientConfiguration) throws WSWarningException {
        String[] protocolIds = WSContainer.getComponentFactory().listClientProtocolIds();
        String excMsg = "Unable to initialize ws client protocols on " + WSClientProtocolNotificator.getModeName(5) + " phase. Application " + applicationName + ", ws client " + wsClientName + ". ";
        Vector warnings = new Vector();
        Hashtable protocols = this.getProtocolsForNotification(protocolIds, 5, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        if (protocolIds == null) {
            return;
        }
        Enumeration enumeration = protocols.keys();
        while (enumeration.hasMoreElements()) {
            String protocolId = (String)enumeration.nextElement();
            ClientFeatureProvider protocol = (ClientFeatureProvider)protocols.get(protocolId);
            try {
                ((WSClientLCMInterface)protocol).downloadFiles(applicationName, wsClientName, this.getProtocolDir(wsClientDir, protocolId), wsClientConfiguration);
            }
            catch (WSWarningException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                String msg = excMsg + "Client protocol " + protocolId + " can not be initialized. ";
                warnings.addAll(WSUtil.addPrefixToStrings(msg, e.getWarningsVector()));
            }
            catch (WSDeploymentException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                String msg = excMsg + "Client protocol " + protocolId + " can not be initialized. ";
                warnings.add(msg);
            }
            catch (Exception e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                String msg = excMsg + "Unexpected exception occurred: " + e.getLocalizedMessage();
                warnings.add(msg);
            }
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onStart(WSClientRuntimeInfo wsClientRuntimeInfo, ServiceBaseServer service, Configuration wsClientConfiguration) throws WSWarningException {
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String excMsg = "Unable to initialize ws client protocols on " + WSClientProtocolNotificator.getModeName(6) + " phase. Application " + wsClientId.getApplicationName() + ", ws client " + wsClientId.getServiceRefName() + ". ";
        Vector warnings = new Vector();
        String[] protocolIds = this.getProtocols(service.getUsedProtocols());
        Hashtable protocols = this.getProtocolsForNotification(protocolIds, 6, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        Hashtable wsClientContexts = this.getWSClientContexts(protocols.keys(), wsClientRuntimeInfo, service);
        try {
            this.onLongNotificationPhases(wsClientId.getApplicationName(), wsClientId.getServiceRefName(), wsClientRuntimeInfo.getWsClientDirsHandler().getWsClientDirectory(), protocols, wsClientContexts, wsClientConfiguration, 6);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onCommitStart(WSClientRuntimeInfo wsClientRuntimeInfo, ServiceBaseServer service) throws WSWarningException {
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String excMsg = "Unable to initialize ws client protocols on " + WSClientProtocolNotificator.getModeName(7) + " phase. Application " + wsClientId.getApplicationName() + ", ws client " + wsClientId.getServiceRefName() + ". ";
        Vector warnings = new Vector();
        String[] protocolIds = this.getProtocols(service.getUsedProtocols());
        Hashtable protocols = this.getProtocols(protocolIds, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        try {
            Hashtable filteredProtocols = this.filterProtocols(protocols, 7);
            this.onCommitStart(wsClientId.getApplicationName(), wsClientId.getServiceRefName(), filteredProtocols);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.onCommitStart630(wsClientRuntimeInfo, service);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onCommitStart(String applicationName, String wsClientName, Hashtable protocols) throws WSWarningException {
        this.onShortNotificationPhases(applicationName, wsClientName, protocols, 7);
    }

    public void onCommitStart630(WSClientRuntimeInfo wsClientRuntimeInfo, ServiceBaseServer service) throws WSWarningException {
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String excMsg = "Unable to initialize ws client protocols on " + WSClientProtocolNotificator.getModeName(7) + " phase. Application " + wsClientId.getApplicationName() + ", ws client " + wsClientId.getServiceRefName() + ". ";
        try {
            RuntimeInformation runtimeInformation = this.getServiceRuntimeInformation(wsClientRuntimeInfo);
            service.setRuntimeInformation(runtimeInformation);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            String msg = excMsg + "Unexpected exception occurred: " + e.getLocalizedMessage();
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
    }

    public void onRollbackStart(String applicationName, String wsClientName, String[] protocolIds) throws WSWarningException {
        this.onShortNotificationPhases(applicationName, wsClientName, protocolIds, 8);
    }

    public void onStop(WSClientRuntimeInfo wsClientRuntimeInfo, ServiceBaseServer service) throws WSWarningException {
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String excMsg = "Unable to initialize ws client protocols on " + WSClientProtocolNotificator.getModeName(7) + " phase. Application " + wsClientId.getApplicationName() + ", ws client " + wsClientId.getServiceRefName() + ". ";
        Vector warnings = new Vector();
        String[] protocolIds = this.getProtocols(service.getUsedProtocols());
        Hashtable protocols = this.getProtocols(protocolIds, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        try {
            Hashtable filteredProtocols = this.filterProtocols(protocols, 9);
            this.onStop(wsClientId.getApplicationName(), wsClientId.getServiceRefName(), filteredProtocols);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.onStop630(wsClientRuntimeInfo, service);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onStop(String applicationName, String wsClientName, Hashtable protocols) throws WSWarningException {
        this.onShortNotificationPhases(applicationName, wsClientName, protocols, 9);
    }

    public void onStop630(WSClientRuntimeInfo wsClientRuntimeInfo, ServiceBaseServer service) throws WSWarningException {
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String excMsg = "Unable to initialize ws client protocols on " + WSClientProtocolNotificator.getModeName(9) + " phase. Application " + wsClientId.getApplicationName() + ", ws client " + wsClientId.getServiceRefName() + ". ";
        try {
            RuntimeInformation runtimeInformation = this.getServiceRuntimeInformation(wsClientRuntimeInfo);
            service.onStopApplication(runtimeInformation);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            String msg = excMsg + "Unexpected exception occurred: " + e.getLocalizedMessage();
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
    }

    public void onRemove70(String applicationName, Hashtable protocols) throws WSWarningException {
        this.onShortNotificationPhases(applicationName, null, protocols, 4);
    }

    public void onRemove630(String applicationName, Hashtable protocols) throws WSWarningException {
        String excMsg = "Error occurred, trying to initialise protocols on " + WSClientProtocolNotificator.getModeName(4) + "phase (6.30 version). Application " + applicationName + ". ";
        if (protocols == null) {
            return;
        }
        Vector<String> warnings = new Vector<String>();
        Enumeration enumeration = protocols.keys();
        while (enumeration.hasMoreElements()) {
            String protocolId = (String)enumeration.nextElement();
            ClientFeatureProvider protocol = (ClientFeatureProvider)protocols.get(protocolId);
            try {
                ((ClientProtocolDeployAppEvents)protocol).onRemoveApplication(applicationName);
            }
            catch (Exception e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                String msg = excMsg + "Unexpected exception occurred: " + e.getLocalizedMessage();
                warnings.add(msg);
            }
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void onLongNotificationPhases(WSClientRuntimeInfo[] wsClientRuntimeInfoes, ServiceBaseServer[] services, Configuration appConfiguration, int mode) throws WSWarningException {
        String excMsg = "Error occurred, trying to initialize protocols on " + WSClientProtocolNotificator.getModeName(mode) + " phase. ";
        if (wsClientRuntimeInfoes == null || wsClientRuntimeInfoes.length == 0) {
            return;
        }
        Configuration[] wsClientConfigurations = null;
        try {
            wsClientConfigurations = this.getWSClientConfigurations(this.getWSClientConfigNames(wsClientRuntimeInfoes), appConfiguration);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(excMsg);
            throw wExc;
        }
        this.onLongNotificationPhases(wsClientRuntimeInfoes, services, wsClientConfigurations, mode);
    }

    private void onLongNotificationPhases(WSClientRuntimeInfo[] wsClientRuntimeInfoes, ServiceBaseServer[] services, Configuration[] wsClientConfigurations, int mode) throws WSWarningException {
        Vector warnings = new Vector();
        int i = 0;
        while (i < wsClientRuntimeInfoes.length) {
            try {
                switch (mode) {
                    case 0: {
                        this.onDeploy(wsClientRuntimeInfoes[i], wsClientConfigurations[i]);
                        break;
                    }
                    case 1: {
                        this.onPostDeploy(wsClientRuntimeInfoes[i], services[i], wsClientConfigurations[i]);
                        break;
                    }
                    case 6: {
                        this.onStart(wsClientRuntimeInfoes[i], services[i], wsClientConfigurations[i]);
                    }
                }
            }
            catch (WSWarningException e) {
                warnings.addAll(e.getWarningsVector());
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onShortNotificationPhases(WSClientRuntimeInfo[] wsClientRuntimeInfoes, ServiceBaseServer[] services, int mode) throws WSWarningException {
        Vector warnings = new Vector();
        int i = 0;
        while (i < wsClientRuntimeInfoes.length) {
            try {
                switch (mode) {
                    case 2: {
                        this.onCommitDeploy(wsClientRuntimeInfoes[i], services[i]);
                        break;
                    }
                    case 7: {
                        this.onCommitStart(wsClientRuntimeInfoes[i], services[i]);
                        break;
                    }
                    case 9: {
                        this.onStop(wsClientRuntimeInfoes[i], services[i]);
                    }
                }
            }
            catch (WSWarningException e) {
                warnings.addAll(e.getWarningsVector());
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onShortNotificationPhases(String applicationName, String[] wsClientNames, String[][] protocolIds, int mode) throws WSWarningException {
        Vector warnings = new Vector();
        int i = 0;
        while (i < wsClientNames.length) {
            try {
                switch (mode) {
                    case 3: {
                        this.onRollbackDeploy(applicationName, wsClientNames[i], protocolIds[i]);
                        break;
                    }
                    case 8: {
                        this.onRollbackStart(applicationName, wsClientNames[i], protocolIds[i]);
                    }
                }
            }
            catch (WSWarningException e) {
                warnings.addAll(e.getWarningsVector());
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onLongNofiticationPhases(String applicationName, String wsClientName, String wsClientDir, Hashtable protocols, WSClientBaseContext wsClientBaseContext, Configuration wsClientConfiguration, int mode) throws WSWarningException {
        String excMsg;
        String warningMsg = excMsg = "Unable to initialize ws client protocols on " + WSClientProtocolNotificator.getModeName(mode) + " phase. Application " + applicationName + ", ws client " + wsClientName + ". ";
        if (protocols == null) {
            return;
        }
        Vector<String> warnings = new Vector<String>();
        Enumeration enumeration = protocols.keys();
        while (enumeration.hasMoreElements()) {
            String protocolId = (String)enumeration.nextElement();
            ClientFeatureProvider protocol = (ClientFeatureProvider)protocols.get(protocolId);
            try {
                switch (mode) {
                    case 0: {
                        ((WSClientDeploymentInterface)protocol).onDeploy(applicationName, wsClientName, wsClientBaseContext, this.getProtocolDir(wsClientDir, protocolId), wsClientConfiguration);
                    }
                }
            }
            catch (WSWarningException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                String msg = warningMsg + "Client protocol " + protocolId + " can not be initialized. ";
                warnings.addAll(WSUtil.addPrefixToStrings(msg, e.getWarningsVector()));
            }
            catch (WSDeploymentException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                String msg = excMsg + "Client protocol " + protocolId + " can not be initialized. ";
                warnings.add(msg);
            }
            catch (Exception e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                String msg = warningMsg + "Unexpected exception occurred: " + e.getLocalizedMessage();
                warnings.add(msg);
            }
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onLongNotificationPhases(String applicationName, String wsClientName, String wsClientDir, Hashtable protocols, Hashtable wsClientContexts, Configuration wsClientConfiguration, int mode) throws WSWarningException {
        String excMsg;
        String warningMsg = excMsg = "Unable to initialize ws client protocols on " + WSClientProtocolNotificator.getModeName(mode) + " phase. Application " + applicationName + ", ws client " + wsClientName + ". ";
        if (protocols == null) {
            return;
        }
        Vector<String> warnings = new Vector<String>();
        Enumeration enumeration = protocols.keys();
        while (enumeration.hasMoreElements()) {
            String protocolId = (String)enumeration.nextElement();
            ClientFeatureProvider protocol = (ClientFeatureProvider)protocols.get(protocolId);
            try {
                switch (mode) {
                    case 0: {
                        ((WSClientDeploymentInterface)protocol).onDeploy(applicationName, wsClientName, (WSClientBaseContext)wsClientContexts.get(protocolId), this.getProtocolDir(wsClientDir, protocolId), wsClientConfiguration);
                        break;
                    }
                    case 1: {
                        ((WSClientDeploymentInterface)protocol).onPostDeploy(applicationName, wsClientName, (WSClientContext)wsClientContexts.get(protocolId), this.getProtocolDir(wsClientDir, protocolId), wsClientConfiguration);
                        break;
                    }
                    case 6: {
                        ((WSClientLCMInterface)protocol).onStart(applicationName, wsClientName, (WSClientContext)wsClientContexts.get(protocolId), this.getProtocolDir(wsClientDir, protocolId), wsClientConfiguration);
                    }
                }
            }
            catch (WSWarningException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                String msg = warningMsg + "Client protocol " + protocolId + " can not be initialized. ";
                warnings.addAll(WSUtil.addPrefixToStrings(msg, e.getWarningsVector()));
            }
            catch (WSDeploymentException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                String msg = excMsg + "Client protocol " + protocolId + " can not be initialized. ";
                warnings.add(msg);
            }
            catch (Exception e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                String msg = warningMsg + "Unexpected exception occurred: " + e.getLocalizedMessage();
                warnings.add(msg);
            }
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void onShortNotificationPhases(String applicationName, String wsClientName, String[] protocolIds, int mode) throws WSWarningException {
        String excMsg = "Unable to initialize ws client protocols on " + WSClientProtocolNotificator.getModeName(mode) + " phase. Application " + applicationName + ", ws client " + wsClientName + ". ";
        Vector warnings = new Vector();
        Hashtable protocols = this.getProtocolsForNotification(protocolIds, mode, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        try {
            this.onShortNotificationPhases(applicationName, wsClientName, protocols, mode);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void onShortNotificationPhases(String applicationName, String wsClientName, Hashtable protocols, int mode) throws WSWarningException {
        String excMsg;
        String warningMsg = excMsg = "Unable to initialize ws client protocols on " + WSClientProtocolNotificator.getModeName(mode) + " phase. Application " + applicationName + ", ws client " + wsClientName + ". ";
        if (protocols == null) {
            return;
        }
        Vector<String> warnings = new Vector<String>();
        Enumeration enumeration = protocols.keys();
        while (enumeration.hasMoreElements()) {
            String protocolId = (String)enumeration.nextElement();
            ClientFeatureProvider protocol = (ClientFeatureProvider)protocols.get(protocolId);
            try {
                switch (mode) {
                    case 2: {
                        ((WSClientDeploymentInterface)protocol).onCommitDeploy(applicationName, wsClientName);
                        break;
                    }
                    case 3: {
                        ((WSClientDeploymentInterface)protocol).onRollbackDeploy(applicationName, wsClientName);
                        break;
                    }
                    case 7: {
                        ((WSClientLCMInterface)protocol).onCommitStart(applicationName, wsClientName);
                        break;
                    }
                    case 8: {
                        ((WSClientLCMInterface)protocol).onRollbackStart(applicationName, wsClientName);
                        break;
                    }
                    case 9: {
                        ((WSClientLCMInterface)protocol).onStop(applicationName, wsClientName);
                        break;
                    }
                    case 4: {
                        ((WSClientDeploymentInterface)protocol).onRemove(applicationName);
                    }
                }
            }
            catch (WSWarningException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                String msg = warningMsg + "Client protocol " + protocolId + " can not be initialized. ";
                warnings.addAll(WSUtil.addPrefixToStrings(msg, e.getWarningsVector()));
            }
            catch (Exception e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                String msg = warningMsg + "Unexpected exception occurred: " + e.getLocalizedMessage();
                warnings.add(msg);
            }
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private RuntimeInformation getServiceRuntimeInformation(WSClientRuntimeInfo wsClientRuntimeInfo) {
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        RuntimeInformation runtimeInformation = new RuntimeInformation();
        runtimeInformation.setApplicationName(wsClientId.getApplicationName());
        runtimeInformation.setArchiveName(wsClientId.getJarName());
        runtimeInformation.setJndiName(wsClientId.getServiceRefName());
        return runtimeInformation;
    }

    private String getProtocolDir(String wsClientDir, String protocolName) {
        return wsClientDir + '/' + WSUtil.replaceForbiddenChars(protocolName);
    }

    private Configuration[] getWSClientConfigurations(String[] wsClientConfigNames, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occurred, trying to get ws client DB configurations. ";
        Configuration wsClientsConfiguration = null;
        try {
            Configuration wsContainerConfiguration = appConfiguration.getSubConfiguration("webservices_container");
            if (wsContainerConfiguration != null) {
                wsClientsConfiguration = wsContainerConfiguration.getSubConfiguration("wsClients");
            }
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to get " + "wsClients" + " configuration. ";
            Object[] args = new Object[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        if (wsClientsConfiguration == null) {
            String msg = excMsg + "Unable to get " + "wsClients" + " DB configuration. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args);
        }
        return this.getSubConfigurations(wsClientConfigNames, wsClientsConfiguration);
    }

    private Configuration[] getSubConfigurations(String[] subconfigNames, Configuration rootConfig) {
        if (subconfigNames == null) {
            return new Configuration[0];
        }
        Vector<Configuration> subconfigs = new Vector<Configuration>();
        int i = 0;
        while (i < subconfigNames.length) {
            String subConfigName = subconfigNames[i];
            Configuration subConfig = null;
            try {
                subConfig = rootConfig.getSubConfiguration(subConfigName);
            }
            catch (ConfigurationException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
            }
            subconfigs.add(subConfig);
            ++i;
        }
        Configuration[] subConfigsArray = new Configuration[subconfigs.size()];
        subconfigs.toArray(subConfigsArray);
        return subConfigsArray;
    }

    private String[] getWSClientConfigNames(WSClientRuntimeInfo[] wsClientRuntimeInfoes) {
        if (wsClientRuntimeInfoes == null) {
            return new String[0];
        }
        String[] wsClientConfigNames = new String[wsClientRuntimeInfoes.length];
        int i = 0;
        while (i < wsClientConfigNames.length) {
            wsClientConfigNames[i] = wsClientRuntimeInfoes[i].getWsClientDirsHandler().getWsClientConfigName();
            ++i;
        }
        return wsClientConfigNames;
    }

    public String[] getProtocols(Hashtable protocols) {
        if (protocols == null) {
            return new String[0];
        }
        Vector protocolsVector = new Vector();
        Enumeration enumeration = protocols.elements();
        while (enumeration.hasMoreElements()) {
            Vector currentProtocolsVector = this.toVector((HashSet)enumeration.nextElement());
            protocolsVector.addAll(currentProtocolsVector);
        }
        Object[] protocolsArray = new String[protocolsVector.size()];
        protocolsVector.copyInto(protocolsArray);
        return protocolsArray;
    }

    private Vector toVector(HashSet set) {
        if (set == null) {
            return new Vector();
        }
        Vector vector = new Vector();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            vector.add(next);
        }
        return vector;
    }

    private Hashtable getWSClientContexts(Enumeration protocolIdsEnum, WSClientRuntimeInfo wsClientRuntimeInfo, ServiceBaseServer service) {
        if (protocolIdsEnum == null) {
            return new Hashtable();
        }
        Hashtable<String, WSClientContext> wsClientContexts = new Hashtable<String, WSClientContext>();
        while (protocolIdsEnum.hasMoreElements()) {
            String protocolId = (String)protocolIdsEnum.nextElement();
            wsClientContexts.put(protocolId, this.getWSClientContext(protocolId, wsClientRuntimeInfo, service));
        }
        return wsClientContexts;
    }

    private WSClientContext getWSClientContext(String protocolId, WSClientRuntimeInfo wsClientRuntimeInfo, ServiceBaseServer service) {
        Hashtable lpProtocols = service.getUsedProtocols();
        RuntimeInformation runtimeInformation = this.getServiceRuntimeInformation(wsClientRuntimeInfo);
        Hashtable allPropertyContexts = service.getConfigurationData(runtimeInformation);
        PropertyContext[] propertyContexts = this.getPropertyContexts(protocolId, lpProtocols, allPropertyContexts);
        WSClientContextImpl wsClientContext = new WSClientContextImpl();
        wsClientContext.init(wsClientRuntimeInfo, propertyContexts);
        return wsClientContext;
    }

    private PropertyContext[] getPropertyContexts(String protocolId, Hashtable lpProtocols, Hashtable propertyContexts) {
        Vector propertyContextsVector = new Vector();
        Enumeration logPortNames = propertyContexts.keys();
        while (logPortNames.hasMoreElements()) {
            String logPortName = (String)logPortNames.nextElement();
            HashSet singleLPProtocols = (HashSet)lpProtocols.get(logPortName);
            if (!singleLPProtocols.contains(protocolId)) continue;
            propertyContextsVector.add(propertyContexts.get(logPortName));
        }
        Object[] propertyContextsArray = new PropertyContext[propertyContextsVector.size()];
        propertyContextsVector.copyInto(propertyContextsArray);
        return propertyContextsArray;
    }

    public boolean isInSkippedList(String str) {
        int i = 0;
        while (i < SKIPPED_PROTOCOLS_LIST.length) {
            if (str.equals(SKIPPED_PROTOCOLS_LIST[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Hashtable getProtocolsForNotification(String[] protocolIds, int mode, Vector warnings) {
        Hashtable protocols = this.getProtocols(protocolIds, warnings);
        return this.filterProtocols(protocols, mode);
    }

    private Hashtable filterProtocols(Hashtable protocols, int mode) {
        Hashtable<String, ClientFeatureProvider> protocolsForNotification = new Hashtable<String, ClientFeatureProvider>();
        Enumeration enumeration = protocols.keys();
        while (enumeration.hasMoreElements()) {
            String protocolId = (String)enumeration.nextElement();
            ClientFeatureProvider protocol = (ClientFeatureProvider)protocols.get(protocolId);
            switch (mode) {
                case 0: {
                    if (!(protocol instanceof WSClientDeploymentInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 1: {
                    if (!(protocol instanceof WSClientDeploymentInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 2: {
                    if (!(protocol instanceof WSClientDeploymentInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 3: {
                    if (!(protocol instanceof WSClientDeploymentInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 4: {
                    if (!(protocol instanceof WSClientDeploymentInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 5: {
                    if (!(protocol instanceof WSClientLCMInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 6: {
                    if (!(protocol instanceof WSClientLCMInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 7: {
                    if (!(protocol instanceof WSClientLCMInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 8: {
                    if (!(protocol instanceof WSClientLCMInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 9: {
                    if (!(protocol instanceof WSClientLCMInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                }
            }
        }
        return protocolsForNotification;
    }

    private Hashtable filterProtocols630(Hashtable protocols, int mode) {
        Hashtable<String, ClientFeatureProvider> protocolsForNotification = new Hashtable<String, ClientFeatureProvider>();
        Enumeration enumeration = protocols.keys();
        block6: while (enumeration.hasMoreElements()) {
            String protocolId = (String)enumeration.nextElement();
            ClientFeatureProvider protocol = (ClientFeatureProvider)protocols.get(protocolId);
            switch (mode) {
                case 2: {
                    if (!(protocol instanceof ClientProtocolDeployAppEvents)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 7: {
                    if (!(protocol instanceof ClientProtocolStartAppEvent) && !(protocol instanceof ClientProtocolAppStateEvents)) continue block6;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 9: {
                    if (!(protocol instanceof ClientProtocolAppStateEvents)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 4: {
                    if (!(protocol instanceof ClientProtocolDeployAppEvents)) break;
                    protocolsForNotification.put(protocolId, protocol);
                }
            }
        }
        return protocolsForNotification;
    }

    private Hashtable getProtocols(String[] protocolIds, Vector warnings) {
        String excMsg = "Error occured, trying to instantiate protocols.";
        if (protocolIds == null) {
            return new Hashtable();
        }
        ComponentFactoryImpl componentFactory = WSContainer.getComponentFactory();
        Hashtable<String, ClientFeatureProvider> protocols = new Hashtable<String, ClientFeatureProvider>();
        int i = 0;
        while (i < protocolIds.length) {
            String protocolId = protocolIds[i];
            try {
                if (!protocols.containsKey(protocolId) && !this.isInSkippedList(protocolId)) {
                    ClientFeatureProvider protocol = componentFactory.getClientProtocolInstance(protocolId);
                    protocols.put(protocolId, protocol);
                }
            }
            catch (Exception e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                String msg = excMsg + "Client protocol " + protocolId + " can not be instantiated.  ";
                warnings.add(msg);
            }
            ++i;
        }
        return protocols;
    }
}

