/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.wsclient;

import com.sap.engine.interfaces.ejb.monitor.EJBManager;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.services.webservices.runtime.definition.wsclient.ComponentDescriptor;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientIdentifier;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientRuntimeInfo;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsFactory;
import java.util.Hashtable;

public class WSClientOutsideSettingsProcessor {
    public void setComponentJndiNames(Hashtable webMappings, WSClientRuntimeInfo wsClientRuntimeInfo) throws WSDeploymentException {
        WSClientIdentifier wsClientIdentifier = wsClientRuntimeInfo.getWsClientId();
        String version = wsClientRuntimeInfo.getVersion();
        String moduleExtension = IOUtil.getFileExtension(wsClientIdentifier.getJarName());
        if (version.equals("6.30")) {
            if (moduleExtension.equals(".war")) {
                this.setWebComponents(webMappings, wsClientRuntimeInfo);
            } else if (moduleExtension.equals(".jar")) {
                this.setEjbComponents(wsClientRuntimeInfo);
            } else if (moduleExtension.equals(".wsar")) {
                // empty if block
            }
        }
    }

    public void setEjbComponents(WSClientRuntimeInfo wsClientRuntimeInfo) throws WSDeploymentException {
        String excMessage = "Error occured trying to obtain outside information for ws client(jndi names for its clients). ";
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String applicationName = wsClientId.getApplicationName();
        String moduleName = wsClientId.getJarName();
        EJBManager ejbManager = WSContainer.getInterfaceContext().getEjbManager();
        if (ejbManager == null) {
            String msg = excMessage + "Unable to get EJBManager.";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args);
        }
        ComponentDescriptor[] componentDescriptors = wsClientRuntimeInfo.getComponentDescriptors();
        if (componentDescriptors == null || componentDescriptors.length == 0) {
            String[] ejbJndiNames = ejbManager.getJNDINames(applicationName, moduleName);
            ComponentDescriptor[] newComponentDescriptors = this.getComponentDescriptorsFromJndiNames(ejbJndiNames);
            wsClientRuntimeInfo.setComponentDescriptors(newComponentDescriptors);
        } else {
            int i = 0;
            while (i < componentDescriptors.length) {
                ComponentDescriptor componentDescriptor = componentDescriptors[i];
                String beanName = componentDescriptor.getName();
                String ejbJndiName = ejbManager.getJNDIName(applicationName, moduleName, beanName);
                componentDescriptor.setJndiName(ejbJndiName);
                ++i;
            }
        }
    }

    private void setWebComponents(Hashtable webMappings, WSClientRuntimeInfo wsClientRuntimeInfo) {
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String moduleName = wsClientId.getJarName();
        ComponentDescriptor[] componentDescriptors = WSClientsFactory.getComponentDescriptors(new String[]{(String)webMappings.get(moduleName)});
        wsClientRuntimeInfo.setComponentDescriptors(componentDescriptors);
    }

    private ComponentDescriptor[] getComponentDescriptorsFromJndiNames(String[] jndiNames) {
        if (jndiNames == null) {
            return new ComponentDescriptor[0];
        }
        ComponentDescriptor[] componentDescriptors = new ComponentDescriptor[jndiNames.length];
        int i = 0;
        while (i < jndiNames.length) {
            ComponentDescriptor componentDescriptor = new ComponentDescriptor();
            componentDescriptor.setJndiName(jndiNames[i]);
            componentDescriptors[i] = componentDescriptor;
            ++i;
        }
        return componentDescriptors;
    }
}

