/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.wsclient;

import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.jaxrpc.exceptions.LogicalPortException;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortFactory;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPorts;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientIdentifier;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientRuntimeInfo;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwsclients.WSClientsParser;
import com.sap.engine.services.webservices.server.deploy.descriptors.wsclientsruntime.WSClientsRuntimeDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.wsclientsruntime.WSClientsRuntimeParser;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.util.jar.JarUtil;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientDeploymentInfo;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientDirsHandler;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsConstants;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsFactory;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.jar.JarFile;

public class WSClientFileStorageHandler
implements WSClientsConstants {
    public void saveWSClientsDeployFiles(WSClientDeploymentInfo wsClientDeploymentInfo) throws WSDeploymentException {
        String excMessage = "Error occured saving ws clients deploy files. ";
        WSClientIdentifier wsClientId = wsClientDeploymentInfo.getWsClientId();
        File moduleArchive = wsClientDeploymentInfo.getModuleArchive();
        try {
            this.saveMappings(wsClientDeploymentInfo);
            this.saveWSClientDeploymentDescriptor(wsClientDeploymentInfo);
            this.saveWSClientsRuntimeDescritor(wsClientDeploymentInfo);
            this.saveWsdlFiles(moduleArchive, wsClientDeploymentInfo);
            this.saveLogicalPortFile(moduleArchive, wsClientDeploymentInfo);
            this.saveUriMappingFiles(moduleArchive, wsClientDeploymentInfo);
            this.savePackageMappingFile(moduleArchive, wsClientDeploymentInfo);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(excMessage, (Throwable)e);
            Object[] args = new String[]{excMessage, wsClientId.getApplicationName(), wsClientId.getJarName(), wsClientId.getServiceRefName()};
            throw new WSDeploymentException("webservices_5042", args, (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveMappings(WSClientDeploymentInfo wsClientDeploymentInfo) throws WSDeploymentException {
        WSClientIdentifier wsClientId = wsClientDeploymentInfo.getWsClientId();
        String excMsg = "Error occured, trying to save mappings for application " + wsClientId.getApplicationName() + ", ws client " + wsClientId.getServiceRefName() + ". ";
        Properties mappings = wsClientDeploymentInfo.getWsClientDirsHandler().getMappings();
        String mappingsPath = WSClientDirsHandler.getMappingsPath(wsClientDeploymentInfo.getWsClientDirsHandler().getWsClientDirectory());
        IOUtil.createParentDir(new String[]{mappingsPath});
        FileOutputStream out = null;
        out = new FileOutputStream(mappingsPath);
        mappings.store(out, "Properties file, specifying the mapping for the ws client directory names.");
        Object var11_7 = null;
        if (out == null) return;
        try {
            ((OutputStream)out).close();
            return;
        }
        catch (IOException iExc) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = "Warning! " + excMsg + "Unable to close output stream for file  " + mappingsPath + ". ";
            wsDeployLocation.catching(msg, (Throwable)iExc);
        }
        return;
        {
            catch (IOException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                Object[] args = new String[]{excMsg};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            if (out == null) throw throwable;
            try {
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException iExc) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                String msg = "Warning! " + excMsg + "Unable to close output stream for file  " + mappingsPath + ". ";
                wsDeployLocation.catching(msg, (Throwable)iExc);
            }
            throw throwable;
        }
    }

    public void saveWSClientDeploymentDescriptor(WSClientDeploymentInfo wsClientDeploymentInfo) throws WSDeploymentException {
        String excMsg = "Error occured trying to save ws-clients-deployment-descriptor.xml. ";
        WSClientIdentifier wsClientId = wsClientDeploymentInfo.getWsClientId();
        String wsClientDDescriptorFileName = wsClientDeploymentInfo.getWsClientDirsHandler().getWSClientsDeploymentDescriptorPath();
        IOUtil.createParentDir(new String[]{wsClientDDescriptorFileName});
        try {
            WSClientsParser.saveWSClientsDeploymentDescriptor(wsClientDeploymentInfo.getWsClientSingleDescriptor(), wsClientDDescriptorFileName);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(excMsg, (Throwable)e);
            Object[] args = new String[]{excMsg, wsClientId.getApplicationName(), wsClientId.getJarName(), wsClientId.getServiceRefName()};
            throw new WSDeploymentException("webservices_5042", args, (Throwable)e);
        }
    }

    public void saveWSClientsRuntimeDescritor(WSClientRuntimeInfo wsClientRuntimeInfo) throws WSDeploymentException {
        String excMsg = "Error occured trying to save ws-clients-runtime-descriptor.xml. ";
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String wsClientRDescriptorFileName = wsClientRuntimeInfo.getWsClientDirsHandler().getWSClientsRuntimeDescriptorPath();
        IOUtil.createParentDir(new String[]{wsClientRDescriptorFileName});
        WSClientsRuntimeDescriptor wsClientsRuntimeDescriptor = new WSClientsFactory().loadWSClientsRuntimeDescriptor(wsClientRuntimeInfo);
        try {
            WSClientsRuntimeParser.saveWSClientsRuntimeDescriptor(wsClientsRuntimeDescriptor, wsClientRDescriptorFileName);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(excMsg, (Throwable)e);
            Object[] args = new String[]{excMsg, wsClientId.getApplicationName(), wsClientId.getJarName(), wsClientId.getServiceRefName()};
            throw new WSDeploymentException("webservices_5042", args, (Throwable)e);
        }
    }

    public void saveWsdlFiles(File moduleFile, WSClientDeploymentInfo wsClientDeploymentInfo) throws WSDeploymentException {
        String excMsg = "Error occured trying to extract ws clients wsdl files. ";
        String baseRelDirEntryPrefix = wsClientDeploymentInfo.getBaseRelativeDirEntry() + '/';
        String wsdlDir = wsClientDeploymentInfo.getWsClientDirsHandler().getWsdlDir();
        try {
            new JarUtil().extractFiles(moduleFile, new String[]{baseRelDirEntryPrefix}, new String[0], new String[]{".wsdl", ".xsd"}, new String[0], wsdlDir, true);
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(excMsg, (Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    public void saveWsdlRootFiles(String wsClientsDir, File moduleFile, WSClientDeploymentInfo wsClientDeploymentInfo) throws WSDeploymentException {
        block10: {
            String excMsg = "Error occured trying to extract ws client wsdl files. ";
            WSClientIdentifier wsClientId = wsClientDeploymentInfo.getWsClientId();
            String wsClientOwnDir = wsClientDeploymentInfo.getWsClientDirsHandler().getWsClientDirectory();
            String[] wsdlRelFileNames = wsClientDeploymentInfo.getWsdlFileNames();
            String baseRelDirEntryPrefix = wsClientDeploymentInfo.getBaseRelativeDirEntry() + '/';
            String[] wsdlFileEntries = WSUtil.addPrefixToStrings(baseRelDirEntryPrefix, wsdlRelFileNames);
            String[] wsdlFileNamesRelToWSClientOwnDir = wsClientDeploymentInfo.getWsdlFileNamesRelToWSClientOwnDir();
            IOUtil.createParentDir(wsClientDeploymentInfo.getWsdlFullFileNames());
            JarFile moduleJarFile = null;
            moduleJarFile = new JarFile(moduleFile);
            int i = 0;
            while (i < wsdlRelFileNames.length) {
                new JarUtil().extractFile(moduleJarFile, wsdlFileEntries[i], wsClientOwnDir, wsdlFileNamesRelToWSClientOwnDir[i]);
                ++i;
            }
            Object var16_14 = null;
            try {
                if (moduleJarFile != null) {
                    moduleJarFile.close();
                }
                break block10;
            }
            catch (IOException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                String msg = "Warning! " + excMsg + "Unable to close jarFile for file: " + moduleFile.getAbsolutePath();
                wsDeployLocation.catching(msg, (Throwable)e);
            }
            break block10;
            {
                catch (Exception e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching(excMsg, (Throwable)e);
                    Object[] args = new String[]{excMsg, wsClientId.getApplicationName(), wsClientId.getJarName(), wsClientId.getServiceRefName()};
                    throw new WSDeploymentException("webservices_5042", args, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var16_15 = null;
                try {
                    if (moduleJarFile != null) {
                        moduleJarFile.close();
                    }
                }
                catch (IOException e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    String msg = "Warning! " + excMsg + "Unable to close jarFile for file: " + moduleFile.getAbsolutePath();
                    wsDeployLocation.catching(msg, (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void saveLogicalPortFile(File moduleFile, WSClientDeploymentInfo wsClientDeploymentInfo) throws WSDeploymentException {
        block9: {
            String excMsg = "Error occured trying to extract ws client logical port file. ";
            WSClientIdentifier wsClientId = wsClientDeploymentInfo.getWsClientId();
            String wsClientOwnDir = wsClientDeploymentInfo.getWsClientDirsHandler().getWsClientDirectory();
            String logPortsRelFileName = wsClientDeploymentInfo.getLogicalPortsFileName();
            String baseRelDirEntryPrefix = wsClientDeploymentInfo.getBaseRelativeDirEntry() + '/';
            String logPortsFileEntry = WSUtil.addPrefixToStrings(baseRelDirEntryPrefix, new String[]{logPortsRelFileName})[0];
            String logPortsFileNameRelToWSClientOwnDir = wsClientDeploymentInfo.getLogicalPortsFileNameRelToWSClientOwnDir();
            IOUtil.createParentDir(new String[]{wsClientDeploymentInfo.getLogicalPortsFullFileName()});
            JarFile moduleJarFile = null;
            moduleJarFile = new JarFile(moduleFile);
            new JarUtil().extractFile(moduleJarFile, logPortsFileEntry, wsClientOwnDir, logPortsFileNameRelToWSClientOwnDir);
            Object var15_11 = null;
            try {
                if (moduleJarFile != null) {
                    moduleJarFile.close();
                }
                break block9;
            }
            catch (IOException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                String msg = "Warning! " + excMsg + "Unable to close jarFile for file: " + moduleFile.getAbsolutePath();
                wsDeployLocation.catching(msg, (Throwable)e);
            }
            break block9;
            {
                catch (Exception e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching(excMsg, (Throwable)e);
                    Object[] args = new String[]{excMsg, wsClientId.getApplicationName(), wsClientId.getJarName(), wsClientId.getServiceRefName()};
                    throw new WSDeploymentException("webservices_5042", args, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var15_12 = null;
                try {
                    if (moduleJarFile != null) {
                        moduleJarFile.close();
                    }
                }
                catch (IOException e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    String msg = "Warning! " + excMsg + "Unable to close jarFile for file: " + moduleFile.getAbsolutePath();
                    wsDeployLocation.catching(msg, (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    public void saveLogicalPortsFile(WSClientRuntimeInfo wsClientRuntimeInfo, LogicalPorts logicalPorts) throws WSDeploymentException {
        String excMsg = "Error occured trying to save new logical ports structure. ";
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String logPortsFileName = wsClientRuntimeInfo.getLogicalPortsFullFileName();
        IOUtil.createParentDir(new String[]{logPortsFileName});
        try {
            new LogicalPortFactory().saveLogicalPorts(logicalPorts, logPortsFileName);
        }
        catch (LogicalPortException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(excMsg, (Throwable)e);
            Object[] args = new String[]{excMsg, wsClientId.getApplicationName(), wsClientId.getJarName(), wsClientId.getServiceRefName()};
            throw new WSDeploymentException("webservices_5042", args, (Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    public void saveUriMappingFiles(File moduleFile, WSClientDeploymentInfo wsClientDeploymentInfo) throws WSDeploymentException {
        block10: {
            String excMsg = "Error occured trying to extract ws client urimapping files. ";
            WSClientIdentifier wsClientId = wsClientDeploymentInfo.getWsClientId();
            String wsClientOwnDir = wsClientDeploymentInfo.getWsClientDirsHandler().getWsClientDirectory();
            String[] uriMappingsRelFileNames = wsClientDeploymentInfo.getUriMappingFiles();
            String baseRelDirEntryPrefix = wsClientDeploymentInfo.getBaseRelativeDirEntry() + '/';
            String[] uriMappingFileEntries = WSUtil.addPrefixToStrings(baseRelDirEntryPrefix, uriMappingsRelFileNames);
            String[] uriMappingFileNamesRelToWSClientOwnDir = wsClientDeploymentInfo.getUriMappingFileNamesRelToWSClientOwnDir();
            IOUtil.createParentDir(wsClientDeploymentInfo.getUriMappingFullFileNames());
            JarFile moduleJarFile = null;
            moduleJarFile = new JarFile(moduleFile);
            int i = 0;
            while (i < uriMappingsRelFileNames.length) {
                new JarUtil().extractFile(moduleJarFile, uriMappingFileEntries[i], wsClientOwnDir, uriMappingFileNamesRelToWSClientOwnDir[i]);
                ++i;
            }
            Object var15_13 = null;
            try {
                if (moduleJarFile != null) {
                    moduleJarFile.close();
                }
                break block10;
            }
            catch (IOException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                String msg = "Warning! " + excMsg + "Unable to close jarFile for file: " + moduleFile.getAbsolutePath();
                wsDeployLocation.catching(msg, (Throwable)e);
            }
            break block10;
            {
                catch (Exception e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching(excMsg, (Throwable)e);
                    Object[] args = new String[]{excMsg, wsClientId.getApplicationName(), wsClientId.getJarName(), wsClientId.getServiceRefName()};
                    throw new WSDeploymentException("webservices_5042", args, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var15_14 = null;
                try {
                    if (moduleJarFile != null) {
                        moduleJarFile.close();
                    }
                }
                catch (IOException e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    String msg = "Warning! " + excMsg + "Unable to close jarFile for file: " + moduleFile.getAbsolutePath();
                    wsDeployLocation.catching(msg, (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void savePackageMappingFile(File moduleFile, WSClientDeploymentInfo wsClientDeploymentInfo) throws WSDeploymentException {
        block9: {
            String excMsg = "Error occured trying to extract ws client package mapping file. ";
            WSClientIdentifier wsClientId = wsClientDeploymentInfo.getWsClientId();
            String wsClientOwnDir = wsClientDeploymentInfo.getWsClientDirsHandler().getWsClientDirectory();
            String packageMappingRelFileNames = wsClientDeploymentInfo.getPackageMappingFile();
            String baseRelDirEntryPrefix = wsClientDeploymentInfo.getBaseRelativeDirEntry() + '/';
            String packageMappingFileEntry = WSUtil.addPrefixToStrings(baseRelDirEntryPrefix, new String[]{packageMappingRelFileNames})[0];
            String packageMappingFileNamesRelToWSClientOwnDir = wsClientDeploymentInfo.getPackageMappingFileRelToWSClientOwnDir();
            IOUtil.createParentDir(new String[]{wsClientDeploymentInfo.getPackageMappingFullFileName()});
            JarFile moduleJarFile = null;
            moduleJarFile = new JarFile(moduleFile);
            new JarUtil().extractFile(moduleJarFile, packageMappingFileEntry, wsClientOwnDir, packageMappingFileNamesRelToWSClientOwnDir);
            Object var15_11 = null;
            try {
                if (moduleJarFile != null) {
                    moduleJarFile.close();
                }
                break block9;
            }
            catch (IOException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                String msg = "Warning! " + excMsg + "Unable to close jarFile for file: " + moduleFile.getAbsolutePath();
                wsDeployLocation.catching(msg, (Throwable)e);
            }
            break block9;
            {
                catch (Exception e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching(excMsg, (Throwable)e);
                    Object[] args = new String[]{excMsg, wsClientId.getApplicationName(), wsClientId.getJarName(), wsClientId.getServiceRefName()};
                    throw new WSDeploymentException("webservices_5042", args, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var15_12 = null;
                try {
                    if (moduleJarFile != null) {
                        moduleJarFile.close();
                    }
                }
                catch (IOException e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    String msg = "Warning! " + excMsg + "Unable to close jarFile for file: " + moduleFile.getAbsolutePath();
                    wsDeployLocation.catching(msg, (Throwable)e);
                }
                throw throwable;
            }
        }
    }
}

