/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.wsclient;

import com.sap.engine.services.webservices.server.deploy.common.ModuleDirsHandler;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientFilesLocationHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;

public class WSClientDirsHandler
extends ModuleDirsHandler
implements WSClientFilesLocationHandler {
    public static final String WS_CLIENT_DIR_PREFIX = "ws_cl_";
    private String wsClientDirectory = null;
    private Properties mappings = null;
    private String descriptorsRelDir = null;
    private String descriptorsDir = null;
    private String logPortsRelDir = null;
    private String logPortsDir = null;
    private String wsdlRelDir = null;
    private String wsdlDir = null;
    private String jarsRelDir = null;
    private String jarsDir = null;
    private String jarFileName = null;
    private String jarPath = null;

    public static String getWSClientsRelConfigName() {
        return "wsClients";
    }

    public static String getWSClientsConfigName(String wsContainerConfigPath) {
        return wsContainerConfigPath + '/' + WSClientDirsHandler.getWSClientsRelConfigName();
    }

    public static String getWSClientsRelDir() {
        return "wsClients";
    }

    public static String getWSClientsDir(String wsContainerDir) {
        return wsContainerDir + '/' + WSClientDirsHandler.getWSClientsRelDir();
    }

    public static String getWSClientsWorkingDir(String wsContainerWorkingDir) {
        return wsContainerWorkingDir + '/' + "wsClients";
    }

    public static String getWSClientWorkingDir(String wsClientsWorkingDir, int number) {
        return wsClientsWorkingDir + '/' + WS_CLIENT_DIR_PREFIX + number;
    }

    public static String getDefaultWSClientWorkingDir(String wsClientsWorkingDir, String serviceRefName) {
        return wsClientsWorkingDir + '/' + WSClientDirsHandler.getAllowedString(serviceRefName);
    }

    public static String getWSClientGeneratedDir(String wsClientWorkingDir) {
        return wsClientWorkingDir + '/' + "gen";
    }

    public static Properties generateMappings(String serviceRefName, int index) {
        Properties mappings = WSClientDirsHandler.generateBaseMappings(index);
        String jarFileName = WSClientDirsHandler.getDefaultJarFileName(serviceRefName);
        mappings.setProperty("jar_file_name", jarFileName);
        return mappings;
    }

    public static Properties generateDefaultMappings(String serviceRefName) {
        Properties mappings = WSClientDirsHandler.generateBaseDefaultMappings();
        mappings.setProperty("jar_file_name", WSClientDirsHandler.getDefaultJarFileName(serviceRefName));
        return mappings;
    }

    public static Properties generateBaseMappings(int index) {
        Properties mappings = WSClientDirsHandler.generateBaseDefaultMappings();
        mappings.setProperty("index", new Integer(index).toString());
        return mappings;
    }

    public static Properties generateBaseDefaultMappings() {
        Properties mappings = new Properties();
        mappings.setProperty("descriptors", "descriptors");
        mappings.setProperty("log_ports", "log_ports");
        mappings.setProperty("wsdl", "wsdl");
        mappings.setProperty("jars", "jars");
        return mappings;
    }

    public static String getDefaultJarFileName(String serviceRefName) {
        return WSClientDirsHandler.getAllowedString(serviceRefName) + ".jar";
    }

    public static void updateDefaultMappings(String serviceRefName, Properties mappings) {
        mappings.setProperty("jar_file_name", WSClientDirsHandler.getDefaultJarFileName(serviceRefName));
    }

    public static String getDefaultWSClientDir(String wsClientsDir, String serviceRefName) {
        return wsClientsDir + '/' + WSClientDirsHandler.getAllowedString(serviceRefName);
    }

    public static String getWSClientDir(String wsClientsDir, int number) {
        return wsClientsDir + '/' + WS_CLIENT_DIR_PREFIX + number;
    }

    public static String getMappingsFileName() {
        return "mapping.props";
    }

    public static String getMappingsPath(String wsClientDir) {
        return WSClientDirsHandler.getMappingsParentDir(wsClientDir) + '/' + WSClientDirsHandler.getMappingsFileName();
    }

    public static String getMappingsParentRelDir() {
        return "";
    }

    public static String getMappingsParentDir(String wsClientDir) {
        return wsClientDir + '/' + WSClientDirsHandler.getMappingsParentRelDir();
    }

    public static String getDescriptorsRelDir(Properties mappings) {
        return mappings.getProperty("descriptors");
    }

    public static String getDescriptorsDir(String wsClientDir, Properties mappings) {
        return wsClientDir + '/' + WSClientDirsHandler.getDescriptorsRelDir(mappings);
    }

    public static String getWSClientsDeploymentDescriptorFileName() {
        return "ws-clients-deployment-descriptor.xml";
    }

    public static String getWSClientsDeploymentDescriptorPath(String wsClientDir, Properties mappings) {
        return WSClientDirsHandler.getDescriptorsDir(wsClientDir, mappings) + '/' + "ws-clients-deployment-descriptor.xml";
    }

    public static String getWSClientsDDescriptorParentRelDir(Properties mappings) {
        return WSClientDirsHandler.getDescriptorsRelDir(mappings);
    }

    public static String getWSClientsDDescriptorParentDir(String wsClientDir, Properties mappings) {
        return WSClientDirsHandler.getDescriptorsDir(wsClientDir, mappings);
    }

    public static String getWSClientsDeploymentDescriptorsDir(String wsClientDir, Properties mappings) {
        return WSClientDirsHandler.getDescriptorsDir(wsClientDir, mappings) + '/' + "ws-clients-descriptors";
    }

    public static String getWSClientsRuntimeDescriptorFileName() {
        return "ws-clients-runtime-descriptor.xml";
    }

    public static String getWSClientsRuntimeDescriptorPath(String wsClientDir, Properties mappings) {
        return WSClientDirsHandler.getDescriptorsDir(wsClientDir, mappings) + '/' + "ws-clients-runtime-descriptor.xml";
    }

    public static String getWSClientsRuntimeDescriptorParentRelDir(Properties mappings) {
        return WSClientDirsHandler.getDescriptorsRelDir(mappings);
    }

    public static String getWSClientsRuntimeDescriptorParentDir(String wsClientDir, Properties mappings) {
        return WSClientDirsHandler.getDescriptorsDir(wsClientDir, mappings);
    }

    public static String getLogPortsDir(String wsClientDir, Properties mappings) {
        return WSClientDirsHandler.getDescriptorsDir(wsClientDir, mappings) + '/' + mappings.getProperty("log_ports");
    }

    public static String getLogPortsPath(String wsClientDir, Properties mappings, String logPortsFileName) {
        return WSClientDirsHandler.getLogPortsDir(wsClientDir, mappings) + '/' + logPortsFileName;
    }

    public static String getWsdlDir(String wsClientDir, Properties mappings) {
        return WSClientDirsHandler.getDescriptorsDir(wsClientDir, mappings) + '/' + mappings.getProperty("wsdl");
    }

    public static String[] getWsdlPaths(String wsClientDir, Properties mappings, String[] wsdlFileNames) {
        return WSUtil.addPrefixToStrings(WSClientDirsHandler.getWsdlDir(wsClientDir, mappings) + '/', wsdlFileNames);
    }

    public static String[] getUriMappingPaths(String wsClientDir, Properties mappings, String[] uriMappingFileNames) {
        return WSUtil.addPrefixToStrings(WSClientDirsHandler.getWsdlDir(wsClientDir, mappings) + '/', uriMappingFileNames);
    }

    public static String getPackageMappingPaths(String wsClientDir, Properties mappings, String packageMappingFileName) {
        return WSClientDirsHandler.getWsdlDir(wsClientDir, mappings) + '/' + packageMappingFileName;
    }

    public static String getJarsRelDir(Properties mappings) {
        return mappings.getProperty("jars");
    }

    public static String getJarsDir(String wsClientDir, Properties mappings) {
        return wsClientDir + '/' + mappings.getProperty("jars");
    }

    public static String getJarPath(String wsClientDir, Properties mappings) {
        return WSClientDirsHandler.getJarsDir(wsClientDir, mappings) + '/' + mappings.getProperty("jar_file_name");
    }

    public WSClientDirsHandler() {
    }

    public WSClientDirsHandler(String wsClientDirectory, Properties dirsMapping) {
        this.wsClientDirectory = wsClientDirectory;
        this.mappings = dirsMapping;
    }

    public String getWsClientDirectory() {
        return this.wsClientDirectory;
    }

    public int getIndex() {
        if (((Hashtable)this.mappings).containsKey("index")) {
            return new Integer(this.mappings.getProperty("index"));
        }
        return this.extractIndex(this.getWsClientDirectory());
    }

    public String getWsClientConfigName() {
        return new File(this.wsClientDirectory).getName();
    }

    public String getWsClientConfigPath(String wsContainerConfigPath) {
        return WSClientDirsHandler.getWSClientsConfigName(wsContainerConfigPath) + '/' + this.getWsClientConfigName();
    }

    public void setWsClientDirectory(String wsClientDirectory) {
        this.wsClientDirectory = wsClientDirectory;
    }

    public Properties getMappings() {
        return this.mappings;
    }

    public void setMappings(Properties dirsMapping) {
        this.mappings = dirsMapping;
    }

    public void updateDefaultMappings(String serviceRefName) {
        this.mappings.setProperty("jar_file_name", WSClientDirsHandler.getDefaultJarFileName(serviceRefName));
    }

    public String getMappingsPath() {
        return this.wsClientDirectory + '/' + WSClientDirsHandler.getMappingsFileName();
    }

    public String getDescriptorsRelDir() {
        if (this.descriptorsRelDir == null) {
            this.descriptorsRelDir = this.mappings.getProperty("descriptors");
        }
        return this.descriptorsRelDir;
    }

    public String getDescriptorsDir() {
        if (this.descriptorsDir == null) {
            this.descriptorsDir = this.wsClientDirectory + '/' + this.getDescriptorsRelDir();
        }
        return this.descriptorsDir;
    }

    public String getWSClientDeploymentDescriptorsDir() {
        return this.getDescriptorsDir() + '/' + "ws-clients-descriptors";
    }

    public String getWSClientsDeploymentDescriptorPath() {
        return this.getDescriptorsDir() + '/' + "ws-clients-deployment-descriptor.xml";
    }

    public boolean existsWSClientsDeploymentDescriptor() {
        return new File(this.getWSClientsDeploymentDescriptorPath()).exists();
    }

    public InputStream getWSClientsDeploymentDescriptorInputStream() throws IOException {
        return new FileInputStream(this.getWSClientsDeploymentDescriptorPath());
    }

    public String getWSClientsDeploymentDescriptorLocationMsg() {
        String locationMsg = "Type: file; ";
        locationMsg = locationMsg + "File location: " + this.getWSClientsDeploymentDescriptorPath() + "; ";
        return locationMsg;
    }

    public String[] getWSClientsDeploymentDescriptorPathsMultipleMode() {
        return new String[0];
    }

    public boolean existsWSClientsDeploymentDescriptorMultipleMode() throws IOException {
        return false;
    }

    public InputStream[] getWSClientsDeploymentDescriptorInputStreamMultipleMode() throws IOException {
        return new InputStream[0];
    }

    public String[] getWSClientsDeploymentDescriptorLocationMsgMultipleMode() throws IOException {
        return new String[0];
    }

    public String getWSClientsRuntimeDescriptorPath() {
        return this.getDescriptorsDir() + '/' + "ws-clients-runtime-descriptor.xml";
    }

    public String getLogPortRelDir() {
        if (this.logPortsRelDir == null) {
            this.logPortsRelDir = this.getDescriptorsRelDir() + '/' + this.mappings.getProperty("log_ports");
        }
        return this.logPortsRelDir;
    }

    public String getLogPortsDir() {
        if (this.logPortsDir == null) {
            this.logPortsDir = this.wsClientDirectory + '/' + this.getLogPortRelDir();
        }
        return this.logPortsDir;
    }

    public String getLogPortsRelPath(String logPortsFileName) {
        return this.getLogPortRelDir() + '/' + logPortsFileName;
    }

    public String getLogPortsPath(String logPortsFileName) {
        return this.getLogPortsDir() + '/' + logPortsFileName;
    }

    public InputStream getLogPortsInputStream(String logPortsRelPath) throws IOException {
        return new FileInputStream(this.getLogPortsPath(logPortsRelPath));
    }

    public String getLogPortsLocationMsg(String logPortsRelPath) {
        String locationMsg = "Type: file; ";
        locationMsg = locationMsg + "File location: " + this.getLogPortsPath(logPortsRelPath) + "; ";
        return locationMsg;
    }

    public String getWsdlRelDir() {
        if (this.wsdlRelDir == null) {
            this.wsdlRelDir = this.getDescriptorsRelDir() + '/' + this.mappings.getProperty("wsdl");
        }
        return this.wsdlRelDir;
    }

    public String getWsdlDir() {
        if (this.wsdlDir == null) {
            this.wsdlDir = this.wsClientDirectory + '/' + this.getWsdlRelDir();
        }
        return this.wsdlDir;
    }

    public String[] getWsdlRelPaths(String[] wsdlFileNames) {
        return WSUtil.addPrefixToStrings(this.getWsdlRelDir() + '/', wsdlFileNames);
    }

    public String[] getWsdlPaths(String[] wsdlFileNames) {
        return WSUtil.addPrefixToStrings(this.getWsdlDir() + '/', wsdlFileNames);
    }

    public InputStream[] getWsdlInputStream(String[] wsdlRelPaths) throws IOException {
        String[] wsdlPaths = this.getWsdlRelPaths(wsdlRelPaths);
        if (wsdlPaths == null) {
            return new InputStream[0];
        }
        InputStream[] wsdlInputStreams = new InputStream[wsdlPaths.length];
        int i = 0;
        while (i < wsdlPaths.length) {
            wsdlInputStreams[i] = new FileInputStream(wsdlPaths[i]);
            ++i;
        }
        return wsdlInputStreams;
    }

    public String[] getWsdlLocationMsg(String[] wsdlRelPaths) {
        String[] wsdlPaths = this.getWsdlRelPaths(wsdlRelPaths);
        if (wsdlPaths == null) {
            return new String[0];
        }
        String[] wsdlLocationMsgs = new String[wsdlPaths.length];
        int i = 0;
        while (i < wsdlPaths.length) {
            String locationMsg = "Type: file; ";
            wsdlLocationMsgs[i] = locationMsg = locationMsg + "File location: " + wsdlPaths[i] + "; ";
            ++i;
        }
        return wsdlLocationMsgs;
    }

    public String[] getUriMappingRelPaths(String[] uriMappingFileNames) {
        return WSUtil.addPrefixToStrings(this.getWsdlRelDir() + '/', uriMappingFileNames);
    }

    public String[] getUriMappingPaths(String[] uriMappingFileNames) {
        return WSUtil.addPrefixToStrings(this.getWsdlDir() + '/', uriMappingFileNames);
    }

    public InputStream[] getUriMappingInputStream(String[] uriMappingsRelPaths) throws IOException {
        String[] uriMappingPaths = this.getUriMappingPaths(uriMappingsRelPaths);
        if (uriMappingPaths == null) {
            return new InputStream[0];
        }
        InputStream[] uriMappingInputStreams = new InputStream[uriMappingPaths.length];
        int i = 0;
        while (i < uriMappingPaths.length) {
            uriMappingInputStreams[i] = new FileInputStream(uriMappingPaths[i]);
            ++i;
        }
        return uriMappingInputStreams;
    }

    public String[] getUriMappingLocationMsg(String[] uriMappingRelPaths) {
        String[] uriMappingPaths = this.getUriMappingPaths(uriMappingRelPaths);
        if (uriMappingPaths == null) {
            return new String[0];
        }
        String[] uriMappingLocationMsgs = new String[uriMappingPaths.length];
        int i = 0;
        while (i < uriMappingPaths.length) {
            String locationMsg = "Type: file; ";
            uriMappingLocationMsgs[i] = locationMsg = locationMsg + "File location: " + uriMappingPaths[i] + "; ";
            ++i;
        }
        return uriMappingLocationMsgs;
    }

    public String getPackageMappingRelPath(String packageMappingFileName) {
        return this.getWsdlRelDir() + '/' + packageMappingFileName;
    }

    public String getPackageMappingPath(String packageMappingFileName) {
        return this.getWsdlDir() + '/' + packageMappingFileName;
    }

    public InputStream getPackageMappingInputStream(String packageMappingRelPath) throws IOException {
        return new FileInputStream(this.getPackageMappingPath(packageMappingRelPath));
    }

    public String getPackageMappingLocationMsg(String packageMappingRelPath) {
        String locationMsg = "Type: file; ";
        locationMsg = locationMsg + "File location: " + this.getPackageMappingPath(packageMappingRelPath) + "; ";
        return locationMsg;
    }

    public String getLocationMsg() {
        String locationMsg = "Type: file; ";
        locationMsg = locationMsg + "File location: " + this.getWSClientsDeploymentDescriptorPath() + "; ";
        return locationMsg;
    }

    public String getJarsRelDir() {
        if (this.jarsRelDir == null) {
            this.jarsRelDir = this.mappings.getProperty("jars");
        }
        return this.jarsRelDir;
    }

    public String getJarsDir() {
        if (this.jarsDir == null) {
            this.jarsDir = this.wsClientDirectory + '/' + this.getJarsRelDir();
        }
        return this.jarsDir;
    }

    public String getJarFileName() {
        if (this.jarFileName == null) {
            this.jarFileName = this.mappings.getProperty("jar_file_name");
        }
        return this.jarFileName;
    }

    public String getJarPath() {
        if (this.jarPath == null) {
            this.jarPath = this.getJarsDir() + '/' + this.getJarFileName();
        }
        return this.jarPath;
    }

    public static String getAllowedString(String str) {
        return WSUtil.replaceForbiddenChars(str);
    }

    private int extractIndex(String str) {
        int index = -1;
        if ((str = str.replace('\\', '/')).endsWith("/")) {
            str = str.substring(0, str.length() - 1);
        }
        if (str.indexOf("/") != -1) {
            str = str.substring(str.lastIndexOf(47) + 1);
        }
        if (str.startsWith(WS_CLIENT_DIR_PREFIX)) {
            String suffix = str.substring(WS_CLIENT_DIR_PREFIX.length());
            index = new Integer(suffix);
        }
        return index;
    }
}

