/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.wsclient;

import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientIdentifier;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientRuntimeInfo;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientsUtil;
import com.sap.tc.logging.Location;
import java.util.HashSet;

public class WSClientChecker {
    public void checkWSClients(WSClientRuntimeInfo[] wsClientRuntimeInfos, String[] additionalServiceRefNames) throws WSDeploymentException {
        this.makeSingleWSClientCheck(wsClientRuntimeInfos);
        if (additionalServiceRefNames == null) {
            additionalServiceRefNames = new String[]{};
        }
        String[] wsClientNames = WSClientsUtil.collectWSClientNames(wsClientRuntimeInfos);
        WSUtil.printStrings(wsClientNames);
        WSUtil.printStrings(additionalServiceRefNames);
        this.checkWSClientNamesForDublicates(WSUtil.unifyStrings(new String[][]{WSClientsUtil.collectWSClientNames(wsClientRuntimeInfos), additionalServiceRefNames}));
    }

    public void makeSingleWSClientCheck(WSClientRuntimeInfo[] wsClientRuntimeInfos) throws WSDeploymentException {
        if (wsClientRuntimeInfos == null) {
            return;
        }
        int i = 0;
        while (i < wsClientRuntimeInfos.length) {
            WSClientRuntimeInfo wsClientRuntimeInfo = wsClientRuntimeInfos[i];
            this.makeSingleWSClientCheck(wsClientRuntimeInfo);
            ++i;
        }
    }

    public void makeSingleWSClientCheck(WSClientRuntimeInfo wsClientRuntimeInfo) throws WSDeploymentException {
        String excMessage = "Unable to deploy ws client.";
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        try {
            this.checkWsdlAndUriMappingFilesCount(wsClientRuntimeInfo);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(excMessage, (Throwable)e);
            Object[] args = new String[]{excMessage, wsClientId.getApplicationName(), wsClientId.getJarName(), wsClientId.getServiceRefName()};
            throw new WSDeploymentException("webservices_5042", args, (Throwable)e);
        }
    }

    public void checkWsdlAndUriMappingFilesCount(WSClientRuntimeInfo wsClientRuntimeInfo) throws WSDeploymentException {
        int uriMappingFilesCount;
        String excMessage = "Wsdl and uri mapping files counts are not equal!";
        if (!wsClientRuntimeInfo.hasUriMappingFiles()) {
            return;
        }
        int wsdlFilesCount = wsClientRuntimeInfo.getWsdlFileNames().length;
        if (wsdlFilesCount != (uriMappingFilesCount = wsClientRuntimeInfo.getUriMappingFiles().length)) {
            Object[] args = new String[]{excMessage};
            throw new WSDeploymentException("webservices_5040", args);
        }
    }

    public void checkWSClientNamesForDublicates(String[] wsClientNames) throws WSDeploymentException {
        String dublicateWSClientName = this.hasDublicates(wsClientNames);
        if (dublicateWSClientName != null) {
            String msg = "There is dublicate element for ws client " + dublicateWSClientName + ". ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args);
        }
    }

    private String hasDublicates(String[] strs) {
        if (strs == null) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < strs.length) {
            String str = strs[i];
            if (set.contains(str)) {
                return str;
            }
            set.add(str);
            ++i;
        }
        return null;
    }
}

