/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.wsclient;

import com.sap.engine.services.webservices.server.deploy.common.WSBaseConstants;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.jar.JarUtil;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientArchiveFilesLocationHandler;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientDirsHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;

public class WSClientArchiveLocationHandlerMultipleMode
extends WSClientArchiveFilesLocationHandler {
    public WSClientArchiveLocationHandlerMultipleMode(File moduleArchive) throws IOException {
        super(moduleArchive);
    }

    public String getWSClientsDescriptorsDir() {
        return this.getMetaInfDir();
    }

    public String[] getWSClientsDeploymentDescriptorPathsMultipleMode() throws IOException {
        String wsClientsDDescriptorsDirEntryPath = this.getWSClientsDescriptorsDir();
        ZipEntry wsClientsDDescriptorDirEntry = this.getModuleJarArchive().getEntry(wsClientsDDescriptorsDirEntryPath);
        if (wsClientsDDescriptorDirEntry == null) {
            return new String[0];
        }
        String wsClientsDDescriptorPathPrefix = wsClientsDDescriptorsDirEntryPath + '/' + IOUtil.getFileNameWithoutExt(WSClientDirsHandler.getWSClientsDeploymentDescriptorFileName());
        return JarUtil.getEntryNames(wsClientsDDescriptorPathPrefix, this.getModuleJarArchive());
    }

    public InputStream[] getWSClientsDeploymentDescriptorInputStreamMultipleMode() throws IOException {
        String[] wsClientsDDescriptorPathsMultipleMode = this.getWSClientsDeploymentDescriptorPathsMultipleMode();
        if (wsClientsDDescriptorPathsMultipleMode == null) {
            return new InputStream[0];
        }
        InputStream[] wsClientsDDescriptorInputStreams = new InputStream[wsClientsDDescriptorPathsMultipleMode.length];
        int i = 0;
        while (i < wsClientsDDescriptorPathsMultipleMode.length) {
            ZipEntry zipEntry = this.getModuleJarArchive().getEntry(wsClientsDDescriptorPathsMultipleMode[i]);
            wsClientsDDescriptorInputStreams[i] = this.getModuleJarArchive().getInputStream(zipEntry);
            ++i;
        }
        return wsClientsDDescriptorInputStreams;
    }

    public boolean existsWSClientsDeploymentDescriptorMultipleMode() throws IOException {
        ZipEntry zipEntry = this.getModuleJarArchive().getEntry(this.getWSClientsDescriptorsDir());
        return zipEntry != null;
    }

    public String[] getWSClientsDeploymentDescriptorLocationMsgMultipleMode() throws IOException {
        String[] wsClientsDDescriptorPathsMultipleMode = this.getWSClientsDeploymentDescriptorPathsMultipleMode();
        if (wsClientsDDescriptorPathsMultipleMode == null) {
            return new String[0];
        }
        String[] wsClientsDDescriptorLocationMsgsMultipleMode = new String[wsClientsDDescriptorPathsMultipleMode.length];
        int i = 0;
        while (i < wsClientsDDescriptorPathsMultipleMode.length) {
            String locationMsg = "type: zip entry, ";
            locationMsg = locationMsg + this.getLocationMsg() + ", ";
            wsClientsDDescriptorLocationMsgsMultipleMode[i] = locationMsg = locationMsg + "entry: " + wsClientsDDescriptorPathsMultipleMode[i] + " ";
            ++i;
        }
        return wsClientsDDescriptorLocationMsgsMultipleMode;
    }

    protected String getMetaInfValue() throws IOException {
        String metaInfValue = null;
        int i = 0;
        while (i < WSBaseConstants.META_INF.length) {
            metaInfValue = WSBaseConstants.META_INF[i];
            if (this.getModuleJarArchive().getEntry(metaInfValue + '/' + "ws-clients-descriptors") != null) break;
            ++i;
        }
        if (metaInfValue != null) {
            metaInfValue = metaInfValue + "/ws-clients-descriptors";
        }
        return metaInfValue;
    }
}

