/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.wsclient;

import com.sap.engine.services.webservices.server.deploy.common.WSBaseConstants;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientDirsHandler;
import com.sap.engine.services.webservices.server.deploy.wsclient.WSClientFilesLocationHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class WSClientArchiveFilesLocationHandler
implements WSClientFilesLocationHandler {
    private File moduleArchive = null;
    private JarFile moduleJarArchive = null;
    private String metaInfValue = null;

    public WSClientArchiveFilesLocationHandler(File moduleArchive) throws IOException {
        this.moduleArchive = moduleArchive;
        this.metaInfValue = this.getMetaInfValue();
    }

    protected JarFile getModuleJarArchive() throws IOException {
        if (this.moduleJarArchive == null) {
            this.moduleJarArchive = new JarFile(this.moduleArchive);
        }
        return this.moduleJarArchive;
    }

    public File getModuleArchive() {
        return this.moduleArchive;
    }

    public String getMetaInfDir() {
        return this.metaInfValue;
    }

    public String getWSClientsDeploymentDescriptorPath() {
        return this.getMetaInfDir() + '/' + WSClientDirsHandler.getWSClientsDeploymentDescriptorFileName();
    }

    public InputStream getWSClientsDeploymentDescriptorInputStream() throws IOException {
        ZipEntry zipEntry = this.getModuleJarArchive().getEntry(this.getWSClientsDeploymentDescriptorPath());
        return this.getModuleJarArchive().getInputStream(zipEntry);
    }

    public boolean existsWSClientsDeploymentDescriptor() throws IOException {
        return this.getModuleJarArchive().getEntry(this.getWSClientsDeploymentDescriptorPath()) != null;
    }

    public String getWSClientsDeploymentDescriptorLocationMsg() {
        String locationMsg = "type: zip entry, ";
        locationMsg = locationMsg + this.getLocationMsg() + ", ";
        locationMsg = locationMsg + "entry: " + this.getWSClientsDeploymentDescriptorPath() + " ";
        return locationMsg;
    }

    public String getLogPortsPath(String logPortsRelPath) {
        return this.getMetaInfDir() + '/' + logPortsRelPath;
    }

    public InputStream getLogPortsInputStream(String logPortsRelPath) throws IOException {
        ZipEntry zipEntry = this.getModuleJarArchive().getEntry(this.getLogPortsPath(logPortsRelPath));
        return this.getModuleJarArchive().getInputStream(zipEntry);
    }

    public String getLogPortsLocationMsg(String logPortsRelPath) {
        String locationMsg = "type: zip entry, ";
        locationMsg = locationMsg + this.getLocationMsg() + ", ";
        locationMsg = locationMsg + "entry: " + this.getLogPortsPath(logPortsRelPath) + " ";
        return locationMsg;
    }

    public String[] getWsdlPaths(String[] wsdlRelPaths) {
        if (wsdlRelPaths == null) {
            return new String[0];
        }
        String metaInfDir = this.getMetaInfDir();
        String[] wsdlEntryPaths = new String[wsdlRelPaths.length];
        int i = 0;
        while (i < wsdlRelPaths.length) {
            wsdlEntryPaths[i] = metaInfDir + '/' + wsdlRelPaths[i];
            ++i;
        }
        return wsdlEntryPaths;
    }

    public InputStream[] getWsdlInputStream(String wsdlRelPaths) throws IOException {
        return new InputStream[0];
    }

    public InputStream[] getWsdlInputStream(String[] wsdlRelPaths) throws IOException {
        String[] wsdlPaths = this.getWsdlPaths(wsdlRelPaths);
        if (wsdlPaths == null) {
            return new InputStream[0];
        }
        InputStream[] wsdlInputStreams = new InputStream[wsdlPaths.length];
        int i = 0;
        while (i < wsdlPaths.length) {
            ZipEntry zipEntry = this.getModuleJarArchive().getEntry(wsdlPaths[i]);
            wsdlInputStreams[i] = this.getModuleJarArchive().getInputStream(zipEntry);
            ++i;
        }
        return wsdlInputStreams;
    }

    public String[] getWsdlLocationMsg(String[] wsdlRelPaths) {
        String[] wsdlPaths = this.getWsdlPaths(wsdlRelPaths);
        if (wsdlPaths == null) {
            return new String[0];
        }
        String[] wsdlLocationMsgs = new String[wsdlPaths.length];
        int i = 0;
        while (i < wsdlPaths.length) {
            String locationMsg = "type: zip entry, ";
            locationMsg = locationMsg + this.getLocationMsg() + ", ";
            wsdlLocationMsgs[i] = locationMsg = locationMsg + "entry: " + wsdlPaths[i] + " ";
            ++i;
        }
        return wsdlLocationMsgs;
    }

    public String[] getUriMappingPaths(String[] uriMappingsRelPaths) {
        if (uriMappingsRelPaths == null) {
            return new String[0];
        }
        String metaInfDir = this.getMetaInfDir();
        String[] uriMappingsEntryPaths = new String[uriMappingsRelPaths.length];
        int i = 0;
        while (i < uriMappingsEntryPaths.length) {
            uriMappingsEntryPaths[i] = metaInfDir + '/' + uriMappingsRelPaths[i];
            ++i;
        }
        return uriMappingsEntryPaths;
    }

    public InputStream[] getUriMappingInputStream(String[] uriMappingRelPaths) throws IOException {
        String[] uriMappingPaths = this.getUriMappingPaths(uriMappingRelPaths);
        if (uriMappingPaths == null) {
            return new InputStream[0];
        }
        InputStream[] uriMappingInputStreams = new InputStream[uriMappingPaths.length];
        int i = 0;
        while (i < uriMappingPaths.length) {
            ZipEntry zipEntry = this.getModuleJarArchive().getEntry(uriMappingPaths[i]);
            uriMappingInputStreams[i] = this.getModuleJarArchive().getInputStream(zipEntry);
            ++i;
        }
        return uriMappingInputStreams;
    }

    public String[] getUriMappingLocationMsg(String[] uriMappingRelPaths) {
        String[] uriMappingPaths = this.getWsdlPaths(uriMappingRelPaths);
        if (uriMappingPaths == null) {
            return new String[0];
        }
        String[] uriMappingLocationMsgs = new String[uriMappingPaths.length];
        int i = 0;
        while (i < uriMappingPaths.length) {
            String locationMsg = "type: zip entry, ";
            locationMsg = locationMsg + this.getLocationMsg() + ", ";
            uriMappingLocationMsgs[i] = locationMsg = locationMsg + "entry: " + uriMappingPaths[i] + " ";
            ++i;
        }
        return uriMappingLocationMsgs;
    }

    public String getPackageMappingPath(String packageMappingRelPath) {
        return this.getMetaInfDir() + '/' + packageMappingRelPath;
    }

    public InputStream getPackageMappingInputStream(String packageMappingRelPath) throws IOException {
        ZipEntry zipEntry = this.getModuleJarArchive().getEntry(this.getPackageMappingPath(packageMappingRelPath));
        return this.getModuleJarArchive().getInputStream(zipEntry);
    }

    public String getPackageMappingLocationMsg(String packageMappingRelPath) {
        String locationMsg = "type: zip entry, ";
        locationMsg = locationMsg + this.getLocationMsg() + ", ";
        locationMsg = locationMsg + "entry: " + this.getPackageMappingPath(packageMappingRelPath) + " ";
        return locationMsg;
    }

    public String getLocationMsg() {
        String locationMsg = "type: jar file, ";
        locationMsg = locationMsg + "location: " + this.moduleArchive.getAbsolutePath() + " ";
        return locationMsg;
    }

    public InputStream getInputStream(String entryName) throws IOException {
        return this.getModuleJarArchive().getInputStream(this.getModuleJarArchive().getEntry(entryName));
    }

    protected String getMetaInfValue() throws IOException {
        int i = 0;
        while (i < WSBaseConstants.META_INF.length) {
            String metaInfValue = WSBaseConstants.META_INF[i];
            if (this.getModuleJarArchive().getEntry(metaInfValue + '/' + "ws-clients-deployment-descriptor.xml") != null) {
                return metaInfValue;
            }
            ++i;
        }
        return null;
    }

    public void close() throws IOException {
        if (this.moduleJarArchive != null) {
            this.moduleJarArchive.close();
            this.moduleArchive = null;
        }
    }
}

