/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.wsclient;

import com.sap.engine.interfaces.webservices.runtime.component.ClientComponentFactory;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ServiceBaseServer;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortFactory;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPorts;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientIdentifier;
import com.sap.engine.services.webservices.runtime.definition.wsclient.WSClientRuntimeInfo;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.tc.logging.Location;
import javax.xml.rpc.Service;

public class ServiceFactory {
    public static final String DEFAULT_SERVICE_CLASS_NAME = "javax.xml.rpc.Service";

    public Service getServiceInstance(WSClientRuntimeInfo wsClientRuntimeInfo) throws WSDeploymentException {
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String applicationName = wsClientId.getApplicationName();
        ClassLoader appLoader = WSContainer.getServiceContext().getCoreContext().getLoadContext().getClassLoader(applicationName);
        return this.getServiceInstance(wsClientRuntimeInfo, appLoader);
    }

    public Service getServiceInstance(WSClientRuntimeInfo wsClientRuntimeInfo, ClassLoader loader) throws WSDeploymentException {
        String excMsg = "Error occured, trying to instantiate ws client service instance.";
        WSClientIdentifier wsClientId = wsClientRuntimeInfo.getWsClientId();
        String logPortsFileName = wsClientRuntimeInfo.getLogicalPortsFullFileName();
        String serviceInterfaceName = wsClientRuntimeInfo.getServiceInterfaceName();
        ServiceBaseServer service = null;
        try {
            if (serviceInterfaceName.equals(DEFAULT_SERVICE_CLASS_NAME)) {
                service = new ServiceBaseServer(logPortsFileName, (ClientComponentFactory)WSContainer.getComponentFactory(), loader);
            } else {
                String serviceClassName = this.getServiceClassName(serviceInterfaceName);
                Class<?> serviceClass = loader.loadClass(serviceClassName);
                service = (ServiceBaseServer)serviceClass.newInstance();
                LogicalPorts logPorts = new LogicalPortFactory().loadLogicalPorts(logPortsFileName);
                service.init(logPorts, (ClientComponentFactory)WSContainer.getComponentFactory(), loader, WSLogging.getWSClientLocationName(wsClientId.getApplicationName(), wsClientId.getServiceRefName()));
            }
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching(excMsg, (Throwable)e);
            Object[] args = new String[]{excMsg, wsClientId.getApplicationName(), wsClientId.getJarName(), wsClientId.getServiceRefName()};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        this.makeWSClientStartSettings(wsClientRuntimeInfo, (Service)service);
        return service;
    }

    private void makeWSClientStartSettings(WSClientRuntimeInfo wsClientRuntimeInfo, Service service) {
        ((ServiceBaseServer)service).setHTTPProxyResolver(WSContainer.getHTTPProxyResolver());
        ((ServiceBaseServer)service).setSLDConnection(WSContainer.getSLDConnection());
    }

    private String getServiceClassName(String serviceInterfaceName) {
        return serviceInterfaceName + "Impl";
    }
}

