/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.ws.update;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.lib.io.hash.HashUtils;
import com.sap.engine.services.webservices.exceptions.WSConfigurationException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.server.deploy.WSConfigurationHandler;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDirsHandler;
import com.sap.engine.services.webservices.server.deploy.common.ModuleFileStorageHandler;
import com.sap.engine.services.webservices.server.deploy.common.update.ModuleUpdateProcessor;
import com.sap.engine.services.webservices.server.deploy.common.update.ModuleUpdateResult;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.util.jar.JarUtil;
import com.sap.engine.services.webservices.server.deploy.ws.WSChecker;
import com.sap.engine.services.webservices.server.deploy.ws.WSDefinitionFactory;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeployGenerator;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeploymentInfo;
import com.sap.engine.services.webservices.server.deploy.ws.WSDirsHandler;
import com.sap.engine.services.webservices.server.deploy.ws.deploy.WSDeployResult;
import com.sap.engine.services.webservices.server.deploy.ws.preprocess.WSArchiveLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.ws.preprocess.WSFileLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.ws.preprocess.WSLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.ws.preprocess.WSPreprocessor;
import com.sap.engine.services.webservices.server.deploy.ws.update.SingleWSUpdateProcessor;
import com.sap.engine.services.webservices.server.deploy.ws.update.WSAppUpdateResult;
import com.sap.engine.services.webservices.server.deploy.ws.update.WSUpdateInfo;
import com.sap.engine.services.webservices.server.deploy.ws.update.WSUpdateResult;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class WSUpdateProcessor {
    private WSDefinitionFactory wsDefinitionFactory = new WSDefinitionFactory();
    private WSPreprocessor wsPreprocessor = new WSPreprocessor();
    private WSDeployGenerator wsDeployGenerator = null;
    private SingleWSUpdateProcessor singleWSUpdateProcessor = null;
    private ModuleUpdateProcessor moduleUpdateProcessor = null;
    private ModuleFileStorageHandler moduleFileStorageHandler = null;
    private JarUtil jarUtil = null;

    public WSUpdateProcessor(WSDeployGenerator wsDeployGenerator, ModuleUpdateProcessor moduleUpdateProcessor, ModuleFileStorageHandler moduleFileStorageHandler) {
        this.wsDeployGenerator = wsDeployGenerator;
        this.singleWSUpdateProcessor = new SingleWSUpdateProcessor(wsDeployGenerator);
        this.moduleUpdateProcessor = moduleUpdateProcessor;
        this.moduleFileStorageHandler = moduleFileStorageHandler;
        this.jarUtil = new JarUtil();
    }

    public WSAppUpdateResult updateWebServices(String applicationName, String webServicesDir, String webServicesWorkingDir, File[] moduleArchives, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occured, trying to update web services for application " + applicationName + ". ";
        this.wsPreprocessor.preprocess(applicationName, webServicesDir, appConfiguration);
        Hashtable notChangedModuleArchives = null;
        Object[] notChangedWS = null;
        WSArchiveLocationWrapper[] newWSArchiveLocationWrappers = null;
        WSFileLocationWrapper[] oldFileLocationWrappersAll = null;
        try {
            notChangedModuleArchives = this.moduleUpdateProcessor.collectNotChangedModules(moduleArchives, WSConfigurationHandler.loadWSModuleCrcTable(appConfiguration));
            notChangedWS = this.moduleUpdateProcessor.collectNotChangedWSComponentsPerModules(notChangedModuleArchives.keySet(), webServicesDir);
            File[] moduleArchivesChanged = IOUtil.filterFiles(moduleArchives, notChangedModuleArchives.keySet());
            newWSArchiveLocationWrappers = this.wsDefinitionFactory.loadWSArchiveLocationWrappers(applicationName, moduleArchivesChanged);
            oldFileLocationWrappersAll = this.wsPreprocessor.loadWSFileLocationWrappers(applicationName, webServicesDir, appConfiguration);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + " Unable to collect web services update information. ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        WSUpdateResult wsUpdateResult = this.updateWebServices(applicationName, webServicesDir, webServicesWorkingDir, newWSArchiveLocationWrappers, oldFileLocationWrappersAll, WSUtil.collectSet(notChangedWS), appConfiguration);
        if (wsUpdateResult.getDeployedComponentNames() == null || wsUpdateResult.getDeployedComponentNames().length == 0) {
            WSAppUpdateResult wsAppUpdateResult = new WSAppUpdateResult();
            wsAppUpdateResult.setWsUpdateResult(wsUpdateResult);
            wsAppUpdateResult.setModuleDeployResult(new ModuleUpdateResult());
            return wsAppUpdateResult;
        }
        ModuleUpdateResult moduleUpdateResult = this.moduleUpdateProcessor.updateModuleFiles(applicationName, webServicesDir, this.getModuleArchives(newWSArchiveLocationWrappers), notChangedModuleArchives, appConfiguration, WSDirsHandler.getWebServicesConfigName("webservices_container"));
        WSAppUpdateResult wsAppUpdateResult = new WSAppUpdateResult();
        wsAppUpdateResult.setModuleDeployResult(moduleUpdateResult);
        wsAppUpdateResult.setWsUpdateResult(wsUpdateResult);
        return wsAppUpdateResult;
    }

    private WSUpdateResult updateWebServices(String applicationName, String webServicesDir, String webServicesWorkingDir, WSArchiveLocationWrapper[] newWSArchiveLocationWrappers, WSFileLocationWrapper[] oldWSFileLocationWrappersAll, Set notChangedWSSet, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occured, trying to update web services for application " + applicationName + ". ";
        WSLocationWrapper[] notChangedWSFileLocationWrappers = this.filterWSFileLocationWrappers(oldWSFileLocationWrappersAll, notChangedWSSet, false);
        WSFileLocationWrapper[] oldWSFileLocationWrappers = this.filterWSFileLocationWrappers(oldWSFileLocationWrappersAll, notChangedWSSet, true);
        WSUpdateInfo wsUpdateInfo = this.collectWSUpdateInfo(newWSArchiveLocationWrappers, oldWSFileLocationWrappers);
        WSUpdateResult notChangedWSUpdateResult = this.singleWSUpdateProcessor.defineWSUpdateResult((WSFileLocationWrapper[])notChangedWSFileLocationWrappers);
        if (!(oldWSFileLocationWrappers != null && oldWSFileLocationWrappers.length != 0 || newWSArchiveLocationWrappers != null && newWSArchiveLocationWrappers.length != 0)) {
            return notChangedWSUpdateResult;
        }
        int maxIndex = WSUtil.getMaxPositiveInt(this.collectIndexSet(oldWSFileLocationWrappersAll));
        int[] freeIndexes = WSUtil.getIntArray(WSUtil.getMissedInts(this.collectIndexSet(oldWSFileLocationWrappersAll), 0, maxIndex));
        String[] webServiceNamesNotChanged = this.collectWebServiceNames(notChangedWSFileLocationWrappers);
        WSUpdateResult changedWSUpdateResult = this.updateWebServices(applicationName, webServicesDir, webServicesWorkingDir, wsUpdateInfo, webServiceNamesNotChanged, freeIndexes, maxIndex, appConfiguration);
        WSUpdateResult wsUpdateResultFinal = new WSUpdateResult();
        wsUpdateResultFinal.addWSUpdateResult(notChangedWSUpdateResult);
        wsUpdateResultFinal.addWSUpdateResult(changedWSUpdateResult);
        String deployedComponentsPerModuleFileName = ModuleDirsHandler.getDeployedComponestPerModuleFileName();
        String deployedComponentsPerModuleParentDir = ModuleDirsHandler.getDeployedComponentsPerModuleParentDir(webServicesDir);
        try {
            this.moduleFileStorageHandler.saveDeployedComponentsPerModule(webServicesDir, wsUpdateResultFinal.getDeployedWSPerModule());
            WSConfigurationHandler.uploadFile(deployedComponentsPerModuleParentDir, deployedComponentsPerModuleFileName, appConfiguration, WSDirsHandler.getWebServicesConfigName("webservices_container") + "/" + ModuleDirsHandler.getAppJarsRelDir());
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to save and/or upload " + ModuleDirsHandler.getDeployedComponestPerModuleFileName() + ". ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsUpdateResultFinal;
    }

    private WSUpdateResult updateWebServices(String applicationName, String webServicesDir, String webServicesWorkingDir, WSUpdateInfo wsUpdateInfo, String[] webServiceNamesNotChanged, int[] freeIndexes, int maxIndex, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occured, trying to update web services for application " + applicationName + ". ";
        WSUpdateResult wsUpdateResultFinal = new WSUpdateResult();
        try {
            WSFileLocationWrapper[] wsForDeleteFileLocationWrappers = wsUpdateInfo.getWsForDeleteFileLocationWrappers();
            this.singleWSUpdateProcessor.deleteWebServices(wsForDeleteFileLocationWrappers, appConfiguration);
            WSUpdateResult wsUpdateResult = this.singleWSUpdateProcessor.updateWebServices(applicationName, webServicesDir, webServicesWorkingDir, wsUpdateInfo.getWsForUpdateArchiveLocationWrappers(), wsUpdateInfo.getWsForUpdateFileLocationWrappers(), appConfiguration);
            String[] webServiceNamesUpdated = this.collectWebServiceNames(this.collectWSFileLocationWrappers(wsUpdateInfo.getWsForUpdateFileLocationWrappers()));
            String[] additionalWebServiceNames = WSUtil.unifyStrings(new String[][]{webServiceNamesNotChanged, webServiceNamesUpdated});
            int[] freeIndexesDeleted = WSUtil.getIntArray(this.collectIndexSet(wsForDeleteFileLocationWrappers));
            int[] allFreeIndexes = WSUtil.unifyInts(new int[][]{freeIndexes, freeIndexesDeleted});
            WSDeployResult wsDeployResult = this.deployWebServices(applicationName, webServicesDir, webServicesWorkingDir, wsUpdateInfo.getWsForDeployArchiveLocationWrappers(), additionalWebServiceNames, allFreeIndexes, maxIndex, appConfiguration);
            wsUpdateResultFinal.addWSUpdateResult(wsDeployResult);
            wsUpdateResultFinal.addWSUpdateResult(wsUpdateResult);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsUpdateResultFinal;
    }

    private WSUpdateInfo collectWSUpdateInfo(WSArchiveLocationWrapper[] newWSArchiveLocationWrappers, WSFileLocationWrapper[] oldWSFIFileLocationWrappers) {
        return this.collectWSUpdateInfo(this.collectWSLocationWrappersTable(newWSArchiveLocationWrappers), this.collectWSLocationWrappersTable(oldWSFIFileLocationWrappers));
    }

    public WSUpdateInfo collectWSUpdateInfo(Hashtable newWSArchiveLocationWrappers, Hashtable oldWSFileLocationWrappers) {
        Hashtable wsForDeploy = WSUtil.makeSubtraction(newWSArchiveLocationWrappers, oldWSFileLocationWrappers);
        Hashtable wsForDelete = WSUtil.makeSubtraction(oldWSFileLocationWrappers, newWSArchiveLocationWrappers);
        Hashtable wsForUpdateNewWrappers = WSUtil.makeIntersection(newWSArchiveLocationWrappers, oldWSFileLocationWrappers);
        Hashtable wsForUpdateOldWrappers = WSUtil.makeIntersection(oldWSFileLocationWrappers, newWSArchiveLocationWrappers);
        WSUpdateInfo wsUpdateInfo = new WSUpdateInfo();
        wsUpdateInfo.setWsForDeployArchiveLocationWrappers(this.collectWSArchiveLocationWrappers(wsForDeploy));
        wsUpdateInfo.setWsForDeleteFileLocationWrappers(this.collectWSFileLocationWrappers(wsForDelete));
        wsUpdateInfo.setWsForUpdateArchiveLocationWrappers(wsForUpdateNewWrappers);
        wsUpdateInfo.setWsForUpdateFileLocationWrappers(wsForUpdateOldWrappers);
        return wsUpdateInfo;
    }

    public Hashtable collectNotChangedModules(String webServicesDir, File[] moduleArchivesNew, Configuration appConfiguration, Properties notChangedDeployedWSPerModule) throws WSDeploymentException {
        String excMsg = "Error occured, trying to collect not updated modules. ";
        Properties deployedWSPerModuleOld = null;
        Hashtable moduleCrcOld = null;
        try {
            moduleCrcOld = WSConfigurationHandler.loadWSModuleCrcTable(appConfiguration);
            deployedWSPerModuleOld = this.loadDeployedComponentsPerModuleFile(webServicesDir);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return this.collectNotChangedModules(moduleArchivesNew, moduleCrcOld, deployedWSPerModuleOld, notChangedDeployedWSPerModule);
    }

    public Hashtable collectNotChangedModules(File[] moduleArchivesNew, Hashtable moduleCrcOld, Properties deployedWSPerModule, Properties notChangedDeployedWSPerModule) throws WSDeploymentException {
        String excMsg = "Error occured, trying to collect not updated modules. ";
        if (moduleArchivesNew == null) {
            return new Hashtable();
        }
        Hashtable<String, File> notChangedModules = new Hashtable<String, File>();
        int i = 0;
        while (i < moduleArchivesNew.length) {
            File moduleArchiveNew = moduleArchivesNew[i];
            String moduleName = moduleArchiveNew.getName();
            try {
                if (moduleCrcOld.containsKey(moduleName)) {
                    byte[] oldCrc = (byte[])moduleCrcOld.get(moduleName);
                    byte[] newCrc = HashUtils.generateFileHash((File)moduleArchiveNew);
                    if (HashUtils.compareHash((byte[])newCrc, (byte[])oldCrc)) {
                        ((Hashtable)notChangedDeployedWSPerModule).put(moduleName, deployedWSPerModule.getProperty(moduleName));
                        notChangedModules.put(moduleName, moduleArchiveNew);
                    }
                }
            }
            catch (IOException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                String msg = excMsg + "Unable to process module " + moduleArchiveNew.getAbsolutePath() + ". ";
                Object[] args = new String[]{msg};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            ++i;
        }
        return notChangedModules;
    }

    private WSDeployResult deployWebServices(String applicationName, String webServicesDir, String webServicesWorkingDir, WSArchiveLocationWrapper[] wsForDeployArchiveLocationWrappers, String[] webServiceNamesUpdated, int[] freeIndexes, int maxIndex, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occured, trying to generate web services deployment files for application " + applicationName + ". ";
        boolean areDirsDeleted = false;
        try {
            areDirsDeleted = IOUtil.deleteDirs(new String[]{webServicesWorkingDir});
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to clear web services directories. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
        if (!areDirsDeleted) {
            String msg = excMsg + "Unable to clear web services directories (" + webServicesWorkingDir + ") + this may cause problems on web services start or update phase. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5041", args);
        }
        WSDeployResult wsDeployResult = this.generateDeployFiles(applicationName, webServicesDir, webServicesWorkingDir, wsForDeployArchiveLocationWrappers, webServiceNamesUpdated, freeIndexes, maxIndex);
        WSRuntimeDefinition[] wsRuntimeDefinitions = this.collectWSRuntimeDefinitions(wsDeployResult.getWsDeploymentInfoes());
        try {
            WSConfigurationHandler.makeWSConfigurations(this.collectWSDirs(wsRuntimeDefinitions), appConfiguration);
        }
        catch (WSConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)((Object)e));
            String msg = excMsg + "Unable to make web services configurations. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)((Object)e));
        }
        return wsDeployResult;
    }

    private WSDeployResult generateDeployFiles(String applicationName, String webServicesDir, String webServicesWorkingDir, WSArchiveLocationWrapper[] wsForDeployArchiveLocationWrappers, String[] webServiceNamesUpdated, int[] freeIndexes, int maxIndex) throws WSDeploymentException {
        String excMsg = "Error occured, trying to generate web services deployment files for application " + applicationName + ". ";
        WSDeploymentInfo[] wsDeploymentInfoes = null;
        try {
            wsDeploymentInfoes = this.wsDefinitionFactory.loadWebServices(webServicesWorkingDir, wsForDeployArchiveLocationWrappers);
            WSRuntimeDefinition[] wsRuntimeDefinitions = this.collectWSRuntimeDefinitions(wsDeploymentInfoes);
            String[] webServiceNamesNew = this.collectWebServiceNames(wsRuntimeDefinitions);
            new WSChecker().checkServiceNamesForDublicates(WSUtil.unifyStrings(new String[][]{webServiceNamesNew, webServiceNamesUpdated}));
            this.wsDeployGenerator.generateWSDeployFiles(webServicesDir, webServicesWorkingDir, wsDeploymentInfoes, freeIndexes, maxIndex);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg;
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
        return this.singleWSUpdateProcessor.defineWSDeployResult(wsDeploymentInfoes);
    }

    private WSUpdateResult updateWebServices(String applicationName, String webServiceName, String webServicesWorkingDir, Hashtable wsForUpdateArchiveLocationWrappers, Hashtable wsForUpdateFileLocationWrappers, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occured, trying to update web services for application " + applicationName + ". ";
        int[] freeIndexes = WSUtil.getIntArray(this.collectIndexSet(this.collectWSFileLocationWrappers(wsForUpdateFileLocationWrappers)));
        WSDeployResult wsDeployResult = null;
        try {
            wsDeployResult = this.deployWebServices(applicationName, webServiceName, webServicesWorkingDir, this.collectWSArchiveLocationWrappers(wsForUpdateArchiveLocationWrappers), new String[0], freeIndexes, -1, appConfiguration);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        WSUpdateResult wsUpdateResult = new WSUpdateResult();
        wsUpdateResult.addWSUpdateResult(wsDeployResult);
        return wsUpdateResult;
    }

    private boolean hasModuleMappingsFile(String webServicesDir) {
        String moduleMappingsPath = ModuleDirsHandler.getModuleMappingsPath(webServicesDir);
        return new File(moduleMappingsPath).exists();
    }

    private Properties loadDeployedComponentsPerModuleFile(String webServicesDir) throws WSDeploymentException {
        Properties deployedComponentsPerModule = null;
        deployedComponentsPerModule = this.hasModuleMappingsFile(webServicesDir) ? this.moduleUpdateProcessor.loadProperties(ModuleDirsHandler.getDeployedComponentsPerModulePath(webServicesDir)) : new Properties();
        return deployedComponentsPerModule;
    }

    private WSArchiveLocationWrapper[] collectWSArchiveLocationWrappers(Hashtable wsArchiveLocationWrappers) {
        if (wsArchiveLocationWrappers == null) {
            return new WSArchiveLocationWrapper[0];
        }
        WSArchiveLocationWrapper[] wsArchiveLocationWrappersArr = new WSArchiveLocationWrapper[wsArchiveLocationWrappers.size()];
        Enumeration wsEnum = wsArchiveLocationWrappers.elements();
        int i = 0;
        while (wsEnum.hasMoreElements()) {
            wsArchiveLocationWrappersArr[i++] = (WSArchiveLocationWrapper)wsEnum.nextElement();
        }
        return wsArchiveLocationWrappersArr;
    }

    private WSFileLocationWrapper[] collectWSFileLocationWrappers(Hashtable wsFileLocationWrappers) {
        if (wsFileLocationWrappers == null) {
            return new WSFileLocationWrapper[0];
        }
        WSFileLocationWrapper[] wsFileLocationWrappersArr = new WSFileLocationWrapper[wsFileLocationWrappers.size()];
        Enumeration wsEnum = wsFileLocationWrappers.elements();
        int i = 0;
        while (wsEnum.hasMoreElements()) {
            wsFileLocationWrappersArr[i++] = (WSFileLocationWrapper)wsEnum.nextElement();
        }
        return wsFileLocationWrappersArr;
    }

    private WSRuntimeDefinition[] collectWSRuntimeDefinitions(WSDeploymentInfo[] wsDeploymentInfoes) {
        if (wsDeploymentInfoes == null) {
            return new WSRuntimeDefinition[0];
        }
        WSRuntimeDefinition[] wsRuntimeDefinitions = new WSRuntimeDefinition[wsDeploymentInfoes.length];
        int i = 0;
        while (i < wsDeploymentInfoes.length) {
            WSDeploymentInfo wsDeploymentInfo = wsDeploymentInfoes[i];
            wsRuntimeDefinitions[i] = wsDeploymentInfo.getWsRuntimeDefinition();
            ++i;
        }
        return wsRuntimeDefinitions;
    }

    private String[] collectWSDirs(WSRuntimeDefinition[] wsRuntimeDefinitions) {
        if (wsRuntimeDefinitions == null) {
            return new String[0];
        }
        String[] wsDirs = new String[wsRuntimeDefinitions.length];
        int i = 0;
        while (i < wsRuntimeDefinitions.length) {
            wsDirs[i] = wsRuntimeDefinitions[i].getWsDirsHandler().getWsDirectory();
            ++i;
        }
        return wsDirs;
    }

    private String[] collectWebServiceNames(WSRuntimeDefinition[] wsRuntimeDefinitions) {
        if (wsRuntimeDefinitions == null) {
            return new String[0];
        }
        String[] webServiceNames = new String[wsRuntimeDefinitions.length];
        int i = 0;
        while (i < wsRuntimeDefinitions.length) {
            webServiceNames[i] = wsRuntimeDefinitions[i].getWSIdentifier().getServiceName();
            ++i;
        }
        return webServiceNames;
    }

    private String[] collectWebServiceNames(WSLocationWrapper[] wsLocationWrappers) {
        if (wsLocationWrappers == null) {
            return new String[0];
        }
        String[] wsNames = new String[wsLocationWrappers.length];
        int i = 0;
        while (i < wsLocationWrappers.length) {
            wsNames[i] = wsLocationWrappers[i].getWebServiceName();
            ++i;
        }
        return wsNames;
    }

    private Hashtable collectWSLocationWrappersTable(WSLocationWrapper[] wsLocationWrappers) {
        if (wsLocationWrappers == null) {
            return new Hashtable();
        }
        Hashtable<String, WSLocationWrapper> wsLocationWrappersTable = new Hashtable<String, WSLocationWrapper>();
        int i = 0;
        while (i < wsLocationWrappers.length) {
            WSLocationWrapper wsLocationWrapper = wsLocationWrappers[i];
            wsLocationWrappersTable.put(wsLocationWrapper.getWebServiceName(), wsLocationWrapper);
            ++i;
        }
        return wsLocationWrappersTable;
    }

    private Set collectIndexSet(WSFileLocationWrapper[] wsFileLocationWrappers) {
        if (wsFileLocationWrappers == null) {
            return new HashSet();
        }
        HashSet<Integer> indexSet = new HashSet<Integer>();
        int i = 0;
        while (i < wsFileLocationWrappers.length) {
            int index = wsFileLocationWrappers[i].getWsDirsHandler().getIndex();
            if (index != -1) {
                indexSet.add(new Integer(index));
            }
            ++i;
        }
        return indexSet;
    }

    private File[] getModuleArchives(WSArchiveLocationWrapper[] wsArchiveLocationWrappers) {
        if (wsArchiveLocationWrappers == null) {
            return new File[0];
        }
        Vector<File> moduleArchives = new Vector<File>();
        int i = 0;
        while (i < wsArchiveLocationWrappers.length) {
            moduleArchives.add(wsArchiveLocationWrappers[i].getWsArchiveFilesLocationHandler().getModuleArchive());
            ++i;
        }
        Object[] moduleArchivesArr = new File[moduleArchives.size()];
        moduleArchives.copyInto(moduleArchivesArr);
        return moduleArchivesArr;
    }

    private WSFileLocationWrapper[] filterWSFileLocationWrappers(WSFileLocationWrapper[] wsFileLocationWrappers, Set wsNamesFilterList, boolean excludeFlag) {
        if (wsFileLocationWrappers == null) {
            return new WSFileLocationWrapper[0];
        }
        Vector<WSFileLocationWrapper> wsFileLocationWrappersFiltered = new Vector<WSFileLocationWrapper>();
        int i = 0;
        while (i < wsFileLocationWrappers.length) {
            WSFileLocationWrapper wsFileLocationWrapper = wsFileLocationWrappers[i];
            if (wsNamesFilterList.contains(wsFileLocationWrapper.getWebServiceName())) {
                if (!excludeFlag) {
                    wsFileLocationWrappersFiltered.add(wsFileLocationWrapper);
                }
            } else if (excludeFlag) {
                wsFileLocationWrappersFiltered.add(wsFileLocationWrapper);
            }
            ++i;
        }
        Object[] wsFileLocationWrappersFilteredArr = new WSFileLocationWrapper[wsFileLocationWrappersFiltered.size()];
        wsFileLocationWrappersFiltered.copyInto(wsFileLocationWrappersFilteredArr);
        return wsFileLocationWrappersFilteredArr;
    }
}

