/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.ws.update;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.webservices.exceptions.WSConfigurationException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.WSConfigurationHandler;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDeployGenerator;
import com.sap.engine.services.webservices.server.deploy.common.ModuleFileStorageHandler;
import com.sap.engine.services.webservices.server.deploy.common.update.ModuleUpdateProcessor;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeployGenerator;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeployManager;
import com.sap.engine.services.webservices.server.deploy.ws.WSDirsHandler;
import com.sap.engine.services.webservices.server.deploy.ws.WSProtocolNotificator;
import com.sap.engine.services.webservices.server.deploy.ws.WSRuntimeActivator;
import com.sap.engine.services.webservices.server.deploy.ws.WebServicesUtil;
import com.sap.engine.services.webservices.server.deploy.ws.preprocess.WSFileLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.ws.update.WSAppUpdateResult;
import com.sap.engine.services.webservices.server.deploy.ws.update.WSUpdateProcessor;
import com.sap.engine.services.webservices.server.deploy.ws.update.WSUpdateResult;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;

public class WSUpdateManager {
    private WSUpdateProcessor wsUpdateProcessor = null;
    private WSDeployManager wsDeployManager = null;

    public WSUpdateManager(WSDeployManager wsDeployManager, WSDeployGenerator wsDeployGenerator, ModuleDeployGenerator moduleDeployGenerator, ModuleFileStorageHandler moduleFileStorageHandler) {
        this.wsUpdateProcessor = new WSUpdateProcessor(wsDeployGenerator, new ModuleUpdateProcessor(moduleDeployGenerator, moduleFileStorageHandler), moduleFileStorageHandler);
        this.wsDeployManager = wsDeployManager;
    }

    public WSAppUpdateResult makeUpdate(String applicationName, String webServicesDir, String webServicesWorkingDir, File[] moduleArchives, Configuration appConfiguration) throws DeploymentException {
        String excMsg = "Error occured, trying to update web services for application " + applicationName + ". ";
        WSAppUpdateResult wsAppUpdateResult = this.wsUpdateProcessor.updateWebServices(applicationName, webServicesDir, webServicesWorkingDir, moduleArchives, appConfiguration);
        WSUpdateResult wsUpdateResult = wsAppUpdateResult.getWsUpdateResult();
        try {
            if (wsUpdateResult.getDeployedComponentNames() == null || wsUpdateResult.getDeployedComponentNames().length == 0) {
                if (WSConfigurationHandler.existsSubConfiguration(appConfiguration, WSDirsHandler.getWebServicesConfigName("webservices_container"))) {
                    WSConfigurationHandler.deleteConfiguration(appConfiguration, WSDirsHandler.getWebServicesConfigName("webservices_container"), "/");
                }
                this.wsDeployManager.removeWebServicesDir(applicationName);
            }
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + " Unable to delete " + WSDirsHandler.getWebServicesConfigName("webservices_container") + " configuration. ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        try {
            this.notifyProtocolsOnUpdate(applicationName, wsAppUpdateResult.getWsUpdateResult(), appConfiguration);
        }
        catch (WSWarningException e) {
            wsAppUpdateResult.addWarnings(e.getWarningsVector());
        }
        return wsAppUpdateResult;
    }

    public void notifyUpdatedComponents(String applicationName) throws WarningException {
        this.wsDeployManager.removeWebServicesDir(applicationName);
    }

    public void prepareUpdate(String applicationName) throws DeploymentException, WarningException {
        this.notifyProtocolsOnPostUpdate(applicationName);
    }

    public ApplicationDeployInfo commitUpdate(String applicationName) throws WarningException {
        this.notifyProtocolsOnCommitUpdate(applicationName);
        return null;
    }

    public void rollbackUpdate(String applicationName, Configuration appConfiguration, Properties props) throws WarningException {
        Vector warnings = new Vector();
        try {
            this.wsDeployManager.removeWebServicesDir(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.notifyProtocolsOnRollbackUpdate(applicationName, appConfiguration);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void notifyProtocolsOnUpdate(String applicationName, WSUpdateResult wsUpdateResult, Configuration appConfiguration) throws WSWarningException {
        String excMsg = "Error occured, trying to notify protocols on " + WSProtocolNotificator.getModeName(10) + " phase, application " + applicationName + ". ";
        WSRuntimeDefinition[] wsRuntimeDefinitions = wsUpdateResult.getWSRuntimeDefinitions();
        WSRuntimeDefinition[] wsRuntimeDefinitionsNotChanged = null;
        try {
            wsRuntimeDefinitionsNotChanged = this.loadWebServices(wsUpdateResult.getWsFileLocationWrappers(), appConfiguration);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            WSWarningException wExc = new WSWarningException();
            String msg = excMsg + e.getLocalizedMessage() + ". ";
            wExc.addWarning(msg);
            throw wExc;
        }
        WSRuntimeDefinition[] allWSRuntimeDefinitions = WebServicesUtil.unifyWSRuntimeDefinitiones(new WSRuntimeDefinition[][]{wsRuntimeDefinitions, wsRuntimeDefinitionsNotChanged});
        this.notifyProtocolsOnUpdate(applicationName, allWSRuntimeDefinitions, appConfiguration);
    }

    private void notifyProtocolsOnUpdate(String applicationName, WSRuntimeDefinition[] wsRuntimeDefinitions, Configuration appConfiguration) throws WSWarningException {
        String excMsg = "Error occured, trying to notify protocols on " + WSProtocolNotificator.getModeName(10) + " phase, application " + applicationName + ". ";
        Vector warnings = new Vector();
        try {
            this.wsDeployManager.notifyProtocolsOnRemove(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
        }
        try {
            this.wsDeployManager.notifyProtocolsOnDeploy(applicationName, wsRuntimeDefinitions, appConfiguration);
        }
        catch (WSWarningException e) {
            warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void notifyProtocolsOnPostUpdate(String applicationName) throws WSWarningException {
        String excMsg = "Error occured, trying to notify protocols on " + WSProtocolNotificator.getModeName(11) + " phase, applicationName " + applicationName + ". ";
        Vector warnings = new Vector();
        try {
            this.wsDeployManager.notifyProtocolsOnPostDeploy(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void notifyProtocolsOnCommitUpdate(String applicationName) throws WSWarningException {
        String excMsg = "Error occured, trying to notify protocols on " + WSProtocolNotificator.getModeName(12) + " phase, applicationName " + applicationName + ". ";
        Vector warnings = new Vector();
        try {
            this.wsDeployManager.notifyProtocolsOnCommitDeploy(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void notifyProtocolsOnRollbackUpdate(String applicationName, Configuration appConfiguration) throws WSWarningException {
        String excMsg = "Error occured, trying to notify protocols on rollback update for application " + applicationName + ". ";
        Vector warnings = new Vector();
        try {
            this.wsDeployManager.notifyProtocolsOnRollbackDeploy(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(WSUtil.addPrefixToStrings(excMsg, e.getWarningsVector()));
        }
        String webServicesDir = null;
        try {
            String wsContainerDir = WSContainer.getWSDeployer().getWSContainerDir(applicationName, 0);
            webServicesDir = WSDirsHandler.getWebServicesDir(wsContainerDir);
            IOUtil.deleteDir(webServicesDir);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            String msg = excMsg + "Unable to delete" + "webservices" + " directory. ";
            WSWarningException wExc = new WSWarningException();
            wExc.addWarnings(warnings);
            wExc.addWarning(msg);
            throw wExc;
        }
        try {
            new WSRuntimeActivator().downloadWSFiles(applicationName, appConfiguration);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            String msg = excMsg + e.getLocalizedMessage();
            WSWarningException wExc = new WSWarningException();
            wExc.addWarnings(warnings);
            wExc.addWarning(msg);
            throw wExc;
        }
        WSRuntimeDefinition[] wsRuntimeDefinitions = null;
        try {
            wsRuntimeDefinitions = this.loadWebServices(applicationName, webServicesDir);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            String msg = excMsg + e.getLocalizedMessage();
            WSWarningException wExc = new WSWarningException();
            wExc.addWarnings(warnings);
            wExc.addWarning(msg);
            throw wExc;
        }
        try {
            this.wsDeployManager.notifyProtocolsOnDeploy(applicationName, wsRuntimeDefinitions, appConfiguration);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.wsDeployManager.notifyProtocolsOnPostDeploy(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.wsDeployManager.notifyProtocolsOnCommitDeploy(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private WSRuntimeDefinition[] loadWebServices(String applicationName, String webServicesDir) throws WSDeploymentException {
        String excMsg = "Error occured, trying to load web services from directory " + webServicesDir + ", application " + applicationName + ". ";
        File appWSDeployDir = new File(webServicesDir);
        if (!appWSDeployDir.exists()) {
            return new WSRuntimeDefinition[0];
        }
        WSRuntimeDefinition[] wsRuntimeDefinitions = null;
        try {
            wsRuntimeDefinitions = this.loadWebServices(applicationName, appWSDeployDir.listFiles());
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsRuntimeDefinitions;
    }

    private WSRuntimeDefinition[] loadWebServices(String aplicationName, File[] wsDirs) throws WSDeploymentException {
        String excMsg = "Error occured, trying to load web services from the local file system, application " + aplicationName + ". ";
        if (wsDirs == null) {
            return new WSRuntimeDefinition[0];
        }
        Vector<WSRuntimeDefinition> wsRuntimeDefinitions = new Vector<WSRuntimeDefinition>();
        try {
            int i = 0;
            while (i < wsDirs.length) {
                File wsDir = wsDirs[i];
                if (!wsDir.getName().equals("app_jars")) {
                    WSRuntimeDefinition wsRuntimeDefinition = WSRuntimeActivator.loadWebService(aplicationName, wsDir.getAbsolutePath());
                    wsRuntimeDefinitions.add(wsRuntimeDefinition);
                }
                ++i;
            }
        }
        catch (WSDeploymentException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        Object[] wsRuntimeDefinitionsArray = new WSRuntimeDefinition[wsRuntimeDefinitions.size()];
        wsRuntimeDefinitions.copyInto(wsRuntimeDefinitionsArray);
        return wsRuntimeDefinitionsArray;
    }

    private WSRuntimeDefinition[] loadWebServices(WSFileLocationWrapper[] wsFileLocationWrappers, Configuration appConfiguration) throws WSDeploymentException {
        if (wsFileLocationWrappers == null) {
            return new WSRuntimeDefinition[0];
        }
        WSRuntimeDefinition[] wsRuntimeDefinitions = new WSRuntimeDefinition[wsFileLocationWrappers.length];
        int i = 0;
        while (i < wsFileLocationWrappers.length) {
            wsRuntimeDefinitions[i] = this.loadWebService(wsFileLocationWrappers[i], appConfiguration);
            ++i;
        }
        return wsRuntimeDefinitions;
    }

    private WSRuntimeDefinition loadWebService(WSFileLocationWrapper wsFileLocationWrapper, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occured, trying to load web service " + wsFileLocationWrapper.getWebServiceName() + ", application " + wsFileLocationWrapper.getApplicationName() + ". ";
        String wsDir = wsFileLocationWrapper.getWsDirsHandler().getWsDirectory();
        try {
            WSDirsHandler wsDirsHandler = wsFileLocationWrapper.getWsDirsHandler();
            WSConfigurationHandler.downloadConfiguration(wsDirsHandler.getDescriptorsDir(), wsDirsHandler.getWSConfigPath("webservices_container") + '/' + wsDirsHandler.getDescriptorsRelDir(), appConfiguration, new HashSet());
        }
        catch (WSConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)((Object)e));
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)((Object)e));
        }
        return WSRuntimeActivator.loadWebService(wsFileLocationWrapper.getApplicationName(), wsDir);
    }

    private String[] collectWSConfigNames(WSFileLocationWrapper[] wsFileLocationWrappers) {
        if (wsFileLocationWrappers == null) {
            return new String[0];
        }
        String[] wsConfigNames = new String[wsFileLocationWrappers.length];
        int i = 0;
        while (i < wsFileLocationWrappers.length) {
            wsConfigNames[i] = wsFileLocationWrappers[i].getWsDirsHandler().getWSConfigName();
            ++i;
        }
        return wsConfigNames;
    }

    private String[] collectWSDirs(WSFileLocationWrapper[] wsFileLocationWrappers) {
        if (wsFileLocationWrappers == null) {
            return new String[0];
        }
        String[] wsDirs = new String[wsFileLocationWrappers.length];
        int i = 0;
        while (i < wsFileLocationWrappers.length) {
            wsDirs[i] = wsFileLocationWrappers[i].getWsDirsHandler().getWsDirectory();
            ++i;
        }
        return wsDirs;
    }
}

