/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.ws.update;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.lib.io.hash.HashUtils;
import com.sap.engine.services.webservices.exceptions.WSConfigurationException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.server.deploy.WSConfigurationHandler;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.WSDeploymentDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.WSDeploymentParser;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.WSDescriptor;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.ws.WSArchiveFilesLocationHandler;
import com.sap.engine.services.webservices.server.deploy.ws.WSDefinitionFactory;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeployGenerator;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeploymentInfo;
import com.sap.engine.services.webservices.server.deploy.ws.WSDirsHandler;
import com.sap.engine.services.webservices.server.deploy.ws.WSServerDeploySettingsProvider;
import com.sap.engine.services.webservices.server.deploy.ws.deploy.WSDeployResult;
import com.sap.engine.services.webservices.server.deploy.ws.deploy.WSDescriptorsLocationTable;
import com.sap.engine.services.webservices.server.deploy.ws.preprocess.ExtArchiveLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.ws.preprocess.ExtFileLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.ws.preprocess.WSArchiveLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.ws.preprocess.WSFileLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.ws.preprocess.WSLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.ws.update.SingleWSUpdateInfo;
import com.sap.engine.services.webservices.server.deploy.ws.update.WSUpdateResult;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class SingleWSUpdateProcessor {
    private WSDefinitionFactory wsDefinitionFactory = new WSDefinitionFactory();
    private WSDeployGenerator wsDeployGenerator = null;

    public SingleWSUpdateProcessor(WSDeployGenerator wsDeployGenerator) {
        WSServerDeploySettingsProvider wsServerDeploySettingsProvider = new WSServerDeploySettingsProvider();
        this.wsDeployGenerator = wsDeployGenerator;
    }

    public WSUpdateResult updateWebServices(String applicationName, String webServicesDir, String webServicesWorkingDir, Hashtable wsArchiveLocationWrappersNew, Hashtable wsFileLocationWrappersOld, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occured, trying to update web services for application " + applicationName + ". ";
        WSUpdateResult wsUpdateResult = null;
        try {
            SingleWSUpdateInfo[] singleWSUpdateInfoes = this.getSingleWSUpdateInfoes(webServicesWorkingDir, wsArchiveLocationWrappersNew, wsFileLocationWrappersOld, appConfiguration);
            wsUpdateResult = this.updateWebServices(webServicesDir, webServicesWorkingDir, singleWSUpdateInfoes, appConfiguration);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsUpdateResult;
    }

    public WSUpdateResult updateWebServices(String webServicesDir, String webServicesWorkingDir, SingleWSUpdateInfo[] singleWSUpdateInfoes, Configuration appConfiguration) throws WSDeploymentException {
        SingleWSUpdateInfo[] notChangedWS = this.collectSingleWSUpdateInfo(singleWSUpdateInfoes, false);
        SingleWSUpdateInfo[] changedWS = this.collectSingleWSUpdateInfo(singleWSUpdateInfoes, true);
        WSUpdateResult wsUpdateResult1 = this.defineWSUpdateResult(this.collectExtFileLocationWrappers(notChangedWS));
        WSUpdateResult wsUpdateResult2 = this.updateWebServices0(webServicesDir, webServicesWorkingDir, changedWS, appConfiguration);
        WSUpdateResult wsUpdateResultFinal = new WSUpdateResult();
        wsUpdateResultFinal.addWSUpdateResult(wsUpdateResult1);
        wsUpdateResultFinal.addWSUpdateResult(wsUpdateResult2);
        return wsUpdateResultFinal;
    }

    public WSUpdateResult updateWebServices0(String webServicesDir, String webServicesWorkingDir, SingleWSUpdateInfo[] singleWSUpdateInfoes, Configuration appConfiguration) throws WSDeploymentException {
        if (singleWSUpdateInfoes == null) {
            return new WSUpdateResult();
        }
        WSDeploymentInfo[] wsDeploymentInfoes = new WSDeploymentInfo[singleWSUpdateInfoes.length];
        int i = 0;
        while (i < singleWSUpdateInfoes.length) {
            wsDeploymentInfoes[i] = this.updateSingleWebService(webServicesDir, webServicesWorkingDir, singleWSUpdateInfoes[i], appConfiguration);
            ++i;
        }
        WSUpdateResult wsUpdateResult = new WSUpdateResult();
        WSDeployResult wsDeployResult = this.defineWSDeployResult(wsDeploymentInfoes);
        wsUpdateResult.addWSUpdateResult(wsDeployResult);
        return wsUpdateResult;
    }

    public WSDeploymentInfo updateSingleWebService(String webServicesDir, String webServicesWorkingDir, SingleWSUpdateInfo singleWSUpdateInfo, Configuration appConfiguration) throws WSDeploymentException {
        ExtArchiveLocationWrapper extArchiveLocationWrapper = singleWSUpdateInfo.getExtArchiveLocationWrapper();
        ExtFileLocationWrapper extFileLocationWrapper = singleWSUpdateInfo.getExtFileLocationWrapper();
        String excMsg = "Error occured, trying to regenerate web services deployment files for web service " + extArchiveLocationWrapper.getWebServiceName() + ", application " + extArchiveLocationWrapper.getApplicationName() + ". ";
        try {
            this.deleteWS(extFileLocationWrapper, appConfiguration);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
        WSDeploymentInfo wsDeploymentInfo = null;
        try {
            wsDeploymentInfo = this.wsDefinitionFactory.loadWebService(webServicesWorkingDir, extArchiveLocationWrapper);
            int index = extFileLocationWrapper.getWsDirsHandler().getIndex();
            if (index != -1) {
                this.wsDeployGenerator.generateWSDeployFiles(webServicesDir, webServicesWorkingDir, new WSDeploymentInfo[]{wsDeploymentInfo}, new int[]{index}, -1);
            } else {
                this.wsDeployGenerator.generateWSDeployFiles630(webServicesDir, webServicesWorkingDir, new WSDeploymentInfo[]{wsDeploymentInfo});
            }
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to generate new deployment files. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
        try {
            WSConfigurationHandler.makeWSConfigurations(new String[]{wsDeploymentInfo.getWsRuntimeDefinition().getWsDirsHandler().getWsDirectory()}, appConfiguration);
        }
        catch (WSConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)((Object)e));
            String msg = excMsg + "Unable to make web service configuration. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)((Object)e));
        }
        return wsDeploymentInfo;
    }

    public void deleteWebServices(WSFileLocationWrapper[] wsForDeleteFileLocationWrappers, Configuration appConfiguration) throws WSDeploymentException {
        if (wsForDeleteFileLocationWrappers == null) {
            return;
        }
        int i = 0;
        while (i < wsForDeleteFileLocationWrappers.length) {
            this.deleteWS(wsForDeleteFileLocationWrappers[i], appConfiguration);
            ++i;
        }
    }

    public void deleteWS(ExtFileLocationWrapper extFileLocationWrapper, Configuration appConfiguration) throws WSDeploymentException {
        String wsDir = extFileLocationWrapper.getWsDirsHandler().getWsDirectory();
        String wsConfigName = extFileLocationWrapper.getWsDirsHandler().getWSConfigName();
        this.deleteWS(extFileLocationWrapper.getApplicationName(), extFileLocationWrapper.getWebServiceName(), wsDir, wsConfigName, appConfiguration);
    }

    public void deleteWS(WSFileLocationWrapper wsFileLocationWrapper, Configuration appConfiguration) throws WSDeploymentException {
        String wsDir = wsFileLocationWrapper.getWsDirsHandler().getWsDirectory();
        String wsConfigName = wsFileLocationWrapper.getWsDirsHandler().getWSConfigName();
        this.deleteWS(wsFileLocationWrapper.getApplicationName(), wsFileLocationWrapper.getWebServiceName(), wsDir, wsConfigName, appConfiguration);
    }

    public void deleteWS(String applicationName, String wsName, String wsDir, String wsConfigName, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occured, trying to delete web service " + wsName + ", application " + applicationName + ". ";
        boolean isWSDirDeleted = false;
        try {
            isWSDirDeleted = IOUtil.deleteDir(wsDir);
            WSConfigurationHandler.deleteWSConfiguration(appConfiguration, wsConfigName);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        if (!isWSDirDeleted) {
            String msg = excMsg + "Unable to clear web service directory " + wsDir + " - this may cause problmes on web service start or update phase. ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args);
        }
    }

    public SingleWSUpdateInfo[] getSingleWSUpdateInfoes(String webServicesWorkingDir, Hashtable wsArchiveLocationWrappersNew, Hashtable wsFileLocaitonWrappersOld, Configuration appConfiguration) throws WSDeploymentException {
        if (wsArchiveLocationWrappersNew == null) {
            return new SingleWSUpdateInfo[0];
        }
        SingleWSUpdateInfo[] singleWSUpdateInfoes = new SingleWSUpdateInfo[wsArchiveLocationWrappersNew.size()];
        Enumeration enumeration = wsArchiveLocationWrappersNew.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            String wsName = (String)enumeration.nextElement();
            WSArchiveLocationWrapper wsArchiveLocationWrapperNew = (WSArchiveLocationWrapper)wsArchiveLocationWrappersNew.get(wsName);
            WSFileLocationWrapper wsFileLocationWrapperOld = (WSFileLocationWrapper)wsFileLocaitonWrappersOld.get(wsName);
            singleWSUpdateInfoes[i++] = this.getSingleWSUpdateStatus(webServicesWorkingDir, wsArchiveLocationWrapperNew, wsFileLocationWrapperOld, appConfiguration);
        }
        return singleWSUpdateInfoes;
    }

    public SingleWSUpdateInfo getSingleWSUpdateStatus(String webServicesWorkingDir, WSArchiveLocationWrapper wsArchiveLocationWrapperNew, WSFileLocationWrapper wsFileLocationWrapperOld, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occured, trying to define update status for web service " + wsArchiveLocationWrapperNew.getWebServiceName() + ", application " + wsArchiveLocationWrapperNew.getApplicationName() + ". ";
        ExtArchiveLocationWrapper extArchiveLocationWrapper = null;
        ExtFileLocationWrapper extFileLocationWrapper = null;
        try {
            WSDirsHandler wsDirsHandler = wsFileLocationWrapperOld.getWsDirsHandler();
            WSConfigurationHandler.downloadConfiguration(wsDirsHandler.getDescriptorsDir(), wsDirsHandler.getWSConfigPath("webservices_container") + '/' + wsDirsHandler.getDescriptorsRelDir(), appConfiguration, new HashSet());
            WSDefinitionFactory wsDefinitionFactory = new WSDefinitionFactory();
            extArchiveLocationWrapper = wsDefinitionFactory.loadExtArchiveLocationWrapper(wsArchiveLocationWrapperNew, wsArchiveLocationWrapperNew.getWsDescriptor(), wsArchiveLocationWrapperNew.getWsArchiveFilesLocationHandler());
            extFileLocationWrapper = wsDefinitionFactory.loadExtFileLocationWrapper(wsFileLocationWrapperOld, wsFileLocationWrapperOld.getWsDirsHandler());
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return this.getSingleWSUpdateStatus(webServicesWorkingDir, extArchiveLocationWrapper, extFileLocationWrapper);
    }

    public SingleWSUpdateInfo getSingleWSUpdateStatus(String webServicesWorkingDir, ExtArchiveLocationWrapper extArchiveLocationWrapperNew, ExtFileLocationWrapper extFileLocationWrapperOld) throws WSDeploymentException {
        String excMsg = "Error occured, trying to define update status for web service " + extArchiveLocationWrapperNew.getWebServiceName() + ", application " + extArchiveLocationWrapperNew.getApplicationName() + ". ";
        SingleWSUpdateInfo singleWSUpdateInfo = null;
        int mode = this.checkMode(extArchiveLocationWrapperNew, extFileLocationWrapperOld);
        try {
            switch (mode) {
                case 0: {
                    singleWSUpdateInfo = this.checkInsideOutUpdateStatus(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld);
                    break;
                }
                case 1: {
                    singleWSUpdateInfo = this.checkOutsideInUpdateStatus(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld);
                    break;
                }
                case 2: {
                    singleWSUpdateInfo = this.checkInsideOutMigrationUpdateStatus(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld);
                    break;
                }
                case 3: {
                    singleWSUpdateInfo = this.checkOutsideInMigrationUpdateStatus(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld);
                }
            }
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return singleWSUpdateInfo;
    }

    public WSDeployResult defineWSDeployResult(WSDeploymentInfo[] wsDeploymentInfoes) {
        if (wsDeploymentInfoes == null) {
            new WSDeployResult();
        }
        WSDeployResult wsDeployResult = new WSDeployResult();
        WSRuntimeDefinition[] wsRuntimeDefinitions = this.wsDeployGenerator.collectWSRuntimeDefinitions(wsDeploymentInfoes);
        wsDeployResult.setDeployedComponentNames(this.wsDeployGenerator.getDeployedComponents(wsRuntimeDefinitions));
        wsDeployResult.setFilesForClassLoader(this.wsDeployGenerator.getWSFilesForClassLoader(wsRuntimeDefinitions));
        wsDeployResult.setWsDeploymentInfoes(wsDeploymentInfoes);
        wsDeployResult.setDeployedWSPerModule(this.wsDeployGenerator.collectDeployedWSNamesPerModule(this.collectWSPerModule(wsDeploymentInfoes)));
        return wsDeployResult;
    }

    private int checkMode(ExtArchiveLocationWrapper extLocationWrapperNew, ExtFileLocationWrapper extLocationWrapperOld) {
        boolean isOutsideInModeOldWS = extLocationWrapperOld.isOutsideInMode();
        boolean isOutsideInModeNewWS = extLocationWrapperNew.isOutsideInMode();
        if (isOutsideInModeNewWS && isOutsideInModeOldWS) {
            return 1;
        }
        if (!isOutsideInModeNewWS && !isOutsideInModeOldWS) {
            return 0;
        }
        if (isOutsideInModeNewWS && !isOutsideInModeOldWS) {
            return 2;
        }
        return 3;
    }

    private SingleWSUpdateInfo checkInsideOutUpdateStatus(String webServicesWorkingDir, ExtArchiveLocationWrapper extArchiveLocationWrapperNew, ExtFileLocationWrapper extFileLocationWrapperOld) throws WSDeploymentException {
        SingleWSUpdateInfo singleWSUpdateInfo = new SingleWSUpdateInfo();
        singleWSUpdateInfo.setExtArchiveLocationWrapper(extArchiveLocationWrapperNew);
        singleWSUpdateInfo.setExtFileLocationWrapper(extFileLocationWrapperOld);
        singleWSUpdateInfo.setMode(0);
        singleWSUpdateInfo.setVisStatus(this.checkVIs(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        singleWSUpdateInfo.setDocStatus(this.checkDoc(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        singleWSUpdateInfo.setWsdStatus(this.checkWsd(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        singleWSUpdateInfo.setWsDeploymentDescriptorStatus(this.checkWSDeploymentDescriptor(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        return singleWSUpdateInfo;
    }

    private SingleWSUpdateInfo checkOutsideInUpdateStatus(String webServicesWorkingDir, ExtArchiveLocationWrapper extArchiveLocationWrapperNew, ExtFileLocationWrapper extFileLocationWrapperOld) throws WSDeploymentException {
        SingleWSUpdateInfo singleWSUpdateInfo = new SingleWSUpdateInfo();
        singleWSUpdateInfo.setExtArchiveLocationWrapper(extArchiveLocationWrapperNew);
        singleWSUpdateInfo.setExtFileLocationWrapper(extFileLocationWrapperOld);
        singleWSUpdateInfo.setMode(1);
        singleWSUpdateInfo.setVisStatus(this.checkVIs(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        singleWSUpdateInfo.setDocStatus(this.checkDoc(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        singleWSUpdateInfo.setWsdStatus(this.checkWsd(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        singleWSUpdateInfo.setWsDeploymentDescriptorStatus(this.checkWSDeploymentDescriptor(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        singleWSUpdateInfo.setWsdlStatus(this.checkWsdl(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        singleWSUpdateInfo.setJavaToQNameMappingStatus(this.checkJavaToQNameMapping(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        return singleWSUpdateInfo;
    }

    private SingleWSUpdateInfo checkInsideOutMigrationUpdateStatus(String webServicesWorkingDir, ExtArchiveLocationWrapper extArchiveLocationWrapperNew, ExtFileLocationWrapper extFileLocationWrapperOld) throws WSDeploymentException {
        SingleWSUpdateInfo singleWSUpdateInfo = new SingleWSUpdateInfo();
        singleWSUpdateInfo.setExtArchiveLocationWrapper(extArchiveLocationWrapperNew);
        singleWSUpdateInfo.setExtFileLocationWrapper(extFileLocationWrapperOld);
        singleWSUpdateInfo.setMode(2);
        singleWSUpdateInfo.setVisStatus(this.checkVIs(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        singleWSUpdateInfo.setDocStatus(this.checkDoc(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        singleWSUpdateInfo.setWsdStatus(this.checkWsd(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        singleWSUpdateInfo.setWsDeploymentDescriptorStatus(this.checkWSDeploymentDescriptor(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        singleWSUpdateInfo.setWsdlStatus(2);
        singleWSUpdateInfo.setJavaToQNameMappingStatus(2);
        return singleWSUpdateInfo;
    }

    private SingleWSUpdateInfo checkOutsideInMigrationUpdateStatus(String webServicesWorkingDir, ExtArchiveLocationWrapper extArchiveLocationWrapperNew, ExtFileLocationWrapper extFileLocationWrapperOld) throws WSDeploymentException {
        SingleWSUpdateInfo singleWSUpdateInfo = new SingleWSUpdateInfo();
        singleWSUpdateInfo.setExtArchiveLocationWrapper(extArchiveLocationWrapperNew);
        singleWSUpdateInfo.setExtFileLocationWrapper(extFileLocationWrapperOld);
        singleWSUpdateInfo.setMode(3);
        singleWSUpdateInfo.setVisStatus(this.checkVIs(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        singleWSUpdateInfo.setDocStatus(this.checkDoc(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        singleWSUpdateInfo.setWsdStatus(this.checkWsd(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        singleWSUpdateInfo.setWsDeploymentDescriptorStatus(this.checkWSDeploymentDescriptor(webServicesWorkingDir, extArchiveLocationWrapperNew, extFileLocationWrapperOld));
        singleWSUpdateInfo.setWsdlStatus(3);
        singleWSUpdateInfo.setJavaToQNameMappingStatus(3);
        return singleWSUpdateInfo;
    }

    private int checkVIs(String webServicesDir, ExtArchiveLocationWrapper extArchiveLocationWrapperNew, ExtFileLocationWrapper extFileLocationWrappeOld) throws WSDeploymentException {
        Hashtable seiDesctiptorsTableOld;
        Hashtable seiDesctiptorsTableNew = extArchiveLocationWrapperNew.getSeiDescriptorsTable();
        Hashtable seisNew = WSUtil.makeSubtraction(seiDesctiptorsTableNew, seiDesctiptorsTableOld = extFileLocationWrappeOld.getSeiDescriptorsTable());
        if (seisNew != null && seisNew.size() != 0) {
            return 1;
        }
        Hashtable seisForDelete = WSUtil.makeSubtraction(seiDesctiptorsTableOld, seiDesctiptorsTableNew);
        if (seisForDelete != null && seisForDelete.size() != 0) {
            return 1;
        }
        Hashtable seisChanged = WSUtil.makeIntersection(seiDesctiptorsTableNew, seiDesctiptorsTableOld);
        return this.checkSingleVI(webServicesDir, extArchiveLocationWrapperNew, extFileLocationWrappeOld, seisChanged);
    }

    private int checkSingleVI(String webServicesDir, ExtArchiveLocationWrapper extArchiveLocationWrapper, ExtFileLocationWrapper extFileLocationWrapper, Hashtable seiDescriptorsTableChanged) throws WSDeploymentException {
        if (seiDescriptorsTableChanged == null) {
            return 0;
        }
        Enumeration seiEnum = seiDescriptorsTableChanged.keys();
        while (seiEnum.hasMoreElements()) {
            int currentVIUpdateStatus = this.checkSingleVi(webServicesDir, extArchiveLocationWrapper, extFileLocationWrapper, (String)seiEnum.nextElement());
            if (currentVIUpdateStatus != 1) continue;
            return currentVIUpdateStatus;
        }
        return 0;
    }

    private int checkSingleVi(String webServicesDir, ExtArchiveLocationWrapper extArchiveLocationWrapperNew, ExtFileLocationWrapper extFileLocationWrapperOld, String seiId) throws WSDeploymentException {
        String excMsg = "Error occured, trying to check if virtual interface desctriptor is updated, ws configuration " + seiId + " web service " + extFileLocationWrapperOld.getWebServiceName() + ", " + extFileLocationWrapperOld.getApplicationName() + ". ";
        WSDirsHandler wsDirsHandlerOld = extFileLocationWrapperOld.getWsDirsHandler();
        WSArchiveFilesLocationHandler wsArchiveFilesLocationHandlerNew = extArchiveLocationWrapperNew.getWsArchiveFilesLocationHandler();
        WSDescriptorsLocationTable seiDescriptorsLocationTableNew = (WSDescriptorsLocationTable)extArchiveLocationWrapperNew.getSeiDescriptorsTable().get(seiId);
        WSDescriptorsLocationTable seiDescriptorsLocationTableOld = (WSDescriptorsLocationTable)extFileLocationWrapperOld.getSeiDescriptorsTable().get(seiId);
        String viPathOld = wsDirsHandlerOld.getViPath(seiDescriptorsLocationTableOld.getSingleDescriptor(WSDescriptorsLocationTable.VI));
        String viEntryPathNew = wsArchiveFilesLocationHandlerNew.getViPath(seiDescriptorsLocationTableNew.getSingleDescriptor(WSDescriptorsLocationTable.VI));
        int viUpdateStatus = 0;
        try {
            String wsWorkingDir = WSDirsHandler.getWSWorkingDir(webServicesDir, wsDirsHandlerOld.getIndex());
            wsArchiveFilesLocationHandlerNew.extractEntry(wsWorkingDir, viEntryPathNew);
            viUpdateStatus = HashUtils.compareFiles((File)new File(viPathOld), (File)new File(wsWorkingDir, viEntryPathNew)) ? 0 : 1;
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Old descriptor " + wsDirsHandlerOld.getViPath(viPathOld) + ", new descriptor " + wsArchiveFilesLocationHandlerNew.getViLocationMsg(viEntryPathNew) + ". ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return viUpdateStatus;
    }

    private int checkWsd(String webServicesWorkingDir, ExtArchiveLocationWrapper extArchiveLocationWrapperNew, ExtFileLocationWrapper extFileLocationWrapperOld) throws WSDeploymentException {
        String excMsg = "Error occured, trying to check if web services definition descriptor is updated, web service " + extFileLocationWrapperOld.getWebServiceName() + ", " + extFileLocationWrapperOld.getApplicationName() + ". ";
        WSArchiveFilesLocationHandler wsArchiveFilesLocationHandlerNew = extArchiveLocationWrapperNew.getWsArchiveFilesLocationHandler();
        WSDirsHandler wsDirsHandlerOld = extFileLocationWrapperOld.getWsDirsHandler();
        WSDescriptorsLocationTable wsDescriptorsLocationTableNew = extArchiveLocationWrapperNew.getWsDescriptorsLocationTable();
        WSDescriptorsLocationTable wsDescriptorsLocationTableOld = extFileLocationWrapperOld.getWsDescriptorsLocationTable();
        String wsdPathOld = wsDirsHandlerOld.getWsdPath(wsDescriptorsLocationTableOld.getSingleDescriptor(WSDescriptorsLocationTable.WSD));
        String wsdEntryPathNew = wsArchiveFilesLocationHandlerNew.getWsdPath(wsDescriptorsLocationTableNew.getSingleDescriptor(WSDescriptorsLocationTable.WSD));
        int wsdUpdateStatus = 0;
        try {
            String wsWorkingDir = WSDirsHandler.getWSWorkingDir(webServicesWorkingDir, wsDirsHandlerOld.getIndex());
            wsArchiveFilesLocationHandlerNew.extractEntry(wsWorkingDir, wsdEntryPathNew);
            wsdUpdateStatus = HashUtils.compareFiles((File)new File(wsdPathOld), (File)new File(wsWorkingDir, wsdEntryPathNew)) ? 0 : 1;
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Old descriptor " + wsDirsHandlerOld.getWsdPath(wsdPathOld) + ", new descriptor " + wsArchiveFilesLocationHandlerNew.getWsdLocationMsg(wsdEntryPathNew) + ". ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsdUpdateStatus;
    }

    private int checkDoc(String webServicesWorkingDir, ExtArchiveLocationWrapper extArchiveLocationWrapperNew, ExtFileLocationWrapper extFileLocationWrapperOld) throws WSDeploymentException {
        String excMsg = "Error occured, trying to check if virtual interface is updated, web service " + extFileLocationWrapperOld.getWebServiceName() + ", " + extFileLocationWrapperOld.getApplicationName() + ". ";
        WSArchiveFilesLocationHandler wsArchiveFilesLocationHandlerNew = extArchiveLocationWrapperNew.getWsArchiveFilesLocationHandler();
        WSDirsHandler wsDirsHandlerOld = extFileLocationWrapperOld.getWsDirsHandler();
        WSDescriptorsLocationTable wsDescriptorsLocationTableNew = extArchiveLocationWrapperNew.getWsDescriptorsLocationTable();
        WSDescriptorsLocationTable wsDescriptorsLocationTableOld = extFileLocationWrapperOld.getWsDescriptorsLocationTable();
        boolean existsDocNew = wsDescriptorsLocationTableNew.containsDesctiptor(WSDescriptorsLocationTable.DOC);
        boolean existsDocOld = wsDescriptorsLocationTableOld.containsDesctiptor(WSDescriptorsLocationTable.DOC);
        if (existsDocNew && !existsDocOld) {
            return 2;
        }
        if (!existsDocNew && existsDocOld) {
            return 3;
        }
        if (!existsDocNew && !existsDocOld) {
            return 0;
        }
        String docPathOld = wsDirsHandlerOld.getDocPath(wsDescriptorsLocationTableOld.getSingleDescriptor(WSDescriptorsLocationTable.DOC));
        String docEntryPathNew = wsArchiveFilesLocationHandlerNew.getDocPath(wsDescriptorsLocationTableNew.getSingleDescriptor(WSDescriptorsLocationTable.DOC));
        int docUpdateStatus = 0;
        try {
            String wsWorkingDir = WSDirsHandler.getWSWorkingDir(webServicesWorkingDir, wsDirsHandlerOld.getIndex());
            wsArchiveFilesLocationHandlerNew.extractEntry(wsWorkingDir, docEntryPathNew);
            docUpdateStatus = HashUtils.compareFiles((File)new File(docPathOld), (File)new File(wsWorkingDir, docEntryPathNew)) ? 0 : 1;
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Old descriptor " + wsDirsHandlerOld.getDocPath(docPathOld) + ", new descriptor " + wsArchiveFilesLocationHandlerNew.getDocLocationMsg(docEntryPathNew) + ". ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return docUpdateStatus;
    }

    private int checkWSDeploymentDescriptor(String webServicesWorkingDir, ExtArchiveLocationWrapper extArchiveLocationWrapperNew, ExtFileLocationWrapper extFileLocationWrapperOld) throws WSDeploymentException {
        String excMsg = "Error occured, trying to check if ws deployment descriptor is updated, web service " + extFileLocationWrapperOld.getWebServiceName() + ", " + extFileLocationWrapperOld.getApplicationName() + ". ";
        WSArchiveFilesLocationHandler wsArchiveFilesLocationHandlerNew = extArchiveLocationWrapperNew.getWsArchiveFilesLocationHandler();
        WSDirsHandler wsDirsHandlerOld = extFileLocationWrapperOld.getWsDirsHandler();
        String wsDeploymentDescriptorPathOld = wsDirsHandlerOld.getWSDeploymentDescriptorPath();
        String wsDeploymentDescriptorEntryPathNew = wsArchiveFilesLocationHandlerNew.getWSDeploymentDescriptorPath();
        int wsDeploymentDescriptorUpdateStatus = 0;
        try {
            String wsWorkingDir = WSDirsHandler.getWSWorkingDir(webServicesWorkingDir, wsDirsHandlerOld.getIndex());
            WSDeploymentDescriptor wsDeploymentDescriptor = new WSDeploymentDescriptor();
            wsDeploymentDescriptor.setVersion(extArchiveLocationWrapperNew.getVersion());
            wsDeploymentDescriptor.setWebservice(new WSDescriptor[]{extArchiveLocationWrapperNew.getWsDescriptor()});
            String wsDeploymentDescriptorPathNew = IOUtil.getFilePath(wsWorkingDir, wsDeploymentDescriptorEntryPathNew);
            IOUtil.createParentDir(new String[]{wsDeploymentDescriptorPathNew});
            WSDeploymentParser.saveWSDeploymentDescriptor(wsDeploymentDescriptor, IOUtil.getFilePath(wsWorkingDir, wsDeploymentDescriptorEntryPathNew));
            wsDeploymentDescriptorUpdateStatus = HashUtils.compareFiles((File)new File(wsDeploymentDescriptorPathOld), (File)new File(wsWorkingDir, wsDeploymentDescriptorEntryPathNew)) ? 0 : 1;
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Old descriptor " + wsDirsHandlerOld.getWSDeploymentDescriptorPath() + ", new descriptor " + wsArchiveFilesLocationHandlerNew.getWSDeploymentDescriptorLocationMsg() + ". ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsDeploymentDescriptorUpdateStatus;
    }

    private int checkWsdl(String webServicesWorkingDir, ExtArchiveLocationWrapper extArchiveLocationWrapperNew, ExtFileLocationWrapper extFileLocationWrapperOld) throws WSDeploymentException {
        String excMsg = "Error occured, trying to check if wsdl is updated, web service " + extFileLocationWrapperOld.getWebServiceName() + ", " + extFileLocationWrapperOld.getApplicationName() + ". ";
        WSArchiveFilesLocationHandler wsArchiveFilesLocationHandlerNew = extArchiveLocationWrapperNew.getWsArchiveFilesLocationHandler();
        WSDirsHandler wsDirsHandlerOld = extFileLocationWrapperOld.getWsDirsHandler();
        WSDescriptorsLocationTable wsDescriptorsLocationTableNew = extArchiveLocationWrapperNew.getWsDescriptorsLocationTable();
        WSDescriptorsLocationTable wsDescriptorsLocationTableOld = extFileLocationWrapperOld.getWsDescriptorsLocationTable();
        String rootWsdlPathOld = wsDirsHandlerOld.getOutsideInWsdlPath(wsDescriptorsLocationTableOld.getSingleDescriptor(WSDescriptorsLocationTable.WSDL));
        String rootWsdlEntryPathNew = wsDescriptorsLocationTableNew.getSingleDescriptor(WSDescriptorsLocationTable.WSDL);
        int wsdlUpdateStatus = 0;
        try {
            String wsWorkingDir = WSDirsHandler.getWSWorkingDir(webServicesWorkingDir, wsDirsHandlerOld.getIndex());
            wsArchiveFilesLocationHandlerNew.extractEntry(wsWorkingDir, rootWsdlEntryPathNew);
            wsdlUpdateStatus = HashUtils.compareFiles((File)new File(rootWsdlPathOld), (File)new File(wsWorkingDir, rootWsdlEntryPathNew)) ? 0 : 1;
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Old descriptor " + wsDirsHandlerOld.getOutsideInWsdlPath(rootWsdlPathOld) + ", new descriptor " + wsArchiveFilesLocationHandlerNew.getOutsideInWsdlLocationMsg(rootWsdlEntryPathNew) + ". ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        wsdlUpdateStatus = 1;
        return wsdlUpdateStatus;
    }

    private int checkJavaToQNameMapping(String webServicesWorkingDir, ExtArchiveLocationWrapper extArchiveLocationWrapperNew, ExtFileLocationWrapper extFileLocationWrapperOld) throws WSDeploymentException {
        String excMsg = "Error occured, trying to check if java to qname mapping descriptor is updated, web service " + extFileLocationWrapperOld.getWebServiceName() + ", " + extFileLocationWrapperOld.getApplicationName() + ". ";
        WSArchiveFilesLocationHandler wsArchiveFilesLocationHandlerNew = extArchiveLocationWrapperNew.getWsArchiveFilesLocationHandler();
        WSDirsHandler wsDirsHandlerOld = extFileLocationWrapperOld.getWsDirsHandler();
        WSDescriptorsLocationTable wsDescriptorsLocationTableNew = extArchiveLocationWrapperNew.getWsDescriptorsLocationTable();
        WSDescriptorsLocationTable wsDescriptorsLocationTableOld = extFileLocationWrapperOld.getWsDescriptorsLocationTable();
        String javaToQNameMappingPathOld = wsDirsHandlerOld.getOutsideInJavaToQNameMapppingPath(wsDescriptorsLocationTableOld.getSingleDescriptor(WSDescriptorsLocationTable.JAVA_TO_QNAME_MAPPING));
        String javaToQNameMappingEntryPathNew = wsDescriptorsLocationTableNew.getSingleDescriptor(WSDescriptorsLocationTable.JAVA_TO_QNAME_MAPPING);
        int wsdUpdateStatus = 0;
        try {
            String wsWorkingDir = WSDirsHandler.getWSWorkingDir(webServicesWorkingDir, wsDirsHandlerOld.getIndex());
            wsArchiveFilesLocationHandlerNew.extractEntry(wsWorkingDir, javaToQNameMappingEntryPathNew);
            wsdUpdateStatus = HashUtils.compareFiles((File)new File(javaToQNameMappingPathOld), (File)new File(wsWorkingDir, javaToQNameMappingEntryPathNew)) ? 0 : 1;
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Old descriptor " + wsDirsHandlerOld.getOutsideInWsdlPath(javaToQNameMappingPathOld) + ", new descriptor " + wsArchiveFilesLocationHandlerNew.getOutsideInWsdlLocationMsg(javaToQNameMappingEntryPathNew) + ". ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsdUpdateStatus;
    }

    private SingleWSUpdateInfo[] collectSingleWSUpdateInfo(SingleWSUpdateInfo[] singleWSUpdateInfoes, boolean isChanged) {
        if (singleWSUpdateInfoes == null) {
            return new SingleWSUpdateInfo[0];
        }
        Vector<SingleWSUpdateInfo> singleWSUpdateInfoesFiltered = new Vector<SingleWSUpdateInfo>();
        int i = 0;
        while (i < singleWSUpdateInfoes.length) {
            SingleWSUpdateInfo singleWSUpdateInfo = singleWSUpdateInfoes[i];
            if (singleWSUpdateInfo.isWSChanged() == isChanged) {
                singleWSUpdateInfoesFiltered.add(singleWSUpdateInfo);
            }
            ++i;
        }
        Object[] singleWSUpdateInfoesFilteredArr = new SingleWSUpdateInfo[singleWSUpdateInfoesFiltered.size()];
        singleWSUpdateInfoesFiltered.copyInto(singleWSUpdateInfoesFilteredArr);
        return singleWSUpdateInfoesFilteredArr;
    }

    public WSUpdateResult defineWSUpdateResult(WSFileLocationWrapper[] wsFileLocationWrappers) {
        if (wsFileLocationWrappers == null) {
            new WSUpdateResult();
        }
        WSUpdateResult wsUpdateResult = new WSUpdateResult();
        wsUpdateResult.setDeployedComponentNames(this.getDeployedComponents(wsFileLocationWrappers));
        wsUpdateResult.setFilesForClassLoader(this.getWSFilesForClassLoader(wsFileLocationWrappers));
        wsUpdateResult.setWsFileLocationWrappers(wsFileLocationWrappers);
        wsUpdateResult.setDeployedWSPerModule(this.wsDeployGenerator.collectDeployedWSNamesPerModule(this.collectWSFileLocationWrappersPerModule(wsFileLocationWrappers)));
        return wsUpdateResult;
    }

    private String[] getDeployedComponents(WSLocationWrapper[] wsLocationWrappers) {
        if (wsLocationWrappers == null) {
            return new String[0];
        }
        String[] deployedComponents = new String[wsLocationWrappers.length];
        int i = 0;
        while (i < wsLocationWrappers.length) {
            deployedComponents[i] = this.getDeployedSEIs(wsLocationWrappers[i]);
            ++i;
        }
        return deployedComponents;
    }

    private String getDeployedSEIs(WSLocationWrapper wsLocationWrapper) {
        String resultString = "WEB SERVICE PORTS: \n";
        Hashtable seiTrAddressesTable = wsLocationWrapper.getSeiTrAddressTable();
        Enumeration enumeration = seiTrAddressesTable.elements();
        while (enumeration.hasMoreElements()) {
            resultString = resultString + (String)enumeration.nextElement() + "\n";
        }
        return resultString;
    }

    public String[] getWSFilesForClassLoader(WSFileLocationWrapper[] wsFileLocationWrappers) {
        if (wsFileLocationWrappers == null) {
            return new String[0];
        }
        String[] wsFilesForClassLoader = new String[wsFileLocationWrappers.length];
        int i = 0;
        while (i < wsFileLocationWrappers.length) {
            wsFilesForClassLoader[i] = wsFileLocationWrappers[i].getWsDirsHandler().getJarPath();
            ++i;
        }
        return wsFilesForClassLoader;
    }

    private ExtFileLocationWrapper[] collectExtFileLocationWrappers(SingleWSUpdateInfo[] singleWSUpdateInfoes) {
        if (singleWSUpdateInfoes == null) {
            return new ExtFileLocationWrapper[0];
        }
        ExtFileLocationWrapper[] extFileLocationWrappers = new ExtFileLocationWrapper[singleWSUpdateInfoes.length];
        int i = 0;
        while (i < singleWSUpdateInfoes.length) {
            extFileLocationWrappers[i] = singleWSUpdateInfoes[i].getExtFileLocationWrapper();
            ++i;
        }
        return extFileLocationWrappers;
    }

    private Hashtable collectWSFileLocationWrappersPerModule(WSFileLocationWrapper[] wsFileLocationWrappers) {
        String moduleName;
        if (wsFileLocationWrappers == null) {
            return new Hashtable();
        }
        Hashtable<String, Object> wsPerModuleTable = new Hashtable<String, Object>();
        int i = 0;
        while (i < wsFileLocationWrappers.length) {
            Vector deployedComponentsPerSingleModule;
            WSFileLocationWrapper wsFileLocationWrapper = wsFileLocationWrappers[i];
            moduleName = wsFileLocationWrapper.getModuleName();
            if (wsPerModuleTable.containsKey(moduleName)) {
                deployedComponentsPerSingleModule = (Vector)wsPerModuleTable.get(moduleName);
                deployedComponentsPerSingleModule.add(wsFileLocationWrapper);
            } else {
                deployedComponentsPerSingleModule = new Vector();
                deployedComponentsPerSingleModule.add(wsFileLocationWrapper);
                wsPerModuleTable.put(moduleName, deployedComponentsPerSingleModule);
            }
            ++i;
        }
        Enumeration enumeration = wsPerModuleTable.keys();
        while (enumeration.hasMoreElements()) {
            moduleName = (String)enumeration.nextElement();
            Vector wsPerModule = (Vector)wsPerModuleTable.get(moduleName);
            Object[] wsPerModuleArr = new WSFileLocationWrapper[wsPerModule.size()];
            wsPerModule.copyInto(wsPerModuleArr);
            wsPerModuleTable.put(moduleName, wsPerModuleArr);
        }
        return wsPerModuleTable;
    }

    private Hashtable collectWSPerModule(WSDeploymentInfo[] wsDeploymentInfoes) {
        String moduleName;
        if (wsDeploymentInfoes == null) {
            return new Hashtable();
        }
        Hashtable<String, Object> wsPerModuleTable = new Hashtable<String, Object>();
        int i = 0;
        while (i < wsDeploymentInfoes.length) {
            Vector deployedComponentsPerSingleModule;
            WSDeploymentInfo wsDeploymentInfo = wsDeploymentInfoes[i];
            moduleName = wsDeploymentInfo.getWsRuntimeDefinition().getWSIdentifier().getJarName();
            if (wsPerModuleTable.containsKey(moduleName)) {
                deployedComponentsPerSingleModule = (Vector)wsPerModuleTable.get(moduleName);
                deployedComponentsPerSingleModule.add(wsDeploymentInfo);
            } else {
                deployedComponentsPerSingleModule = new Vector();
                deployedComponentsPerSingleModule.add(wsDeploymentInfo);
                wsPerModuleTable.put(moduleName, deployedComponentsPerSingleModule);
            }
            ++i;
        }
        Enumeration enumeration = wsPerModuleTable.keys();
        while (enumeration.hasMoreElements()) {
            moduleName = (String)enumeration.nextElement();
            Vector wsPerModule = (Vector)wsPerModuleTable.get(moduleName);
            Object[] wsPerModuleArr = new WSDeploymentInfo[wsPerModule.size()];
            wsPerModule.copyInto(wsPerModuleArr);
            wsPerModuleTable.put(moduleName, wsPerModuleArr);
        }
        return wsPerModuleTable;
    }

    private SingleWSUpdateInfo[] filterSingleWSUpdateInfo(SingleWSUpdateInfo[] singleWSUpdateInfoes, boolean is630Version) {
        if (singleWSUpdateInfoes == null) {
            return new SingleWSUpdateInfo[0];
        }
        Vector<SingleWSUpdateInfo> filteredWSSingleWSUpdateInfoes = new Vector<SingleWSUpdateInfo>();
        int i = 0;
        while (i < singleWSUpdateInfoes.length) {
            SingleWSUpdateInfo singleWSUpdateInfo = singleWSUpdateInfoes[i];
            if (is630Version) {
                if (singleWSUpdateInfo.getExtFileLocationWrapper().getWsDirsHandler().getIndex() == -1) {
                    filteredWSSingleWSUpdateInfoes.add(singleWSUpdateInfo);
                }
            } else if (singleWSUpdateInfo.getExtFileLocationWrapper().getWsDirsHandler().getIndex() != -1) {
                filteredWSSingleWSUpdateInfoes.add(singleWSUpdateInfo);
            }
            ++i;
        }
        Object[] filteredWSingleWSUpdateInfoesArr = new SingleWSUpdateInfo[filteredWSSingleWSUpdateInfoes.size()];
        filteredWSSingleWSUpdateInfoes.copyInto(filteredWSingleWSUpdateInfoesArr);
        return filteredWSingleWSUpdateInfoesArr;
    }
}

