/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.ws.preprocess;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.server.deploy.WSConfigurationHandler;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDirsHandler;
import com.sap.engine.services.webservices.server.deploy.ws.WSDefinitionFactory;
import com.sap.engine.services.webservices.server.deploy.ws.WSDirsHandler;
import com.sap.engine.services.webservices.server.deploy.ws.WSRuntimeActivator;
import com.sap.engine.services.webservices.server.deploy.ws.preprocess.WSFileLocationWrapper;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.Properties;
import java.util.Vector;

public class WSPreprocessor {
    public void preprocess(String applicationName, String webServicesDir, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occured, trying to collect web services location information for application " + applicationName + ". ";
        try {
            if (!WSConfigurationHandler.existsWebServicesConfiguration(appConfiguration)) {
                return;
            }
            WSConfigurationHandler.downloadWebServicesBaseConfiguration(webServicesDir, appConfiguration);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    public WSFileLocationWrapper[] loadWSFileLocationWrappers(String applicationName, String webServicesDir, Configuration appConfiguration) throws WSDeploymentException {
        return this.loadWSFileLocationWrappers(applicationName, new File(webServicesDir).listFiles());
    }

    public WSFileLocationWrapper[] loadWSFileLocationWrappers(String applicationName, File[] wsDirs) throws WSDeploymentException {
        if (wsDirs == null) {
            return new WSFileLocationWrapper[0];
        }
        Vector<WSFileLocationWrapper> wsFileLocationWrappers = new Vector<WSFileLocationWrapper>();
        int i = 0;
        while (i < wsDirs.length) {
            File wsDir = wsDirs[i];
            if (!wsDir.getName().equals(ModuleDirsHandler.getAppJarsRelDir())) {
                wsFileLocationWrappers.add(this.loadWSFileLocationWrapper(applicationName, wsDir.getAbsolutePath()));
            }
            ++i;
        }
        Object[] wsFileLocationWrappersArr = new WSFileLocationWrapper[wsFileLocationWrappers.size()];
        wsFileLocationWrappers.copyInto(wsFileLocationWrappersArr);
        return wsFileLocationWrappersArr;
    }

    public WSFileLocationWrapper loadWSFileLocationWrapper(String applicationName, String wsDir) throws WSDeploymentException {
        String excMsg = "Error occured, trying to collect web service location information, web service directory " + wsDir + ", application " + applicationName + ". ";
        WSFileLocationWrapper wsLocationWrapper = null;
        try {
            Properties mappings = null;
            boolean isBaseMappings = false;
            if (WSRuntimeActivator.hasMappings(wsDir)) {
                mappings = WSRuntimeActivator.loadMappingsFile(WSDirsHandler.getMappingsPath(wsDir));
            } else {
                mappings = WSDirsHandler.generateBaseDefaultMappings();
                isBaseMappings = true;
            }
            String wsName = WSDefinitionFactory.extractWebServicesNames(WSDirsHandler.getWSDeploymentDescriptorPath(wsDir, mappings))[0];
            if (isBaseMappings) {
                WSDirsHandler.upgradeBaseMappings(mappings, wsName);
            }
            wsLocationWrapper = new WSDefinitionFactory().loadWSFileLocationWrapper(applicationName, new WSDirsHandler(mappings, wsDir));
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsLocationWrapper;
    }
}

