/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.ws.deploy;

import java.util.Hashtable;

public class WSDescriptorsLocationTable {
    public static int SINGLE_DESCRIPTOR = 0;
    public static int MULTIPLE_DESCRIPTOR = 1;
    public static String VI = "vi";
    public static String WSD = "wsd";
    public static String DOC = "doc";
    public static String WSDL = "wsdl";
    public static String JAVA_TO_QNAME_MAPPING = "java_to_qname_mapping";
    private Hashtable descriptorsTypes = null;
    private Hashtable wsDescriptorsTable = null;

    public WSDescriptorsLocationTable() {
        this.initDescriptorsTypes();
        this.wsDescriptorsTable = new Hashtable();
    }

    public boolean containsDesctiptor(String key) {
        return this.wsDescriptorsTable.containsKey(key);
    }

    public int getDescriptorType(String key) {
        if (!this.descriptorsTypes.containsKey(key)) {
            return (Integer)this.descriptorsTypes.get(key);
        }
        return -1;
    }

    public String getSingleDescriptor(String key) {
        if ((Integer)this.descriptorsTypes.get(key) != SINGLE_DESCRIPTOR) {
            throw new IllegalArgumentException("Descriptor key is expected to be from type " + this.getName(SINGLE_DESCRIPTOR) + ". ");
        }
        return (String)this.wsDescriptorsTable.get(key);
    }

    public String[] getMultipleDescriptor(String key) {
        if ((Integer)this.descriptorsTypes.get(key) != MULTIPLE_DESCRIPTOR) {
            throw new IllegalArgumentException("Descriptor key is expected to be from type " + this.getName(MULTIPLE_DESCRIPTOR) + ". ");
        }
        return (String[])this.wsDescriptorsTable.get(key);
    }

    public void setDescriptor(String key, String value, int type) {
        if (type != SINGLE_DESCRIPTOR && type != MULTIPLE_DESCRIPTOR) {
            throw new IllegalArgumentException("Type " + type + " is not acceptable. Accepted values are " + SINGLE_DESCRIPTOR + " and " + MULTIPLE_DESCRIPTOR + ". ");
        }
        this.descriptorsTypes.put(key, new Integer(type));
        this.wsDescriptorsTable.put(key, value);
    }

    public void setDescriptor(String key, String value) {
        if (!this.descriptorsTypes.containsKey(key)) {
            throw new IllegalArgumentException("No type is specified for descriptor " + key + ". ");
        }
        this.wsDescriptorsTable.put(key, value);
    }

    private void initDescriptorsTypes() {
        this.descriptorsTypes = new Hashtable();
        this.descriptorsTypes.put(VI, new Integer(SINGLE_DESCRIPTOR));
        this.descriptorsTypes.put(WSD, new Integer(SINGLE_DESCRIPTOR));
        this.descriptorsTypes.put(DOC, new Integer(SINGLE_DESCRIPTOR));
        this.descriptorsTypes.put(WSDL, new Integer(SINGLE_DESCRIPTOR));
        this.descriptorsTypes.put(JAVA_TO_QNAME_MAPPING, new Integer(SINGLE_DESCRIPTOR));
    }

    private String getName(int descriptorType) {
        String typeName = null;
        switch (descriptorType) {
            case 0: {
                typeName = "single value descriptor";
                break;
            }
            case 1: {
                typeName = "multiple value descriptor";
            }
        }
        return typeName;
    }
}

