/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.ws;

import com.sap.engine.interfaces.ejb.monitor.EJBManager;
import com.sap.engine.interfaces.webservices.runtime.ImplLink;
import com.sap.engine.interfaces.webservices.runtime.TransportBinding;
import com.sap.engine.interfaces.webservices.runtime.component.ComponentInstantiationException;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.services.webservices.runtime.TransportBindingProvider;
import com.sap.engine.services.webservices.runtime.definition.JavaImplConstants;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.definition.WSIdentifier;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeploySettingsProvider;

public class WSServerDeploySettingsProvider
implements WSDeploySettingsProvider,
TransportBindingProvider {
    public String getClassPath() {
        return WSContainer.getWSDeployer().getJarsPath();
    }

    public void defineImplLink(ServiceEndpointDefinition endpointDefinition) throws WSDeploymentException {
        WSIdentifier wsIdentifier = endpointDefinition.getOwner().getWSIdentifier();
        String applicationName = wsIdentifier.getApplicationName();
        String jarName = wsIdentifier.getJarName();
        ImplLink implLink = endpointDefinition.getImplLink();
        EJBManager ejbManager = WSContainer.getInterfaceContext().getEjbManager();
        if (implLink.getImplId().equals(JavaImplConstants.JAVA_ID)) {
            implLink.getProperties().setProperty(JavaImplConstants.APPLICATION_NAME, applicationName);
        } else if (implLink.getImplId().equals("ejb-impllink")) {
            implLink.getProperties().setProperty("application-name", applicationName);
            String ejbName = implLink.getProperties().getProperty("ejb-name");
            if (ejbManager != null) {
                String jndiName = ejbManager.getJNDIName(applicationName, jarName, ejbName);
                if (jndiName == null) {
                    Object[] args = new Object[]{"Unable to find ejbean:" + ejbName, wsIdentifier.getApplicationName(), wsIdentifier.getJarName(), wsIdentifier.getServiceName()};
                    throw new WSDeploymentException("webservices_5041", args);
                }
                implLink.getProperties().setProperty("ejb-jndi-name", jndiName);
                if (ejbManager.isStatefulSession(jndiName)) {
                    implLink.getProperties().setProperty("ejb-session-type", "stateful");
                } else {
                    implLink.getProperties().setProperty("ejb-session-type", "stateless");
                }
                String jndiNameLocal = ejbManager.getJNDINameLocal(applicationName, jarName, ejbName);
                if (endpointDefinition.getOwner().isFastEJB() && jndiNameLocal == null) {
                    Object[] args = new Object[]{"Unable to find local interface for EJB: " + ejbName, wsIdentifier.getApplicationName(), wsIdentifier.getJarName(), wsIdentifier.getServiceName()};
                    throw new WSDeploymentException("webservices_5041", args);
                }
                if (jndiNameLocal != null) {
                    implLink.getProperties().setProperty("ejb-jndi-name-local", jndiNameLocal);
                }
            } else {
                Object[] args = new Object[]{"Server error! Could not obtain ejb information from EJBManager.", wsIdentifier.getApplicationName(), wsIdentifier.getJarName(), wsIdentifier.getServiceName()};
                throw new WSDeploymentException("webservices_5041", args);
            }
        }
    }

    public TransportBinding getTransportBinding(String trBindingId) throws ComponentInstantiationException {
        return WSContainer.getComponentFactory().getTransportBindingInstance(trBindingId);
    }
}

