/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.ws;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.interfaces.webservices.runtime.Key;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.interfaces.webservices.runtime.ServletDispatcher;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.services.webservices.exceptions.RegistryException;
import com.sap.engine.services.webservices.exceptions.WSConfigurationException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl;
import com.sap.engine.services.webservices.runtime.RuntimeProcessor;
import com.sap.engine.services.webservices.runtime.definition.JavaToQNameMappingRegistryImpl;
import com.sap.engine.services.webservices.runtime.definition.OperationDefinitionImpl;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.definition.WSIdentifier;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.runtime.registry.OperationMappingRegistry;
import com.sap.engine.services.webservices.runtime.registry.RuntimeRegistry;
import com.sap.engine.services.webservices.runtime.servlet.ServletDispatcherImpl;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.WSConfigurationHandler;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.ws.WSBaseContext;
import com.sap.engine.services.webservices.server.deploy.ws.WSBaseGlobalContext;
import com.sap.engine.services.webservices.server.deploy.ws.WSDefinitionFactory;
import com.sap.engine.services.webservices.server.deploy.ws.WSDirsHandler;
import com.sap.engine.services.webservices.server.deploy.ws.WSProtocolNotificator;
import com.sap.engine.services.webservices.server.deploy.ws.WebServicesConstants;
import com.sap.engine.services.webservices.server.deploy.ws.WebServicesUtil;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.xml.rpc.encoding.TypeMappingRegistry;

public class WSRuntimeActivator
implements WebServicesConstants {
    private WSBaseGlobalContext lcmContext = new WSBaseGlobalContext();

    public WSBaseGlobalContext getLcmContext() {
        return this.lcmContext;
    }

    public void setLcmContext(WSBaseGlobalContext lcmContext) {
        this.lcmContext = lcmContext;
    }

    public void downloadApplicationFiles(String applicationName, Configuration appConfiguration) throws WSDeploymentException, WSWarningException {
        Hashtable configsToDirsMappings = this.downloadWSFiles(applicationName, appConfiguration);
        this.notifyProtocolsOnDownloadFiles(applicationName, this.getStrings(configsToDirsMappings.elements(), configsToDirsMappings.size()), this.getStrings(configsToDirsMappings.keys(), configsToDirsMappings.size()), appConfiguration);
    }

    public Hashtable downloadWSFiles(String applicationName, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occurred, downloading web services files for application: " + applicationName + ". ";
        try {
            if (!WSConfigurationHandler.existsWebServicesConfiguration(appConfiguration)) {
                return new Hashtable();
            }
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Error occurred, trying to get " + "webservices_container" + " DB configuration. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        String webservicesDir = null;
        try {
            String wsContainerDir = WSContainer.getWSDeployer().getWSContainerDir(applicationName);
            webservicesDir = WSDirsHandler.getWebServicesDir(wsContainerDir);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to get " + "webservices_container" + " directory. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        Hashtable configsToDirsMappings = null;
        try {
            configsToDirsMappings = WSConfigurationHandler.downloadWebServicesConfiguration(webservicesDir, appConfiguration);
        }
        catch (WSConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)((Object)e));
            String msg = excMsg + "Error occurred, trying to download web services files. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)((Object)e));
        }
        return configsToDirsMappings;
    }

    public void start(String applicationName, String webServicesDir, Configuration appConfiguration) throws WSDeploymentException, WSWarningException {
        Vector warnings = new Vector();
        try {
            this.start(applicationName, new File(webServicesDir).listFiles());
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.notifyProtocolsOnStart(applicationName, appConfiguration);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void start(String applicationName, File[] wsDirs) throws WSDeploymentException, WSWarningException {
        if (wsDirs == null) {
            return;
        }
        Vector warnings = new Vector();
        int i = 0;
        while (i < wsDirs.length) {
            String wsDir = wsDirs[i].getAbsolutePath();
            if (!wsDir.endsWith("app_jars")) {
                try {
                    this.startSingleWebService(applicationName, wsDir);
                }
                catch (WSWarningException e) {
                    warnings.addAll(e.getWarningsVector());
                }
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void startSingleWebService(String applicationName, String wsDir) throws WSWarningException {
        String excMsg = "Error occured, trying to start web service from directory " + wsDir + ", application " + applicationName + ".";
        WSRuntimeDefinition wsRuntimeDefinition = null;
        try {
            wsRuntimeDefinition = WSRuntimeActivator.loadWebService(applicationName, wsDir);
            this.startSingleWebService(wsRuntimeDefinition);
        }
        catch (WSWarningException e) {
            throw e;
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            String msg = excMsg;
            if (wsRuntimeDefinition != null) {
                msg = msg + "Web Service " + wsRuntimeDefinition.getWSIdentifier().getServiceName() + ". ";
            }
            try {
                if (wsRuntimeDefinition != null) {
                    this.unregisterWebService(wsRuntimeDefinition);
                }
            }
            catch (WSWarningException iExc) {
                wsDeployLocation.catching("Warning! ", (Throwable)iExc);
                msg = msg + "The web service has been unregistered with warnings: " + iExc.getLocalizedMessage();
            }
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
    }

    public void commitStart(String applicationName) throws WSWarningException {
        this.notifyProtocolsOnCommitStart(applicationName);
    }

    public void rollbackStart(String applicationName) throws WSWarningException {
        Vector warnings = new Vector();
        try {
            this.notifyProtocolsOnRollbackStart(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.unregisterWebServices(WSContainer.getWSRegistry().getWebServicesByApplicationName(applicationName));
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void stop(String applicationName) throws WSWarningException {
        WSRuntimeDefinition[] wsRuntimeDefinitions = WSContainer.getWSRegistry().getWebServicesByApplicationName(applicationName);
        Vector warnings = new Vector();
        try {
            this.clearRuntimeCaches(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.notifyProtocolsOnStop(wsRuntimeDefinitions);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.unregisterWebServices(wsRuntimeDefinitions);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private String[] getWSDirs(String webServicesDir) {
        Vector<String> wsDirPaths = new Vector<String>();
        File[] wsDirs = new File(webServicesDir).listFiles();
        int i = 0;
        while (i < wsDirs.length) {
            File wsDir = wsDirs[i];
            if (!wsDir.getName().equals("app_jars")) {
                wsDirPaths.add(wsDir.getAbsolutePath());
            }
            ++i;
        }
        String[] wsDirPathsArray = new String[wsDirPaths.size()];
        wsDirPaths.toArray(wsDirPathsArray);
        return wsDirPathsArray;
    }

    private String[] getWebServicesNames(String[] wsDirs) throws WSDeploymentException {
        Vector<String> webServicesNames = new Vector<String>();
        int i = 0;
        while (i < wsDirs.length) {
            String wsDir = wsDirs[i];
            if (!new File(wsDir).getName().equals("app_jars")) {
                webServicesNames.add(this.getWebServiceName(wsDir));
            }
            ++i;
        }
        String[] webServicesNamesArray = new String[webServicesNames.size()];
        webServicesNames.toArray(webServicesNamesArray);
        return webServicesNamesArray;
    }

    private String getWebServiceName(String wsDirectory) throws WSDeploymentException {
        String excMsg = "Error occured, extracting web service name from directory " + wsDirectory + ". ";
        String wsName = null;
        try {
            Properties mappings = WSRuntimeActivator.loadMappings(wsDirectory);
            String wsDeploymentDescriptorPath = WSDirsHandler.getWSDeploymentDescriptorPath(wsDirectory, mappings);
            wsName = WSDefinitionFactory.extractWebServicesNames(wsDeploymentDescriptorPath)[0];
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg;
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsName;
    }

    public static WSRuntimeDefinition loadWebService(String applicationName, String wsDirectory) throws WSDeploymentException {
        String excMsg = "Error occured, loading web service from directory " + wsDirectory + ". ";
        Properties mappings = null;
        boolean baseMappings = false;
        WSRuntimeDefinition wsRuntimeDefinition = null;
        try {
            if (WSRuntimeActivator.hasMappings(wsDirectory)) {
                mappings = WSRuntimeActivator.loadMappingsFile(WSDirsHandler.getMappingsPath(wsDirectory));
            } else {
                mappings = WSDirsHandler.generateBaseDefaultMappings();
                baseMappings = true;
            }
            String wsDeploymentDescriptorPath = WSDirsHandler.getWSDeploymentDescriptorPath(wsDirectory, mappings);
            String wsRuntimeDescriptorPath = WSDirsHandler.getWSRuntimeDescriptorPath(wsDirectory, mappings);
            wsRuntimeDefinition = new WSDefinitionFactory().loadWebServiceRuntimeMode(applicationName, wsDirectory, mappings);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg;
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        if (baseMappings) {
            WSDirsHandler.upgradeBaseMappings(mappings, wsRuntimeDefinition.getServiceName());
        }
        WSRuntimeActivator.setMappings(wsRuntimeDefinition, wsDirectory, mappings);
        return wsRuntimeDefinition;
    }

    public static boolean hasMappings(String wsDirectory) {
        return new File(WSDirsHandler.getMappingsPath(wsDirectory)).exists();
    }

    public static Properties loadMappings(String wsDirectory) throws WSDeploymentException {
        Properties mappings = null;
        mappings = WSRuntimeActivator.hasMappings(wsDirectory) ? WSRuntimeActivator.loadMappingsFile(WSDirsHandler.getMappingsPath(wsDirectory)) : WSDirsHandler.generateBaseDefaultMappings();
        return mappings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadMappingsFile(String mappingsPath) throws WSDeploymentException {
        String excMsg = "Error occured, trying to load " + mappingsPath + ". ";
        Properties mappings = new Properties();
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(mappingsPath);
                mappings.load(in);
            }
            catch (IOException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                String msg = excMsg;
                Object[] args = new String[]{msg, "none"};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            Object var9_4 = null;
            if (in == null) return mappings;
        }
        catch (Throwable throwable) {
            Object var9_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        in.close();
        return mappings;
    }

    private void setMappings(WSRuntimeDefinition[] wsRuntimeDefinitions, String[] wsDirectories, Properties[] mappings) {
        if (wsRuntimeDefinitions == null) {
            return;
        }
        int i = 0;
        while (i < wsRuntimeDefinitions.length) {
            WSRuntimeActivator.setMappings(wsRuntimeDefinitions[i], wsDirectories[i], mappings[i]);
            ++i;
        }
    }

    private static void setMappings(WSRuntimeDefinition wsRuntimeDefinitions, String wsDirectory, Properties mappings) {
        WSDirsHandler wsDirsHandler = new WSDirsHandler(mappings, wsDirectory);
        wsRuntimeDefinitions.setWsDirsHandler(wsDirsHandler);
    }

    private void startSingleWebService(WSRuntimeDefinition wsRuntimeDefinition) throws WSDeploymentException, WSWarningException {
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        String excMsg = "Error occured, starting web service " + wsIdentifier.getServiceName() + ", application " + wsIdentifier.getApplicationName() + ". ";
        this.prepareWSRuntimeEnabled(wsRuntimeDefinition);
        this.registerWebService(wsRuntimeDefinition);
        try {
            WSLogging.applyAndStoreWSConfiguration(wsIdentifier.getApplicationName(), wsIdentifier.getServiceName());
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            String msg = excMsg + "Unable to register log configurations. ";
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
    }

    private void prepareWSRuntimeEnabled(WSRuntimeDefinition wsRuntimeDefinition) throws WSDeploymentException {
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        ClassLoader appLoader = WSContainer.getServiceContext().getCoreContext().getLoadContext().getClassLoader(wsIdentifier.getApplicationName());
        WSDirsHandler wsDirsHandler = wsRuntimeDefinition.getWsDirsHandler();
        try {
            String typesJarFileName = wsDirsHandler.getJarPath();
            File typesJarFile = new File(typesJarFileName);
            if (typesJarFile.exists()) {
                String typeMappingFile = wsDirsHandler.getTypeMappingPath();
                TypeMappingRegistryImpl typeMappingRegistryImpl = new TypeMappingRegistryImpl();
                typeMappingRegistryImpl.fromXML(typeMappingFile, appLoader);
                wsRuntimeDefinition.setTypeMappingRegistry((TypeMappingRegistry)typeMappingRegistryImpl);
                String javaQNameMappingPath = null;
                javaQNameMappingPath = wsRuntimeDefinition.hasOutsideInDefinition() ? wsDirsHandler.getOutsideInJavaToQNameMapppingPath(wsRuntimeDefinition.getOutsideInDefinition().getJavaQNameMappingFile()) : wsDirsHandler.getJavaToQNameMappingPath();
                JavaToQNameMappingRegistryImpl javaToQNameRegistry = JavaToQNameMappingRegistryImpl.loadFromFile(new File(javaQNameMappingPath));
                wsRuntimeDefinition.setJavaToQNameMappingRegistry(javaToQNameRegistry);
            } else {
                wsRuntimeDefinition.setJavaToQNameMappingRegistry(new JavaToQNameMappingRegistryImpl());
                wsRuntimeDefinition.setTypeMappingRegistry((TypeMappingRegistry)new TypeMappingRegistryImpl());
            }
            ServiceEndpointDefinition[] endpointDefinitions = wsRuntimeDefinition.getServiceEndpointDefinitions();
            int endpointsSize = endpointDefinitions.length;
            int i = 0;
            while (i < endpointsSize) {
                ServiceEndpointDefinition endpointDefinition = endpointDefinitions[i];
                OperationMappingRegistry operationMappingRegistry = new OperationMappingRegistry();
                endpointDefinition.setOperationMappingRegistry(operationMappingRegistry);
                OperationDefinition[] operations = endpointDefinition.getOperations();
                int operationsSize = operations.length;
                int j = 0;
                while (j < operationsSize) {
                    Key[] runtimeKeys;
                    OperationDefinitionImpl operation = (OperationDefinitionImpl)operations[j];
                    Key[] allKeys = runtimeKeys = operation.getKeys();
                    Hashtable keysHash = this.getKeysAsHash(runtimeKeys);
                    if (!keysHash.containsKey("SoapRequestWrapper")) {
                        Key soapRequestKey = new Key();
                        soapRequestKey.setName("SoapRequestWrapper");
                        soapRequestKey.setValue(operation.getOperationName());
                        allKeys = this.unifyKeys(new Key[][]{runtimeKeys, {soapRequestKey}});
                    }
                    operationMappingRegistry.addOperation(allKeys, operation);
                    ++j;
                }
                ++i;
            }
            Location wsLocation = WSLogging.getWSLocation(wsIdentifier.getApplicationName(), wsIdentifier.getServiceName());
            wsRuntimeDefinition.setWsLocation(wsLocation);
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{"Unable to prepare webservice runtime enabled ", wsIdentifier.getApplicationName(), wsIdentifier.getJarName(), wsIdentifier.getServiceName()};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
    }

    private void registerWebService(WSRuntimeDefinition wsRuntimeDefinition) throws WSDeploymentException {
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        String excMsg = "Error occured, trying to register web service " + wsIdentifier.getServiceName() + ", application " + wsIdentifier.getApplicationName() + ". ";
        try {
            WSContainer.getWSRegistry().registerWebService(wsRuntimeDefinition);
        }
        catch (RegistryException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)((Object)e));
            String msg = excMsg;
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)((Object)e));
        }
        try {
            this.registerServiceEndpoints(wsRuntimeDefinition.getServiceEndpointDefinitions());
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg;
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    private void registerServiceEndpoints(ServiceEndpointDefinition[] seiDefinitions) throws WSDeploymentException {
        String excMsg = "Error occured, trying to register service endpoints. ";
        RuntimeRegistry runtimeRegistry = WSContainer.getRuntimeRegistry();
        int endpointsSize = seiDefinitions.length;
        int i = 0;
        while (i < endpointsSize) {
            ServiceEndpointDefinition endpointDefinition = seiDefinitions[i];
            try {
                runtimeRegistry.registerServiceEndpoint(endpointDefinition);
            }
            catch (RegistryException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)((Object)e));
                String msg = excMsg + "Unable to register service endpoint " + endpointDefinition.getTransportBindingId() + ". ";
                Object[] args = new String[]{msg, "none"};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)((Object)e));
            }
            ++i;
        }
    }

    private Hashtable getKeysAsHash(Key[] keys) {
        Hashtable<String, String> keysHash = new Hashtable<String, String>();
        if (keys == null) {
            return keysHash;
        }
        int keySize = keys.length;
        int i = 0;
        while (i < keySize) {
            Key key = keys[i];
            keysHash.put(key.getName(), key.getValue());
            ++i;
        }
        return keysHash;
    }

    private Key[] unifyKeys(Key[][] keys) {
        Key[] allKeys = new Key[]{};
        int size = keys.length;
        int i = 0;
        while (i < size) {
            Key[] currentKeys = keys[i];
            Key[] newKeys = new Key[allKeys.length + currentKeys.length];
            System.arraycopy(allKeys, 0, newKeys, 0, allKeys.length);
            System.arraycopy(currentKeys, 0, newKeys, allKeys.length, currentKeys.length);
            allKeys = newKeys;
            ++i;
        }
        return allKeys;
    }

    public void unregisterWebServices(WSRuntimeDefinition[] wsRuntimeDefinitions) throws WSWarningException {
        Vector warnings = new Vector();
        int i = 0;
        while (i < wsRuntimeDefinitions.length) {
            try {
                this.unregisterWebService(wsRuntimeDefinitions[i]);
            }
            catch (WSWarningException e) {
                warnings.addAll(e.getWarningsVector());
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void unregisterWebService(WSRuntimeDefinition wsRuntimeDefinition) throws WSWarningException {
        String msg;
        Location wsDeployLocation;
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        String excMsg = "Error occurred, trying to unregister web service from WS Runtime, application " + wsIdentifier.getApplicationName() + ", web service " + wsIdentifier.getServiceName() + ". ";
        Vector<String> warnings = new Vector<String>();
        try {
            WSLogging.removeAndStoreWSConfiguration(wsIdentifier.getApplicationName(), wsIdentifier.getServiceName());
        }
        catch (Exception e) {
            wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            msg = excMsg + "Unexpected errror occurred: " + e.getLocalizedMessage() + ". ";
            warnings.add(msg);
        }
        try {
            WSContainer.getWSRegistry().unregisterWebService(wsIdentifier);
        }
        catch (Exception e) {
            wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            msg = excMsg + "Unexpected errror occurred: " + e.getLocalizedMessage() + ". ";
            warnings.add(msg);
        }
        try {
            this.unregisterSEIs(WebServicesUtil.getSEITransportIds(wsRuntimeDefinition.getServiceEndpointDefinitions()));
        }
        catch (Exception e) {
            wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            msg = excMsg + "Unexpected errror occurred: " + e.getLocalizedMessage() + ". ";
            warnings.add(msg);
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void unregisterSEIs(String[] seiTransportIds) {
        RuntimeRegistry runtimeRegistry = WSContainer.getRuntimeRegistry();
        if (seiTransportIds == null) {
            return;
        }
        int i = 0;
        while (i < seiTransportIds.length) {
            runtimeRegistry.unregisterServiceEndpoint(seiTransportIds[i]);
            ++i;
        }
    }

    private void clearRuntimeCaches(String applicationName) throws WSWarningException {
        String excMsg = "Unexpected error occurred, trying to clear web services caches. ";
        try {
            InitialContext ctx = new InitialContext();
            ServletDispatcher wsDispatcher = (ServletDispatcher)ctx.lookup("wsContext/WSDispatcher");
            RuntimeProcessor runtimeProcessor = ((ServletDispatcherImpl)wsDispatcher).getWsProcessor();
            runtimeProcessor.clearApplicationCaches(applicationName);
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            WSWarningException wExc = new WSWarningException((Throwable)e);
            wExc.addWarning(excMsg);
            throw wExc;
        }
    }

    public void notifyProtocolsOnDownloadFiles(String applicationName, String[] wsDirNames, String[] wsConfigNames, Configuration appConfiguration) throws WSWarningException {
        String excMsg = "Error occurred, trying to notify protocols on " + WSProtocolNotificator.getModeName(5) + " phase for application " + applicationName + ". ";
        if (wsDirNames == null || wsDirNames.length == 0) {
            return;
        }
        String webservicesDir = null;
        try {
            String wsContainerDir = WSContainer.getWSDeployer().getWSContainerDir(applicationName);
            webservicesDir = WSDirsHandler.getWebServicesDir(wsContainerDir);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to get " + "webservices_container" + " directory. ";
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
        String[] wsDirs = IOUtil.getFilePaths(webservicesDir, wsDirNames);
        String[] webServicesNames = null;
        try {
            webServicesNames = this.getWebServicesNames(wsDirs);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning! ", (Throwable)e);
            String msg = excMsg + "Error occurred, trying to extract web services names. ";
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
        new WSProtocolNotificator().downloadFiles(applicationName, webServicesNames, wsDirs, wsConfigNames, appConfiguration);
    }

    public void notifyProtocolsOnStart(String applicationName, Configuration appConfiguration) throws WSWarningException {
        WSRuntimeDefinition[] wsRuntimeDefinitions = WSContainer.getWSRegistry().getWebServicesByApplicationName(applicationName);
        this.lcmContext.putContext(applicationName, new WSBaseContext(applicationName, wsRuntimeDefinitions, appConfiguration));
        new WSProtocolNotificator().onStart(applicationName, wsRuntimeDefinitions, appConfiguration);
    }

    public void notifyProtocolsOnCommitStart(String applicationName) throws WSWarningException {
        this.notifyProtocolsOnShortPhases(applicationName, 7);
    }

    public void notifyProtocolsOnRollbackStart(String applicationName) throws WSWarningException {
        this.notifyProtocolsOnShortPhases(applicationName, 8);
    }

    private void notifyProtocolsOnShortPhases(String applicationName, int mode) throws WSWarningException {
        WSBaseContext wsBaseContext = this.lcmContext.getContext(applicationName);
        if (wsBaseContext == null) {
            return;
        }
        switch (mode) {
            case 7: {
                new WSProtocolNotificator().onCommitStart(wsBaseContext.getWsRuntimeDefinitions());
                break;
            }
            case 8: {
                new WSProtocolNotificator().onRollbackStart(wsBaseContext.getWsRuntimeDefinitions());
            }
        }
        this.lcmContext.removeContext(applicationName);
    }

    private void notifyProtocolsOnStop(WSRuntimeDefinition[] wsRuntimeDefinitions) throws WSWarningException {
        new WSProtocolNotificator().onStop(wsRuntimeDefinitions);
    }

    private String[] getStrings(Enumeration strEnum, int size) {
        if (strEnum == null) {
            return new String[0];
        }
        String[] strs = new String[size];
        int i = 0;
        while (strEnum.hasMoreElements()) {
            strs[i++] = (String)strEnum.nextElement();
        }
        return strs;
    }
}

