/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.ws;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.interfaces.webservices.runtime.Protocol;
import com.sap.engine.interfaces.webservices.runtime.RuntimeContext;
import com.sap.engine.interfaces.webservices.runtime.ServerProtocolAppStateEvents;
import com.sap.engine.interfaces.webservices.runtime.ServerProtocolDeployAppEvents;
import com.sap.engine.interfaces.webservices.runtime.ServerProtocolStartAppEvent;
import com.sap.engine.interfaces.webservices.runtime.WSRuntimeContext;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.interfaces.webservices.server.deploy.ws.WSContext;
import com.sap.engine.interfaces.webservices.server.deploy.ws.WSDeploymentInterface;
import com.sap.engine.interfaces.webservices.server.deploy.ws.WSLCMInterface;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.RuntimeProcessor;
import com.sap.engine.services.webservices.runtime.WSRuntimeContextImpl;
import com.sap.engine.services.webservices.runtime.component.ComponentFactoryImpl;
import com.sap.engine.services.webservices.runtime.definition.FeatureInfo;
import com.sap.engine.services.webservices.runtime.definition.OperationDefinitionImpl;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.definition.WSIdentifier;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.ws.WSContextImpl;
import com.sap.engine.services.webservices.server.deploy.ws.WebServicesUtil;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class WSProtocolNotificator {
    public static final String[] SKIPPED_PROTOCOLS_LIST = new String[]{""};
    public static final int DEPLOY = 0;
    public static final int POST_DEPLOY = 1;
    public static final int COMMIT_DEPLOY = 2;
    public static final int ROLLBACK_DEPLOY = 3;
    public static final int REMOVE = 4;
    public static final int DOWNLOAD = 5;
    public static final int START = 6;
    public static final int COMMIT_START = 7;
    public static final int ROLLBACK_START = 8;
    public static final int STOP = 9;
    public static final int UPDATE = 10;
    public static final int POST_UPDATE = 11;
    public static final int COMMIT_UPDATE = 12;
    public static final int ROLLBACK_UPDATE = 13;

    public static String getModeName(int mode) {
        String modeName = "";
        switch (mode) {
            case 0: {
                modeName = "deploy";
                break;
            }
            case 1: {
                modeName = "post-deploy";
                break;
            }
            case 2: {
                modeName = "commit-deploy";
                break;
            }
            case 3: {
                modeName = "rollback-deploy";
                break;
            }
            case 4: {
                modeName = "download";
                break;
            }
            case 5: {
                modeName = "start";
                break;
            }
            case 6: {
                modeName = "commit-start";
                break;
            }
            case 7: {
                modeName = "rollback-start";
                break;
            }
            case 8: {
                modeName = "stop";
                break;
            }
            case 9: {
                modeName = "remove";
                break;
            }
            case 10: {
                modeName = "update";
                break;
            }
            case 11: {
                modeName = "post-update";
                break;
            }
            case 12: {
                modeName = "commit-update";
                break;
            }
            case 13: {
                modeName = "rollback-update";
            }
        }
        return modeName;
    }

    public void onDeploy(String applicationName, WSRuntimeDefinition[] wsRuntimeDefinitions, Configuration appConfiguration) throws WSWarningException {
        this.onDeployPhases(applicationName, wsRuntimeDefinitions, appConfiguration, 0);
    }

    public void onPostDeploy(String applicationName, WSRuntimeDefinition[] wsRuntimeDefinitions, Configuration appConfiguration) throws WSWarningException {
        this.onDeployPhases(applicationName, wsRuntimeDefinitions, appConfiguration, 1);
    }

    public void onDeploy(WSRuntimeDefinition[] wsRuntimeDefinitions, Configuration[] wsConfigurations) throws WSWarningException {
        this.onDeployPhases(wsRuntimeDefinitions, wsConfigurations, 0);
    }

    public void onPostDeploy(WSRuntimeDefinition[] wsRuntimeDefinitions, Configuration[] wsConfigurations) throws WSWarningException {
        this.onDeployPhases(wsRuntimeDefinitions, wsConfigurations, 1);
    }

    public void onDeploy(WSRuntimeDefinition wsRuntimeDefinition, Configuration wsConfiguration) throws WSWarningException {
        this.onDeployPhases(wsRuntimeDefinition, wsConfiguration, 0);
    }

    public void onPostDeploy(WSRuntimeDefinition wsRuntimeDefinition, Configuration wsConfiguration) throws WSWarningException {
        this.onDeployPhases(wsRuntimeDefinition, wsConfiguration, 1);
    }

    public void onDeployPhases(String applicationName, WSRuntimeDefinition[] wsRuntimeDefinitions, Configuration appConfiguration, int mode) throws WSWarningException {
        String excMsg = "Error occured trying to initialize protocols on web services " + WSProtocolNotificator.getModeName(mode) + " phase from application " + applicationName + ". ";
        if (wsRuntimeDefinitions == null || wsRuntimeDefinitions.length == 0) {
            return;
        }
        Configuration webservicesConfiguration = null;
        try {
            Configuration wsContainerConfiguration = appConfiguration.getSubConfiguration("webservices_container");
            if (wsContainerConfiguration != null) {
                webservicesConfiguration = wsContainerConfiguration.getSubConfiguration("webservices");
            }
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to get " + "webservices" + " configuration. ";
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
        if (webservicesConfiguration == null) {
            String msg = excMsg + "Unable to get " + "webservices" + " DB configuration. ";
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
        Configuration[] wsConfigurations = this.getSubConfigurations(this.getWSConfigNames(wsRuntimeDefinitions), webservicesConfiguration);
        this.onDeployPhases(wsRuntimeDefinitions, wsConfigurations, mode);
    }

    public void onDeployPhases(WSRuntimeDefinition[] wsRuntimeDefinitions, Configuration[] wsConfigurations, int mode) throws WSWarningException {
        if (wsRuntimeDefinitions == null || wsRuntimeDefinitions == null) {
            return;
        }
        Vector warnings = new Vector();
        int i = 0;
        while (i < wsRuntimeDefinitions.length) {
            WSRuntimeDefinition wsRuntimeDefinition = wsRuntimeDefinitions[i];
            Configuration wsConfiguration = wsConfigurations[i];
            try {
                this.onDeployPhases(wsRuntimeDefinition, wsConfiguration, mode);
            }
            catch (WSWarningException e) {
                warnings.addAll(e.getWarningsVector());
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onCommitDeploy(WSRuntimeDefinition[] wsRuntimeDefinitions) throws WSWarningException {
        if (wsRuntimeDefinitions == null) {
            return;
        }
        Vector warnings = new Vector();
        int i = 0;
        while (i < wsRuntimeDefinitions.length) {
            WSRuntimeDefinition wsRuntimeDefinition = wsRuntimeDefinitions[i];
            try {
                this.onCommitDeploy(wsRuntimeDefinition);
            }
            catch (WSWarningException e) {
                warnings.addAll(e.getWarningsVector());
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onCommitDeploy(WSRuntimeDefinition wsRuntimeDefinition) throws WSWarningException {
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        String excMsg = "Unable to initialize web service protocols on " + WSProtocolNotificator.getModeName(2) + " phase. Web Service  " + wsIdentifier + ". ";
        Vector warnings = new Vector();
        String[] protocolIds = this.getWSProtocolIds(wsRuntimeDefinition);
        Hashtable protocols = this.getProtocols(protocolIds, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        String[] seiTransportIds = WebServicesUtil.getSEITransportIds(wsRuntimeDefinition.getServiceEndpointDefinitions());
        try {
            this.onCommitDeploy630(wsIdentifier, seiTransportIds, this.filterProtocols630(protocols, 2));
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.onShortNotificationPhases(wsIdentifier.getApplicationName(), wsIdentifier.getServiceName(), this.filterProtocols(protocols, 2), 2);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onRollbackDeploy(WSRuntimeDefinition[] wsRuntimeDefinitions) throws WSWarningException {
        if (wsRuntimeDefinitions == null) {
            return;
        }
        Vector warnings = new Vector();
        int i = 0;
        while (i < wsRuntimeDefinitions.length) {
            WSRuntimeDefinition wsRuntimeDefinition = wsRuntimeDefinitions[i];
            try {
                this.onRollbackDeploy(wsRuntimeDefinition);
            }
            catch (WSWarningException e) {
                warnings.addAll(e.getWarningsVector());
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onRollbackDeploy(WSRuntimeDefinition wsRuntimeDefinition) throws WSWarningException {
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        this.onShortNotificationPhases(wsIdentifier.getApplicationName(), wsIdentifier.getServiceName(), this.getWSProtocolIds(wsRuntimeDefinition), 3);
    }

    public void downloadFiles(String applicationName, String[] webServiceNames, String[] wsDirs, String[] wsConfigNames, Configuration appConfiguration) throws WSWarningException {
        String excMsg = "Error occured trying to initialize protocols on web services " + WSProtocolNotificator.getModeName(5) + " phase from application " + applicationName + ". ";
        if (webServiceNames == null || webServiceNames.length == 0) {
            return;
        }
        Configuration webservicesConfiguration = null;
        try {
            Configuration wsContainerConfiguration = appConfiguration.getSubConfiguration("webservices_container");
            if (wsContainerConfiguration != null) {
                webservicesConfiguration = wsContainerConfiguration.getSubConfiguration("webservices");
            }
        }
        catch (ConfigurationException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to get " + "webservices" + " configuration. ";
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
        if (webservicesConfiguration == null) {
            String msg = excMsg + "Unable to get " + "webservices" + " DB configuration. ";
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
        Configuration[] wsConfigurations = this.getSubConfigurations(wsConfigNames, webservicesConfiguration);
        this.downloadFiles(applicationName, webServiceNames, wsDirs, wsConfigurations);
    }

    public void downloadFiles(String applicationName, String[] webServiceNames, String[] wsDirs, Configuration[] wsConfigurations) throws WSWarningException {
        if (webServiceNames == null || wsConfigurations == null) {
            return;
        }
        Vector warnings = new Vector();
        int i = 0;
        while (i < webServiceNames.length) {
            try {
                this.downloadFiles(applicationName, webServiceNames[i], wsDirs[i], wsConfigurations[i]);
            }
            catch (WSWarningException e) {
                warnings.addAll(e.getWarningsVector());
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void downloadFiles(String applicationName, String webServiceName, String wsDir, Configuration wsConfiguration) throws WSWarningException {
        String excMsg;
        String warningMsg = excMsg = "Unable to initialize web service protocols on " + WSProtocolNotificator.getModeName(5) + " phase. Application: " + applicationName + ", web service: " + webServiceName + ". ";
        String[] protocolIds = WSContainer.getComponentFactory().listProtocolIds();
        Vector warnings = new Vector();
        Hashtable protocols = this.getProtocolsForNotification(protocolIds, 5, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        if (protocols.size() > 0) {
            Enumeration enumeration = protocols.keys();
            while (enumeration.hasMoreElements()) {
                String protocolId = (String)enumeration.nextElement();
                Protocol protocol = (Protocol)protocols.get(protocolId);
                try {
                    ((WSLCMInterface)protocol).downloadFiles(applicationName, webServiceName, this.getProtocolDir(wsDir, protocolId), wsConfiguration);
                }
                catch (WSWarningException wExc) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching("Warning! ", (Throwable)wExc);
                    String msg = warningMsg + "Error occured trying to initialize protocol with id: " + protocolId + ". ";
                    warnings.addAll(WSUtil.addPrefixToStrings(msg, wExc.getWarningsVector()));
                }
                catch (WSDeploymentException dExc) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching("Warning! ", (Throwable)dExc);
                    String msg = excMsg + "Error occured trying to initialize protocol with id: " + protocolId + ". ";
                    warnings.add(msg);
                }
                catch (Exception e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching("Warning! ", (Throwable)e);
                    String msg = warningMsg + "Unexpected exception occurred: " + e.getLocalizedMessage();
                    warnings.add(msg);
                }
            }
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onStart(String applicationName, WSRuntimeDefinition[] wsRuntimeDefinitions, Configuration appConfiguration) throws WSWarningException {
        String excMsg = "Error occured trying to initialize protocols on web services " + WSProtocolNotificator.getModeName(6) + " phase from application " + applicationName + ". ";
        if (wsRuntimeDefinitions == null || wsRuntimeDefinitions.length == 0) {
            return;
        }
        Configuration[] wsConfigurations = new Configuration[wsRuntimeDefinitions.length];
        if (appConfiguration != null) {
            Configuration webservicesConfiguration = null;
            try {
                Configuration wsContainerConfiguration = appConfiguration.getSubConfiguration("webservices_container");
                if (wsContainerConfiguration != null) {
                    webservicesConfiguration = wsContainerConfiguration.getSubConfiguration("webservices");
                }
            }
            catch (ConfigurationException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                String msg = excMsg + "Unable to get " + "webservices" + " configuration. ";
                WSWarningException wExc = new WSWarningException();
                wExc.addWarning(msg);
                throw wExc;
            }
            if (webservicesConfiguration == null) {
                String msg = excMsg + "Unable to get " + "webservices" + " DB configuration. ";
                WSWarningException wExc = new WSWarningException();
                wExc.addWarning(msg);
                throw wExc;
            }
            wsConfigurations = this.getSubConfigurations(this.getWSConfigNames(wsRuntimeDefinitions), webservicesConfiguration);
        }
        this.onStart(wsRuntimeDefinitions, wsConfigurations);
    }

    public void onStart(WSRuntimeDefinition[] wsRuntimeDefinitions, Configuration[] wsConfigurations) throws WSWarningException {
        if (wsRuntimeDefinitions == null || wsRuntimeDefinitions == null) {
            return;
        }
        Vector warnings = new Vector();
        int i = 0;
        while (i < wsRuntimeDefinitions.length) {
            WSRuntimeDefinition wsRuntimeDefinition = wsRuntimeDefinitions[i];
            Configuration wsConfiguration = wsConfigurations[i];
            try {
                this.onStart(wsRuntimeDefinition, wsConfiguration);
            }
            catch (WSWarningException e) {
                warnings.addAll(e.getWarningsVector());
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onStart(WSRuntimeDefinition wsRuntimeDefinition, Configuration wsConfiguration) throws WSWarningException {
        String excMsg;
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        String warningMsg = excMsg = "Unable to initialize web service protocols on " + WSProtocolNotificator.getModeName(6) + " phase. Web service: " + wsIdentifier + ". ";
        Vector warnings = new Vector();
        String[] protocolIds = this.getWSProtocolIds(wsRuntimeDefinition);
        Hashtable protocols = this.getProtocolsForNotification(protocolIds, 6, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        if (protocols.size() > 0) {
            WSRuntimeContextImpl wsRuntimeContext = null;
            String wsDir = wsRuntimeDefinition.getWsDirsHandler().getWsDirectory();
            try {
                wsRuntimeContext = new WSRuntimeContextImpl(wsRuntimeDefinition);
            }
            catch (WSWarningException e) {
                WSWarningException wExc = new WSWarningException();
                wExc.addWarnings(WSUtil.addPrefixToStrings(warningMsg, e.getWarningsVector()));
                throw e;
            }
            Enumeration enumeration = protocols.keys();
            while (enumeration.hasMoreElements()) {
                String protocolId = (String)enumeration.nextElement();
                Protocol protocol = (Protocol)protocols.get(protocolId);
                try {
                    ((WSLCMInterface)protocol).onStart(wsIdentifier.getApplicationName(), wsIdentifier.getServiceName(), (WSRuntimeContext)wsRuntimeContext, this.getProtocolDir(wsDir, protocolId), wsConfiguration);
                }
                catch (WSWarningException wExc) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching("Warning! ", (Throwable)wExc);
                    String msg = warningMsg + "Error occured trying to initialize protocol with id: " + protocolId + ". ";
                    warnings.addAll(WSUtil.addPrefixToStrings(msg, wExc.getWarningsVector()));
                }
                catch (WSDeploymentException dExc) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching("Warning! ", (Throwable)dExc);
                    String msg = excMsg + "Error occured trying to initialize protocol with id: " + protocolId + ". ";
                    warnings.add(msg);
                }
                catch (Exception e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching("Warning! ", (Throwable)e);
                    String msg = warningMsg + "Unexpected exception occurred: " + e.getLocalizedMessage();
                    warnings.add(msg);
                }
            }
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onCommitStart(WSRuntimeDefinition[] wsRuntimeDefinitions) throws WSWarningException {
        Vector warnings = new Vector();
        if (wsRuntimeDefinitions == null) {
            return;
        }
        int i = 0;
        while (i < wsRuntimeDefinitions.length) {
            WSRuntimeDefinition wsRuntimeDefinition = wsRuntimeDefinitions[i];
            try {
                this.onCommitStart(wsRuntimeDefinition);
            }
            catch (WSWarningException e) {
                warnings.addAll(e.getWarningsVector());
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onCommitStart(WSRuntimeDefinition wsRuntimeDefinition) throws WSWarningException {
        this.onCommitStartStop(wsRuntimeDefinition, 7);
    }

    public void onRollbackStart(WSRuntimeDefinition[] wsRuntimeDefinitions) throws WSWarningException {
        Vector warnings = new Vector();
        if (wsRuntimeDefinitions == null) {
            return;
        }
        int i = 0;
        while (i < wsRuntimeDefinitions.length) {
            WSRuntimeDefinition wsRuntimeDefinition = wsRuntimeDefinitions[i];
            try {
                this.onRollbackStart(wsRuntimeDefinition);
            }
            catch (WSWarningException e) {
                warnings.addAll(e.getWarningsVector());
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void onRollbackStart(WSRuntimeDefinition wsRuntimeDefinition) throws WSWarningException {
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        this.onShortNotificationPhases(wsIdentifier.getApplicationName(), wsIdentifier.getServiceName(), this.getWSProtocolIds(wsRuntimeDefinition), 8);
    }

    public void onStop(WSRuntimeDefinition[] wsRuntimeDefinitions) throws WSWarningException {
        Vector warnings = new Vector();
        if (wsRuntimeDefinitions == null) {
            return;
        }
        int i = 0;
        while (i < wsRuntimeDefinitions.length) {
            WSRuntimeDefinition wsRuntimeDefinition = wsRuntimeDefinitions[i];
            try {
                this.onStop(wsRuntimeDefinition);
            }
            catch (WSWarningException e) {
                warnings.addAll(e.getWarningsVector());
            }
            ++i;
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onStop(WSRuntimeDefinition wsRuntimeDefinition) throws WSWarningException {
        this.onCommitStartStop(wsRuntimeDefinition, 9);
    }

    public void onRemove(String applicationName) throws WSWarningException {
        String excMsg = "Unable to initialize web service protocols on " + WSProtocolNotificator.getModeName(4) + " mode. Application name " + applicationName + ". ";
        String[] protocolIds = WSContainer.getComponentFactory().listProtocolIds();
        Vector warnings = new Vector();
        Hashtable protocols = this.getProtocols(protocolIds, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        try {
            this.onRemove630(applicationName, this.filterProtocols630(protocols, 4));
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.onRemove(applicationName, this.filterProtocols(protocols, 4));
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void onDeployPhases(WSRuntimeDefinition wsRuntimeDefinition, Configuration wsConfiguration, int mode) throws WSWarningException {
        String excMsg;
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        String warningMsg = excMsg = "Unable to initialize web service protocols on " + WSProtocolNotificator.getModeName(mode) + " phase. Web Service  " + wsIdentifier + ". ";
        String wsDir = wsRuntimeDefinition.getWsDirsHandler().getWsDirectory();
        Vector warnings = new Vector();
        String[] protocolIds = this.getWSProtocolIds(wsRuntimeDefinition);
        Hashtable protocols = this.getProtocolsForNotification(protocolIds, mode, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        if (protocols.size() > 0) {
            WSContextImpl wsContext = new WSContextImpl(wsRuntimeDefinition);
            Enumeration enumeration = protocols.keys();
            while (enumeration.hasMoreElements()) {
                String protocolId = (String)enumeration.nextElement();
                Protocol protocol = (Protocol)protocols.get(protocolId);
                try {
                    switch (mode) {
                        case 0: {
                            ((WSDeploymentInterface)protocol).onDeploy(wsIdentifier.getApplicationName(), wsIdentifier.getServiceName(), (WSContext)wsContext, this.getProtocolDir(wsDir, protocolId), wsConfiguration);
                            break;
                        }
                        case 1: {
                            ((WSDeploymentInterface)protocol).onPostDeploy(wsIdentifier.getApplicationName(), wsIdentifier.getServiceName(), (WSContext)wsContext, this.getProtocolDir(wsDir, protocolId), wsConfiguration);
                        }
                    }
                }
                catch (WSWarningException wExc) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching("Warning! ", (Throwable)wExc);
                    String msg = warningMsg + "Error occured trying to initialize protocol with id: " + protocolId + ". ";
                    warnings.addAll(WSUtil.addPrefixToStrings(msg, wExc.getWarningsVector()));
                }
                catch (WSDeploymentException dExc) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching("Warning! ", (Throwable)dExc);
                    String msg = excMsg + "Error occured trying to initialize protocol with id: " + protocolId + ". ";
                    warnings.add(msg);
                }
                catch (Exception e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching("Warning! ", (Throwable)e);
                    String msg = warningMsg + "Unexpected exception occurred: " + e.getLocalizedMessage();
                    warnings.add(msg);
                }
            }
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onCommitDeploy630(WSIdentifier wsIdentifier, String[] seiTransportIds, Hashtable protocols) throws WSWarningException {
        String warningMsg = "Unable to initialize web service protocols on " + WSProtocolNotificator.getModeName(2) + " phase. Web Service  " + wsIdentifier + ". ";
        Vector<String> warnings = new Vector<String>();
        if (protocols.size() > 0) {
            Enumeration enumeration = protocols.keys();
            while (enumeration.hasMoreElements()) {
                String protocolId = (String)enumeration.nextElement();
                Protocol protocol = (Protocol)protocols.get(protocolId);
                try {
                    ((ServerProtocolDeployAppEvents)protocol).onDeployApplication(wsIdentifier.getApplicationName(), wsIdentifier.getServiceName(), seiTransportIds);
                }
                catch (Exception e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching("Warning! ", (Throwable)e);
                    String msg = warningMsg + "Unexpected exception occurred: " + e.getLocalizedMessage();
                    warnings.add(msg);
                }
            }
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void onCommitStartStop(WSRuntimeDefinition wsRuntimeDefinition, int mode) throws WSWarningException {
        Hashtable filteredProtocols;
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        String excMsg = "Unable to initialize web service protocols on " + WSProtocolNotificator.getModeName(mode) + " phase. Application:  " + wsIdentifier.getApplicationName() + ", web service: " + wsIdentifier.getServiceName() + ". ";
        Vector warnings = new Vector();
        String[] protocolIds = this.getWSProtocolIds(wsRuntimeDefinition);
        Hashtable protocols = this.getProtocols(protocolIds, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        try {
            filteredProtocols = this.filterProtocols630(protocols, mode);
            this.onCommitStartStop630(wsRuntimeDefinition, filteredProtocols, mode);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            filteredProtocols = this.filterProtocols(protocols, mode);
            this.onShortNotificationPhases(wsIdentifier.getApplicationName(), wsIdentifier.getServiceName(), filteredProtocols, mode);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onCommitStartStop630(WSRuntimeDefinition wsRuntimeDefinition, Hashtable protocols, int mode) throws WSWarningException {
        String warningMsg = "Unable to initialize some web service protocols on " + WSProtocolNotificator.getModeName(mode) + " phase. Web Service " + wsRuntimeDefinition.getWSIdentifier() + ". ";
        ServiceEndpointDefinition[] endpointDefinitions = wsRuntimeDefinition.getServiceEndpointDefinitions();
        if (endpointDefinitions == null) {
            return;
        }
        Vector warnings = new Vector();
        int i = 0;
        while (i < endpointDefinitions.length) {
            try {
                ServiceEndpointDefinition endpointDefinition = endpointDefinitions[i];
                String[] protocolIds = this.getSEIProtocolIds(endpointDefinition);
                Hashtable filteredProtocols = this.filterProtocols(protocolIds, protocols);
                this.onCommitStartStop630(endpointDefinition, filteredProtocols, mode);
            }
            catch (WSWarningException e) {
                warnings.addAll(e.getWarningsVector());
            }
            ++i;
        }
        WSUtil.addPrefixToStrings(warningMsg, warnings);
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void onCommitStartStop630(ServiceEndpointDefinition endpointDefinition, Hashtable protocols, int mode) throws WSWarningException {
        String warningMsg = "Unable to initialize service endpoint protocols on " + WSProtocolNotificator.getModeName(mode) + " phase. SEI for ws configuration: " + endpointDefinition.getConfigurationName() + ". ";
        Vector<String> warnings = new Vector<String>();
        if (protocols.size() > 0) {
            RuntimeContext runtimeContext = RuntimeProcessor.initilizeRuntimeContext(endpointDefinition);
            Enumeration enumeration = protocols.keys();
            while (enumeration.hasMoreElements()) {
                String protocolId = (String)enumeration.nextElement();
                Protocol protocol = (Protocol)protocols.get(protocolId);
                try {
                    switch (mode) {
                        case 7: {
                            if (protocol instanceof ServerProtocolAppStateEvents) {
                                ((ServerProtocolAppStateEvents)protocol).onStartApplicationEvent(runtimeContext);
                            }
                            if (!(protocol instanceof ServerProtocolStartAppEvent)) break;
                            ((ServerProtocolStartAppEvent)protocol).onStartApplication(runtimeContext.getProtocolChain().getProtocolContext(protocolId));
                            break;
                        }
                        case 9: {
                            ((ServerProtocolAppStateEvents)protocol).onStopApplicationEvent(runtimeContext);
                        }
                    }
                }
                catch (Exception e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching("Warning! ", (Throwable)e);
                    String msg = warningMsg + "Unexpected exception occurred: " + e.getLocalizedMessage();
                    warnings.add(msg);
                }
            }
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void onShortNotificationPhases(String applicationName, String webServiceName, String[] protocolIds, int mode) throws WSWarningException {
        String excMsg = "Unable to initialize web service protocols on " + WSProtocolNotificator.getModeName(mode) + " phase. Application:  " + applicationName + ", web service: " + webServiceName + ". ";
        Vector warnings = new Vector();
        Hashtable protocols = this.getProtocolsForNotification(protocolIds, mode, warnings);
        warnings = WSUtil.addPrefixToStrings(excMsg, warnings);
        try {
            this.onShortNotificationPhases(applicationName, webServiceName, protocols, mode);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void onShortNotificationPhases(String applicationName, String webServiceName, Hashtable protocols, int mode) throws WSWarningException {
        String warningMsg = "Unable to initialize web service protocols on " + WSProtocolNotificator.getModeName(mode) + " phase. Application:  " + applicationName + ", web service: " + webServiceName + ". ";
        Vector<String> warnings = new Vector<String>();
        if (protocols.size() > 0) {
            Enumeration enumeration = protocols.keys();
            while (enumeration.hasMoreElements()) {
                String protocolId = (String)enumeration.nextElement();
                Protocol protocol = (Protocol)protocols.get(protocolId);
                try {
                    switch (mode) {
                        case 2: {
                            ((WSDeploymentInterface)protocol).onCommitDeploy(applicationName, webServiceName);
                            break;
                        }
                        case 3: {
                            ((WSDeploymentInterface)protocol).onRollbackDeploy(applicationName, webServiceName);
                            break;
                        }
                        case 7: {
                            ((WSLCMInterface)protocol).onCommitStart(applicationName, webServiceName);
                            break;
                        }
                        case 8: {
                            ((WSLCMInterface)protocol).onRollbackStart(applicationName, webServiceName);
                            break;
                        }
                        case 9: {
                            ((WSLCMInterface)protocol).onStop(applicationName, webServiceName);
                        }
                    }
                }
                catch (WSWarningException wExc) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching("Warning! ", (Throwable)wExc);
                    String msg = warningMsg + "Error occured trying to initialize protocol with id: " + protocolId + ". ";
                    warnings.addAll(WSUtil.addPrefixToStrings(msg, wExc.getWarningsVector()));
                }
                catch (Exception e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching("Warning! ", (Throwable)e);
                    String msg = warningMsg + "Unexpected exception occurred: " + e.getLocalizedMessage();
                    warnings.add(msg);
                }
            }
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void onRemove630(String applicationName, Hashtable protocols) throws WSWarningException {
        String warningMsg = "Unable to initialize web service protocols on " + WSProtocolNotificator.getModeName(4) + " mode. Application name " + applicationName + ". ";
        Vector<String> warnings = new Vector<String>();
        if (protocols.size() > 0) {
            Enumeration enumeration = protocols.keys();
            while (enumeration.hasMoreElements()) {
                String protocolId = (String)enumeration.nextElement();
                Protocol protocol = (Protocol)protocols.get(protocolId);
                try {
                    ((ServerProtocolDeployAppEvents)protocol).onUndeployApplication(applicationName);
                }
                catch (Exception e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching("Warning! ", (Throwable)e);
                    String msg = warningMsg + "Unexpected exception occurred: " + e.getLocalizedMessage();
                    warnings.add(msg);
                }
            }
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    private void onRemove(String applicationName, Hashtable protocols) throws WSWarningException {
        String warningMsg = "Unable to initialize web service protocols on " + WSProtocolNotificator.getModeName(4) + " mode. Application name " + applicationName + ". ";
        Vector<String> warnings = new Vector<String>();
        if (protocols.size() > 0) {
            Enumeration enumeration = protocols.keys();
            while (enumeration.hasMoreElements()) {
                String protocolId = (String)enumeration.nextElement();
                Protocol protocol = (Protocol)protocols.get(protocolId);
                try {
                    ((WSDeploymentInterface)protocol).onRemove(applicationName);
                }
                catch (WSWarningException wExc) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching("Warning! ", (Throwable)wExc);
                    String msg = warningMsg + "Error occured trying to initialize protocol with id: " + protocolId + ". ";
                    warnings.addAll(WSUtil.addPrefixToStrings(msg, wExc.getWarningsVector()));
                }
                catch (Exception e) {
                    Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeployLocation.catching("Warning! ", (Throwable)e);
                    String msg = warningMsg + "Unexpected exception occurred: " + e.getLocalizedMessage();
                    warnings.add(msg);
                }
            }
        }
        if (warnings.size() != 0) {
            WSWarningException e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public String[] getWSProtocolIds(WSRuntimeDefinition wsRuntimeDefinition) {
        return this.getSEIProtocolIds(wsRuntimeDefinition.getServiceEndpointDefinitions());
    }

    private String[] getSEIProtocolIds(ServiceEndpointDefinition[] endpointDefinitions) {
        if (endpointDefinitions == null) {
            return new String[0];
        }
        String[] allSeiProtocolIds = new String[]{};
        int i = 0;
        while (i < endpointDefinitions.length) {
            String[] currentSeiProtocolIds = this.getSEIProtocolIds(endpointDefinitions[i]);
            allSeiProtocolIds = WSUtil.unifyStrings(new String[][]{allSeiProtocolIds, currentSeiProtocolIds});
            ++i;
        }
        return allSeiProtocolIds;
    }

    private String[] getSEIProtocolIds(ServiceEndpointDefinition endpointDefinition) {
        String[] globalProtocolIds = this.getProtocolIds(endpointDefinition.getFeaturesChain());
        String[] operationsProtocolIds = this.getOperationProtocolIds(endpointDefinition.getOperations());
        return WSUtil.unifyStrings(new String[][]{globalProtocolIds, operationsProtocolIds});
    }

    private String[] getOperationProtocolIds(OperationDefinition[] operations) {
        if (operations == null) {
            return new String[0];
        }
        String[] allProtocolIds = new String[]{};
        int i = 0;
        while (i < operations.length) {
            OperationDefinitionImpl operation = (OperationDefinitionImpl)operations[i];
            String[] currentProtocolIds = this.getProtocolIds(operation.getFeaturesChain());
            allProtocolIds = WSUtil.unifyStrings(new String[][]{allProtocolIds, currentProtocolIds});
            ++i;
        }
        return allProtocolIds;
    }

    private String[] getProtocolIds(FeatureInfo[] protocols) {
        if (protocols == null) {
            return new String[0];
        }
        String[] protocolIds = new String[protocols.length];
        int i = 0;
        while (i < protocols.length) {
            protocolIds[i] = protocols[i].getProtocolID();
            ++i;
        }
        return protocolIds;
    }

    private String[] getWSConfigNames(WSRuntimeDefinition[] wsRuntimeDefinitions) {
        if (wsRuntimeDefinitions == null) {
            return new String[0];
        }
        String[] wsConfigNames = new String[wsRuntimeDefinitions.length];
        int i = 0;
        while (i < wsRuntimeDefinitions.length) {
            String wsConfigName;
            WSRuntimeDefinition wsRuntimeDefinition = wsRuntimeDefinitions[i];
            wsConfigNames[i] = wsConfigName = wsRuntimeDefinition.getWsDirsHandler().getWSConfigName();
            ++i;
        }
        return wsConfigNames;
    }

    private Configuration[] getSubConfigurations(String[] subconfigNames, Configuration rootConfig) {
        if (subconfigNames == null) {
            return new Configuration[0];
        }
        Vector<Configuration> subconfigs = new Vector<Configuration>();
        int i = 0;
        while (i < subconfigNames.length) {
            String subConfigName = subconfigNames[i];
            Configuration subConfig = null;
            try {
                subConfig = rootConfig.getSubConfiguration(subConfigName);
            }
            catch (ConfigurationException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
            }
            subconfigs.add(subConfig);
            ++i;
        }
        Configuration[] subConfigsArray = new Configuration[subconfigs.size()];
        subconfigs.toArray(subConfigsArray);
        return subConfigsArray;
    }

    private String getProtocolDir(String baseDir, String protocolId) {
        return baseDir + '/' + WSUtil.replaceForbiddenChars(protocolId);
    }

    public boolean isInSkippedList(String str) {
        int i = 0;
        while (i < SKIPPED_PROTOCOLS_LIST.length) {
            if (str.equals(SKIPPED_PROTOCOLS_LIST[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Hashtable getProtocolsForNotification(String[] protocolIds, int mode, Vector warnings) {
        Hashtable protocols = this.getProtocols(protocolIds, warnings);
        return this.filterProtocols(protocols, mode);
    }

    private Hashtable filterProtocols(Hashtable protocols, int mode) {
        Hashtable<String, Protocol> protocolsForNotification = new Hashtable<String, Protocol>();
        Enumeration enumeration = protocols.keys();
        while (enumeration.hasMoreElements()) {
            String protocolId = (String)enumeration.nextElement();
            Protocol protocol = (Protocol)protocols.get(protocolId);
            switch (mode) {
                case 0: {
                    if (!(protocol instanceof WSDeploymentInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 1: {
                    if (!(protocol instanceof WSDeploymentInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 2: {
                    if (!(protocol instanceof WSDeploymentInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 3: {
                    if (!(protocol instanceof WSDeploymentInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 4: {
                    if (!(protocol instanceof WSDeploymentInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 5: {
                    if (!(protocol instanceof WSLCMInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 6: {
                    if (!(protocol instanceof WSLCMInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 7: {
                    if (!(protocol instanceof WSLCMInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 8: {
                    if (!(protocol instanceof WSLCMInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 9: {
                    if (!(protocol instanceof WSLCMInterface)) break;
                    protocolsForNotification.put(protocolId, protocol);
                }
            }
        }
        return protocolsForNotification;
    }

    private Hashtable filterProtocols630(Hashtable protocols, int mode) {
        Hashtable<String, Protocol> protocolsForNotification = new Hashtable<String, Protocol>();
        Enumeration enumeration = protocols.keys();
        block6: while (enumeration.hasMoreElements()) {
            String protocolId = (String)enumeration.nextElement();
            Protocol protocol = (Protocol)protocols.get(protocolId);
            switch (mode) {
                case 2: {
                    if (!(protocol instanceof ServerProtocolDeployAppEvents)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 7: {
                    if (!(protocol instanceof ServerProtocolStartAppEvent) && !(protocol instanceof ServerProtocolAppStateEvents)) continue block6;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 9: {
                    if (!(protocol instanceof ServerProtocolAppStateEvents)) break;
                    protocolsForNotification.put(protocolId, protocol);
                    break;
                }
                case 4: {
                    if (!(protocol instanceof ServerProtocolDeployAppEvents)) break;
                    protocolsForNotification.put(protocolId, protocol);
                }
            }
        }
        return protocolsForNotification;
    }

    private Hashtable filterProtocols(String[] protocolIds, Hashtable protocols) {
        if (protocolIds == null || protocols == null) {
            return new Hashtable();
        }
        Hashtable filteredProtocols = new Hashtable();
        int i = 0;
        while (i < protocolIds.length) {
            String protocolId = protocolIds[i];
            if (protocols.containsKey(protocolId)) {
                filteredProtocols.put(protocolId, protocols.get(protocolId));
            }
            ++i;
        }
        return filteredProtocols;
    }

    private Hashtable getProtocols(String[] protocolIds, Vector warnings) {
        String excMsg = "Error occured, trying to instantiate protocols.";
        if (protocolIds == null) {
            return new Hashtable();
        }
        ComponentFactoryImpl componentFactory = WSContainer.getComponentFactory();
        Hashtable<String, Protocol> protocols = new Hashtable<String, Protocol>();
        int i = 0;
        while (i < protocolIds.length) {
            String protocolId = protocolIds[i];
            try {
                if (!protocols.containsKey(protocolId) && !this.isInSkippedList(protocolId)) {
                    Protocol protocol = componentFactory.getProtocolInstance(protocolId);
                    protocols.put(protocolId, protocol);
                }
            }
            catch (Exception e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                String msg = excMsg + "Protocol " + protocolId + " can not be instantiated.  ";
                warnings.add(msg);
            }
            ++i;
        }
        return protocols;
    }
}

