/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.ws;

import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.JavaToQNameMappingRegistryImpl;
import com.sap.engine.services.webservices.runtime.definition.WSIdentifier;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.server.deploy.common.WSBaseConstants;
import com.sap.engine.services.webservices.server.deploy.descriptors.runtime.WSRuntimeDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.runtime.WSRuntimeParser;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.WSDeploymentDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.WSDeploymentParser;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.ws.WSDefinitionFactory;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeploymentInfo;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class WSFileStorageHandler {
    public void saveDescriptors(WSDeploymentInfo wsDeploymentInfo) throws WSDeploymentException {
        WSRuntimeDefinition wsRuntimeDefinition = wsDeploymentInfo.getWsRuntimeDefinition();
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        String excMsg = "Error occured, trying to save descriptors for web service " + wsIdentifier.getServiceName() + ", application " + wsIdentifier.getApplicationName() + ". ";
        try {
            this.saveMappings(wsRuntimeDefinition);
            this.saveWSDeploymentDescriptor(wsDeploymentInfo);
            this.saveVIs(wsDeploymentInfo);
            this.saveWsd(wsDeploymentInfo);
            this.saveDoc(wsDeploymentInfo);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveMappings(WSRuntimeDefinition wsRuntimeDefinition) throws WSDeploymentException {
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        String excMsg = "Error occured, trying to save mappings for application " + wsIdentifier.getApplicationName() + ", ws client " + wsIdentifier.getServiceName() + ". ";
        Properties mappigns = wsRuntimeDefinition.getWsDirsHandler().getMappings();
        String mappingsPath = wsRuntimeDefinition.getWsDirsHandler().getMappingsPath();
        IOUtil.createParentDir(new String[]{mappingsPath});
        FileOutputStream out = null;
        out = new FileOutputStream(mappingsPath);
        mappigns.store(out, "Properties file, specifying the mapping for the web service directory names.");
        Object var11_7 = null;
        if (out == null) return;
        try {
            ((OutputStream)out).close();
            return;
        }
        catch (IOException iExc) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = "Warning! " + excMsg + "Unable to close output stream for file  " + mappingsPath + ". ";
            wsDeployLocation.catching(msg, (Throwable)iExc);
        }
        return;
        {
            catch (IOException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                Object[] args = new String[]{excMsg};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            if (out == null) throw throwable;
            try {
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException iExc) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                String msg = "Warning! " + excMsg + "Unable to close output stream for file  " + mappingsPath + ". ";
                wsDeployLocation.catching(msg, (Throwable)iExc);
            }
            throw throwable;
        }
    }

    public void saveWSDeploymentDescriptor(WSDeploymentInfo wsDeploymentInfo) throws WSDeploymentException {
        String excMessage = "Error occured saving ws-deployment-descriptor.xml. ";
        WSRuntimeDefinition wsRuntimeDefinition = wsDeploymentInfo.getWsRuntimeDefinition();
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        String wsDeploymentDescriptorPath = wsRuntimeDefinition.getWsDirsHandler().getWSDeploymentDescriptorPath();
        IOUtil.createParentDir(new String[]{wsDeploymentDescriptorPath});
        WSDeploymentDescriptor wsDeploymentDescriptor = wsDeploymentInfo.getWsDeploymentDescriptor();
        FileOutputStream wsDeploymentDescriptorOutput = null;
        try {
            try {
                wsDeploymentDescriptorOutput = new FileOutputStream(wsDeploymentDescriptorPath);
                WSDeploymentParser.saveWSDeploymentDescriptor(wsDeploymentDescriptor, wsDeploymentDescriptorOutput);
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsLocation.catching((Throwable)e);
                Object[] args = new Object[]{"Unable to save ws-deployment-descriptor", wsIdentifier.getApplicationName(), wsIdentifier.getJarName(), wsIdentifier.getServiceName()};
                throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
            }
            Object var12_8 = null;
        }
        catch (Throwable throwable) {
            Object var12_9 = null;
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = excMessage + WSBaseConstants.LINE_SEPARATOR + wsIdentifier.toString() + WSBaseConstants.LINE_SEPARATOR + "Unable to close stream for file: " + wsDeploymentDescriptorPath;
            IOUtil.closeOutputStreams(new OutputStream[]{wsDeploymentDescriptorOutput}, new String[]{msg}, wsLocation);
            throw throwable;
        }
        Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
        String msg = excMessage + WSBaseConstants.LINE_SEPARATOR + wsIdentifier.toString() + WSBaseConstants.LINE_SEPARATOR + "Unable to close stream for file: " + wsDeploymentDescriptorPath;
        IOUtil.closeOutputStreams(new OutputStream[]{wsDeploymentDescriptorOutput}, new String[]{msg}, wsLocation);
    }

    public void saveWSRuntimeDescriptor(WSRuntimeDefinition wsRuntimeDefinition) throws WSDeploymentException {
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        String excMsg = "Error occured, trying to generate and/or save ws-runtime-descriptor.xml, application " + wsIdentifier.getApplicationName() + ", service " + wsIdentifier.getServiceName() + ". ";
        WSRuntimeDescriptor wsRuntimeDescriptor = new WSDefinitionFactory().getWSRuntimeDescriptor(wsRuntimeDefinition);
        String wsRuntimeDescriptorPath = wsRuntimeDefinition.getWsDirsHandler().getWSRuntimeDescriptorPath();
        IOUtil.createParentDir(new String[]{wsRuntimeDescriptorPath});
        try {
            WSRuntimeParser.saveWSRuntimeDescriptor(wsRuntimeDescriptor, wsRuntimeDefinition.getWsDirsHandler().getWSRuntimeDescriptorPath());
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    public void saveVIs(WSDeploymentInfo wsDeploymentInfo) throws WSDeploymentException {
        try {
            WSRuntimeDefinition wsRuntimeDefinition = wsDeploymentInfo.getWsRuntimeDefinition();
            ArrayList virualInterfaces = wsDeploymentInfo.getVirtualInterfaces();
            ArrayList virtualInterfaceEntries = wsDeploymentInfo.getVirtualInterfaceEntries();
            int viSize = virualInterfaces.size();
            int i = 0;
            while (i < viSize) {
                String viSourcePath = (String)virualInterfaces.get(i);
                String viEntry = (String)virtualInterfaceEntries.get(i);
                String viDestPath = wsRuntimeDefinition.getWsDirsHandler().getViPath(viEntry);
                IOUtil.createParentDir(new String[]{viDestPath});
                IOUtil.copyFile(viSourcePath, viDestPath);
                ++i;
            }
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            WSIdentifier wsIdentifier = wsDeploymentInfo.getWsRuntimeDefinition().getWSIdentifier();
            Object[] args = new Object[]{"Unable to save virtual interface files", wsIdentifier.getApplicationName(), wsIdentifier.getJarName(), wsIdentifier.getServiceName()};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
    }

    public void saveWsd(WSDeploymentInfo wsDeploymentInfo) throws WSDeploymentException {
        try {
            WSRuntimeDefinition wsRuntimeDefinition = wsDeploymentInfo.getWsRuntimeDefinition();
            String wsdSourcePath = wsDeploymentInfo.getWsdRef();
            String wsdDestPath = wsRuntimeDefinition.getWsDirsHandler().getWsdPath(wsDeploymentInfo.getWsdRefEntry());
            IOUtil.createParentDir(new String[]{wsdDestPath});
            IOUtil.copyFile(wsdSourcePath, wsdDestPath);
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            WSIdentifier wsIdentifier = wsDeploymentInfo.getWsRuntimeDefinition().getWSIdentifier();
            Object[] args = new Object[]{"Unable to save wsd file", wsIdentifier.getApplicationName(), wsIdentifier.getJarName(), wsIdentifier.getServiceName()};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
    }

    public void saveDoc(WSDeploymentInfo wsDeploymentInfo) throws WSDeploymentException {
        try {
            WSRuntimeDefinition wsRuntimeDefinition = wsDeploymentInfo.getWsRuntimeDefinition();
            if (wsDeploymentInfo.getWsDocPath() != null) {
                String docSourcePath = wsDeploymentInfo.getWsDocPath();
                String docDestPath = wsRuntimeDefinition.getWsDirsHandler().getDocPath(wsDeploymentInfo.getWsDocEntry());
                IOUtil.createParentDir(new String[]{docDestPath});
                IOUtil.copyFile(docSourcePath, docDestPath);
            }
        }
        catch (IOException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            WSIdentifier wsIdentifier = wsDeploymentInfo.getWsRuntimeDefinition().getWSIdentifier();
            Object[] args = new Object[]{"Unable to save webservice documentation file", wsIdentifier.getApplicationName(), wsIdentifier.getJarName(), wsIdentifier.getServiceName()};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
    }

    public void saveOutsideIn(WSDeploymentInfo wsDeploymentInfo) throws WSDeploymentException {
        WSRuntimeDefinition wsRuntimeDefinition = wsDeploymentInfo.getWsRuntimeDefinition();
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        try {
            String javaQNameMappingDestPath = wsRuntimeDefinition.getWsDirsHandler().getOutsideInJavaToQNameMapppingPath(wsRuntimeDefinition.getOutsideInDefinition().getJavaQNameMappingFile());
            String javaQNameMappingSourcePath = wsDeploymentInfo.getJavaQNameMappingRefPath();
            IOUtil.createParentDir(new String[]{javaQNameMappingSourcePath});
            IOUtil.copyFile(javaQNameMappingDestPath, javaQNameMappingSourcePath);
            String rootWsdlSourcePath = wsDeploymentInfo.getWsdlRefPath();
            String rootWsdlEntry = wsRuntimeDefinition.getOutsideInDefinition().getWsdlRelPath();
            String wsdlSourceDir = rootWsdlSourcePath.substring(0, rootWsdlSourcePath.lastIndexOf(rootWsdlEntry));
            String wsdlDestDir = wsRuntimeDefinition.getWsDirsHandler().getOutsideInWsdlDir();
            IOUtil.copyDir(wsdlSourceDir, wsdlDestDir);
        }
        catch (IOException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{"Unable to save webservice outside in files file", wsIdentifier.getApplicationName(), wsIdentifier.getJarName(), wsIdentifier.getServiceName()};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
    }

    public void saveJavaToQNameMappingFile(WSRuntimeDefinition wsRuntimeDefinition, HashMap[] mappings) throws WSDeploymentException {
        String javaQNameMappingPath = wsRuntimeDefinition.getWsDirsHandler().getJavaToQNameMappingPath();
        IOUtil.createParentDir(new String[]{javaQNameMappingPath});
        try {
            HashMap literalMappings = mappings[0];
            HashMap encodedMappings = mappings[1];
            JavaToQNameMappingRegistryImpl javaToQNameMappingRegistry = new JavaToQNameMappingRegistryImpl();
            javaToQNameMappingRegistry.setLiteralMappings(literalMappings);
            javaToQNameMappingRegistry.setEncodedMappings(encodedMappings);
            javaToQNameMappingRegistry.saveToFile(new File(javaQNameMappingPath));
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{"Unable to save " + javaQNameMappingPath, "none"};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
    }
}

