/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.ws;

import com.sap.engine.services.webservices.server.deploy.common.ModuleDirsHandler;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.ws.WSFilesLocationHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;

public class WSDirsHandler
extends ModuleDirsHandler
implements WSFilesLocationHandler {
    private Properties mappings = null;
    private String wsDirectory = null;
    private String descriptorsRelDir = null;
    private String descriptorsDir = null;
    private String typeMappingFileName = null;
    private String typeMappingPath = null;
    private String javaQNameMappingFileName = null;
    private String javaQNameMappingPath = null;
    private String docRelDir = null;
    private String docDir = null;
    private String wsdRelDir = null;
    private String wsdDir = null;
    private String viRelDir = null;
    private String viDir = null;
    private String jarsRelDir = null;
    private String jarsDir = null;
    private String jarFileName = null;
    private String jarPath = null;
    private String wsdlRelDir = null;
    private String wsdlDir = null;
    private String outsideInReldDir = null;
    private String outsideInDir = null;
    private String outsideInWsdlRelDir = null;
    private String outsideInWsdlDir = null;

    public WSDirsHandler() {
    }

    public WSDirsHandler(Properties mappings, String wsDirectory) {
        this.mappings = mappings;
        this.wsDirectory = wsDirectory;
    }

    public static Properties generateBaseMappings(int index) {
        Properties mappings = new Properties();
        mappings.setProperty("index", new Integer(index).toString());
        mappings.setProperty("descriptors", "descriptors");
        mappings.setProperty("doc", "doc");
        mappings.setProperty("wsd", "wsd");
        mappings.setProperty("vi", "vi");
        mappings.setProperty("type_mapping_file_name", "type-mapping.xml");
        mappings.setProperty("java_qname_mapping_file_name", "java-qname-mapping.xml");
        mappings.setProperty("jars", "jars");
        mappings.setProperty("wsdl", "wsdl");
        mappings.setProperty("out_in", "out_in");
        mappings.setProperty("outside_in_wsdl_dir_name", "");
        return mappings;
    }

    public static Properties generateBaseDefaultMappings() {
        Properties mappings = new Properties();
        mappings.setProperty("descriptors", "descriptors");
        mappings.setProperty("doc", "doc");
        mappings.setProperty("wsd", "wsd");
        mappings.setProperty("vi", "vi");
        mappings.setProperty("type_mapping_file_name", "type-mapping.xml");
        mappings.setProperty("java_qname_mapping_file_name", "java-qname-mapping.xml");
        mappings.setProperty("jars", "jars");
        mappings.setProperty("wsdl", "wsdl");
        mappings.setProperty("out_in", "out_in");
        mappings.setProperty("outside_in_wsdl_dir_name", "wsdl");
        return mappings;
    }

    public static void upgradeBaseMappings(Properties mappings, String serviceName) {
        String jarFileName = WSDirsHandler.getDefaultJarFileName(serviceName);
        mappings.setProperty("jar_file_name", jarFileName);
    }

    public static Properties generateDefaultMappings(String serviceName) {
        Properties defaultMappings = WSDirsHandler.generateBaseDefaultMappings();
        String jarFileName = WSDirsHandler.getDefaultJarFileName(serviceName);
        defaultMappings.setProperty("jar_file_name", jarFileName);
        return defaultMappings;
    }

    public static Properties generateMappings(String serviceName, int index) {
        Properties mappings = WSDirsHandler.generateBaseMappings(index);
        String jarFileName = WSDirsHandler.getDefaultJarFileName(serviceName);
        mappings.setProperty("jar_file_name", jarFileName);
        return mappings;
    }

    public static String getWebServicesConfigRelName() {
        return "webservices";
    }

    public static String getWebServicesConfigName(String wsContainerPath) {
        return wsContainerPath + '/' + WSDirsHandler.getWebServicesConfigRelName();
    }

    public static String getWebServicesRelDir() {
        return "webservices";
    }

    public static String getWebServicesDir(String wsContainerDir) {
        return wsContainerDir + '/' + WSDirsHandler.getWebServicesRelDir();
    }

    public static String getWebServicesWorkingDir(String wsContainerWorkingDir) {
        return wsContainerWorkingDir + '/' + "webservices";
    }

    public static String getModuleWorkingDir(String webServicesWorkingDir, String moduleName) {
        return webServicesWorkingDir + '/' + WSUtil.getModuleNameByType(moduleName);
    }

    public static String getModuleExtractDir(String moduleWorkingDir) {
        return moduleWorkingDir + '/' + "extract";
    }

    public static String getWSDirectory(String webServicesDir, int index) {
        return webServicesDir + '/' + "ws_" + index;
    }

    public static String getWSDefaultDirectory(String webServicesDir, String serviceName) {
        return webServicesDir + '/' + WSUtil.replaceForbiddenChars(serviceName);
    }

    public static String getWSWorkingDir(String webServicesWorkingDir, int number) {
        return webServicesWorkingDir + '/' + "ws_" + number;
    }

    public static String getWSDefaultWorkingDir(String webServicesWorkingDir, String serviceName) {
        return webServicesWorkingDir + '/' + WSUtil.replaceForbiddenChars(serviceName);
    }

    public static int getIndex(Properties mappings) {
        if (((Hashtable)mappings).containsKey("index")) {
            return new Integer(mappings.getProperty("index"));
        }
        return -1;
    }

    public static String getMappingsFileName() {
        return "mapping.props";
    }

    public static String getMappingsParentRelDir() {
        return "";
    }

    public static String getMappingsParentDir(String wsDirectory) {
        return wsDirectory + '/' + WSDirsHandler.getMappingsParentRelDir();
    }

    public static String getMappingsPath(String wsDirectory) {
        return WSDirsHandler.getMappingsParentDir(wsDirectory) + '/' + WSDirsHandler.getMappingsFileName();
    }

    public static String getDescriptorsRelDir(Properties mappings) {
        return mappings.getProperty("descriptors");
    }

    public static String getDescriptorsDir(String wsDirectory, Properties mappings) {
        return wsDirectory + '/' + WSDirsHandler.getDescriptorsRelDir(mappings);
    }

    public static String getWSDeploymentDescriptorFileName() {
        return "ws-deployment-descriptor.xml";
    }

    public static String getWSDeploymentDescriptorParentRelDir(Properties mappings) {
        return WSDirsHandler.getDescriptorsRelDir(mappings);
    }

    public static String getWSDeploymentDescriptorParentDir(String wsDirectory, Properties mappings) {
        return WSDirsHandler.getDescriptorsDir(wsDirectory, mappings);
    }

    public static String getWSDeploymentDescriptorPath(String wsDirectory, Properties mappings) {
        return WSDirsHandler.getWSDeploymentDescriptorParentDir(wsDirectory, mappings) + '/' + WSDirsHandler.getWSDeploymentDescriptorFileName();
    }

    public static InputStream getWSDeploymentDescriptorInputStream(String wsDirectory, Properties mappings) throws IOException {
        return new FileInputStream(WSDirsHandler.getWSDeploymentDescriptorPath(wsDirectory, mappings));
    }

    public static String getWSRuntimeDescriptorFileName() {
        return "ws-runtime-descriptor.xml";
    }

    public static String getWSRuntimeDescriptorParentRelDir(Properties mappings) {
        return WSDirsHandler.getDescriptorsRelDir(mappings);
    }

    public static String getWSRuntimeDescriptorParentDir(String wsDirectory, Properties mappings) {
        return WSDirsHandler.getDescriptorsDir(wsDirectory, mappings);
    }

    public static String getWSRuntimeDescriptorPath(String wsDirectory, Properties mappings) {
        return WSDirsHandler.getWSRuntimeDescriptorParentDir(wsDirectory, mappings) + '/' + WSDirsHandler.getWSRuntimeDescriptorFileName();
    }

    public static String getTypeMappingFileName(Properties mappings) {
        return mappings.getProperty("type_mapping_file_name");
    }

    public static String getTypeMappingPath(String wsDirectory, Properties mappings) {
        return WSDirsHandler.getDescriptorsDir(wsDirectory, mappings) + '/' + WSDirsHandler.getTypeMappingFileName(mappings);
    }

    public static String getJavaQNameMappingFileName(Properties mappings) {
        return mappings.getProperty("java_qname_mapping_file_name");
    }

    public static String getJavaToQNameMappingPath(String wsDirectory, Properties mappings) {
        return WSDirsHandler.getDescriptorsDir(wsDirectory, mappings) + '/' + WSDirsHandler.getJavaQNameMappingFileName(mappings);
    }

    public static String getDocRelDir(Properties mappings) {
        return WSDirsHandler.getDescriptorsRelDir(mappings) + '/' + mappings.getProperty("doc");
    }

    public static String getDocDir(String wsDirectory, Properties mappings) {
        return wsDirectory + '/' + WSDirsHandler.getDocRelDir(mappings);
    }

    public static String getDocPath(String wsDirectory, Properties mappings, String docRelPath) {
        return WSDirsHandler.getDocDir(wsDirectory, mappings) + '/' + docRelPath;
    }

    public static InputStream getDocInputStream(String wsDirectory, Properties mappings, String docRelPath) throws IOException {
        return new FileInputStream(WSDirsHandler.getDocPath(wsDirectory, mappings, docRelPath));
    }

    public static String getWsdRelDir(Properties mappings) {
        return WSDirsHandler.getDescriptorsRelDir(mappings) + '/' + mappings.getProperty("wsd");
    }

    public static String getWsdDir(String wsDirectory, Properties mappings) {
        return wsDirectory + '/' + WSDirsHandler.getWsdRelDir(mappings);
    }

    public static String getWsdPath(String wsDirectory, Properties mappings, String wsdRelPath) {
        return WSDirsHandler.getWsdDir(wsDirectory, mappings) + '/' + wsdRelPath;
    }

    public static InputStream getWsdInputStream(String wsDirectory, Properties mappings, String wsdRelPath) throws IOException {
        return new FileInputStream(WSDirsHandler.getWsdPath(wsDirectory, mappings, wsdRelPath));
    }

    public static String getViRelDir(Properties mappings) {
        return WSDirsHandler.getDescriptorsRelDir(mappings) + '/' + mappings.getProperty("vi");
    }

    public static String getViDir(String wsDirectory, Properties mappings) {
        return wsDirectory + '/' + WSDirsHandler.getViRelDir(mappings);
    }

    public static String getViPath(String wsDirectory, Properties mappings, String viRelPath) {
        return WSDirsHandler.getViDir(wsDirectory, mappings) + '/' + viRelPath;
    }

    public static InputStream getViInputStream(String wsDirectory, Properties mappings, String viRelPath) throws IOException {
        return new FileInputStream(WSDirsHandler.getViPath(wsDirectory, mappings, viRelPath));
    }

    public static String getJarsRelDir(Properties mappings) {
        return mappings.getProperty("jars");
    }

    public static String getJarsDir(String wsDirectory, Properties mappings) {
        return wsDirectory + '/' + WSDirsHandler.getJarsRelDir(mappings);
    }

    public static String getJarFileName(Properties mappings) {
        return mappings.getProperty("jar_file_name");
    }

    public static String getJarPath(String wsDirectory, Properties mappings) {
        return WSDirsHandler.getJarsDir(wsDirectory, mappings) + '/' + WSDirsHandler.getJarFileName(mappings);
    }

    public static String getDefaultJarFileName(String serviceName) {
        return WSDirsHandler.getAllowedString(serviceName) + ".jar";
    }

    public static String getWsdlRelDir(Properties mappings) {
        return mappings.getProperty("wsdl");
    }

    public static String getWsdlDir(String wsDirectory, Properties mappings) {
        return wsDirectory + '/' + WSDirsHandler.getWsdlRelDir(mappings);
    }

    public static String getOutsideInRelDir(Properties mappings) {
        return mappings.getProperty("out_in");
    }

    public static String getOutsideInDir(String wsDirectory, Properties mappings) {
        return wsDirectory + '/' + WSDirsHandler.getOutsideInRelDir(mappings);
    }

    public static String getOutsideInWsdlRelDir(Properties mappings) {
        return WSDirsHandler.getOutsideInRelDir(mappings) + '/' + mappings.getProperty("outside_in_wsdl_dir_name");
    }

    public static String getOutsideInWsdlDir(String wsDirectory, Properties mappings) {
        return wsDirectory + '/' + WSDirsHandler.getOutsideInWsdlRelDir(mappings);
    }

    public Properties getMappings() {
        return this.mappings;
    }

    public void setMappings(Properties mappings) {
        this.mappings = mappings;
    }

    public String getWsDirectory() {
        return this.wsDirectory;
    }

    public void setWsDirectory(String wsDirectory) {
        this.wsDirectory = wsDirectory;
    }

    public int getIndex() {
        if (((Hashtable)this.mappings).containsKey("index")) {
            return new Integer(this.mappings.getProperty("index"));
        }
        return -1;
    }

    public String getMappingsPath() {
        return this.wsDirectory + '/' + WSDirsHandler.getMappingsFileName();
    }

    public String getWSConfigName() {
        return new File(this.getWsDirectory()).getName();
    }

    public String getWSConfigPath(String wsContainerConfigPath) {
        return WSDirsHandler.getWebServicesConfigName(wsContainerConfigPath) + '/' + this.getWSConfigName();
    }

    public String getDescriptorsRelDir() {
        if (this.descriptorsRelDir == null) {
            this.descriptorsRelDir = this.mappings.getProperty("descriptors");
        }
        return this.descriptorsRelDir;
    }

    public String getDescriptorsDir() {
        if (this.descriptorsDir == null) {
            this.descriptorsDir = this.wsDirectory + '/' + this.getDescriptorsRelDir();
        }
        return this.descriptorsDir;
    }

    public String getWSDeploymentDescriptorPath() {
        return this.getDescriptorsDir() + '/' + WSDirsHandler.getWSDeploymentDescriptorFileName();
    }

    public String getWSDeploymentDescriptorParentRelDir() {
        return this.getDescriptorsRelDir();
    }

    public InputStream getWSDeploymentDescriptorInputStream() throws IOException {
        return new FileInputStream(this.getWSDeploymentDescriptorPath());
    }

    public String getBaseLocationMsg() {
        return this.wsDirectory;
    }

    public String getWSDeploymentDescriptorLocationMsg() {
        String locationMsg = "Type: file; ";
        locationMsg = locationMsg + "File location: " + this.getWSDeploymentDescriptorPath() + "; ";
        return locationMsg;
    }

    public String getWSRuntimeDescriptorPath() {
        return this.getDescriptorsDir() + '/' + WSDirsHandler.getWSRuntimeDescriptorFileName();
    }

    public String getWSRuntimeDescriptorBaseParentDir() {
        return this.getDescriptorsDir();
    }

    public String getTypeMappingFileName() {
        if (this.typeMappingFileName == null) {
            this.typeMappingFileName = this.mappings.getProperty("type_mapping_file_name");
        }
        return this.typeMappingFileName;
    }

    public String getTypeMappingPath() {
        if (this.typeMappingPath == null) {
            this.typeMappingPath = this.getDescriptorsDir() + '/' + this.getTypeMappingFileName();
        }
        return this.typeMappingPath;
    }

    public String getJavaQNameMappingFileName() {
        if (this.javaQNameMappingFileName == null) {
            this.javaQNameMappingFileName = this.mappings.getProperty("java_qname_mapping_file_name");
        }
        return this.javaQNameMappingFileName;
    }

    public String getJavaToQNameMappingPath() {
        if (this.javaQNameMappingPath == null) {
            this.javaQNameMappingPath = this.getDescriptorsDir() + '/' + this.getJavaQNameMappingFileName();
        }
        return this.javaQNameMappingPath;
    }

    public String getDocRelDir() {
        if (this.docRelDir == null) {
            this.docRelDir = this.getDescriptorsRelDir() + '/' + this.mappings.getProperty("doc");
        }
        return this.docRelDir;
    }

    public String getDocDir() {
        if (this.docDir == null) {
            this.docDir = this.wsDirectory + '/' + this.getDocRelDir();
        }
        return this.docDir;
    }

    public String findDocRelPath(String[] docRelPathTemplates) {
        if (docRelPathTemplates == null) {
            return null;
        }
        int i = 0;
        while (i < docRelPathTemplates.length) {
            String docRelPathTemplate = docRelPathTemplates[i];
            String docPath = this.getDocPath(docRelPathTemplate);
            if (new File(docPath).exists()) {
                return docRelPathTemplate;
            }
            ++i;
        }
        return null;
    }

    public String getDocPath(String docRelPath) {
        return this.getDocDir() + '/' + docRelPath;
    }

    public String getWsdRelDir() {
        if (this.wsdRelDir == null) {
            this.wsdRelDir = this.getDescriptorsRelDir() + '/' + this.mappings.getProperty("wsd");
        }
        return this.wsdRelDir;
    }

    public InputStream getDocInputStream(String docRelPath) throws IOException {
        return new FileInputStream(this.getDocPath(docRelPath));
    }

    public String getDocLocationMsg(String docRelPath) {
        String locationMsg = "type: file, ";
        locationMsg = locationMsg + "file location: " + this.getDocPath(docRelPath) + " ";
        return locationMsg;
    }

    public String getWsdDir() {
        if (this.wsdDir == null) {
            this.wsdDir = this.wsDirectory + '/' + this.getWsdRelDir();
        }
        return this.wsdDir;
    }

    public String getWsdPath(String wsdRelPath) {
        return this.getWsdDir() + '/' + wsdRelPath;
    }

    public InputStream getWsdInputStream(String wsdRelPath) throws IOException {
        return new FileInputStream(this.getWsdPath(wsdRelPath));
    }

    public String getWsdLocationMsg(String wsdRelPath) {
        String locationMsg = "type: file, ";
        locationMsg = locationMsg + "file location: " + this.getWsdPath(wsdRelPath) + " ";
        return locationMsg;
    }

    public String getViRelDir() {
        if (this.viRelDir == null) {
            this.viRelDir = this.getDescriptorsRelDir() + '/' + this.mappings.getProperty("vi");
        }
        return this.viRelDir;
    }

    public String getViDir() {
        if (this.viDir == null) {
            this.viDir = this.wsDirectory + '/' + this.getViRelDir();
        }
        return this.viDir;
    }

    public String getViPath(String viRelPath) {
        return this.getViDir() + '/' + viRelPath;
    }

    public InputStream getViInputStream(String viRelPath) throws IOException {
        return new FileInputStream(this.getViPath(viRelPath));
    }

    public String getViLocationMsg(String viRelPath) {
        String locationMsg = "type: file, ";
        locationMsg = locationMsg + "file location: " + this.getViPath(viRelPath) + " ";
        return locationMsg;
    }

    public String getJarsRelDir() {
        if (this.jarsRelDir == null) {
            this.jarsRelDir = this.mappings.getProperty("jars");
        }
        return this.jarsRelDir;
    }

    public String getJarsDir() {
        if (this.jarsDir == null) {
            this.jarsDir = this.wsDirectory + '/' + this.getJarsRelDir();
        }
        return this.jarsDir;
    }

    public String getJarFileName() {
        if (this.jarFileName == null) {
            this.jarFileName = this.mappings.getProperty("jar_file_name");
        }
        return this.jarFileName;
    }

    public String getJarPath() {
        if (this.jarPath == null) {
            this.jarPath = this.getJarsDir() + '/' + this.getJarFileName();
        }
        return this.jarPath;
    }

    public String getWsdlRelDir() {
        if (this.wsdlRelDir == null) {
            this.wsdlRelDir = this.mappings.getProperty("wsdl");
        }
        return this.wsdlRelDir;
    }

    public String getWsdlDir() {
        if (this.wsdlDir == null) {
            this.wsdlDir = this.wsDirectory + '/' + this.getWsdlRelDir();
        }
        return this.wsdlDir;
    }

    public String getViWsdlPath(String viRelPath, String configurationName, String style, boolean isSapMode) {
        String viRelPathWithoutExt = IOUtil.getFileNameWithoutExt(viRelPath);
        String viWsdlRelPath = null;
        viWsdlRelPath = isSapMode ? viRelPathWithoutExt + "_" + configurationName + "_" + style + "_sap.wsdl" : viRelPathWithoutExt + "_" + configurationName + "_" + style + ".wsdl";
        return this.getWsdlDir() + '/' + viWsdlRelPath;
    }

    public String getBindingWsdlPath(String configurationName, String style, boolean isSapMode) {
        String bindingWsdlFileName = null;
        bindingWsdlFileName = isSapMode ? configurationName + "_" + style + "_sap.wsdl" : configurationName + "_" + style + ".wsdl";
        return this.getWsdlDir() + '/' + bindingWsdlFileName;
    }

    public String getOutsideInRelDir() {
        if (this.outsideInReldDir == null) {
            this.outsideInReldDir = this.mappings.getProperty("out_in");
        }
        return this.outsideInReldDir;
    }

    public String getOutsideInDir() {
        if (this.outsideInDir == null) {
            this.outsideInDir = this.wsDirectory + '/' + this.getOutsideInRelDir();
        }
        return this.outsideInDir;
    }

    public String getOutsideInWsdlRelDir() {
        if (this.outsideInWsdlRelDir == null) {
            this.outsideInWsdlRelDir = this.getOutsideInRelDir() + '/' + this.mappings.getProperty("outside_in_wsdl_dir_name");
        }
        return this.outsideInWsdlRelDir;
    }

    public String getOutsideInWsdlDir() {
        if (this.outsideInWsdlDir == null) {
            this.outsideInWsdlDir = this.wsDirectory + '/' + this.getOutsideInWsdlRelDir();
        }
        return this.outsideInWsdlDir;
    }

    public String getOutsideInWsdlPath(String wsdlRelPath) {
        return this.getOutsideInWsdlDir() + '/' + wsdlRelPath;
    }

    public String getOutsideInJavaToQNameMapppingPath(String javaToQNameMappingRelPath) {
        return this.getOutsideInDir() + '/' + javaToQNameMappingRelPath;
    }

    private static String getAllowedString(String str) {
        return WSUtil.replaceForbiddenChars(str);
    }

    public InputStream getOutsideInWsdlInputStream(String wsdlRelPath) throws IOException {
        return new FileInputStream(this.getOutsideInWsdlPath(wsdlRelPath));
    }

    public String getOutsideInWsdlLocationMsg(String wsdlrelPath) {
        String locationMsg = "type: file ";
        locationMsg = locationMsg + "file location: " + this.getOutsideInWsdlPath(wsdlrelPath) + " ";
        return locationMsg;
    }

    public InputStream getOutsideInJavaToQNameMappingStream(String javaToQNameMappingRelPath) throws IOException {
        return new FileInputStream(this.getOutsideInJavaToQNameMapppingPath(javaToQNameMappingRelPath));
    }

    public String getOutsideInJavaToQNameMappingLocationMsg(String javaToQNameMappingRelPath) {
        String locationMsg = "type: file, ";
        locationMsg = locationMsg + "file location: " + this.getOutsideInJavaToQNameMapppingPath(javaToQNameMappingRelPath) + " ";
        return locationMsg;
    }

    public String getLocationMsg() {
        String locationMsg = "type: file system location, ";
        locationMsg = locationMsg + "location: " + this.wsDirectory + " ";
        return locationMsg;
    }
}

