/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.ws;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.interfaces.webservices.server.deploy.WSWarningException;
import com.sap.engine.services.webservices.exceptions.WSConfigurationException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.server.WSContainer;
import com.sap.engine.services.webservices.server.deploy.WSConfigurationHandler;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.ws.WSAppDeployResult;
import com.sap.engine.services.webservices.server.deploy.ws.WSBaseContext;
import com.sap.engine.services.webservices.server.deploy.ws.WSBaseGlobalContext;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeployGenerator;
import com.sap.engine.services.webservices.server.deploy.ws.WSDirsHandler;
import com.sap.engine.services.webservices.server.deploy.ws.WSProtocolNotificator;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.Vector;

public class WSDeployManager {
    private WSBaseGlobalContext deployContext = new WSBaseGlobalContext();
    private WSDeployGenerator wsDeployGenerator = null;

    public WSDeployManager(WSDeployGenerator wsDeployGenerator) {
        this.wsDeployGenerator = wsDeployGenerator;
    }

    public WSBaseGlobalContext getDeployContext() {
        return this.deployContext;
    }

    public WSAppDeployResult deploy(String applicationName, String wsContainerDir, String wsContainerWorkingDir, File[] moduleArchives, Configuration appConfiguration) throws WSDeploymentException {
        String excMsg = "Error occured, trying to deploy web services for application " + applicationName + ". ";
        String webServicesDir = WSDirsHandler.getWebServicesDir(wsContainerDir);
        String webServicesWorkingDir = WSDirsHandler.getWebServicesWorkingDir(wsContainerWorkingDir);
        WSAppDeployResult wsAppDeployResult = this.wsDeployGenerator.generateDeployFiles(applicationName, webServicesDir, webServicesWorkingDir, moduleArchives);
        try {
            if (wsAppDeployResult.getDeployedComponentNames() != null && wsAppDeployResult.getDeployedComponentNames().length != 0) {
                WSConfigurationHandler.makeWebServicesConfiguration(webServicesDir, wsAppDeployResult.getModuleCrcTable(), appConfiguration);
            }
        }
        catch (WSConfigurationException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)((Object)e));
            Object[] args = new Object[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)((Object)e));
        }
        try {
            this.notifyProtocolsOnDeploy(applicationName, wsAppDeployResult.getWSRuntimeDefinitions(), appConfiguration);
        }
        catch (WSWarningException e) {
            wsAppDeployResult.addWarnings(e.getWarningsVector());
        }
        return wsAppDeployResult;
    }

    public void postDeploy(String applicationName) throws WSWarningException {
        this.notifyProtocolsOnPostDeploy(applicationName);
    }

    public void commitDeploy(String applicationName) throws WSWarningException {
        this.notifyProtocolsOnCommitDeploy(applicationName);
    }

    public void rollbackDeploy(String applicationName) throws WSWarningException {
        Vector warnings = new Vector();
        try {
            this.removeWebServicesDir(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.notifyProtocolsOnRollbackDeploy(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void remove(String applicationName) throws WSWarningException {
        Vector warnings = new Vector();
        try {
            this.notifyProtocolsOnRemove(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.removeWebServicesDir(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void notifyProtocolsOnDeploy(String applicationName, WSRuntimeDefinition[] wsRuntimeDefinitions, Configuration appConfiguration) throws WSWarningException {
        this.deployContext.putContext(applicationName, new WSBaseContext(applicationName, wsRuntimeDefinitions, appConfiguration));
        this.notifyProtocolsOnDeployPhases(applicationName, wsRuntimeDefinitions, appConfiguration, 0);
    }

    public void notifyProtocolsOnPostDeploy(String applicationName) throws WSWarningException {
        WSBaseContext wsBaseContext = this.deployContext.getContext(applicationName);
        if (wsBaseContext == null) {
            return;
        }
        this.notifyProtocolsOnDeployPhases(applicationName, wsBaseContext.getWsRuntimeDefinitions(), wsBaseContext.getAppConfiguration(), 1);
    }

    public void notifyProtocolsOnCommitDeploy(String applicationName) throws WSWarningException {
        this.notifyProtocolsOnShortPhases(applicationName, 2);
    }

    public void notifyProtocolsOnRollbackDeploy(String applicationName) throws WSWarningException {
        Vector warnings = new Vector();
        try {
            this.notifyProtocolsOnShortPhases(applicationName, 3);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        try {
            this.removeWebServicesDir(applicationName);
        }
        catch (WSWarningException e) {
            warnings.addAll(e.getWarningsVector());
        }
        if (warnings.size() != 0) {
            e = new WSWarningException();
            e.addWarnings(warnings);
            throw e;
        }
    }

    public void notifyProtocolsOnRemove(String applicationName) throws WSWarningException {
        new WSProtocolNotificator().onRemove(applicationName);
    }

    private void notifyProtocolsOnDeployPhases(String applicationName, WSRuntimeDefinition[] wsRuntimeDefinitions, Configuration appConfiguration, int mode) throws WSWarningException {
        switch (mode) {
            case 0: {
                new WSProtocolNotificator().onDeploy(applicationName, wsRuntimeDefinitions, appConfiguration);
                break;
            }
            case 1: {
                new WSProtocolNotificator().onPostDeploy(applicationName, wsRuntimeDefinitions, appConfiguration);
            }
        }
    }

    private void notifyProtocolsOnShortPhases(String applicationName, int mode) throws WSWarningException {
        WSBaseContext wsBaseContext = this.deployContext.getContext(applicationName);
        if (wsBaseContext == null) {
            return;
        }
        switch (mode) {
            case 2: {
                new WSProtocolNotificator().onCommitDeploy(wsBaseContext.getWsRuntimeDefinitions());
                break;
            }
            case 3: {
                new WSProtocolNotificator().onRollbackDeploy(wsBaseContext.getWsRuntimeDefinitions());
            }
        }
        this.deployContext.removeContext(applicationName);
    }

    public void removeWebServicesDir(String applicationName) throws WSWarningException {
        String excMsg = "Error occured, deleting webservices directory. ";
        String webServicesDir = null;
        boolean isWebServicesDirDeleted = false;
        try {
            String wsContainerDir = WSContainer.getWSDeployer().getWSContainerDir(applicationName, 0);
            webServicesDir = WSDirsHandler.getWebServicesDir(wsContainerDir);
            isWebServicesDirDeleted = IOUtil.deleteDir(webServicesDir);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = null;
            msg = webServicesDir != null ? excMsg + "Unable to delete" + webServicesDir + " directory. " : excMsg + "Unable to delete" + "webservices" + " directory. ";
            msg = msg + "Reason is: " + e.getLocalizedMessage();
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
        if (!isWebServicesDirDeleted) {
            String msg = null;
            msg = webServicesDir != null ? excMsg + "Unable to delete" + webServicesDir + " directory. " : excMsg + "Unable to delete" + "webservices" + " directory. ";
            WSWarningException wExc = new WSWarningException();
            wExc.addWarning(msg);
            throw wExc;
        }
    }
}

