/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.ws;

import com.sap.engine.interfaces.webservices.runtime.Key;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.lib.io.hash.HashUtils;
import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.jaxrpc.encoding.ExtendedTypeMapping;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl;
import com.sap.engine.services.webservices.jaxrpc.schema2java.SchemaToJavaGenerator;
import com.sap.engine.services.webservices.jaxrpc.util.PackageBuilder;
import com.sap.engine.services.webservices.runtime.TransportBindingProvider;
import com.sap.engine.services.webservices.runtime.definition.JavaToQNameMappingRegistryImpl;
import com.sap.engine.services.webservices.runtime.definition.OperationDefinitionImpl;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.definition.WSIdentifier;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.runtime.interfaces.RuntimeTransportBinding;
import com.sap.engine.services.webservices.runtime.registry.OperationMappingRegistry;
import com.sap.engine.services.webservices.runtime.wsdl.SchemaConvertor;
import com.sap.engine.services.webservices.runtime.wsdl.WSDLGenerator;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDeployGenerator;
import com.sap.engine.services.webservices.server.deploy.common.ModuleDeployResult;
import com.sap.engine.services.webservices.server.deploy.common.ModuleFileStorageHandler;
import com.sap.engine.services.webservices.server.deploy.common.WSBaseConstants;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.VInterfaceParser;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.VirtualInterfaceState;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.ws.VISchemasInfo;
import com.sap.engine.services.webservices.server.deploy.ws.WSAppDeployResult;
import com.sap.engine.services.webservices.server.deploy.ws.WSChecker;
import com.sap.engine.services.webservices.server.deploy.ws.WSDefinitionFactory;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeploySettingsProvider;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeploymentInfo;
import com.sap.engine.services.webservices.server.deploy.ws.WSDirsHandler;
import com.sap.engine.services.webservices.server.deploy.ws.WSFileStorageHandler;
import com.sap.engine.services.webservices.server.deploy.ws.WebServicesUtil;
import com.sap.engine.services.webservices.server.deploy.ws.preprocess.WSLocationWrapper;
import com.sap.engine.services.webservices.wsdl.WSDLDOMLoader;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;

public class WSDeployGenerator {
    private static final String nl = WSBaseConstants.LINE_SEPARATOR;
    private WSDefinitionFactory wsDefinitionFactory = null;
    private WSFileStorageHandler wsFileStorageHandler = null;
    private WSDLGenerator wsdlGenerator = null;
    private JarUtils jarUtils = null;
    private PackageBuilder packageBuilder = null;
    private ModuleDeployGenerator moduleDeployGenerator = null;
    private ModuleFileStorageHandler moduleFileStorageHandler = null;
    private WSDeploySettingsProvider wsDeploySettingsProvider = null;
    private TransportBindingProvider trBindingProvider = null;

    public WSDeployGenerator(WSDeploySettingsProvider wsDeploySettingsProvider, TransportBindingProvider trBindingProvider, ModuleDeployGenerator moduleDepoyGenerator, ModuleFileStorageHandler moduleFileStorageHandler) {
        this.moduleDeployGenerator = moduleDepoyGenerator;
        this.moduleFileStorageHandler = moduleFileStorageHandler;
        this.wsDeploySettingsProvider = wsDeploySettingsProvider;
        this.trBindingProvider = trBindingProvider;
    }

    public WSDefinitionFactory getWsDefinitionFactory() {
        if (this.wsDefinitionFactory == null) {
            this.wsDefinitionFactory = new WSDefinitionFactory();
        }
        return this.wsDefinitionFactory;
    }

    public WSFileStorageHandler getWsFileStorageHandler() {
        if (this.wsFileStorageHandler == null) {
            this.wsFileStorageHandler = new WSFileStorageHandler();
        }
        return this.wsFileStorageHandler;
    }

    public WSDLGenerator getWsdlGenerator() {
        if (this.wsdlGenerator == null) {
            this.wsdlGenerator = new WSDLGenerator(this.trBindingProvider);
        }
        return this.wsdlGenerator;
    }

    public JarUtils getJarUtils() {
        if (this.jarUtils == null) {
            this.jarUtils = new JarUtils();
        }
        return this.jarUtils;
    }

    public PackageBuilder getPackageBuilder() {
        if (this.packageBuilder == null) {
            this.packageBuilder = new PackageBuilder();
        }
        return this.packageBuilder;
    }

    public WSAppDeployResult generateDeployFiles(String applicationName, String webServicesDir, String webServicesWorkingDir, File[] moduleArchives) throws WSDeploymentException {
        String excMsg = "Error occured, trying to generate web services deployment files for application " + applicationName + ". ";
        boolean areDirsDeleted = false;
        try {
            areDirsDeleted = IOUtil.deleteDirs(new String[]{webServicesDir, webServicesWorkingDir});
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to clear web services directories. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
        if (!areDirsDeleted) {
            String msg = excMsg + "Unable to clear web services directories (" + webServicesDir + ", " + webServicesWorkingDir + ") - this may cause problems on web services start or update phase. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5041", args);
        }
        WSAppDeployResult wsAppDeployResult = new WSAppDeployResult();
        try {
            Vector warnings = new Vector();
            Hashtable wsDeploymentInfoesPerModule = this.loadWebServices(applicationName, webServicesWorkingDir, moduleArchives, warnings);
            if (wsDeploymentInfoesPerModule != null && wsDeploymentInfoesPerModule.size() != 0) {
                WSDeploymentInfo[] wsDeploymentInfoes = this.collectWSDeploymentInfoes(wsDeploymentInfoesPerModule);
                new WSChecker().checkWSAppLevel(this.collectWSRuntimeDefinitions(wsDeploymentInfoes));
                ModuleDeployResult moduleDeployResult = this.moduleDeployGenerator.generateAndSaveModuleDeployFiles(applicationName, webServicesDir, moduleArchives);
                this.generateWSDeployFiles(applicationName, webServicesDir, webServicesWorkingDir, wsDeploymentInfoes, wsDeploymentInfoesPerModule);
                File[] deployedFiles = this.collectFiles(moduleArchives, WSUtil.collectKeySet(wsDeploymentInfoesPerModule));
                wsAppDeployResult = this.defineAppDeployResult(deployedFiles, moduleDeployResult.getFilesForClassLoader(), wsDeploymentInfoes, warnings);
            }
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg;
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
        return wsAppDeployResult;
    }

    public void getSchemas(ArrayList vInterfaceEntries, ArrayList vInterfacePaths, Hashtable viSchemaInfoes, DOMSource[][] allSchemas, HashMap[] mappings) throws WSDeploymentException {
        String excMessage = "Error occured, getting schemas from virtual interfaces. ";
        FileInputStream viInputStream = null;
        try {
            int vInterfacesSize = vInterfacePaths.size();
            DOMSource[] literalSchemas = new DOMSource[]{};
            DOMSource[] encodedSchemas = new DOMSource[]{};
            SchemaConvertor literalSchemaConvertor = new SchemaConvertor();
            SchemaConvertor encodedSchemaConvertor = new SchemaConvertor();
            int i = 0;
            while (i < vInterfacesSize) {
                String msg;
                Location wsLocation;
                Object var23_25;
                String vInterfacePath = null;
                try {
                    String vInterfaceEntry = (String)vInterfaceEntries.get(i);
                    vInterfacePath = (String)vInterfacePaths.get(i);
                    viInputStream = new FileInputStream(vInterfacePath);
                    VirtualInterfaceState virtualInterfaceState = VInterfaceParser.getVInterface(viInputStream);
                    DOMSource[] currentLiteralSchemas = literalSchemaConvertor.parseInLiteralMode(virtualInterfaceState);
                    DOMSource[] currentEncodedSchemas = encodedSchemaConvertor.parseInEncodedMode(virtualInterfaceState);
                    VISchemasInfo currentViSchemasInfo = new VISchemasInfo();
                    currentViSchemasInfo.setViPath(vInterfaceEntry);
                    currentViSchemasInfo.setViName(virtualInterfaceState.getName().trim());
                    currentViSchemasInfo.setLiteralSchemas(currentLiteralSchemas);
                    currentViSchemasInfo.setEncodedSchemas(currentEncodedSchemas);
                    viSchemaInfoes.put(currentViSchemasInfo.getViPath(), currentViSchemasInfo);
                    DOMSource[] newLiteralSchemas = new DOMSource[literalSchemas.length + currentLiteralSchemas.length];
                    System.arraycopy(literalSchemas, 0, newLiteralSchemas, 0, literalSchemas.length);
                    System.arraycopy(currentLiteralSchemas, 0, newLiteralSchemas, literalSchemas.length, currentLiteralSchemas.length);
                    literalSchemas = newLiteralSchemas;
                    DOMSource[] newEncodedSchemas = new DOMSource[encodedSchemas.length + currentEncodedSchemas.length];
                    System.arraycopy(encodedSchemas, 0, newEncodedSchemas, 0, encodedSchemas.length);
                    System.arraycopy(currentEncodedSchemas, 0, newEncodedSchemas, encodedSchemas.length, currentEncodedSchemas.length);
                    encodedSchemas = newEncodedSchemas;
                    var23_25 = null;
                }
                catch (Throwable throwable) {
                    var23_25 = null;
                    wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    msg = excMessage + nl + "Unable to close stream for file: " + vInterfacePath;
                    IOUtil.closeInputStreams(new InputStream[]{viInputStream}, new String[]{msg}, wsLocation);
                    throw throwable;
                }
                wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                msg = excMessage + nl + "Unable to close stream for file: " + vInterfacePath;
                IOUtil.closeInputStreams(new InputStream[]{viInputStream}, new String[]{msg}, wsLocation);
                ++i;
            }
            allSchemas[0] = literalSchemas;
            allSchemas[1] = encodedSchemas;
            mappings[0] = literalSchemaConvertor.getJavaToQNameMappings();
            mappings[1] = encodedSchemaConvertor.getJavaToQNameMappings();
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{"Unable to generate schemas for complex types from provided virtual interfaces", "not available"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    public Hashtable getModuleCrcTable(File[] moduleArchives) throws IOException {
        if (moduleArchives == null) {
            return new Hashtable();
        }
        Hashtable<String, byte[]> moduleCrcTable = new Hashtable<String, byte[]>();
        int i = 0;
        while (i < moduleArchives.length) {
            File moduleArchive = moduleArchives[i];
            byte[] moduleCrc = HashUtils.generateFileHash((File)moduleArchive);
            moduleCrcTable.put(moduleArchive.getName(), moduleCrc);
            ++i;
        }
        return moduleCrcTable;
    }

    public String[] getWSFilesForClassLoader(WSRuntimeDefinition[] wsRuntimeDefinitions) {
        if (wsRuntimeDefinitions == null) {
            return new String[0];
        }
        String[] wsFilesForClassLoader = new String[wsRuntimeDefinitions.length];
        int i = 0;
        while (i < wsRuntimeDefinitions.length) {
            wsFilesForClassLoader[i] = wsRuntimeDefinitions[i].getWsDirsHandler().getJarPath();
            ++i;
        }
        return wsFilesForClassLoader;
    }

    public String[] getDeployedComponents(WSRuntimeDefinition[] wsRuntimeDefinitions) {
        if (wsRuntimeDefinitions == null) {
            return new String[0];
        }
        String[] deployedComponents = new String[wsRuntimeDefinitions.length];
        int i = 0;
        while (i < wsRuntimeDefinitions.length) {
            deployedComponents[i] = this.getDeployedSEIs(wsRuntimeDefinitions[i]);
            ++i;
        }
        return deployedComponents;
    }

    private Hashtable loadWebServices(String applicationName, String webServicesWorkingDir, File[] moduleArchives, Vector warnings) {
        String excMsg = "Error occured, loading web services for application " + applicationName + ". ";
        if (moduleArchives == null) {
            return new Hashtable();
        }
        WSDefinitionFactory wsDefinitionFactory = this.getWsDefinitionFactory();
        Hashtable<String, WSDeploymentInfo[]> wsDeploymentInfoesPerModule = new Hashtable<String, WSDeploymentInfo[]>();
        int i = 0;
        while (i < moduleArchives.length) {
            File moduleArchive = moduleArchives[i];
            try {
                WSDeploymentInfo[] wsDeploymentInfoes = wsDefinitionFactory.loadWebServices(applicationName, webServicesWorkingDir, moduleArchive);
                if (wsDeploymentInfoes != null && wsDeploymentInfoes.length != 0) {
                    wsDeploymentInfoesPerModule.put(moduleArchive.getName(), wsDeploymentInfoes);
                }
            }
            catch (WSDeploymentException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                String msg = excMsg + "Unable to load web services from archive " + moduleArchive + ". ";
                warnings.add(msg);
            }
            ++i;
        }
        return wsDeploymentInfoesPerModule;
    }

    public void generateWSDeployFiles(String applicationName, String webServicesDir, String webServicesWorkingDir, WSDeploymentInfo[] wsDeploymentInfoes, Hashtable wsDeploymentInfoesPerModule) throws WSDeploymentException {
        String excMsg = "Error occured, trying to generate web services deploy files for applicaiton " + applicationName + ". ";
        this.generateWSDeployFiles(webServicesDir, webServicesWorkingDir, wsDeploymentInfoes, new int[0], -1);
        try {
            if (wsDeploymentInfoes != null && wsDeploymentInfoes.length != 0) {
                Properties deployedWSPerModule = this.collectDeployedWSNamesPerModule(wsDeploymentInfoesPerModule);
                this.moduleFileStorageHandler.saveDeployedComponentsPerModule(webServicesDir, deployedWSPerModule);
            }
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    public void generateWSDeployFiles(String webServicesDir, String webServicesWorkingDir, WSDeploymentInfo[] wsDeploymentInfoes, int[] freeIndexes, int maxIndex) throws WSDeploymentException {
        this.setMappings(webServicesDir, webServicesWorkingDir, wsDeploymentInfoes, freeIndexes, maxIndex);
        this.generateWSDeployFiles0(webServicesDir, webServicesWorkingDir, wsDeploymentInfoes);
    }

    public void generateWSDeployFiles630(String webServicesDir, String webServicesWorkingDir, WSDeploymentInfo[] wsDeploymentInfoes) throws WSDeploymentException {
        this.setDefaultMappings(webServicesDir, webServicesWorkingDir, wsDeploymentInfoes);
        this.generateWSDeployFiles0(webServicesDir, webServicesWorkingDir, wsDeploymentInfoes);
    }

    public void generateWSDeployFiles0(String webServicesDir, String webServicesWorkingDir, WSDeploymentInfo[] wsDeploymentInfoes) throws WSDeploymentException {
        this.setOutsideImplSettings(this.collectWSRuntimeDefinitions(wsDeploymentInfoes));
        this.generateSingleWSDeployFiles(wsDeploymentInfoes);
    }

    private void setMappings(String webServicesDir, String webServicesWorkingDir, WSDeploymentInfo[] wsDeploymentInfoes, int[] freeIndexes, int maxIndex) {
        if (wsDeploymentInfoes == null) {
            return;
        }
        int freeIndexesLength = freeIndexes.length;
        int i = 0;
        while (i < wsDeploymentInfoes.length) {
            if (i < freeIndexesLength) {
                this.setMappings(webServicesDir, webServicesWorkingDir, wsDeploymentInfoes[i], freeIndexes[i]);
            } else {
                this.setMappings(webServicesDir, webServicesWorkingDir, wsDeploymentInfoes[i], maxIndex + 1 + i - freeIndexesLength);
            }
            ++i;
        }
    }

    private void setDefaultMappings(String webServicesDir, String webServicesWorkingDir, WSDeploymentInfo[] wsDeploymentInfoes) {
        if (wsDeploymentInfoes == null) {
            return;
        }
        int i = 0;
        while (i < wsDeploymentInfoes.length) {
            this.setDefaultMappings(webServicesDir, webServicesWorkingDir, wsDeploymentInfoes[i]);
            ++i;
        }
    }

    private void setDefaultMappings(String webServicesDir, String webServicesWorkingDir, WSDeploymentInfo wsDeploymentInfo) {
        WSRuntimeDefinition wsRuntimeDefinition = wsDeploymentInfo.getWsRuntimeDefinition();
        String serviceName = wsRuntimeDefinition.getWSIdentifier().getServiceName();
        Properties mappings = WSDirsHandler.generateDefaultMappings(serviceName);
        String wsDir = WSDirsHandler.getWSDefaultDirectory(webServicesDir, serviceName);
        WSDirsHandler wsDirsHandler = new WSDirsHandler(mappings, wsDir);
        wsRuntimeDefinition.setWsDirsHandler(wsDirsHandler);
        wsDeploymentInfo.setWsWorkingDirectory(WSDirsHandler.getWSDefaultWorkingDir(webServicesWorkingDir, serviceName));
    }

    private void setMappings(String webServicesDir, String webServicesWorkingDir, WSDeploymentInfo wsDeploymentInfo, int index) {
        WSRuntimeDefinition wsRuntimeDefinition = wsDeploymentInfo.getWsRuntimeDefinition();
        Properties mappings = WSDirsHandler.generateMappings(wsRuntimeDefinition.getWSIdentifier().getServiceName(), index);
        WSDirsHandler wsDirsHandler = new WSDirsHandler(mappings, WSDirsHandler.getWSDirectory(webServicesDir, index));
        wsRuntimeDefinition.setWsDirsHandler(wsDirsHandler);
        wsDeploymentInfo.setWsWorkingDirectory(WSDirsHandler.getWSWorkingDir(webServicesWorkingDir, index));
    }

    private void setOutsideImplSettings(WSRuntimeDefinition[] wsRuntimeDefinitions) throws WSDeploymentException {
        if (wsRuntimeDefinitions == null) {
            return;
        }
        int i = 0;
        while (i < wsRuntimeDefinitions.length) {
            this.setOutsideImplSettings(wsRuntimeDefinitions[i]);
            ++i;
        }
    }

    private void setOutsideImplSettings(WSRuntimeDefinition wsRuntimeDefinition) throws WSDeploymentException {
        String excMsg = "Error occured, trying to make implementation specific settings. ";
        ServiceEndpointDefinition[] endpointDefinitions = wsRuntimeDefinition.getServiceEndpointDefinitions();
        int i = 0;
        while (i < endpointDefinitions.length) {
            try {
                this.wsDeploySettingsProvider.defineImplLink(endpointDefinitions[i]);
            }
            catch (WSDeploymentException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                Object[] args = new String[]{excMsg};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            ++i;
        }
    }

    private void generateSEIAccessKeys(WSRuntimeDefinition wsRuntimeDefinition) throws WSDeploymentException {
        String excMsg = "Error occured, trying to make implementation specific settings. ";
        ServiceEndpointDefinition[] endpointDefinitions = wsRuntimeDefinition.getServiceEndpointDefinitions();
        int i = 0;
        while (i < endpointDefinitions.length) {
            try {
                this.generateAccessKeys(endpointDefinitions[i]);
            }
            catch (WSDeploymentException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                Object[] args = new String[]{excMsg};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            ++i;
        }
    }

    private void generateAccessKeys(ServiceEndpointDefinition endpointDefinition) throws WSDeploymentException {
        WSRuntimeDefinition wsRuntimeDefinition = endpointDefinition.getOwner();
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        String excMsg = "Error occured, trying to generate runtime access keys for service endpoint " + endpointDefinition.getServiceEndpointId() + ", web service " + wsIdentifier.getServiceName() + ", application " + wsIdentifier.getApplicationName() + ". ";
        String trBindingId = endpointDefinition.getTransportBindingId();
        RuntimeTransportBinding trBinding = null;
        try {
            trBinding = (RuntimeTransportBinding)this.trBindingProvider.getTransportBinding(trBindingId);
            OperationMappingRegistry operationMappingRegistry = new OperationMappingRegistry();
            endpointDefinition.setOperationMappingRegistry(operationMappingRegistry);
            OperationDefinition[] operations = endpointDefinition.getOperations();
            int operationsSize = operations.length;
            int j = 0;
            while (j < operationsSize) {
                OperationDefinitionImpl operation = (OperationDefinitionImpl)operations[j];
                Key[] keys = null;
                keys = trBinding.getOperationKeys(operation);
                operation.setKeys(keys);
                operationMappingRegistry.addOperation(keys, operation);
                ++j;
            }
        }
        catch (Exception e) {
            Location location = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            location.catching((Throwable)e);
            Object[] args = new Object[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
    }

    private void generateSingleWSDeployFiles(WSDeploymentInfo[] wsDeploymentInfoes) throws WSDeploymentException {
        if (wsDeploymentInfoes == null) {
            return;
        }
        int i = 0;
        while (i < wsDeploymentInfoes.length) {
            this.generateSingleWSDeployFiles(wsDeploymentInfoes[i]);
            ++i;
        }
    }

    private void generateSingleWSDeployFiles(WSDeploymentInfo wsDeploymentInfo) throws WSDeploymentException {
        WSRuntimeDefinition wsRuntimeDefinition = wsDeploymentInfo.getWsRuntimeDefinition();
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        String excMsg = "Error occured, deploying web service " + wsIdentifier.getServiceName() + ", application " + wsIdentifier.getApplicationName() + ". ";
        try {
            this.clearDirs(new String[]{wsRuntimeDefinition.getWsDirsHandler().getWsDirectory(), wsDeploymentInfo.getWsWorkingDirectory()});
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        if (wsDeploymentInfo.hasOutsideInDescriptor()) {
            this.generateSingleWSDeployFilesOutsideIn(wsDeploymentInfo);
        } else {
            this.generateSingleWSDeployFilesStandard(wsDeploymentInfo);
        }
    }

    private void generateSingleWSDeployFilesStandard(WSDeploymentInfo wsDeploymentInfo) throws WSDeploymentException {
        WSRuntimeDefinition wsRuntimeDefinition = wsDeploymentInfo.getWsRuntimeDefinition();
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        String excMsg = "Error occured, deploying web service " + wsIdentifier.getServiceName() + ", application " + wsIdentifier.getApplicationName() + ". ";
        this.generateSEIAccessKeys(wsRuntimeDefinition);
        this.getWsFileStorageHandler().saveDescriptors(wsDeploymentInfo);
        try {
            DOMSource[][] allschemas = new DOMSource[2][];
            Hashtable viSchemasInfoes = new Hashtable();
            HashMap[] mappings = new HashMap[2];
            this.getSchemas(wsDeploymentInfo.getVirtualInterfaceEntries(), wsDeploymentInfo.getVirtualInterfaces(), viSchemasInfoes, allschemas, mappings);
            this.generateTypesInfo(wsDeploymentInfo, allschemas, mappings);
            this.getWsdlGenerator().generateWsdls(wsRuntimeDefinition, viSchemasInfoes, mappings);
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        this.getWsFileStorageHandler().saveWSRuntimeDescriptor(wsDeploymentInfo.getWsRuntimeDefinition());
    }

    private void generateSingleWSDeployFilesOutsideIn(WSDeploymentInfo wsDeploymentInfo) throws WSDeploymentException {
        WSRuntimeDefinition wsRuntimeDefinition = wsDeploymentInfo.getWsRuntimeDefinition();
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        String excMsg = "Error occured, deploying web service " + wsIdentifier.getServiceName() + ", application " + wsIdentifier.getApplicationName() + ". ";
        this.generateSEIAccessKeys(wsRuntimeDefinition);
        this.getWsFileStorageHandler().saveDescriptors(wsDeploymentInfo);
        this.getWsFileStorageHandler().saveOutsideIn(wsDeploymentInfo);
        try {
            DOMSource[][] allschemas = new DOMSource[2][];
            HashMap[] mappings = new HashMap[2];
            this.getOutsideInSchemas(wsDeploymentInfo.getWsdlRefPath(), allschemas);
            JavaToQNameMappingRegistryImpl javaToQNameRegistry = JavaToQNameMappingRegistryImpl.loadFromFile(new File(wsDeploymentInfo.getJavaQNameMappingRefPath()));
            mappings[0] = javaToQNameRegistry.getLiteralMappings().getJavaToQNameMappings();
            mappings[1] = javaToQNameRegistry.getEncodedMappings().getJavaToQNameMappings();
            this.generateTypesInfo(wsDeploymentInfo, allschemas, mappings);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    private void getOutsideInSchemas(String wsdlPath, DOMSource[][] allSchemas) throws WSDeploymentException {
        try {
            WSDLDefinitions wsdlDefinitions = new WSDLDOMLoader().loadWSDLDocument(new File(wsdlPath).getAbsolutePath());
            ArrayList schemas = wsdlDefinitions.getSchemaDefinitions();
            int schemasSize = schemas.size();
            DOMSource[] schemasArr = new DOMSource[schemasSize];
            int i = 0;
            while (i < schemasSize) {
                schemasArr[i] = (DOMSource)schemas.get(i);
                ++i;
            }
            allSchemas[0] = schemasArr;
            allSchemas[1] = schemasArr;
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{"Unable to load or parse wsdl file and to get the provided schemas in outside-in case", "not available"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    private void generateTypesInfo(WSDeploymentInfo wsDeploymentInfo, DOMSource[][] allSchemas, HashMap[] mappings) throws WSDeploymentException {
        WSRuntimeDefinition wsRuntimeDefinition = wsDeploymentInfo.getWsRuntimeDefinition();
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        WSFileStorageHandler wsFileStorageHandler = this.getWsFileStorageHandler();
        try {
            wsFileStorageHandler.saveJavaToQNameMappingFile(wsRuntimeDefinition, mappings);
            this.generateTypes(wsDeploymentInfo, allSchemas, mappings);
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{"Unable to generate complex types", wsIdentifier.getApplicationName(), wsIdentifier.getJarName(), wsIdentifier.getServiceName()};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
    }

    private void generateTypes(WSDeploymentInfo wsDeploymentInfo, DOMSource[][] allSchemas, HashMap[] mapppings) throws WSDeploymentException {
        WSRuntimeDefinition wsRuntimeDefinition = wsDeploymentInfo.getWsRuntimeDefinition();
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        try {
            String wsIdentifierAsString = this.getWSIdentifierAsString(wsIdentifier);
            DOMSource[] literalSchemas = allSchemas[0];
            DOMSource[] encodedSchemas = allSchemas[1];
            HashMap literalMappings = mapppings[0];
            HashMap encodedMappings = mapppings[1];
            String wsWorkingDir = wsDeploymentInfo.getWsWorkingDirectory();
            TypeMappingRegistryImpl typeMappingRegistryImpl = new TypeMappingRegistryImpl();
            TypeMappingImpl literalTypeMapping = (TypeMappingImpl)typeMappingRegistryImpl.getDefaultTypeMapping();
            String packageNameForLiteral = wsIdentifierAsString + "";
            this.generateSerializationClasses(literalTypeMapping, literalSchemas, literalMappings, wsWorkingDir, packageNameForLiteral);
            TypeMappingImpl encodedTypeMapping = (TypeMappingImpl)typeMappingRegistryImpl.createTypeMapping();
            String packageNameForEncoded = wsIdentifierAsString + "SOAPENC";
            this.generateSerializationClasses(encodedTypeMapping, encodedSchemas, encodedMappings, wsWorkingDir, packageNameForEncoded);
            typeMappingRegistryImpl.registerDefault((TypeMapping)literalTypeMapping);
            typeMappingRegistryImpl.register("http://schemas.xmlsoap.org/soap/encoding/", (TypeMapping)encodedTypeMapping);
            String typeMappingPath = wsRuntimeDefinition.getWsDirsHandler().getTypeMappingPath();
            typeMappingRegistryImpl.toXmlFile(typeMappingPath);
            Vector<String> filters = new Vector<String>();
            filters.add("class");
            String typesJarPath = wsRuntimeDefinition.getWsDirsHandler().getJarPath();
            IOUtil.createParentDir(new String[]{typesJarPath});
            this.getJarUtils().makeJarFromDir(typesJarPath, new String[]{wsWorkingDir}, filters);
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{"Unable to generate complex types", wsIdentifier.getApplicationName(), wsIdentifier.getJarName(), wsIdentifier.getServiceName()};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
    }

    private void generateSerializationClasses(TypeMappingImpl typeMapping, DOMSource[] schemas, HashMap mappings, String workingDir, String packageName) throws WSDeploymentException {
        try {
            SchemaToJavaGenerator schemaToJavaGenerator = new SchemaToJavaGenerator();
            int schemasSize = schemas.length;
            int i = 0;
            while (i < schemasSize) {
                schemaToJavaGenerator.addSchemaSource((Source)schemas[i]);
                ++i;
            }
            String classPath = this.wsDeploySettingsProvider.getClassPath();
            HashMap schemaJavaMap = this.revert(mappings);
            schemaToJavaGenerator.setApplicationSchemaMapping(schemaJavaMap);
            schemaToJavaGenerator.setApplicationJavaMapping(mappings);
            schemaToJavaGenerator.generateAll(new File(workingDir), packageName, false);
            schemaToJavaGenerator.registerTypes((ExtendedTypeMapping)typeMapping);
            if (!IOUtil.isEmptyDir(workingDir)) {
                this.getPackageBuilder().compileExternal(classPath + File.pathSeparator + workingDir, new File(workingDir));
            }
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{"Unable to generate complex types", "not available"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    private HashMap revert(HashMap hMap) {
        HashMap nMap = new HashMap();
        Iterator keys = hMap.keySet().iterator();
        while (keys.hasNext()) {
            Object tmpKey = keys.next();
            nMap.put(hMap.get(tmpKey), tmpKey);
        }
        return nMap;
    }

    private String getDeployedSEIs(WSRuntimeDefinition wsRuntimeDefinition) {
        String resultString = "WEB SERVICE PORTS: \n";
        ServiceEndpointDefinition[] endpointDefinitions = wsRuntimeDefinition.getServiceEndpointDefinitions();
        int i = 0;
        while (i < endpointDefinitions.length) {
            resultString = resultString + endpointDefinitions[i].getServiceEndpointId() + "\n";
            ++i;
        }
        return resultString;
    }

    public WSRuntimeDefinition[] collectWSRuntimeDefinitions(WSDeploymentInfo[] wsDeploymentInfoes) {
        if (wsDeploymentInfoes == null) {
            return new WSRuntimeDefinition[0];
        }
        WSRuntimeDefinition[] wsRuntimeDefinitions = new WSRuntimeDefinition[wsDeploymentInfoes.length];
        int i = 0;
        while (i < wsDeploymentInfoes.length) {
            WSDeploymentInfo wsDeploymentInfo = wsDeploymentInfoes[i];
            wsRuntimeDefinitions[i] = wsDeploymentInfo.getWsRuntimeDefinition();
            ++i;
        }
        return wsRuntimeDefinitions;
    }

    public String getWSIdentifierAsString(WSIdentifier wsIdentifier) {
        String jarName = WSUtil.getJarNameAsString(wsIdentifier.getJarName());
        String serviceName = this.getServiceNameAsString(wsIdentifier.getServiceName());
        return jarName + "_" + serviceName;
    }

    private String getServiceNameAsString(String serviceName) {
        return WSUtil.replaceForbiddenChars(serviceName);
    }

    private WSAppDeployResult defineAppDeployResult(File[] deployedModules, String[] moduleFilesForClassLoader, WSDeploymentInfo[] wsDeploymentInfoes, Vector warnings) throws WSDeploymentException {
        String excMsg = "Error occured, trying to construct web services deploy result. ";
        if (wsDeploymentInfoes == null) {
            return new WSAppDeployResult();
        }
        WSAppDeployResult wsAppDeployResult = new WSAppDeployResult();
        WSRuntimeDefinition[] wsRuntimeDefinitions = this.collectWSRuntimeDefinitions(wsDeploymentInfoes);
        wsAppDeployResult.setDeployedComponentNames(this.getDeployedComponents(wsRuntimeDefinitions));
        wsAppDeployResult.setFilesForClassloader(WSUtil.unifyStrings(new String[][]{moduleFilesForClassLoader, this.getWSFilesForClassLoader(wsRuntimeDefinitions)}));
        wsAppDeployResult.setWsDeploymentInfos(wsDeploymentInfoes);
        try {
            wsAppDeployResult.setModuleCrcTable(this.getModuleCrcTable(deployedModules));
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg + "Unable to generate file hashes for module archives. ";
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        wsAppDeployResult.setWarnings(warnings);
        return wsAppDeployResult;
    }

    public WSDeploymentInfo[] collectWSDeploymentInfoes(Hashtable wsDeploymentInfoesHash) {
        if (wsDeploymentInfoesHash == null) {
            return new WSDeploymentInfo[0];
        }
        Enumeration enumeration = wsDeploymentInfoesHash.elements();
        WSDeploymentInfo[] wsDeploymentInfoes = new WSDeploymentInfo[]{};
        while (enumeration.hasMoreElements()) {
            WSDeploymentInfo[] currentWsDeploymentInfoes = (WSDeploymentInfo[])enumeration.nextElement();
            wsDeploymentInfoes = WebServicesUtil.unifyWSDeploymentInfoes(new WSDeploymentInfo[][]{wsDeploymentInfoes, currentWsDeploymentInfoes});
        }
        return wsDeploymentInfoes;
    }

    public Properties collectDeployedWSNamesPerModule(Hashtable wsDeploymentInfoesPerModule) {
        String delimiter = ";";
        if (wsDeploymentInfoesPerModule == null) {
            return new Properties();
        }
        Enumeration enumeration = wsDeploymentInfoesPerModule.keys();
        Properties deployedWSNamesPerModule = new Properties();
        while (enumeration.hasMoreElements()) {
            String moduleName = (String)enumeration.nextElement();
            Object wsPerModule = wsDeploymentInfoesPerModule.get(moduleName);
            if (wsPerModule instanceof WSDeploymentInfo[]) {
                WSDeploymentInfo[] wsDeploymentInfoes = (WSDeploymentInfo[])wsPerModule;
                deployedWSNamesPerModule.setProperty(moduleName, WSUtil.concatStrings(this.collectServiceNames(wsDeploymentInfoes), delimiter));
                continue;
            }
            if (!(wsPerModule instanceof WSLocationWrapper[])) continue;
            WSLocationWrapper[] wsLocationWrappers = (WSLocationWrapper[])wsPerModule;
            deployedWSNamesPerModule.setProperty(moduleName, WSUtil.concatStrings(this.collectServiceNames(wsLocationWrappers), delimiter));
        }
        return deployedWSNamesPerModule;
    }

    private String[] collectServiceNames(WSDeploymentInfo[] wsDeploymentInfoes) {
        if (wsDeploymentInfoes == null) {
            return new String[0];
        }
        String[] serviceNames = new String[wsDeploymentInfoes.length];
        int i = 0;
        while (i < wsDeploymentInfoes.length) {
            serviceNames[i] = wsDeploymentInfoes[i].getWsRuntimeDefinition().getWSIdentifier().getServiceName();
            ++i;
        }
        return serviceNames;
    }

    private String[] collectServiceNames(WSLocationWrapper[] wsLocationWrappers) {
        if (wsLocationWrappers == null) {
            return new String[0];
        }
        String[] serviceNames = new String[wsLocationWrappers.length];
        int i = 0;
        while (i < wsLocationWrappers.length) {
            serviceNames[i] = wsLocationWrappers[i].getWebServiceName();
            ++i;
        }
        return serviceNames;
    }

    public void clearDirs(String[] dirs) throws WSDeploymentException {
        String excMsg = "Unable to clear directories ( " + WSUtil.concatStrings(dirs, ";") + "). ";
        boolean areDirsDeleted = false;
        try {
            areDirsDeleted = IOUtil.deleteDirs(dirs);
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg;
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5041", args, (Throwable)e);
        }
        if (!areDirsDeleted) {
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args);
        }
    }

    private File[] collectFiles(File[] files, Set filterList) {
        if (files == null) {
            return new File[0];
        }
        if (filterList == null) {
            filterList = new HashSet();
        }
        Vector<File> filteredFiles = new Vector<File>();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (filterList.contains(file.getName())) {
                filteredFiles.add(file);
            }
            ++i;
        }
        Object[] filteredFilesArr = new File[filteredFiles.size()];
        filteredFiles.copyInto(filteredFilesArr);
        return filteredFilesArr;
    }
}

