/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.ws;

import com.sap.engine.interfaces.webservices.runtime.Config;
import com.sap.engine.interfaces.webservices.runtime.Fault;
import com.sap.engine.interfaces.webservices.runtime.ImplLink;
import com.sap.engine.interfaces.webservices.runtime.Key;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.interfaces.webservices.runtime.ParameterNode;
import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.webservices.exceptions.WSGenerationException;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.definition.ConfigImpl;
import com.sap.engine.services.webservices.runtime.definition.FaultImpl;
import com.sap.engine.services.webservices.runtime.definition.FeatureInfo;
import com.sap.engine.services.webservices.runtime.definition.JavaImplConstants;
import com.sap.engine.services.webservices.runtime.definition.OperationDefinitionImpl;
import com.sap.engine.services.webservices.runtime.definition.OutsideInDefinition;
import com.sap.engine.services.webservices.runtime.definition.ParameterNodeImpl;
import com.sap.engine.services.webservices.runtime.definition.PropertyDescriptorInterfaceImpl;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.definition.WSIdentifier;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.runtime.wsdl.WSDProcessor;
import com.sap.engine.services.webservices.server.deploy.common.WSBaseConstants;
import com.sap.engine.services.webservices.server.deploy.descriptors.runtime.ImplLinkDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.runtime.QNameDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.runtime.RuntimeOperationConfigDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.runtime.WSRuntimeConfigurationDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.runtime.WSRuntimeDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.runtime.WSRuntimeParser;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.FaultConfigDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.FeatureDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.NameDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.OperationConfigurationDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.OutsideInDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.PropertyDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.TrBindingConfigDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.TrBindingDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.WSConfigurationDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.WSDeploymentDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.WSDeploymentParser;
import com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.WSDescriptor;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.FaultState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.FunctionState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.ParameterMappedTypeReference;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.ParameterState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.SoapExtensionFunctionState;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.VInterfaceParser;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.VirtualInterfaceEndpointReference;
import com.sap.engine.services.webservices.server.deploy.descriptors.vi.VirtualInterfaceState;
import com.sap.engine.services.webservices.server.deploy.util.IOUtil;
import com.sap.engine.services.webservices.server.deploy.util.WSUtil;
import com.sap.engine.services.webservices.server.deploy.util.jar.JarUtil;
import com.sap.engine.services.webservices.server.deploy.ws.WSArchiveFilesLocationHandler;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeploymentInfo;
import com.sap.engine.services.webservices.server.deploy.ws.WSDirsHandler;
import com.sap.engine.services.webservices.server.deploy.ws.WSFilesLocationHandler;
import com.sap.engine.services.webservices.server.deploy.ws.WebServicesConstants;
import com.sap.engine.services.webservices.server.deploy.ws.deploy.WSDescriptorsLocationTable;
import com.sap.engine.services.webservices.server.deploy.ws.preprocess.ExtArchiveLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.ws.preprocess.ExtFileLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.ws.preprocess.WSArchiveLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.ws.preprocess.WSFileLocationWrapper;
import com.sap.engine.services.webservices.server.deploy.ws.preprocess.WSLocationWrapper;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarFile;
import javax.xml.namespace.QName;

public class WSDefinitionFactory
implements WebServicesConstants {
    private JarUtil jarUtil = new JarUtil();
    static /* synthetic */ Class class$com$sap$engine$services$webservices$server$deploy$descriptors$sapwebservices$WSDeploymentDescriptor;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$server$deploy$descriptors$sapwebservices$WSDescriptor;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$server$deploy$descriptors$runtime$WSRuntimeDescriptor;
    static /* synthetic */ Class class$java$rmi$RemoteException;

    public static String[] extractWebServicesNames(String wsDeploymentDescriptorPath) throws WSDeploymentException {
        String excMsg = "Error occured, trying to extract web service names from descriptor " + wsDeploymentDescriptorPath + ". ";
        WSDeploymentDescriptor wsDeploymentDescriptor = null;
        try {
            wsDeploymentDescriptor = WSDeploymentParser.loadWSDeploymentDescriptor(wsDeploymentDescriptorPath);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        WSDescriptor[] wsDescriptors = wsDeploymentDescriptor.getWebservice();
        if (wsDescriptors == null) {
            return new String[0];
        }
        String[] webServicesNames = new String[wsDescriptors.length];
        int i = 0;
        while (i < webServicesNames.length) {
            webServicesNames[i] = wsDescriptors[i].getWebserviceInternalName().trim();
            ++i;
        }
        return webServicesNames;
    }

    public static String extractModuleName(String wsRuntimeDescriptorPath) throws WSDeploymentException {
        String excMsg = "Error occured, trying to extract module names from descriptor " + wsRuntimeDescriptorPath + ". ";
        WSRuntimeDescriptor wsRuntimeDescriptor = null;
        try {
            wsRuntimeDescriptor = WSRuntimeParser.loadWSRuntimeDescriptor(wsRuntimeDescriptorPath);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return WSDefinitionFactory.extractModuleNames(new WSRuntimeDescriptor[]{wsRuntimeDescriptor})[0];
    }

    public static String[] extractModuleNames(WSRuntimeDescriptor[] wsRuntimeDescriptors) {
        if (wsRuntimeDescriptors == null) {
            return new String[0];
        }
        String[] moduleNames = new String[wsRuntimeDescriptors.length];
        int i = 0;
        while (i < wsRuntimeDescriptors.length) {
            moduleNames[i] = wsRuntimeDescriptors[i].getJarName().trim();
            ++i;
        }
        return moduleNames;
    }

    public WSDeploymentInfo[] loadWebServices(String applicationName, String webServicesWorkingDir, File moduleArchive) throws WSDeploymentException {
        Vector warnings = new Vector();
        WSDeploymentInfo[] wsDeploymentInfoes = this.loadWebServices(applicationName, webServicesWorkingDir, moduleArchive, warnings);
        if (warnings.size() != 0) {
            String msg = WSUtil.concatStrings(warnings, "");
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args);
        }
        return wsDeploymentInfoes;
    }

    /*
     * Loose catch block
     */
    public WSDeploymentInfo[] loadWebServices(String applicationName, String webServicesWorkingDir, File moduleArchive, Vector warnings) throws WSDeploymentException {
        WSDeploymentInfo[] wsDeploymentInfoes;
        block9: {
            String excMsg = "Error occured, trying to load web services for module " + moduleArchive.getAbsolutePath() + ". ";
            wsDeploymentInfoes = new WSDeploymentInfo[]{};
            JarFile moduleArchiveJarFile = null;
            moduleArchiveJarFile = new JarFile(moduleArchive);
            WSArchiveFilesLocationHandler wsArchiveFilesLocationHandler = new WSArchiveFilesLocationHandler(moduleArchive, WSDirsHandler.getModuleWorkingDir(webServicesWorkingDir, moduleArchive.getName()));
            wsDeploymentInfoes = this.parseWSDeploymentDescriptor(applicationName, wsArchiveFilesLocationHandler, warnings);
            Object var12_10 = null;
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = excMsg + "Unable to close input stream for module. ";
            try {
                if (moduleArchiveJarFile != null) {
                    moduleArchiveJarFile.close();
                }
                break block9;
            }
            catch (IOException ioExc) {
                wsDeployLocation.catching(msg, (Throwable)ioExc);
            }
            break block9;
            {
                catch (IOException e) {
                    Location wsDeplLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeplLocation.catching((Throwable)e);
                    Object[] args = new String[]{excMsg};
                    throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                msg = excMsg + "Unable to close input stream for module. ";
                try {
                    if (moduleArchiveJarFile != null) {
                        moduleArchiveJarFile.close();
                    }
                }
                catch (IOException ioExc) {
                    wsDeployLocation.catching(msg, (Throwable)ioExc);
                }
                throw throwable;
            }
        }
        return wsDeploymentInfoes;
    }

    public WSDeploymentInfo[] loadWebServices(String webServicesWorkingDir, WSArchiveLocationWrapper[] wsArchiveLocationWrappers) throws WSDeploymentException {
        if (wsArchiveLocationWrappers == null) {
            return new WSDeploymentInfo[0];
        }
        WSDeploymentInfo[] wsDeploymentInfoes = new WSDeploymentInfo[wsArchiveLocationWrappers.length];
        int i = 0;
        while (i < wsArchiveLocationWrappers.length) {
            wsDeploymentInfoes[i] = this.loadWebService(webServicesWorkingDir, wsArchiveLocationWrappers[i]);
            ++i;
        }
        return wsDeploymentInfoes;
    }

    public WSDeploymentInfo loadWebService(String webServicesWorkingDir, WSArchiveLocationWrapper wsArchiveLocationWrapper) throws WSDeploymentException {
        WSArchiveFilesLocationHandler wsArchiveFilesLocationHandler = wsArchiveLocationWrapper.getWsArchiveFilesLocationHandler();
        String moduleWorkingDir = WSDirsHandler.getModuleWorkingDir(webServicesWorkingDir, wsArchiveFilesLocationHandler.getModuleArchive().getName());
        WSDeploymentInfo wsDeploymentInfo = new WSDeploymentInfo();
        wsArchiveFilesLocationHandler.setWorkingDir(moduleWorkingDir);
        wsArchiveFilesLocationHandler.setWsDeploymentInfo(wsDeploymentInfo);
        String applicationName = wsArchiveLocationWrapper.getApplicationName();
        String version = wsArchiveLocationWrapper.getVersion();
        WSDescriptor wsDescriptor = wsArchiveLocationWrapper.getWsDescriptor();
        try {
            this.parseWSDescriptor(applicationName, version, wsDescriptor, wsArchiveFilesLocationHandler, wsDeploymentInfo);
            this.setAdditionalWSDeploymentSettings(wsArchiveFilesLocationHandler.getModuleArchive().getName(), wsDeploymentInfo);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                if (wsArchiveFilesLocationHandler != null) {
                    wsArchiveFilesLocationHandler.close();
                }
            }
            catch (IOException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning!", (Throwable)e);
            }
            throw throwable;
        }
        try {
            if (wsArchiveFilesLocationHandler != null) {
                wsArchiveFilesLocationHandler.close();
            }
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching("Warning!", (Throwable)e);
        }
        return wsDeploymentInfo;
    }

    public WSDeploymentInfo loadWebService(String webServicesWorkingDir, ExtArchiveLocationWrapper extArchiveLocationWrapper) throws WSDeploymentException {
        WSArchiveFilesLocationHandler wsArchiveFilesLocationHandler = extArchiveLocationWrapper.getWsArchiveFilesLocationHandler();
        String moduleWorkingDir = WSDirsHandler.getModuleWorkingDir(webServicesWorkingDir, wsArchiveFilesLocationHandler.getModuleArchive().getName());
        WSDeploymentInfo wsDeploymentInfo = new WSDeploymentInfo();
        wsArchiveFilesLocationHandler.setWorkingDir(moduleWorkingDir);
        wsArchiveFilesLocationHandler.setWsDeploymentInfo(wsDeploymentInfo);
        String applicationName = extArchiveLocationWrapper.getApplicationName();
        String version = extArchiveLocationWrapper.getVersion();
        WSDescriptor wsDescriptor = extArchiveLocationWrapper.getWsDescriptor();
        this.parseWSDescriptor(applicationName, version, wsDescriptor, wsArchiveFilesLocationHandler, wsDeploymentInfo);
        this.setAdditionalWSDeploymentSettings(wsArchiveFilesLocationHandler.getModuleArchive().getName(), wsDeploymentInfo);
        return wsDeploymentInfo;
    }

    public WSRuntimeDefinition loadWebServiceRuntimeMode(String applicationName, String wsDir, Properties mappings) throws WSDeploymentException {
        WSDirsHandler wsDirsHandler = new WSDirsHandler(mappings, wsDir);
        return this.loadWebServiceRuntimeMode(applicationName, wsDirsHandler);
    }

    public WSRuntimeDefinition loadWebServiceRuntimeMode(String applicationName, WSDirsHandler wsDirsHandler) throws WSDeploymentException {
        String excMsg = "Error occured, loading web services. ";
        WSDeploymentDescriptor wsDeploymentDescriptor = null;
        InputStream wsDeploymentDescriptorInputStream = null;
        try {
            try {
                wsDeploymentDescriptorInputStream = wsDirsHandler.getWSDeploymentDescriptorInputStream();
                wsDeploymentDescriptor = WSDeploymentParser.loadWSDeploymentDescriptor(wsDeploymentDescriptorInputStream);
            }
            catch (Exception e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                String msg = excMsg + " Unable to parse " + (class$com$sap$engine$services$webservices$server$deploy$descriptors$sapwebservices$WSDeploymentDescriptor == null ? (class$com$sap$engine$services$webservices$server$deploy$descriptors$sapwebservices$WSDeploymentDescriptor = WSDefinitionFactory.class$("com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.WSDeploymentDescriptor")) : class$com$sap$engine$services$webservices$server$deploy$descriptors$sapwebservices$WSDeploymentDescriptor).getName() + " descriptor, source " + wsDirsHandler.getWSDeploymentDescriptorLocationMsg() + ". ";
                Object[] args = new String[]{msg, "none"};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            Object var11_6 = null;
        }
        catch (Throwable throwable) {
            Object var11_7 = null;
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = excMsg + " Unable to close input stream for source " + wsDirsHandler.getWSDeploymentDescriptorLocationMsg() + ". ";
            IOUtil.closeInputStreams(new InputStream[]{wsDeploymentDescriptorInputStream}, new String[]{msg}, wsDeployLocation);
            throw throwable;
        }
        Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
        String msg = excMsg + " Unable to close input stream for source " + wsDirsHandler.getWSDeploymentDescriptorLocationMsg() + ". ";
        IOUtil.closeInputStreams(new InputStream[]{wsDeploymentDescriptorInputStream}, new String[]{msg}, wsDeployLocation);
        WSRuntimeDescriptor wsRuntimeDescriptor = null;
        String wsRuntimeDescriptorPath = wsDirsHandler.getWSRuntimeDescriptorPath();
        try {
            wsRuntimeDescriptor = this.loadWSRuntimeDescriptors(new String[]{wsRuntimeDescriptorPath})[0];
        }
        catch (Exception e) {
            Location wsDeployLocation2 = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation2.catching((Throwable)e);
            String msg2 = excMsg;
            Object[] args = new String[]{msg2, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        Hashtable notParsedDescriptors = new Hashtable();
        WSRuntimeDefinition wsRuntimeDefinition = this.loadWebServicesRuntimeMode(applicationName, wsDeploymentDescriptor.getVersion().trim(), wsDeploymentDescriptor.getWebservice(), new WSRuntimeDescriptor[]{wsRuntimeDescriptor}, wsDirsHandler, notParsedDescriptors)[0];
        if (notParsedDescriptors.size() > 0) {
            String[] prefixMsgs = WSUtil.addPrefixToStrings(excMsg + "Unable to load web service with corresponding descriptor ", new String[]{wsRuntimeDescriptorPath});
            prefixMsgs = WSUtil.addSuffixToStrings(prefixMsgs, ", nested exception is: ");
            Vector msgs = this.constructMsgs(prefixMsgs, notParsedDescriptors);
            Object[] args = new String[]{WSUtil.concatStrings(msgs, "")};
            throw new WSDeploymentException("webservices_5040", args);
        }
        return wsRuntimeDefinition;
    }

    public WSRuntimeDefinition[] loadWebServicesRuntimeMode(String applicationName, String version, WSDescriptor[] wsDescriptors, WSRuntimeDescriptor[] wsRuntimeDescriptors, WSDirsHandler wsDirsHandler, Hashtable notLoadedWS) {
        if (wsRuntimeDescriptors == null) {
            return new WSRuntimeDefinition[0];
        }
        Vector<WSRuntimeDefinition> wsRuntimeDefinitions = new Vector<WSRuntimeDefinition>();
        int i = 0;
        while (i < wsDescriptors.length) {
            try {
                WSRuntimeDefinition wsRuntimeDefinition = this.loadWebServiceRuntimeMode(applicationName, version, wsDescriptors[i], wsRuntimeDescriptors[i], wsDirsHandler);
                wsRuntimeDefinitions.add(wsRuntimeDefinition);
            }
            catch (WSDeploymentException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                notLoadedWS.put(new Integer(i), e.getLocalizedMessage());
            }
            ++i;
        }
        Object[] wsRuntimeDefinitionsArr = new WSRuntimeDefinition[wsRuntimeDefinitions.size()];
        wsRuntimeDefinitions.copyInto(wsRuntimeDefinitionsArr);
        return wsRuntimeDefinitionsArr;
    }

    public WSRuntimeDefinition loadWebServiceRuntimeMode(String applicationName, String version, WSDescriptor wsDescriptor, WSRuntimeDescriptor wsRuntimeDescriptor, WSDirsHandler wsDirsHandler) throws WSDeploymentException {
        String excMsg = "Error occured, loading web service from " + (class$com$sap$engine$services$webservices$server$deploy$descriptors$sapwebservices$WSDescriptor == null ? (class$com$sap$engine$services$webservices$server$deploy$descriptors$sapwebservices$WSDescriptor = WSDefinitionFactory.class$("com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.WSDescriptor")) : class$com$sap$engine$services$webservices$server$deploy$descriptors$sapwebservices$WSDescriptor).getName() + " and " + (class$com$sap$engine$services$webservices$server$deploy$descriptors$runtime$WSRuntimeDescriptor == null ? (class$com$sap$engine$services$webservices$server$deploy$descriptors$runtime$WSRuntimeDescriptor = WSDefinitionFactory.class$("com.sap.engine.services.webservices.server.deploy.descriptors.runtime.WSRuntimeDescriptor")) : class$com$sap$engine$services$webservices$server$deploy$descriptors$runtime$WSRuntimeDescriptor).getName() + ". ";
        WSRuntimeDefinition wsRuntimeDefinition = null;
        try {
            WSDeploymentInfo wsDeploymentInfo = new WSDeploymentInfo();
            this.parseWSDescriptor(applicationName, version, wsDescriptor, wsDirsHandler, wsDeploymentInfo);
            wsRuntimeDefinition = wsDeploymentInfo.getWsRuntimeDefinition();
            this.parseRuntimeSpecific(applicationName, wsRuntimeDefinition, wsRuntimeDescriptor);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            String msg = excMsg;
            Object[] args = new String[]{msg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsRuntimeDefinition;
    }

    public void saveRuntime(String fileName, WSRuntimeDefinition wsRuntimeDefinition) throws WSDeploymentException {
        WSIdentifier wsIdentifier = wsRuntimeDefinition.getWSIdentifier();
        String excMsg = "Error occured, trying to generate and/or save ws-runtime-descriptor.xml, application " + wsIdentifier.getApplicationName() + ", service " + wsIdentifier.getServiceName() + ". ";
        WSRuntimeDescriptor wsRuntimeDescriptor = this.getWSRuntimeDescriptor(wsRuntimeDefinition);
        try {
            WSRuntimeParser.saveWSRuntimeDescriptor(wsRuntimeDescriptor, fileName);
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{excMsg, "none"};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    private WSRuntimeDescriptor[] loadWSRuntimeDescriptors(String[] wsRuntimeDescriptorPaths) throws Exception {
        if (wsRuntimeDescriptorPaths == null) {
            return new WSRuntimeDescriptor[0];
        }
        WSRuntimeDescriptor[] wsRuntimeDescriptors = new WSRuntimeDescriptor[wsRuntimeDescriptorPaths.length];
        int i = 0;
        while (i < wsRuntimeDescriptorPaths.length) {
            wsRuntimeDescriptors[i] = WSRuntimeParser.loadWSRuntimeDescriptor(wsRuntimeDescriptorPaths[i]);
            ++i;
        }
        return wsRuntimeDescriptors;
    }

    private Vector constructMsgs(String[] prefixMsgs, Hashtable tailMsgs) {
        if (tailMsgs == null) {
            return new Vector();
        }
        Vector<String> msgs = new Vector<String>();
        Enumeration enumeration = tailMsgs.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            Integer number = (Integer)enumeration.nextElement();
            String msg = prefixMsgs[i] + (String)tailMsgs.get(number);
            msgs.add(msg);
            ++i;
        }
        return msgs;
    }

    public WSArchiveLocationWrapper[] loadWSArchiveLocationWrappers(String applicationName, File[] moduleArchives) throws WSDeploymentException {
        if (moduleArchives == null) {
            return new WSArchiveLocationWrapper[0];
        }
        WSArchiveLocationWrapper[] wsArchiveLocationWrappers = new WSArchiveLocationWrapper[]{};
        int i = 0;
        while (i < moduleArchives.length) {
            WSArchiveLocationWrapper[] currentWSArchiveLocationWrappers = this.loadWSArchiveLocationWrappers(applicationName, moduleArchives[i]);
            WSArchiveLocationWrapper[] newWSArchiveLocationWrappers = new WSArchiveLocationWrapper[wsArchiveLocationWrappers.length + currentWSArchiveLocationWrappers.length];
            System.arraycopy(wsArchiveLocationWrappers, 0, newWSArchiveLocationWrappers, 0, wsArchiveLocationWrappers.length);
            System.arraycopy(currentWSArchiveLocationWrappers, 0, newWSArchiveLocationWrappers, wsArchiveLocationWrappers.length, currentWSArchiveLocationWrappers.length);
            wsArchiveLocationWrappers = newWSArchiveLocationWrappers;
            ++i;
        }
        return wsArchiveLocationWrappers;
    }

    /*
     * Loose catch block
     */
    public WSArchiveLocationWrapper[] loadWSArchiveLocationWrappers(String applicationName, File moduleArchive) throws WSDeploymentException {
        WSArchiveLocationWrapper[] wsArchiveLocationWrappers;
        block12: {
            String excMsg = "Error occured, trying to load web services location information for module " + moduleArchive.getAbsolutePath() + ". ";
            try {
                if (this.containsWSDeploymentDescriptor(moduleArchive) == null) {
                    return new WSArchiveLocationWrapper[0];
                }
            }
            catch (Exception e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                Object[] args = new String[]{excMsg};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            wsArchiveLocationWrappers = new WSArchiveLocationWrapper[]{};
            WSArchiveFilesLocationHandler wsArchiveFilesLocationHandler = null;
            wsArchiveFilesLocationHandler = new WSArchiveFilesLocationHandler(moduleArchive);
            wsArchiveLocationWrappers = this.loadWSArchiveLocationWrappers(applicationName, wsArchiveFilesLocationHandler);
            Object var10_10 = null;
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = excMsg + "Unable to close input stream for module. ";
            try {
                if (wsArchiveFilesLocationHandler != null) {
                    wsArchiveFilesLocationHandler.close();
                }
                break block12;
            }
            catch (IOException ioExc) {
                wsDeployLocation.catching(msg, (Throwable)ioExc);
            }
            break block12;
            {
                catch (IOException e) {
                    Location wsDeplLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                    wsDeplLocation.catching((Throwable)e);
                    Object[] args = new String[]{excMsg};
                    throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                msg = excMsg + "Unable to close input stream for module. ";
                try {
                    if (wsArchiveFilesLocationHandler != null) {
                        wsArchiveFilesLocationHandler.close();
                    }
                }
                catch (IOException ioExc) {
                    wsDeployLocation.catching(msg, (Throwable)ioExc);
                }
                throw throwable;
            }
        }
        return wsArchiveLocationWrappers;
    }

    public WSArchiveLocationWrapper[] loadWSArchiveLocationWrappers(String applicationName, WSArchiveFilesLocationHandler wsArchiveFilesLocationHandler) throws WSDeploymentException {
        String excMsg = "Error occured, trying to load web service archive location wrapper, from descriptors: " + wsArchiveFilesLocationHandler.getWSDeploymentDescriptorLocationMsg() + ". ";
        InputStream wsDeploymentDescriptorInputStream = null;
        WSDeploymentDescriptor wsDeploymentDescriptor = null;
        try {
            wsDeploymentDescriptorInputStream = wsArchiveFilesLocationHandler.getWSDeploymentDescriptorInputStream();
            wsDeploymentDescriptor = WSDeploymentParser.loadWSDeploymentDescriptor(wsDeploymentDescriptorInputStream);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        String version = wsDeploymentDescriptor.getVersion().trim();
        return this.loadWSArchiveLocationWrappers(applicationName, version, wsDeploymentDescriptor.getWebservice(), wsArchiveFilesLocationHandler);
    }

    private WSArchiveLocationWrapper[] loadWSArchiveLocationWrappers(String applicationName, String version, WSDescriptor[] wsDescriptors, WSArchiveFilesLocationHandler wsArchiveFilesLocationHandler) {
        if (wsDescriptors == null) {
            return new WSArchiveLocationWrapper[0];
        }
        WSArchiveLocationWrapper[] wsArchiveLocationWrappers = new WSArchiveLocationWrapper[wsDescriptors.length];
        int i = 0;
        while (i < wsDescriptors.length) {
            wsArchiveLocationWrappers[i] = this.loadWSArchiveLocationWrapper(applicationName, version, wsDescriptors[i], wsArchiveFilesLocationHandler);
            ++i;
        }
        return wsArchiveLocationWrappers;
    }

    private WSArchiveLocationWrapper loadWSArchiveLocationWrapper(String applicationName, String version, WSDescriptor wsDescriptor, WSArchiveFilesLocationHandler wsArchiveFilesLocationHandler) {
        WSArchiveLocationWrapper wsArchiveLocationWrapper = new WSArchiveLocationWrapper();
        this.loadWSArchiveLocationWrapper(applicationName, version, wsDescriptor, wsArchiveFilesLocationHandler, wsArchiveLocationWrapper);
        return wsArchiveLocationWrapper;
    }

    private void loadWSArchiveLocationWrapper(String applicationName, String version, WSDescriptor wsDescriptor, WSArchiveFilesLocationHandler wsArchiveFilesLocationHandler, WSArchiveLocationWrapper wsArchiveLocationWrapper) {
        this.loadWSLocationWrapper(applicationName, wsDescriptor, wsArchiveLocationWrapper, wsArchiveFilesLocationHandler);
        wsArchiveLocationWrapper.setVersion(version);
        wsArchiveLocationWrapper.setWsDescriptor(wsDescriptor);
    }

    public ExtArchiveLocationWrapper loadExtArchiveLocationWrapper(WSArchiveLocationWrapper wsArchiveLocationWrapper, WSDescriptor wsDescriptor, WSArchiveFilesLocationHandler wsArchiveFilesLocationHandler) throws WSDeploymentException {
        String excMsg = "Error occured, trying to load extended information for web service " + wsArchiveLocationWrapper.getWebServiceName() + ", application " + wsArchiveLocationWrapper.getApplicationName() + ". ";
        ExtArchiveLocationWrapper extArchiveLocationWrapper = new ExtArchiveLocationWrapper();
        wsArchiveLocationWrapper.clone(extArchiveLocationWrapper);
        if (wsDescriptor.hasOutsideInDescriptor()) {
            extArchiveLocationWrapper.setOutsideInMode(true);
        }
        try {
            extArchiveLocationWrapper.setWsDescriptorsLocationTable(this.loadWSDescriptorsTable(wsDescriptor, extArchiveLocationWrapper.getWsArchiveFilesLocationHandler()));
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        extArchiveLocationWrapper.setSeiDescriptorsTable(this.loadSeiDescriptorsTable(wsDescriptor.getWsConfiguration()));
        return extArchiveLocationWrapper;
    }

    public WSFileLocationWrapper loadWSFileLocationWrapper(String applicationName, WSDirsHandler wsDirsHandler) throws WSDeploymentException {
        String excMsg = "Error occured, trying to load web service file location wrapper, from descriptors: " + wsDirsHandler.getWSDeploymentDescriptorPath() + " and " + wsDirsHandler.getWSRuntimeDescriptorPath();
        InputStream wsDeploymentDescriptorInputStream = null;
        WSDeploymentDescriptor wsDeploymentDescriptor = null;
        try {
            wsDeploymentDescriptorInputStream = wsDirsHandler.getWSDeploymentDescriptorInputStream();
            wsDeploymentDescriptor = WSDeploymentParser.loadWSDeploymentDescriptor(wsDeploymentDescriptorInputStream);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        String wsRuntimeDescriptorPath = null;
        WSRuntimeDescriptor wsRuntimeDescriptor = null;
        try {
            wsRuntimeDescriptorPath = wsDirsHandler.getWSRuntimeDescriptorPath();
            wsRuntimeDescriptor = WSRuntimeParser.loadWSRuntimeDescriptor(wsRuntimeDescriptorPath);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return this.loadWSFileLocationWrapper(applicationName, wsDeploymentDescriptor.getWebservice()[0], wsRuntimeDescriptor, wsDirsHandler);
    }

    public ExtFileLocationWrapper loadExtFileLocationWrapper(WSFileLocationWrapper wsFileLocationWrapper, WSDirsHandler wsDirsHandler) throws WSDeploymentException {
        String excMsg = "Error occured, trying to load web service file location wrapper, from descriptors: " + wsDirsHandler.getWSDeploymentDescriptorPath() + " and " + wsDirsHandler.getWSRuntimeDescriptorPath();
        InputStream wsDeploymentDescriptorInputStream = null;
        WSDeploymentDescriptor wsDeploymentDescriptor = null;
        try {
            wsDeploymentDescriptorInputStream = wsDirsHandler.getWSDeploymentDescriptorInputStream();
            wsDeploymentDescriptor = WSDeploymentParser.loadWSDeploymentDescriptor(wsDeploymentDescriptorInputStream);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return this.loadExtFileLocationWrapper(wsFileLocationWrapper, wsDeploymentDescriptor.getWebservice()[0], wsDirsHandler);
    }

    private WSFileLocationWrapper loadWSFileLocationWrapper(String applicationName, WSDescriptor wsDescriptor, WSRuntimeDescriptor wsRuntimeDescriptor, WSDirsHandler wsDirsHandler) {
        return this.loadWSFileLocationWrapper(applicationName, wsRuntimeDescriptor.getJarName().trim(), wsDescriptor, wsDirsHandler);
    }

    private WSFileLocationWrapper loadWSFileLocationWrapper(String applicationName, String moduleName, WSDescriptor wsDescriptor, WSDirsHandler wsDirsHandler) {
        WSFileLocationWrapper wsFileLocationWrapper = new WSFileLocationWrapper();
        this.loadWSFileLocationWrapper(applicationName, moduleName, wsDescriptor, wsDirsHandler, wsFileLocationWrapper);
        return wsFileLocationWrapper;
    }

    private void loadWSFileLocationWrapper(String applicationName, String moduleName, WSDescriptor wsDescriptor, WSDirsHandler wsDirsHandler, WSFileLocationWrapper wsFileLocationWrapper) {
        this.loadWSLocationWrapper(applicationName, wsDescriptor, wsFileLocationWrapper, wsDirsHandler);
        wsFileLocationWrapper.setModuleName(moduleName);
    }

    public ExtFileLocationWrapper loadExtFileLocationWrapper(WSFileLocationWrapper wsFileLocationWrapper, WSDescriptor wsDescriptor, WSDirsHandler wsDirsHandler) throws WSDeploymentException {
        String excMsg = "Error occured, trying to load extended information for web service " + wsFileLocationWrapper.getWebServiceName() + ", application " + wsFileLocationWrapper.getApplicationName() + ". ";
        ExtFileLocationWrapper extFileLocationWrapper = new ExtFileLocationWrapper();
        wsFileLocationWrapper.clone(extFileLocationWrapper);
        if (wsDescriptor.hasOutsideInDescriptor()) {
            extFileLocationWrapper.setOutsideInMode(true);
        }
        try {
            extFileLocationWrapper.setWsDescriptorsLocationTable(this.loadWSDescriptorsTable(wsDescriptor, extFileLocationWrapper.getWsDirsHandler()));
        }
        catch (WSDeploymentException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        extFileLocationWrapper.setSeiDescriptorsTable(this.loadSeiDescriptorsTable(wsDescriptor.getWsConfiguration()));
        return extFileLocationWrapper;
    }

    private void loadWSLocationWrapper(String applicationName, WSDescriptor wsDescriptor, WSLocationWrapper wsLocationWrapper, WSFilesLocationHandler wsFilesLocationHandler) {
        String wsName = wsDescriptor.getWebserviceInternalName().trim();
        wsLocationWrapper.setApplicationName(applicationName);
        wsLocationWrapper.setWebServiceName(wsName);
        wsLocationWrapper.setWsConfigurationNames(this.loadWSConfigurationNames(wsDescriptor.getWsConfiguration()));
        wsLocationWrapper.setSeiTrAddressTable(this.loadSeiTrAddressesTable(wsDescriptor.getWsConfiguration()));
        wsLocationWrapper.setWsFilesLocationHandler(wsFilesLocationHandler);
    }

    private String[] loadWSConfigurationNames(WSConfigurationDescriptor[] wsConfigurationDescriptors) {
        if (wsConfigurationDescriptors == null) {
            return new String[0];
        }
        String[] wsConfigurationNames = new String[wsConfigurationDescriptors.length];
        int i = 0;
        while (i < wsConfigurationDescriptors.length) {
            wsConfigurationNames[i] = wsConfigurationDescriptors[i].getConfigurationName().trim();
            ++i;
        }
        return wsConfigurationNames;
    }

    private Hashtable loadSeiTrAddressesTable(WSConfigurationDescriptor[] wsConfigurationDescriptors) {
        if (wsConfigurationDescriptors == null) {
            return new Hashtable();
        }
        Hashtable<String, String> seiTrAddressesTable = new Hashtable<String, String>();
        int i = 0;
        while (i < wsConfigurationDescriptors.length) {
            WSConfigurationDescriptor wsConfigurationDescriptor = wsConfigurationDescriptors[i];
            seiTrAddressesTable.put(wsConfigurationDescriptor.getConfigurationName().trim(), wsConfigurationDescriptor.getTransportAddress().trim());
            ++i;
        }
        return seiTrAddressesTable;
    }

    private WSDescriptorsLocationTable loadWSDescriptorsTable(WSDescriptor wsDescriptor, WSFilesLocationHandler wsFilesLocationHandler) throws WSDeploymentException {
        WSDescriptorsLocationTable wsDescriptorsLocationTable = new WSDescriptorsLocationTable();
        if (wsDescriptor.hasOutsideInDescriptor()) {
            OutsideInDescriptor outsideInDescriptor = wsDescriptor.getOutsideInDescriptor();
            String wsdlRelPath = IOUtil.convertPackageToDirPath(outsideInDescriptor.getWsdlRef().getPackage().trim(), outsideInDescriptor.getWsdlRef().getName().trim());
            String javaToQNameMappingRelPath = IOUtil.convertPackageToDirPath(outsideInDescriptor.getJavaQnameMappingRef().getPackage().trim(), outsideInDescriptor.getJavaQnameMappingRef().getName().trim());
            wsDescriptorsLocationTable.setDescriptor(WSDescriptorsLocationTable.WSDL, wsdlRelPath);
            wsDescriptorsLocationTable.setDescriptor(WSDescriptorsLocationTable.JAVA_TO_QNAME_MAPPING, javaToQNameMappingRelPath);
        }
        this.loadExtendedLocationInfo(wsDescriptorsLocationTable, wsDescriptor.getWsConfiguration(), wsFilesLocationHandler);
        return wsDescriptorsLocationTable;
    }

    private void loadExtendedLocationInfo(WSDescriptorsLocationTable wsDescriptorsLocationTable, WSConfigurationDescriptor[] wsConfigurationDescriptors, WSFilesLocationHandler wsFilesLocationHandler) throws WSDeploymentException {
        if (wsConfigurationDescriptors == null) {
            return;
        }
        int i = 0;
        while (i < wsConfigurationDescriptors.length) {
            this.loadExtendedLocationInfo(wsDescriptorsLocationTable, wsConfigurationDescriptors[i], wsFilesLocationHandler);
            ++i;
        }
    }

    private void loadExtendedLocationInfo(WSDescriptorsLocationTable wsDescriptorsLocationTable, WSConfigurationDescriptor wsConfigurationDescriptor, WSFilesLocationHandler wsFilesLocationHandler) throws WSDeploymentException {
        String excMsg = "Error occured, trying to load extended information (descriptors locations) from " + ((Object)((Object)wsConfigurationDescriptor)).getClass().getName() + ", location " + wsFilesLocationHandler.getLocationMsg() + ". ";
        NameDescriptor wsdNameDescriptor = wsConfigurationDescriptor.getWebserviceDefinitionRef();
        String wsdPackage = wsdNameDescriptor.getPackage().trim();
        String wsdName = wsdNameDescriptor.getName().trim();
        String wsdRelPath = IOUtil.convertPackageToDirPath(wsdPackage, wsdName);
        if (!wsDescriptorsLocationTable.containsDesctiptor(WSDescriptorsLocationTable.WSD)) {
            wsDescriptorsLocationTable.setDescriptor(WSDescriptorsLocationTable.WSD, wsdRelPath);
        }
        try {
            String[] docRelPathTemplates;
            String docRelPath;
            if (!wsDescriptorsLocationTable.containsDesctiptor(WSDescriptorsLocationTable.DOC) && (docRelPath = wsFilesLocationHandler.findDocRelPath(docRelPathTemplates = this.constructRelPathTemplates(wsdPackage.replace('.', '/'), wsdName, WSBaseConstants.WS_DOCUMENTATION_EXTENSIONS))) != null) {
                wsDescriptorsLocationTable.setDescriptor(WSDescriptorsLocationTable.DOC, docRelPath);
            }
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
    }

    private Hashtable loadSeiDescriptorsTable(WSConfigurationDescriptor[] wsConfigurationDescriptors) {
        if (wsConfigurationDescriptors == null) {
            return new Hashtable();
        }
        Hashtable<String, WSDescriptorsLocationTable> seiDescriptorsTable = new Hashtable<String, WSDescriptorsLocationTable>();
        int i = 0;
        while (i < wsConfigurationDescriptors.length) {
            WSConfigurationDescriptor wsConfigurationDescriptor = wsConfigurationDescriptors[i];
            WSDescriptorsLocationTable singleSEIDescriptorsLocationTable = this.loadSingleSeiDesctiptorsTable(wsConfigurationDescriptor);
            seiDescriptorsTable.put(wsConfigurationDescriptor.getConfigurationName().trim(), singleSEIDescriptorsLocationTable);
            ++i;
        }
        return seiDescriptorsTable;
    }

    private WSDescriptorsLocationTable loadSingleSeiDesctiptorsTable(WSConfigurationDescriptor wsConfigurationDescriptor) {
        WSDescriptorsLocationTable wsDescriptorsLocationTable = new WSDescriptorsLocationTable();
        NameDescriptor viNameDescriptor = wsConfigurationDescriptor.getServiceEndpointViRef();
        wsDescriptorsLocationTable.setDescriptor(WSDescriptorsLocationTable.VI, IOUtil.convertPackageToDirPath(viNameDescriptor.getPackage().trim(), viNameDescriptor.getName().trim()));
        return wsDescriptorsLocationTable;
    }

    private WSDeploymentInfo[] parseWSDeploymentDescriptor(String applicationName, WSArchiveFilesLocationHandler wsArchiveFilesLocationHandler, Vector warnings) throws WSDeploymentException {
        String excMsg = "Error occured, trying to parse " + (class$com$sap$engine$services$webservices$server$deploy$descriptors$sapwebservices$WSDeploymentDescriptor == null ? (class$com$sap$engine$services$webservices$server$deploy$descriptors$sapwebservices$WSDeploymentDescriptor = WSDefinitionFactory.class$("com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.WSDeploymentDescriptor")) : class$com$sap$engine$services$webservices$server$deploy$descriptors$sapwebservices$WSDeploymentDescriptor).getName() + " descriptor, source " + wsArchiveFilesLocationHandler.getWSDeploymentDescriptorLocationMsg() + ". ";
        InputStream wsDeploymentDescriptorInputStream = null;
        WSDeploymentDescriptor wsDeploymentDescriptor = null;
        try {
            if (!wsArchiveFilesLocationHandler.hasWSDeploymentDesctiptor()) {
                return new WSDeploymentInfo[0];
            }
            wsDeploymentDescriptorInputStream = wsArchiveFilesLocationHandler.getWSDeploymentDescriptorInputStream();
            wsDeploymentDescriptor = WSDeploymentParser.loadWSDeploymentDescriptor(wsDeploymentDescriptorInputStream);
        }
        catch (Exception e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        String version = wsDeploymentDescriptor.getVersion().trim();
        WSDescriptor[] wsDescriptors = wsDeploymentDescriptor.getWebservice();
        Vector<WSDeploymentInfo> wsDeploymentInfoes = new Vector<WSDeploymentInfo>();
        int i = 0;
        while (i < wsDescriptors.length) {
            try {
                WSDeploymentInfo wsDeploymentInfo = new WSDeploymentInfo();
                wsArchiveFilesLocationHandler.setWsDeploymentInfo(wsDeploymentInfo);
                this.parseWSDescriptor(applicationName, version, wsDescriptors[i], wsArchiveFilesLocationHandler, wsDeploymentInfo);
                this.setAdditionalWSDeploymentSettings(wsArchiveFilesLocationHandler.getModuleArchive().getName(), wsDeploymentInfo);
                wsDeploymentInfoes.add(wsDeploymentInfo);
            }
            catch (WSDeploymentException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching("Warning! ", (Throwable)e);
                String msg = excMsg + "Unable to parse " + (class$com$sap$engine$services$webservices$server$deploy$descriptors$sapwebservices$WSDescriptor == null ? WSDefinitionFactory.class$("com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.WSDescriptor") : class$com$sap$engine$services$webservices$server$deploy$descriptors$sapwebservices$WSDescriptor).getName() + " descriptor, numer " + i + ". ";
                warnings.add(msg);
            }
            ++i;
        }
        Object[] wsDeploymentInfoesArr = new WSDeploymentInfo[wsDeploymentInfoes.size()];
        wsDeploymentInfoes.copyInto(wsDeploymentInfoesArr);
        return wsDeploymentInfoesArr;
    }

    private void setAdditionalWSDeploymentSettings(String moduleArchiveName, WSDeploymentInfo wsDeploymentInfo) {
        wsDeploymentInfo.getWsRuntimeDefinition().getWSIdentifier().setJarName(moduleArchiveName);
    }

    private WSDeploymentInfo parseWSDescriptor(String applicationName, String version, WSDescriptor wsDescriptor, WSFilesLocationHandler wsFilesLocationHandler, WSDeploymentInfo wsDeploymentInfo) throws WSDeploymentException {
        String serviceName = wsDescriptor.getWebserviceInternalName().trim();
        String excMsg = "Error occured, parsing " + (class$com$sap$engine$services$webservices$server$deploy$descriptors$sapwebservices$WSDescriptor == null ? (class$com$sap$engine$services$webservices$server$deploy$descriptors$sapwebservices$WSDescriptor = WSDefinitionFactory.class$("com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.WSDescriptor")) : class$com$sap$engine$services$webservices$server$deploy$descriptors$sapwebservices$WSDescriptor).getName() + " descriptor, application " + applicationName + ", web service " + serviceName + ", location message: " + wsFilesLocationHandler.getLocationMsg() + ". ";
        try {
            WSConfigurationDescriptor[] wsConfigurations;
            int endpointsSize;
            WSRuntimeDefinition wsDefinition = new WSRuntimeDefinition();
            wsDeploymentInfo.setWsRuntimeDefinition(wsDefinition);
            wsDeploymentInfo.setWsDeploymentDescriptor(this.getWSDeploymentDescriptor(version, wsDescriptor));
            wsDefinition.setWSIdentifier(new WSIdentifier(applicationName, null, wsDescriptor.getWebserviceInternalName().trim()));
            if (wsDescriptor.hasOutsideInDescriptor()) {
                wsDefinition.setOutsideInDefinition(this.parseOutsideInDescriptor(wsDescriptor.getOutsideInDescriptor(), wsFilesLocationHandler));
            }
            wsDefinition.setStandardNS(wsDescriptor.getStandardNamespaceURI().trim());
            wsDefinition.setWsQName(this.parseQNameDescriptor(wsDescriptor.getWebserviceName()));
            if (wsDescriptor.hasUddiKey()) {
                wsDefinition.setUddiKey(wsDescriptor.getUddiKey());
            }
            if ((endpointsSize = (wsConfigurations = wsDescriptor.getWsConfiguration()).length) == 0) {
                Object[] args = new Object[]{"webservice definition error in the deployment descriptor: there are no ws configurations defined", applicationName, "not available", "ws-deployment-descriptor.xml", "web service: " + wsDefinition.getWsQName()};
                throw new WSGenerationException("webservices_5001", args);
            }
            ServiceEndpointDefinition[] serviceEndpoints = new ServiceEndpointDefinition[endpointsSize];
            wsDefinition.setServiceEndpointDefinitions(serviceEndpoints);
            int j = 0;
            while (j < endpointsSize) {
                Object[] args;
                ServiceEndpointDefinition endpointDefinition = new ServiceEndpointDefinition();
                endpointDefinition.setOwner(wsDefinition);
                serviceEndpoints[j] = endpointDefinition;
                WSConfigurationDescriptor configurationDescriptor = wsConfigurations[j];
                endpointDefinition.setConfigurationName(configurationDescriptor.getConfigurationName().trim());
                OperationConfigurationDescriptor[] operationDescriptors = configurationDescriptor.getOperationConfiguration();
                this.setImplLink(applicationName, configurationDescriptor, endpointDefinition);
                endpointDefinition.setServiceEndpointQualifiedName(this.parseQNameDescriptor(configurationDescriptor.getServiceEndpointName()));
                if (!endpointDefinition.getServiceEndpointQualifiedName().getNamespaceURI().equals(wsDefinition.getStandardNS())) {
                    args = new Object[]{" the namespaceURI of the service-endpoint does not match to the standard namespaceURI in the deploment descriptor", "not available", "ws-deployment-descriptor.xml", "webservice: " + wsDefinition.getWsQName() + ", ws configuration: " + configurationDescriptor.getConfigurationName().trim()};
                    throw new WSGenerationException("webservices_5001", args);
                }
                endpointDefinition.setPortTypeName(this.parseQNameDescriptor(configurationDescriptor.getWsdlPorttypeName()));
                if (!endpointDefinition.getPortTypeName().getNamespaceURI().equals(wsDefinition.getStandardNS())) {
                    args = new Object[]{" the namespaceURI of the porttype does not match to the standard namespaceURI in the deploment descriptor", applicationName, "not available", "ws-deployment-descriptor.xml", "webservice: " + wsDefinition.getWsQName() + ", ws configuration: " + configurationDescriptor.getConfigurationName().trim()};
                    throw new WSGenerationException("webservices_5001", args);
                }
                if (wsDefinition.getWsdRelPath() == null) {
                    this.parseWSDAndDocumentation(configurationDescriptor.getWebserviceDefinitionRef(), wsDefinition, wsFilesLocationHandler);
                }
                this.parseVI(applicationName, IOUtil.convertPackageToDirPath(configurationDescriptor.getServiceEndpointViRef().getPackage().trim(), configurationDescriptor.getServiceEndpointViRef().getName().trim()), wsFilesLocationHandler, endpointDefinition, endpointDefinition.getOwner().getWsdName());
                TrBindingDescriptor trBindingDescriptor = configurationDescriptor.getTransportBinding();
                endpointDefinition.setTransportBinding(trBindingDescriptor.getName().trim());
                com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.QNameDescriptor bindingQNameDescriptor = trBindingDescriptor.getWsdlBindingName();
                QName bindingQName = new QName(bindingQNameDescriptor.getNamespaceURI().trim(), bindingQNameDescriptor.getLocalName().trim());
                if (!bindingQName.getNamespaceURI().equals(wsDefinition.getStandardNS())) {
                    Object[] args2 = new Object[]{" the namespaceURI of the transport binding does not match to the standard namespaceURI in the deploment descriptor", applicationName, "not available", "ws-deployment-descriptor.xml", "webservice: " + wsDefinition.getWsQName() + ", ws configuration: " + configurationDescriptor.getConfigurationName().trim()};
                    throw new WSGenerationException("webservices_5001", args2);
                }
                endpointDefinition.setWsdlBindingName(bindingQName);
                endpointDefinition.setTrBindingConfig(new ConfigImpl(this.getExtensionProperties(trBindingDescriptor.getProperty())));
                if (configurationDescriptor.hasTargetServerUrl()) {
                    endpointDefinition.setTargetServerURL(configurationDescriptor.getTargetServerUrl().trim());
                }
                endpointDefinition.setServiceEndpointId(configurationDescriptor.getTransportAddress().trim());
                if (configurationDescriptor.hasGlobalFeatures()) {
                    FeatureDescriptor[] glFeatureDescriptor = configurationDescriptor.getGlobalFeatures();
                    endpointDefinition.setFeaturesChain(this.getFeaturesChain(glFeatureDescriptor));
                }
                HashMapObjectObject operationConfigsAsHash = this.getOperationConfigsAsHash(configurationDescriptor.getOperationConfiguration(), false);
                HashMapObjectObject uniqueOperationConfigsAsHash = this.getOperationConfigsAsHash(configurationDescriptor.getOperationConfiguration(), true);
                OperationDefinition[] operations = endpointDefinition.getOperations();
                int operationsSize = operations.length;
                int k = 0;
                while (k < operationsSize) {
                    OperationDefinitionImpl operation = (OperationDefinitionImpl)operations[k];
                    OperationConfigurationDescriptor operationDescriptor = (OperationConfigurationDescriptor)((Object)uniqueOperationConfigsAsHash.get((Object)operation.getUniqueOperationName()));
                    if (operationDescriptor == null) {
                        operationDescriptor = (OperationConfigurationDescriptor)((Object)operationConfigsAsHash.get((Object)operation.getOperationName()));
                    }
                    if (operationDescriptor != null) {
                        if (operationDescriptor.hasDocumentation()) {
                            operation.setDescription(operationDescriptor.getDocumentation().trim());
                        }
                        operation.setFeaturesChain(this.getFeaturesChain(operationDescriptor.getFeature()));
                        TrBindingConfigDescriptor trBindingConfiguration = operationDescriptor.getTransportBindingConfiguration();
                        if (trBindingConfiguration.hasGeneralConfiguration()) {
                            PropertyDescriptor[] generalConfiguration = trBindingConfiguration.getGeneralConfiguration();
                            Config generalConfig = operation.getGeneralConfiguration();
                            Hashtable newProperties = this.getExtensionProperties(generalConfiguration);
                            ((ConfigImpl)generalConfig).addProperties(newProperties);
                        }
                        PropertyDescriptor[] inputParameterDescriptor = trBindingConfiguration.getInput();
                        ((ConfigImpl)operation.getInputConfiguration()).addProperties(this.getExtensionProperties(inputParameterDescriptor));
                        PropertyDescriptor[] outputParameterDescriptor = trBindingConfiguration.getOutput();
                        ((ConfigImpl)operation.getOutputConfiguration()).addProperties(this.getExtensionProperties(outputParameterDescriptor));
                        Fault[] faults = operation.getFaults();
                        HashMapObjectObject faultConfigsAsHash = this.getFaultConfigsAsHash(trBindingConfiguration.getFault());
                        int faultsSize = faults.length;
                        int l = 0;
                        while (l < faultsSize) {
                            FaultImpl fault = (FaultImpl)faults[l];
                            FaultConfigDescriptor faultConfigDescriptor = (FaultConfigDescriptor)((Object)faultConfigsAsHash.get((Object)fault.getFaultName()));
                            if (faultConfigDescriptor != null) {
                                ((ConfigImpl)fault.getFaultConfiguration()).addProperties(this.getExtensionProperties(faultConfigDescriptor.getProperty()));
                            }
                            ++l;
                        }
                    }
                    ++k;
                }
                if (configurationDescriptor.hasOutsideInConfiguration()) {
                    endpointDefinition.setOutsideInConfiguration(configurationDescriptor.getOutsideInConfiguration());
                }
                ++j;
            }
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        return wsDeploymentInfo;
    }

    public void parseVI(String applicationName, String viRelPath, WSFilesLocationHandler wsFilesLocationHandler, ServiceEndpointDefinition endpointDefinition, String wsdName) throws WSDeploymentException {
        String excMsg = "Error occured, trying to parse source " + wsFilesLocationHandler.getViLocationMsg(viRelPath);
        InputStream viInputStream = null;
        try {
            try {
                viInputStream = wsFilesLocationHandler.getViInputStream(viRelPath);
                endpointDefinition.setViRelPath(viRelPath);
                this.parseVInterface(applicationName, endpointDefinition, VInterfaceParser.getVInterface(viInputStream), endpointDefinition.getOwner().getWsdName());
            }
            catch (Exception e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                Object[] args = new String[]{excMsg};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            Object var12_8 = null;
        }
        catch (Throwable throwable) {
            Object var12_9 = null;
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String msg = "Warning! " + excMsg + "Unable to close input strema for source. ";
            IOUtil.closeInputStreams(new InputStream[]{viInputStream}, new String[]{msg}, wsDeployLocation);
            throw throwable;
        }
        Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
        String msg = "Warning! " + excMsg + "Unable to close input strema for source. ";
        IOUtil.closeInputStreams(new InputStream[]{viInputStream}, new String[]{msg}, wsDeployLocation);
    }

    public void parseVInterface(String applicationName, ServiceEndpointDefinition endpointDefinition, VirtualInterfaceState vInterface, String wsdName) throws WSGenerationException {
        try {
            endpointDefinition.setvInterfaceName(vInterface.getName().trim());
            VirtualInterfaceEndpointReference viReference = vInterface.getVirtualInterfaceEndpointReference();
            if (viReference.hasEjbEndpointReference()) {
                endpointDefinition.setServiceEndpointInterface(viReference.getEjbEndpointReference().getRemoteInterfaceName());
            }
            FunctionState[] viFunctions = vInterface.getVirtualInterfaceFunctions();
            int operationsSize = viFunctions.length;
            ArrayList<OperationDefinitionImpl> operations = new ArrayList<OperationDefinitionImpl>();
            int i = 0;
            while (i < operationsSize) {
                FunctionState viFunction = viFunctions[i];
                if (viFunction.getIsExposed()) {
                    OperationDefinitionImpl operation = new OperationDefinitionImpl();
                    operations.add(operation);
                    String isElFormDfQualified = "true";
                    if (vInterface.hasVirtualInterfaceSoapExtensionVI() && !vInterface.getVirtualInterfaceSoapExtensionVI().getSoapExtensionVI().getUseNamespaces()) {
                        isElFormDfQualified = "false";
                    }
                    SoapExtensionFunctionState soapExtensionFunctionState = viFunction.getFunctionSoapExtensionFunction().getSoapExtensionFunction();
                    ConfigImpl generalConfig = new ConfigImpl();
                    generalConfig.setProperty("SoapRequestWrapper", soapExtensionFunctionState.getSOAPRequestName());
                    generalConfig.setProperty("SoapResponseWrapper", soapExtensionFunctionState.getSOAPResponseName());
                    generalConfig.setProperty("isQualified", isElFormDfQualified);
                    operation.setGeneralConfiguration(generalConfig);
                    ConfigImpl inputConf = new ConfigImpl();
                    inputConf.setProperty("namespace", soapExtensionFunctionState.getNamespace());
                    operation.setInputOperationConfiguration(inputConf);
                    ConfigImpl outputConf = new ConfigImpl();
                    outputConf.setProperty("namespace", soapExtensionFunctionState.getNamespace());
                    operation.setOutputOperationConfiguration(outputConf);
                    operation.setUniqueOperationName(viFunction.getName().trim());
                    operation.setOperationName(viFunction.getNameMappedTo().trim());
                    operation.setJavaOperationName(viFunction.getOriginalName().trim());
                    operation.setExposed(viFunction.getIsExposed());
                    ParameterState[] inputParams = !viFunction.hasFunctionIncomingParameters() ? new ParameterState[]{} : viFunction.getFunctionIncomingParameters();
                    String serviceName = endpointDefinition.getOwner() != null ? endpointDefinition.getOwner().getServiceName() : null;
                    operation.setInputParameters(this.getParameters(applicationName, inputParams, 0, serviceName, endpointDefinition.getServiceEndpointQualifiedName(), operation.getOperationName()));
                    ParameterState[] outputParams = !viFunction.hasFunctionOutgoingParameters() ? new ParameterState[]{} : viFunction.getFunctionOutgoingParameters();
                    operation.setOutputParameters(this.getParameters(applicationName, outputParams, 2, serviceName, endpointDefinition.getServiceEndpointQualifiedName(), operation.getOperationName()));
                    FaultState[] faultStates = !viFunction.hasFunctionFaults() ? new FaultState[]{} : viFunction.getFunctionFaults();
                    int faultsSize = faultStates.length;
                    ArrayList<FaultImpl> faults = new ArrayList<FaultImpl>();
                    int j = 0;
                    while (j < faultsSize) {
                        FaultState faultState = faultStates[j];
                        if (!faultState.getName().trim().equals((class$java$rmi$RemoteException == null ? WSDefinitionFactory.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).getName())) {
                            FaultImpl fault = new FaultImpl();
                            fault.setFaultName(faultState.getName().trim());
                            fault.setJavaClassName(faultState.getName().trim());
                            ConfigImpl cfg = new ConfigImpl();
                            cfg.setProperty("namespace", this.getDefaultFaultNS(wsdName, endpointDefinition.getvInterfaceName()));
                            fault.setFaultConfiguration(cfg);
                            faults.add(fault);
                        }
                        ++j;
                    }
                    operation.setFaults(faults.toArray(new Fault[faults.size()]));
                }
                ++i;
            }
            int exposedOpsSize = operations.size();
            OperationDefinition[] operationsArray = new OperationDefinition[exposedOpsSize];
            int i2 = 0;
            while (i2 < exposedOpsSize) {
                operationsArray[i2] = (OperationDefinition)operations.get(i2);
                ++i2;
            }
            endpointDefinition.setOperations(operationsArray);
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{e.getClass().getName() + " exception occured", applicationName, "not available", "ws-deployment-descriptor.xml", "not available"};
            throw new WSGenerationException("webservices_5001", args, e);
        }
    }

    private String getDefaultFaultNS(String wsdName, String viName) {
        return "urn:" + wsdName + "/" + viName;
    }

    private ParameterNode[] getParameters(String applicationName, ParameterState[] parameterStates, int parameterMode, String serviceName, QName endpointQName, String operationName) throws WSGenerationException {
        int paramsSize = parameterStates.length;
        ParameterNode[] parameters = new ParameterNode[paramsSize];
        int i = 0;
        while (i < paramsSize) {
            ParameterNodeImpl parameter = new ParameterNodeImpl();
            parameters[i] = parameter;
            ParameterState parameterState = parameterStates[i];
            parameter.setParameterMode(parameterMode);
            parameter.setParameterName(parameterState.getNameMappedTo().trim());
            parameter.setJavaParameterName(parameterState.getName().trim());
            ParameterMappedTypeReference mappedTypeReference = parameterState.getParameterMappedTypeReference();
            try {
                boolean isExposed = true;
                boolean isOptional = false;
                if (parameterState.hasIsExposed()) {
                    isExposed = parameterState.getIsExposed();
                }
                parameter.setExposed(isExposed);
                if (parameterState.hasIsOptional() && (isOptional = parameterState.getIsOptional())) {
                    if (parameterState.hasParameterDefaultValue()) {
                        parameter.setDefaultValue(parameterState.getParameterDefaultValue().getDefaultValue().getName().trim());
                    } else {
                        Object[] args = new Object[]{"Incorrect parameter settings. The parameter is optional, but does not have default value.", applicationName, "not available", "ws-deployment-descriptor.xml", "webservice: " + serviceName + ", service endpoint: " + endpointQName + ", operation: " + operationName, "parameter: " + parameter.getParameterName()};
                        throw new WSGenerationException("webservices_5001", args);
                    }
                }
                parameter.setOptional(isOptional);
                if (!isExposed && !isOptional) {
                    Object[] args = new Object[]{"Incorrect parameter settings. The parameter is not exposed. Must be optional" + (Object)((Object)mappedTypeReference), applicationName, "not available", "ws-deployment-descriptor.xml", "webservice: " + serviceName + ", service endpoint: " + endpointQName + ", operation: " + operationName + ", parameter: " + parameter.getParameterName()};
                    throw new WSGenerationException("webservices_5001", args);
                }
                if (mappedTypeReference.hasConvertedTypeReference()) {
                    parameter.setJavaClassName(mappedTypeReference.getConvertedTypeReference().getName().trim());
                    parameter.setOriginalClassName(mappedTypeReference.getConvertedTypeReference().getOriginalType().trim());
                } else if (mappedTypeReference.hasConvertedTableReference()) {
                    parameter.setJavaClassName(mappedTypeReference.getConvertedTableReference().getName().trim());
                    parameter.setOriginalClassName(mappedTypeReference.getConvertedTableReference().getName().trim());
                } else if (mappedTypeReference.hasComplexTypeReference()) {
                    parameter.setJavaClassName(mappedTypeReference.getComplexTypeReference().getName().trim());
                    parameter.setOriginalClassName(mappedTypeReference.getComplexTypeReference().getName().trim());
                } else {
                    Object[] args = new Object[]{"Incorrect type reference found." + (Object)((Object)mappedTypeReference), applicationName, "not available", "ws-deployment-descriptor.xml", "webservice: " + serviceName + ", service endpoint: " + endpointQName + ", operation: " + operationName};
                    throw new WSGenerationException("webservices_5001", args);
                }
                if (parameterState.hasParameterSoapExtensionParameter() && parameterState.getParameterSoapExtensionParameter().getSoapExtensionParameter().hasIsHeader() && parameterState.getParameterSoapExtensionParameter().getSoapExtensionParameter().getIsHeader()) {
                    parameter.setHeader(true);
                    if (parameterState.getParameterSoapExtensionParameter().getSoapExtensionParameter().hasNamespace()) {
                        parameter.setHeaderElementNamespace(parameterState.getParameterSoapExtensionParameter().getSoapExtensionParameter().getNamespace());
                    }
                }
            }
            catch (WSGenerationException e) {
                throw e;
            }
            catch (Exception e) {
                Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsLocation.catching((Throwable)e);
                Object[] args = new Object[]{"Error in extraxting parameter info from the deployment descriptor", applicationName, "not available", "ws-deployment-descriptor.xml", "not available"};
                throw new WSGenerationException("webservices_5001", args, e);
            }
            ++i;
        }
        return parameters;
    }

    private void setImplLink(String applicationName, WSConfigurationDescriptor configurationDescriptor, ServiceEndpointDefinition endpointDefinition) throws WSGenerationException {
        ImplLink implLink = null;
        if (configurationDescriptor.hasImplLink()) {
            com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.ImplLinkDescriptor implLinkDescriptor = configurationDescriptor.getImplLink();
            String implId = implLinkDescriptor.getImplementationId().trim();
            PropertyDescriptor[] propertyDescriptors = implLinkDescriptor.getProperties();
            Properties properties = this.getPropertiesAsHash(propertyDescriptors);
            implLink = new ImplLink();
            implLink.setImplId(implId);
            implLink.setProperties(properties);
        } else if (configurationDescriptor.hasEjbName()) {
            implLink = new ImplLink();
            implLink.setImplId("ejb-impllink");
            Properties properties = new Properties();
            properties.setProperty("ejb-name", configurationDescriptor.getEjbName().trim());
            implLink.setProperties(properties);
        }
        if (implLink == null) {
            Object[] args = new Object[]{"there is no implementation specified for the current configuration. You should specify 'impl-link' or 'ejb-name' tag", applicationName, "not available", "ws-deployment-descriptor.xml", "webservice: " + endpointDefinition.getOwner().getServiceName() + ", ws configuration: " + configurationDescriptor.getConfigurationName().trim()};
            throw new WSGenerationException("webservices_5001", args);
        }
        endpointDefinition.setImplLink(implLink);
    }

    private FeatureInfo[] getFeaturesChain(FeatureDescriptor[] featureDescriptors) throws Exception {
        int featuresSize = featureDescriptors.length;
        FeatureInfo[] featuresChain = new FeatureInfo[featuresSize];
        int i = 0;
        while (i < featuresSize) {
            FeatureInfo feature;
            featuresChain[i] = feature = new FeatureInfo();
            FeatureDescriptor featureDescriptor = featureDescriptors[i];
            feature.setName(featureDescriptor.getName().trim());
            feature.setProtocol(featureDescriptor.getProtocol().trim());
            feature.setConfiguration(new ConfigImpl(this.getExtensionProperties(featureDescriptor.getProperty())));
            ++i;
        }
        return featuresChain;
    }

    private Hashtable getExtensionProperties(PropertyDescriptor[] propertyDescriptors) throws Exception {
        int propertiesSize = propertyDescriptors.length;
        Hashtable<String, PropertyDescriptorInterfaceImpl> properties = new Hashtable<String, PropertyDescriptorInterfaceImpl>();
        int l = 0;
        while (l < propertiesSize) {
            PropertyDescriptor propertyDescriptor = propertyDescriptors[l];
            PropertyDescriptorInterfaceImpl propertyDescriptorInterface = new PropertyDescriptorInterfaceImpl();
            String propertyName = propertyDescriptor.getName().trim();
            properties.put(propertyName, propertyDescriptorInterface);
            propertyDescriptorInterface.setPropertyName(propertyName);
            propertyDescriptorInterface.setValue(propertyDescriptor.getValue());
            if (propertyDescriptor.getChoiceGroup1() != null) {
                if (propertyDescriptor.getChoiceGroup1().hasSimpleContent()) {
                    propertyDescriptorInterface.setSimpleContent(propertyDescriptor.getChoiceGroup1().getSimpleContent());
                }
                if (propertyDescriptor.getChoiceGroup1().hasProperty()) {
                    PropertyDescriptor[] inPropertyDescriptors = propertyDescriptor.getChoiceGroup1().getProperty();
                    propertyDescriptorInterface.setInternals(this.getExtensionProperties(inPropertyDescriptors));
                } else {
                    propertyDescriptorInterface.setInternals(new Hashtable());
                }
            }
            ++l;
        }
        return properties;
    }

    private HashMapObjectObject getOperationConfigsAsHash(OperationConfigurationDescriptor[] operations, boolean sortByUniqueName) {
        HashMapObjectObject operationsAsHash = new HashMapObjectObject();
        int operationsSize = operations.length;
        int i = 0;
        while (i < operationsSize) {
            OperationConfigurationDescriptor operation = operations[i];
            if (sortByUniqueName) {
                if (operation.hasUniqueViName()) {
                    operationsAsHash.put((Object)operation.getUniqueViName().trim(), (Object)operation);
                }
            } else if (operation.hasName()) {
                operationsAsHash.put((Object)operation.getName().trim(), (Object)operation);
            }
            ++i;
        }
        return operationsAsHash;
    }

    private HashMapObjectObject getFaultConfigsAsHash(FaultConfigDescriptor[] faultConfigDescriptors) {
        HashMapObjectObject faultsAsHash = new HashMapObjectObject();
        int faultsSize = faultConfigDescriptors.length;
        int i = 0;
        while (i < faultsSize) {
            FaultConfigDescriptor fault = faultConfigDescriptors[i];
            faultsAsHash.put((Object)fault.getName().trim(), (Object)fault);
            ++i;
        }
        return faultsAsHash;
    }

    public void parseRuntimeSpecific(String applicationName, WSRuntimeDefinition wsRuntimeDefinition, WSRuntimeDescriptor wsRuntimeDescriptor) throws WSGenerationException {
        try {
            wsRuntimeDefinition.setUddiKey(wsRuntimeDescriptor.getUddiKey());
            wsRuntimeDefinition.setUddiPublications(wsRuntimeDescriptor.getUddiPublications());
        }
        catch (Exception e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)e);
            Object[] args = new Object[]{"Unable to get UDDI information from the ws-runtime-descriptor", applicationName, "not available", "ws-runtime-descriptor.xml", "not available"};
            throw new WSGenerationException("webservices_5001", args, e);
        }
        ServiceEndpointDefinition endpointDefinition = null;
        try {
            wsRuntimeDefinition.getWSIdentifier().setJarName(wsRuntimeDescriptor.getJarName().trim());
            wsRuntimeDefinition.setWsdlSupportedStyles(wsRuntimeDescriptor.getWsdlStyles());
            HashMapObjectObject wsRuntimeConfigsAsHash = this.getRuntimeConfigsAsHash(wsRuntimeDescriptor.getWsRuntimeConfiguration());
            ServiceEndpointDefinition[] endpointDefinitions = wsRuntimeDefinition.getServiceEndpointDefinitions();
            int endpointsSize = endpointDefinitions.length;
            int i = 0;
            while (i < endpointsSize) {
                endpointDefinition = endpointDefinitions[i];
                WSRuntimeConfigurationDescriptor wsRuntimeConfigDescriptor = (WSRuntimeConfigurationDescriptor)((Object)wsRuntimeConfigsAsHash.get((Object)endpointDefinition.getServiceEndpointQualifiedName()));
                ImplLinkDescriptor implLinkDescriptor = wsRuntimeConfigDescriptor.getImplLink();
                if (implLinkDescriptor != null) {
                    this.setAdditionalImplLinkProperties(applicationName, endpointDefinition.getImplLink(), implLinkDescriptor);
                }
                HashMapObjectObject operationConfigsAsHash = this.getRuntimeOperationConfigsAsHash(wsRuntimeConfigDescriptor.getRuntimeOperationConfiguration());
                OperationDefinition[] operations = endpointDefinition.getOperations();
                int operationsSize = operations.length;
                int j = 0;
                while (j < operationsSize) {
                    OperationDefinitionImpl operation = (OperationDefinitionImpl)operations[j];
                    RuntimeOperationConfigDescriptor runtimeOperationConfig = (RuntimeOperationConfigDescriptor)((Object)operationConfigsAsHash.get((Object)operation.getOperationName()));
                    Key[] keys = this.getKeys(runtimeOperationConfig.getOperationMapping());
                    operation.setKeys(keys);
                    ++j;
                }
                ++i;
            }
        }
        catch (WSGenerationException e) {
            Location wsLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsLocation.catching((Throwable)((Object)e));
            Object[] args = new Object[]{"Setting runtime properties", applicationName, "not available", "ws-runtime-descriptor.xml", "webservice: " + wsRuntimeDefinition.getServiceName(), ", configuration: " + endpointDefinition.getConfigurationName()};
            throw new WSGenerationException("webservices_5001", args, (Throwable)((Object)e));
        }
    }

    public void setAdditionalImplLinkProperties(String applicationName, ImplLink implLink, ImplLinkDescriptor implLinkDescriptor) throws WSGenerationException {
        com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[] propertyDescriptors = implLinkDescriptor.getProperties();
        if (propertyDescriptors != null) {
            if (implLinkDescriptor.getImplementationId().equals(implLink.getImplId())) {
                Properties additionalProperties = this.getPropertiesAsHash(propertyDescriptors);
                Properties allProperties = new Properties(implLink.getProperties());
                ((Hashtable)allProperties).putAll(additionalProperties);
                implLink.setProperties(allProperties);
            } else {
                Object[] args = new Object[]{"Server error! The 'implementation-id' value does not match to the one, specified in the deployment descriptor", applicationName, "not available", "ws-deployment-descriptor.xml", "not available"};
                throw new WSGenerationException("webservices_5001", args);
            }
        }
    }

    public ImplLinkDescriptor getImplLinkDescriptor(ImplLink implLink) {
        ImplLinkDescriptor implLinkDescriptor = new ImplLinkDescriptor();
        String implId = implLink.getImplId();
        implLinkDescriptor.setImplementationId(implId);
        if (implId.equals(JavaImplConstants.JAVA_ID) || implId.equals("ejb-impllink")) {
            com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[] propertyDescriptors = new com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[1];
            implLinkDescriptor.setProperties(propertyDescriptors);
            propertyDescriptors[0] = new com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor();
            propertyDescriptors[0].setName("application-name");
            propertyDescriptors[0].setValue(implLink.getProperties().getProperty("application-name"));
            this.getAdditionalImplLinkProperties(implLink, implLinkDescriptor);
        }
        return implLinkDescriptor;
    }

    private void getAdditionalImplLinkProperties(ImplLink implLink, ImplLinkDescriptor implLinkDescriptor) {
        if (implLink.getImplId().equals("ejb-impllink")) {
            com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[] additionalPropertyDescriptors = null;
            additionalPropertyDescriptors = implLink.getProperties().getProperty("ejb-jndi-name-local") != null ? new com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[3] : new com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[2];
            additionalPropertyDescriptors[0] = new com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor();
            additionalPropertyDescriptors[0].setName("ejb-jndi-name");
            additionalPropertyDescriptors[0].setValue(implLink.getProperties().getProperty("ejb-jndi-name"));
            additionalPropertyDescriptors[1] = new com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor();
            additionalPropertyDescriptors[1].setName("ejb-session-type");
            additionalPropertyDescriptors[1].setValue(implLink.getProperties().getProperty("ejb-session-type"));
            if (implLink.getProperties().getProperty("ejb-jndi-name-local") != null) {
                additionalPropertyDescriptors[2] = new com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor();
                additionalPropertyDescriptors[2].setName("ejb-jndi-name-local");
                additionalPropertyDescriptors[2].setValue(implLink.getProperties().getProperty("ejb-jndi-name-local"));
            }
            com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[] properties = implLinkDescriptor.getProperties();
            com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[][] descriptors = new com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[][]{properties, additionalPropertyDescriptors};
            com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[] allPropertyDescriptors = this.getAllProperties(descriptors);
            implLinkDescriptor.setProperties(allPropertyDescriptors);
        }
    }

    private com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[] getAllProperties(com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[][] propertyDescriptors) {
        com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[] allPropertyDescriptors = new com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[]{};
        int size = propertyDescriptors.length;
        int i = 0;
        while (i < size) {
            com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[] currentDescriptors = propertyDescriptors[i];
            com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[] newDescriptors = new com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[allPropertyDescriptors.length + currentDescriptors.length];
            System.arraycopy(allPropertyDescriptors, 0, newDescriptors, 0, allPropertyDescriptors.length);
            System.arraycopy(currentDescriptors, 0, newDescriptors, allPropertyDescriptors.length, currentDescriptors.length);
            allPropertyDescriptors = newDescriptors;
            ++i;
        }
        return allPropertyDescriptors;
    }

    public HashMapObjectObject getRuntimeConfigsAsHash(WSRuntimeConfigurationDescriptor[] wsRuntimeConfigDescriptors) {
        HashMapObjectObject runtimeConfigsAsHash = new HashMapObjectObject();
        int runtimeConfigsSize = wsRuntimeConfigDescriptors.length;
        int i = 0;
        while (i < runtimeConfigsSize) {
            WSRuntimeConfigurationDescriptor wsRuntimeConfigDescriptor = wsRuntimeConfigDescriptors[i];
            QNameDescriptor endpointQNameDescriptor = wsRuntimeConfigDescriptor.getServiceEndpointName();
            QName endpointQName = new QName(endpointQNameDescriptor.getNamespaceURI().trim(), endpointQNameDescriptor.getLocalName().trim());
            runtimeConfigsAsHash.put((Object)endpointQName, (Object)wsRuntimeConfigDescriptor);
            ++i;
        }
        return runtimeConfigsAsHash;
    }

    public HashMapObjectObject getRuntimeOperationConfigsAsHash(RuntimeOperationConfigDescriptor[] runtimeOperationsDescriptors) {
        HashMapObjectObject runtimeOperationsAsHash = new HashMapObjectObject();
        int runtimeOperationsSize = runtimeOperationsDescriptors.length;
        int i = 0;
        while (i < runtimeOperationsSize) {
            RuntimeOperationConfigDescriptor runtimeOperationConfigDescriptor = runtimeOperationsDescriptors[i];
            runtimeOperationsAsHash.put((Object)runtimeOperationConfigDescriptor.getName().trim(), (Object)runtimeOperationConfigDescriptor);
            ++i;
        }
        return runtimeOperationsAsHash;
    }

    public Key[] getKeys(com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[] propertyDescriptors) {
        int propertiesSize = propertyDescriptors.length;
        Key[] keys = new Key[propertiesSize];
        int i = 0;
        while (i < propertiesSize) {
            Key key;
            com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            keys[i] = key = new Key(propertyDescriptor.getName().trim(), propertyDescriptor.getValue().trim());
            ++i;
        }
        return keys;
    }

    public WSRuntimeDescriptor getWSRuntimeDescriptor(WSRuntimeDefinition wsRuntimeDefinition) {
        WSRuntimeDescriptor wsRuntimeDescriptor = new WSRuntimeDescriptor();
        if (wsRuntimeDefinition.getUddiKey() != null) {
            wsRuntimeDescriptor.setUddiKey(wsRuntimeDefinition.getUddiKey());
        }
        wsRuntimeDescriptor.setUddiPublications(wsRuntimeDefinition.getUddiPublications());
        wsRuntimeDescriptor.setJarName(wsRuntimeDefinition.getWSIdentifier().getJarName());
        wsRuntimeDescriptor.setWsdlStyles(wsRuntimeDefinition.getWsdlSupportedStyles());
        ServiceEndpointDefinition[] endpointDefinitions = wsRuntimeDefinition.getServiceEndpointDefinitions();
        int endpointsSize = endpointDefinitions.length;
        WSRuntimeConfigurationDescriptor[] wsRuntimeConfigs = new WSRuntimeConfigurationDescriptor[endpointsSize];
        wsRuntimeDescriptor.setWsRuntimeConfiguration(wsRuntimeConfigs);
        int i = 0;
        while (i < endpointsSize) {
            WSRuntimeConfigurationDescriptor wsRuntimeConfigurationDescriptor;
            ServiceEndpointDefinition endpointDefinition = endpointDefinitions[i];
            wsRuntimeConfigs[i] = wsRuntimeConfigurationDescriptor = new WSRuntimeConfigurationDescriptor();
            QName endpointQName = endpointDefinition.getServiceEndpointQualifiedName();
            QNameDescriptor qNameDescriptor = new QNameDescriptor();
            wsRuntimeConfigurationDescriptor.setServiceEndpointName(qNameDescriptor);
            qNameDescriptor.setNamespaceURI(endpointQName.getNamespaceURI());
            qNameDescriptor.setLocalName(endpointQName.getLocalPart());
            ImplLink implLink = endpointDefinition.getImplLink();
            ImplLinkDescriptor implLinkDescriptor = this.getImplLinkDescriptor(implLink);
            if (implLinkDescriptor != null) {
                wsRuntimeConfigurationDescriptor.setImplLink(implLinkDescriptor);
            }
            OperationDefinition[] operations = endpointDefinition.getOperations();
            int operationsSize = operations.length;
            RuntimeOperationConfigDescriptor[] operationConfigs = new RuntimeOperationConfigDescriptor[operationsSize];
            wsRuntimeConfigurationDescriptor.setRuntimeOperationConfiguration(operationConfigs);
            int j = 0;
            while (j < operationsSize) {
                RuntimeOperationConfigDescriptor runtimeOperationConfig;
                OperationDefinition operation = operations[j];
                operationConfigs[j] = runtimeOperationConfig = new RuntimeOperationConfigDescriptor();
                runtimeOperationConfig.setName(operation.getOperationName());
                Key[] keys = ((OperationDefinitionImpl)operation).getKeys();
                int keysSize = keys.length;
                com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[] propertiesArr = new com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[keysSize];
                runtimeOperationConfig.setOperationMapping(propertiesArr);
                int l = 0;
                while (l < keysSize) {
                    com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor property;
                    Key key = keys[l];
                    propertiesArr[l] = property = new com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor();
                    property.setName(key.getName());
                    property.setValue(key.getValue());
                    ++l;
                }
                ++j;
            }
            ++i;
        }
        return wsRuntimeDescriptor;
    }

    public Properties getPropertiesAsHash(PropertyDescriptor[] propertyDescriptors) {
        Properties propertiesAsHash = new Properties();
        int propertiesSize = propertyDescriptors.length;
        int i = 0;
        while (i < propertiesSize) {
            PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            ((Hashtable)propertiesAsHash).put(propertyDescriptor.getName().trim(), propertyDescriptor.getValue().trim());
            ++i;
        }
        return propertiesAsHash;
    }

    public Properties getPropertiesAsHash(com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor[] propertyDescriptors) {
        Properties propertiesAsHash = new Properties();
        int propertiesSize = propertyDescriptors.length;
        int i = 0;
        while (i < propertiesSize) {
            com.sap.engine.services.webservices.server.deploy.descriptors.runtime.PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            ((Hashtable)propertiesAsHash).put(propertyDescriptor.getName().trim(), propertyDescriptor.getValue());
            ++i;
        }
        return propertiesAsHash;
    }

    private String[] constructRelPathTemplates(String baseRelativeDir, String baseFileNameTemplate, String[] fileExtensions) {
        String[] docFileNameTemplates = this.constructFileNamesTemplates(baseFileNameTemplate, fileExtensions);
        return WSUtil.addPrefixToStrings(baseRelativeDir + '/', docFileNameTemplates);
    }

    private String[] constructFileNamesTemplates(String baseFileNameTemplate, String[] fileExtensions) {
        String baseFileNameWithoutExt = IOUtil.getFileNameWithoutExt(baseFileNameTemplate);
        String[] docFileNameTemplates = new String[fileExtensions.length];
        int i = 0;
        while (i < docFileNameTemplates.length) {
            docFileNameTemplates[i] = baseFileNameWithoutExt + fileExtensions[i];
            ++i;
        }
        return docFileNameTemplates;
    }

    private OutsideInDefinition parseOutsideInDescriptor(OutsideInDescriptor outsideInDescriptor, WSFilesLocationHandler wsFilesLocationHandler) throws WSDeploymentException {
        String excMsg = "Error occured, parsing " + ((Object)((Object)outsideInDescriptor)).getClass().getName() + " descriptor. ";
        OutsideInDefinition outsideInDefinition = new OutsideInDefinition();
        String wsdlRelPath = IOUtil.convertPackageToDirPath(outsideInDescriptor.getWsdlRef().getPackage().trim(), outsideInDescriptor.getWsdlRef().getName().trim());
        String javaToQNameMappingRelPath = IOUtil.convertPackageToDirPath(outsideInDescriptor.getJavaQnameMappingRef().getPackage().trim(), outsideInDescriptor.getJavaQnameMappingRef().getName().trim());
        outsideInDefinition.setWsdlRelPath(wsdlRelPath);
        outsideInDefinition.setJavaQNameMappingFile(javaToQNameMappingRelPath);
        InputStream outsideInWsdlInputStream = null;
        InputStream outsideInJavaToQNameMappingStream = null;
        try {
            try {
                outsideInWsdlInputStream = wsFilesLocationHandler.getOutsideInWsdlInputStream(wsdlRelPath);
                outsideInJavaToQNameMappingStream = wsFilesLocationHandler.getOutsideInJavaToQNameMappingStream(javaToQNameMappingRelPath);
            }
            catch (IOException e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                Object[] args = new String[]{excMsg};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            Object var13_9 = null;
        }
        catch (Throwable throwable) {
            Object var13_10 = null;
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String wsdlMsg = "Warning! " + excMsg + "Unable to close input stream for source: " + wsFilesLocationHandler.getOutsideInWsdlLocationMsg(wsdlRelPath) + ". ";
            String javaToQNameMappingMsg = "Warning! " + excMsg + "Unable to close input stream for source: " + wsFilesLocationHandler.getOutsideInJavaToQNameMappingLocationMsg(javaToQNameMappingRelPath) + ". ";
            IOUtil.closeInputStreams(new InputStream[]{outsideInWsdlInputStream, outsideInJavaToQNameMappingStream}, new String[]{wsdlMsg, javaToQNameMappingMsg}, wsDeployLocation);
            throw throwable;
        }
        Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
        String wsdlMsg = "Warning! " + excMsg + "Unable to close input stream for source: " + wsFilesLocationHandler.getOutsideInWsdlLocationMsg(wsdlRelPath) + ". ";
        String javaToQNameMappingMsg = "Warning! " + excMsg + "Unable to close input stream for source: " + wsFilesLocationHandler.getOutsideInJavaToQNameMappingLocationMsg(javaToQNameMappingRelPath) + ". ";
        IOUtil.closeInputStreams(new InputStream[]{outsideInWsdlInputStream, outsideInJavaToQNameMappingStream}, new String[]{wsdlMsg, javaToQNameMappingMsg}, wsDeployLocation);
        return outsideInDefinition;
    }

    private void parseWSDAndDocumentation(NameDescriptor wsdNameDescriptor, WSRuntimeDefinition wsRuntimeDefinition, WSFilesLocationHandler wsFilesLocationHandler) throws WSDeploymentException {
        String excMsg = "Error occured, trying to parse web service definition and documentation from location " + wsFilesLocationHandler.getLocationMsg() + ". ";
        String wsdPackage = wsdNameDescriptor.getPackage().trim();
        String wsdName = wsdNameDescriptor.getName().trim();
        String wsdRelPath = IOUtil.convertPackageToDirPath(wsdPackage, wsdName);
        wsRuntimeDefinition.setWsdRelPath(wsdRelPath);
        String[] docRelPathTemplates = this.constructRelPathTemplates(wsdPackage.replace('.', '/'), wsdName, WSBaseConstants.WS_DOCUMENTATION_EXTENSIONS);
        String docRelPath = null;
        try {
            docRelPath = wsFilesLocationHandler.findDocRelPath(docRelPathTemplates);
        }
        catch (IOException e) {
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            wsDeployLocation.catching((Throwable)e);
            Object[] args = new String[]{excMsg};
            throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
        }
        if (docRelPath != null) {
            wsRuntimeDefinition.setDocumentationRelPath(docRelPath);
        }
        this.parseDocumentation(wsdRelPath, docRelPath, wsRuntimeDefinition, wsFilesLocationHandler);
    }

    private void parseDocumentation(String wsdRelPath, String docRelPath, WSRuntimeDefinition wsRuntimeDefinition, WSFilesLocationHandler wsFilesLocationHandler) throws WSDeploymentException {
        String excMsg = "Error occured, trying to parse documentation for web service " + wsRuntimeDefinition.getWSIdentifier().getServiceName() + ". ";
        InputStream wsdInputStream = null;
        InputStream docInputStream = null;
        try {
            try {
                wsdInputStream = wsFilesLocationHandler.getWsdInputStream(wsdRelPath);
                if (docRelPath != null) {
                    docInputStream = wsFilesLocationHandler.getDocInputStream(docRelPath);
                }
                WSDProcessor wsdProcessor = new WSDProcessor();
                wsdProcessor.process(wsdInputStream, docInputStream);
                wsRuntimeDefinition.setWsdUDDIPublications(wsdProcessor.getUDDIPublications());
                wsRuntimeDefinition.setWsdName(wsdProcessor.getName());
                wsRuntimeDefinition.setWsdDocumentation(wsdProcessor.getDocumentation());
                wsRuntimeDefinition.setDesigntimeFeatures(wsdProcessor.getFeatures());
            }
            catch (Exception e) {
                Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
                wsDeployLocation.catching((Throwable)e);
                Object[] args = new String[]{excMsg};
                throw new WSDeploymentException("webservices_5040", args, (Throwable)e);
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
            String wsdMsg = "Warning! " + excMsg + " Unable to close imput stream for source: " + wsFilesLocationHandler.getWsdLocationMsg(wsdRelPath) + ". ";
            String docMsg = "Warning! " + excMsg + " Unable to close imput stream for source: " + wsFilesLocationHandler.getDocLocationMsg(docRelPath) + ". ";
            IOUtil.closeInputStreams(new InputStream[]{wsdInputStream, docInputStream}, new String[]{wsdMsg, docMsg}, wsDeployLocation);
            throw throwable;
        }
        Location wsDeployLocation = Location.getLocation((String)WSLogging.DEPLOY_LOCATION);
        String wsdMsg = "Warning! " + excMsg + " Unable to close imput stream for source: " + wsFilesLocationHandler.getWsdLocationMsg(wsdRelPath) + ". ";
        String docMsg = "Warning! " + excMsg + " Unable to close imput stream for source: " + wsFilesLocationHandler.getDocLocationMsg(docRelPath) + ". ";
        IOUtil.closeInputStreams(new InputStream[]{wsdInputStream, docInputStream}, new String[]{wsdMsg, docMsg}, wsDeployLocation);
    }

    private QName parseQNameDescriptor(com.sap.engine.services.webservices.server.deploy.descriptors.sapwebservices.QNameDescriptor qNameDescriptor) {
        return new QName(qNameDescriptor.getNamespaceURI().trim(), qNameDescriptor.getLocalName().trim());
    }

    private WSDeploymentDescriptor getWSDeploymentDescriptor(String version, WSDescriptor wsDescriptor) {
        WSDeploymentDescriptor wsDeploymentDescriptor = new WSDeploymentDescriptor();
        wsDeploymentDescriptor.setVersion(version);
        wsDeploymentDescriptor.setWebservice(new WSDescriptor[]{wsDescriptor});
        return wsDeploymentDescriptor;
    }

    private String containsWSDeploymentDescriptor(File moduleArchive) throws IOException {
        String wsDeploymentDescriptorEntry = null;
        int i = 0;
        while (i < WSBaseConstants.META_INF.length) {
            wsDeploymentDescriptorEntry = WSBaseConstants.META_INF[i] + '/' + "ws-deployment-descriptor.xml";
            if (JarUtil.hasEntry(moduleArchive, wsDeploymentDescriptorEntry)) {
                return wsDeploymentDescriptorEntry;
            }
            ++i;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

