/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.ws;

import com.sap.engine.interfaces.webservices.server.deploy.ws.SEIContext;
import com.sap.engine.interfaces.webservices.server.deploy.ws.WSContext;
import com.sap.engine.services.webservices.runtime.definition.ServiceEndpointDefinition;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import com.sap.engine.services.webservices.server.deploy.ws.SEIContextImpl;

public class WSContextImpl
implements WSContext {
    private WSRuntimeDefinition wsRuntimeDefinition = null;
    private SEIContext[] seiContexts = new SEIContextImpl[0];

    public WSContextImpl() {
    }

    public WSContextImpl(WSRuntimeDefinition wsRuntimeDefinition) {
        this.init(wsRuntimeDefinition);
    }

    public void init(WSRuntimeDefinition wsRuntimeDefinition) {
        this.wsRuntimeDefinition = wsRuntimeDefinition;
        this.seiContexts = this.createSEIContexts(wsRuntimeDefinition.getServiceEndpointDefinitions());
    }

    public WSRuntimeDefinition getAssociatedWebService() {
        return this.wsRuntimeDefinition;
    }

    public String getApplicationName() {
        return this.wsRuntimeDefinition.getWSIdentifier().getApplicationName();
    }

    public String getWebServiceName() {
        return this.wsRuntimeDefinition.getWSIdentifier().getServiceName();
    }

    public SEIContext[] getSEIContexts() {
        return this.seiContexts;
    }

    public String getWSDName() {
        return this.wsRuntimeDefinition.getWsdName();
    }

    private SEIContext[] createSEIContexts(ServiceEndpointDefinition[] endpointDefinitions) {
        if (endpointDefinitions == null) {
            return new SEIContextImpl[0];
        }
        SEIContext[] seiContexts = new SEIContextImpl[endpointDefinitions.length];
        int i = 0;
        while (i < endpointDefinitions.length) {
            ServiceEndpointDefinition endpointDefinition = endpointDefinitions[i];
            SEIContextImpl seiContext = new SEIContextImpl(endpointDefinition);
            seiContexts[i] = seiContext;
            ++i;
        }
        return seiContexts;
    }
}

