/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.ws;

import com.sap.engine.interfaces.webservices.server.deploy.WSDeploymentException;
import com.sap.engine.services.webservices.runtime.definition.WSRuntimeDefinition;
import java.util.HashSet;

public class WSChecker {
    public void checkWSAppLevel(WSRuntimeDefinition[] wsRuntimeDefinitions) throws WSDeploymentException {
        if (wsRuntimeDefinitions == null) {
            return;
        }
        this.checkServiceNamesForDublicates(this.collectWebServiceNames(wsRuntimeDefinitions));
    }

    public void checkServiceNamesForDublicates(String[] webServiceNames) throws WSDeploymentException {
        String dublicateWSName = this.hasDublicates(webServiceNames);
        if (dublicateWSName != null) {
            String msg = "There is dublicate element for web service " + dublicateWSName + ". ";
            Object[] args = new String[]{msg};
            throw new WSDeploymentException("webservices_5040", args);
        }
    }

    private String[] collectWebServiceNames(WSRuntimeDefinition[] wsRuntimeDefinitions) {
        if (wsRuntimeDefinitions == null) {
            return new String[0];
        }
        String[] webServiceNames = new String[wsRuntimeDefinitions.length];
        int i = 0;
        while (i < wsRuntimeDefinitions.length) {
            webServiceNames[i] = wsRuntimeDefinitions[i].getWSIdentifier().getServiceName();
            ++i;
        }
        return webServiceNames;
    }

    private String hasDublicates(String[] strs) {
        if (strs == null) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < strs.length) {
            String str = strs[i];
            if (set.contains(str)) {
                return str;
            }
            set.add(str);
            ++i;
        }
        return null;
    }
}

