/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.server.deploy.ws;

import com.sap.engine.services.webservices.server.deploy.common.WSBaseConstants;
import com.sap.engine.services.webservices.server.deploy.util.jar.JarUtil;
import com.sap.engine.services.webservices.server.deploy.ws.WSDeploymentInfo;
import com.sap.engine.services.webservices.server.deploy.ws.WSFilesLocationHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class WSArchiveFilesLocationHandler
implements WSFilesLocationHandler {
    private File moduleArchive = null;
    private String workingDir = null;
    private Properties mappings = null;
    private String descriptorsRelDir = null;
    private String viRelDir = null;
    private String wsdRelDir = null;
    private String docRelDir = null;
    private String outsideInRelDir = null;
    private JarFile moduleArchiveJarFile = null;
    private WSDeploymentInfo wsDeploymentInfo = null;
    private JarUtil jarUtil = null;

    public WSArchiveFilesLocationHandler(File moduleArchive) throws IOException {
        this(moduleArchive, null);
    }

    public WSArchiveFilesLocationHandler(File moduleArchive, String workingDir) throws IOException {
        this(moduleArchive, workingDir, null);
    }

    public WSArchiveFilesLocationHandler(File moduleArchive, String workingDir, WSDeploymentInfo wsDeploymentInfo) throws IOException {
        this.moduleArchive = moduleArchive;
        this.workingDir = workingDir;
        String metaInfValue = this.getMetaInfValue();
        if (metaInfValue == null) {
            metaInfValue = "";
        }
        this.mappings = this.initMappings(metaInfValue);
        this.wsDeploymentInfo = wsDeploymentInfo;
    }

    public WSArchiveFilesLocationHandler(File moduleArchive, Properties mappings, String workingDir, WSDeploymentInfo wsDeploymentInfo) {
        this.moduleArchive = moduleArchive;
        this.workingDir = workingDir;
        this.mappings = mappings;
        this.wsDeploymentInfo = wsDeploymentInfo;
    }

    public File getModuleArchive() {
        return this.moduleArchive;
    }

    public String getBaseLocationMsg() {
        return this.moduleArchive.getAbsolutePath();
    }

    public WSDeploymentInfo getWsDeploymentInfo() {
        return this.wsDeploymentInfo;
    }

    public void setWsDeploymentInfo(WSDeploymentInfo wsDeploymentInfo) {
        this.wsDeploymentInfo = wsDeploymentInfo;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public static String getWSDeploymentDescriptorFileName() {
        return "ws-deployment-descriptor.xml";
    }

    public String getDescriptorsRelDir() {
        if (this.descriptorsRelDir == null) {
            this.descriptorsRelDir = this.mappings.getProperty("descriptors");
        }
        return this.descriptorsRelDir;
    }

    public boolean hasWSDeploymentDesctiptor() throws IOException {
        return this.getModuleArchiveJarFile().getEntry(this.getWSDeploymentDescriptorPath()) != null;
    }

    public String getWSDeploymentDescriptorPath() {
        String wsDeploymentDescriptorPath = WSArchiveFilesLocationHandler.getWSDeploymentDescriptorFileName();
        String descriptorsRelDir = this.getDescriptorsRelDir();
        if (descriptorsRelDir != null && !descriptorsRelDir.equals("")) {
            wsDeploymentDescriptorPath = this.getDescriptorsRelDir() + '/' + WSArchiveFilesLocationHandler.getWSDeploymentDescriptorFileName();
        }
        return wsDeploymentDescriptorPath;
    }

    public InputStream getWSDeploymentDescriptorInputStream() throws IOException {
        ZipEntry wsDeploymentDescriptorEntry = this.getModuleArchiveJarFile().getEntry(this.getWSDeploymentDescriptorPath());
        return this.getModuleArchiveJarFile().getInputStream(wsDeploymentDescriptorEntry);
    }

    public String getWSDeploymentDescriptorLocationMsg() {
        String locationMsg = "type: zip entry, ";
        locationMsg = locationMsg + "zip file location: " + this.getBaseLocationMsg() + ", ";
        locationMsg = locationMsg + "entry: " + this.getWSDeploymentDescriptorPath() + " ";
        return locationMsg;
    }

    public String getViRelDir() {
        if (this.viRelDir == null) {
            this.viRelDir = this.mappings.getProperty("vi");
        }
        return this.viRelDir;
    }

    public String getViPath(String viRelPath) {
        String viPath = viRelPath;
        String viRelDir = this.getViRelDir();
        if (viRelDir != null && !viRelDir.equals("")) {
            viPath = viRelDir + '/' + viRelPath;
        }
        return viPath;
    }

    public InputStream getViInputStream(String viRelPath) throws IOException {
        String viEntryPath = this.getViPath(viRelPath);
        this.getJarUtil().extractFile(this.getModuleArchiveJarFile(), viEntryPath, this.workingDir);
        this.wsDeploymentInfo.addVirtualInterfaceEntry(viEntryPath);
        this.wsDeploymentInfo.addVirtualInterface(this.workingDir + '/' + viEntryPath);
        return this.getModuleArchiveJarFile().getInputStream(this.getModuleArchiveJarFile().getEntry(viEntryPath));
    }

    public String getViLocationMsg(String viRelPath) {
        String locationMsg = "type: zip entry, ";
        locationMsg = locationMsg + "zip file location: " + this.getBaseLocationMsg() + ", ";
        locationMsg = locationMsg + "entry: " + this.getViPath(viRelPath) + " ";
        return locationMsg;
    }

    public String getWsdRelDir() {
        if (this.wsdRelDir == null) {
            this.wsdRelDir = this.mappings.getProperty("wsd");
        }
        return this.wsdRelDir;
    }

    public String getWsdPath(String wsdRelPath) {
        String wsdPath = wsdRelPath;
        String wsdRelDir = this.getWsdRelDir();
        if (wsdRelDir != null && !wsdRelDir.equals("")) {
            wsdPath = wsdRelDir + '/' + wsdRelPath;
        }
        return wsdPath;
    }

    public InputStream getWsdInputStream(String wsdRelPath) throws IOException {
        String wsdEntryPath = this.getWsdPath(wsdRelPath);
        this.getJarUtil().extractFile(this.getModuleArchiveJarFile(), wsdEntryPath, this.workingDir);
        this.wsDeploymentInfo.setWsdRefEntry(wsdEntryPath);
        this.wsDeploymentInfo.setWsdRef(this.workingDir + '/' + wsdEntryPath);
        return this.getModuleArchiveJarFile().getInputStream(this.getModuleArchiveJarFile().getEntry(wsdRelPath));
    }

    public String getWsdLocationMsg(String wsdRelPath) {
        String locationMsg = "type: zip entry, ";
        locationMsg = locationMsg + "zip file location: " + this.getBaseLocationMsg() + ", ";
        locationMsg = locationMsg + "entry: " + this.getWsdPath(wsdRelPath) + " ";
        return locationMsg;
    }

    public String getDocRelDir() {
        if (this.docRelDir == null) {
            this.docRelDir = this.mappings.getProperty("doc");
        }
        return this.docRelDir;
    }

    public String findDocRelPath(String[] docRelPathTemplates) throws IOException {
        if (docRelPathTemplates == null) {
            return null;
        }
        int i = 0;
        while (i < docRelPathTemplates.length) {
            String docRelPathTemplate = docRelPathTemplates[i];
            String docEntryPath = this.getDocPath(docRelPathTemplate);
            if (this.getModuleArchiveJarFile().getEntry(docEntryPath) != null) {
                return docRelPathTemplate;
            }
            ++i;
        }
        return null;
    }

    public String getDocPath(String docRelPath) {
        String docPath = docRelPath;
        String docRelDir = this.getDocRelDir();
        if (docRelDir != null && !docRelDir.equals("")) {
            docPath = docRelDir + '/' + docRelPath;
        }
        return docPath;
    }

    public String getDocLocationMsg(String docRelPath) {
        String locationMsg = "type: zip entry, ";
        locationMsg = locationMsg + "zip file location: " + this.getBaseLocationMsg() + ", ";
        locationMsg = locationMsg + "entry: " + this.getDocPath(docRelPath) + " ";
        return locationMsg;
    }

    public InputStream getDocInputStream(String docRelPath) throws IOException {
        String docEntryPath = this.getDocPath(docRelPath);
        this.getJarUtil().extractFile(this.getModuleArchiveJarFile(), docEntryPath, this.workingDir);
        this.wsDeploymentInfo.setWsDocEntry(docEntryPath);
        this.wsDeploymentInfo.setWsDocPath(this.workingDir + '/' + docEntryPath);
        return this.getModuleArchiveJarFile().getInputStream(this.getModuleArchiveJarFile().getEntry(docEntryPath));
    }

    public String getOutSideInRelDir() {
        if (this.outsideInRelDir == null) {
            this.outsideInRelDir = this.mappings.getProperty("out_in");
        }
        return this.outsideInRelDir;
    }

    public String getOutsideInWsdlPath(String wsdlRelPath) {
        String wsdlPath = wsdlRelPath;
        String outsideInRelDir = this.getOutSideInRelDir();
        if (outsideInRelDir != null && !outsideInRelDir.equals("")) {
            wsdlPath = outsideInRelDir + '/' + wsdlRelPath;
        }
        return wsdlPath;
    }

    public InputStream getOutsideInWsdlInputStream(String wsdlRelPath) throws IOException {
        String wsdlWorkingDir = this.workingDir + '/' + "wsdl";
        String wsdlEntryPath = this.getOutsideInWsdlPath(wsdlRelPath);
        this.getJarUtil().extractFile(this.getModuleArchiveJarFile(), wsdlEntryPath, wsdlWorkingDir);
        this.wsDeploymentInfo.setWsdlRefPath(wsdlWorkingDir + '/' + wsdlEntryPath);
        return this.getModuleArchiveJarFile().getInputStream(this.getModuleArchiveJarFile().getEntry(wsdlEntryPath));
    }

    public String getOutsideInWsdlLocationMsg(String wsdlrelPath) {
        String locationMsg = "type: zip entry, ";
        locationMsg = locationMsg + "zip file location: " + this.getBaseLocationMsg() + ", ";
        locationMsg = locationMsg + "entry: " + this.getOutsideInWsdlPath(wsdlrelPath) + " ";
        return locationMsg;
    }

    public String getOutsideInJavaToQNameMapppingPath(String javaToQNameMappingRelPath) {
        String javaToQNameMappingPath = javaToQNameMappingRelPath;
        String outsideInRelDir = this.getOutSideInRelDir();
        if (outsideInRelDir != null && !outsideInRelDir.equals("")) {
            javaToQNameMappingPath = outsideInRelDir + '/' + javaToQNameMappingRelPath;
        }
        return javaToQNameMappingPath;
    }

    public InputStream getOutsideInJavaToQNameMappingStream(String javaToQNameMappingRelPath) throws IOException {
        String javaToQNameMappingEntryPath = this.getOutsideInJavaToQNameMapppingPath(javaToQNameMappingRelPath);
        this.getJarUtil().extractFile(this.getModuleArchiveJarFile(), javaToQNameMappingEntryPath, this.workingDir);
        this.wsDeploymentInfo.setJavaQNameMappingRefPath(this.workingDir + '/' + javaToQNameMappingEntryPath);
        return this.getModuleArchiveJarFile().getInputStream(this.getModuleArchiveJarFile().getEntry(javaToQNameMappingEntryPath));
    }

    public String getOutsideInJavaToQNameMappingLocationMsg(String javaToQNameMappingRelPath) {
        String locationMsg = "type: zip entry, ";
        locationMsg = locationMsg + "zip file location: " + this.getBaseLocationMsg() + ", ";
        locationMsg = locationMsg + "entry: " + this.getOutsideInJavaToQNameMapppingPath(javaToQNameMappingRelPath) + " ";
        return locationMsg;
    }

    public String getLocationMsg() {
        String locationMsg = "type: jar file, ";
        locationMsg = locationMsg + "location: " + this.getBaseLocationMsg() + " ";
        return locationMsg;
    }

    public void close() throws IOException {
        if (this.moduleArchiveJarFile != null) {
            this.moduleArchiveJarFile.close();
            this.moduleArchiveJarFile = null;
        }
    }

    private JarUtil getJarUtil() {
        if (this.jarUtil == null) {
            this.jarUtil = new JarUtil();
        }
        return this.jarUtil;
    }

    public void extractEntry(String parentDir, String entryPath) throws IOException {
        this.getJarUtil().extractFile(this.getModuleArchiveJarFile(), entryPath, parentDir);
    }

    private JarFile getModuleArchiveJarFile() throws IOException {
        if (this.moduleArchiveJarFile == null) {
            this.moduleArchiveJarFile = new JarFile(this.moduleArchive);
        }
        return this.moduleArchiveJarFile;
    }

    private String getMetaInfValue() throws IOException {
        JarFile moduleJarFile = this.getModuleArchiveJarFile();
        int i = 0;
        while (i < WSBaseConstants.META_INF.length) {
            String metaInfValue = WSBaseConstants.META_INF[i];
            if (moduleJarFile.getEntry(metaInfValue + '/' + "ws-deployment-descriptor.xml") != null) {
                return metaInfValue;
            }
            ++i;
        }
        return null;
    }

    private Properties initMappings(String baseRelDir) {
        Properties mappings = new Properties();
        mappings.setProperty("descriptors", baseRelDir);
        mappings.setProperty("vi", "");
        mappings.setProperty("wsd", "");
        mappings.setProperty("doc", "");
        mappings.setProperty("out_in", "");
        return mappings;
    }
}

